/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.chart.AbstractDisplayPlugin;
import net.maizegenetics.analysis.chart.TablePluginDialog;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportUtils;

public class TableDisplayPlugin
extends AbstractDisplayPlugin {
    private String myDelimiter;
    private TablePluginDialog myDialog = null;

    public TableDisplayPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> alignInList = input.getDataOfType(TableReport.class);
            if (alignInList.size() < 1) {
                String message = "Invalid selection.  Please select Table Report.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    System.out.println(message);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            for (Datum current : alignInList) {
                this.processDatum(current);
            }
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private void processDatum(Datum input) {
        TableReport tr = (TableReport)input.getData();
        if (this.isInteractive()) {
            this.myDialog = new TablePluginDialog(this, tr);
            this.myDialog.setLocationRelativeTo(this.getParentFrame());
            this.myDialog.setVisible(true);
        } else if (this.getSaveFile() != null) {
            this.saveDataToFile(tr, this.myDelimiter);
        }
    }

    public void saveDataToFile(TableReport tr, String delimit, AbstractDisplayPlugin.FileFormat[] formats) {
        TableReportUtils.saveDelimitedTableReport(tr, delimit, this.getSaveFileByChooser(formats, this.myDialog));
    }

    public void saveDataToFile(TableReport tr, String delimit) {
        TableReportUtils.saveDelimitedTableReport(tr, delimit, this.getSaveFile());
    }

    public String getDelimiter() {
        return this.myDelimiter;
    }

    public void setDelimiter(String theDelimiter) {
        this.myDelimiter = theDelimiter;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = TableDisplayPlugin.class.getResource("/net/maizegenetics/analysis/images/Table.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Table";
    }

    @Override
    public String getToolTipText() {
        return "Present data in table";
    }
}

