/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.chart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.maizegenetics.analysis.chart.AbstractDisplayPlugin;
import net.maizegenetics.analysis.chart.TableDisplayPlugin;
import net.maizegenetics.gui.TableReportNoPagingTableModel;
import net.maizegenetics.util.TableReport;

class TablePluginDialog
extends JDialog
implements Printable {
    TableReport theTableSource;
    TableDisplayPlugin theTableDisplayPlugin;
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable;
    JPanel jPanel1 = new JPanel();
    JButton saveTabButton = new JButton();
    JButton saveCommaButton = new JButton();
    JButton printButton = new JButton();

    public TablePluginDialog(TableDisplayPlugin plugin, TableReport theTableSource) {
        super(plugin.getParentFrame(), theTableSource.getTableTitle(), false);
        this.theTableDisplayPlugin = plugin;
        this.theTableSource = theTableSource;
        this.jTable = new JTable(new TableReportNoPagingTableModel(theTableSource));
        this.jTable.setAutoCreateRowSorter(true);
        this.jTable.getTableHeader().setToolTipText("Click to specify sorting; Control-Click to specify secondary sorting");
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.saveTabButton.setText("Export (Tab)");
        this.saveTabButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePluginDialog.this.saveTabButton_actionPerformed(e);
            }
        });
        this.saveCommaButton.setText("Export (CSV)");
        this.saveCommaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePluginDialog.this.saveCommaButton_actionPerformed(e);
            }
        });
        this.printButton.setText("Print");
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePluginDialog.this.printButton_actionPerformed(e);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jTable, null);
        this.panel1.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.printButton, null);
        this.jPanel1.add((Component)this.saveCommaButton, null);
        this.jPanel1.add((Component)this.saveTabButton, null);
    }

    void saveTabButton_actionPerformed(ActionEvent e) {
        this.theTableDisplayPlugin.saveDataToFile(this.theTableSource, "\t", new AbstractDisplayPlugin.FileFormat[]{AbstractDisplayPlugin.FileFormat.txt});
    }

    void saveCommaButton_actionPerformed(ActionEvent e) {
        this.theTableDisplayPlugin.saveDataToFile(this.theTableSource, ",", new AbstractDisplayPlugin.FileFormat[]{AbstractDisplayPlugin.FileFormat.csv});
    }

    void printButton_actionPerformed(ActionEvent e) {
        this.sendToPrinter();
    }

    void sendToPrinter() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDesent = g2.getFontMetrics().getDescent();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight;
        double pageWidth = pageFormat.getImageableWidth();
        double tableWidth = this.jTable.getColumnModel().getTotalColumnWidth();
        double scale = 1.0;
        if (tableWidth >= pageWidth) {
            scale = pageWidth / tableWidth;
        }
        double headerHeightOnPage = (double)this.jTable.getTableHeader().getHeight() * scale;
        double tableWidthOnPage = tableWidth * scale;
        double oneRowHeight = (double)(this.jTable.getRowHeight() + this.jTable.getRowMargin()) * scale;
        int numRowsOnAPage = (int)((pageHeight - headerHeightOnPage) / oneRowHeight);
        double pageHeightForTable = oneRowHeight * (double)numRowsOnAPage;
        int totalNumPages = (int)Math.ceil((double)this.jTable.getRowCount() / (double)numRowsOnAPage);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2.drawString("Page: " + (pageIndex + 1), (int)pageWidth / 2 - 35, (int)(pageHeight + (double)fontHeight - (double)fontDesent));
        g2.translate(0.0, headerHeightOnPage);
        g2.translate(0.0, (double)(-pageIndex) * pageHeightForTable);
        if (pageIndex + 1 == totalNumPages) {
            int lastRowPrinted = numRowsOnAPage * pageIndex;
            int numRowsLeft = this.jTable.getRowCount() - lastRowPrinted;
            g2.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(oneRowHeight * (double)numRowsLeft));
        } else {
            g2.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(pageHeightForTable));
        }
        g2.scale(scale, scale);
        this.jTable.paint(g2);
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.translate(0.0, (double)pageIndex * pageHeightForTable);
        g2.translate(0.0, -headerHeightOnPage);
        g2.setClip(0, 0, (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(headerHeightOnPage));
        g2.scale(scale, scale);
        this.jTable.getTableHeader().paint(g2);
        return 0;
    }
}

