/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.clustering;

import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;

public class Haplotype
implements Comparable<Haplotype> {
    public byte[] seq;
    public int notMissingCount;
    public int seqlen;
    public static final byte N = NucleotideAlignmentConstants.getNucleotideDiploidByte("N");
    public int taxonIndex;

    public Haplotype(byte[] hap, int taxon) {
        this.seq = hap;
        this.seqlen = this.seq.length;
        this.countNotMissing();
        this.taxonIndex = taxon;
    }

    public Haplotype(byte[] hap) {
        this(hap, -1);
    }

    public void countNotMissing() {
        this.notMissingCount = 0;
        for (byte b : this.seq) {
            if (b == N) continue;
            ++this.notMissingCount;
        }
    }

    @Override
    public int compareTo(Haplotype arg0) {
        if (this.notMissingCount > arg0.notMissingCount) {
            return -1;
        }
        if (this.notMissingCount < arg0.notMissingCount) {
            return 1;
        }
        return 0;
    }

    public int distanceFrom(Haplotype h0) {
        return Haplotype.getDistance(this.seq, h0.seq);
    }

    public static int getDistance(Haplotype hap0, Haplotype hap1) {
        return hap0.distanceFrom(hap1);
    }

    public static int getDistance(byte[] hap0, byte[] hap1) {
        int d = 0;
        int n = hap0.length;
        for (int s = 0; s < n; ++s) {
            byte b0 = hap0[s];
            byte b1 = hap1[s];
            if (b0 == b1 || b0 == N || b1 == N) continue;
            if (GenotypeTableUtils.isHeterozygous(b0)) {
                if (GenotypeTableUtils.isHeterozygous(b1)) continue;
                ++d;
                continue;
            }
            if (GenotypeTableUtils.isHeterozygous(b1)) {
                ++d;
                continue;
            }
            d += 2;
        }
        return d;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.seq) {
            sb.append(NucleotideAlignmentConstants.getNucleotideIUPAC(b));
        }
        return sb.toString();
    }
}

