/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.maizegenetics.analysis.data.FileLoadPlugin;

class FileLoadPluginDialog
extends JDialog {
    boolean isCancel = true;
    ButtonGroup conversionButtonGroup = new ButtonGroup();
    JRadioButton hapMapRadioButton = new JRadioButton("Load Hapmap");
    JRadioButton hdf5RadioButton = new JRadioButton("Load HDF5");
    JRadioButton vcfRadioButton = new JRadioButton("Load VCF");
    JRadioButton plinkRadioButton = new JRadioButton("Load Plink");
    JRadioButton sequenceAlignRadioButton = new JRadioButton("Load Phylip");
    JRadioButton fastaRadioButton = new JRadioButton("Load FASTA File");
    JRadioButton numericalRadioButton = new JRadioButton("Load Numerical (trait, covariates, or factors)");
    JRadioButton loadMatrixRadioButton = new JRadioButton("Load Square Numerical Matrix (i.e. kinship)");
    JRadioButton guessRadioButton = new JRadioButton("Make Best Guess");
    JRadioButton projectionAlignmentRadioButton = new JRadioButton("Load Projection Alignment");
    JRadioButton geneticMapRadioButton = new JRadioButton("Load a Genetic Map");
    JRadioButton tableReportRadioButton = new JRadioButton("Load a Table Report");
    JRadioButton topmRadioButton = new JRadioButton("Load a TOPM (Tags on Physical Map)");

    public FileLoadPluginDialog() {
        super((Frame)null, "File Loader", true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle("File Loader");
        this.setDefaultCloseOperation(1);
        this.setUndecorated(false);
        this.getRootPane().setWindowDecorationStyle(0);
        Container contentPane = this.getContentPane();
        BoxLayout layout = new BoxLayout(contentPane, 1);
        contentPane.setLayout(layout);
        JPanel main = this.getMain();
        contentPane.add(main);
        this.pack();
        this.setResizable(false);
        this.conversionButtonGroup.add(this.projectionAlignmentRadioButton);
        this.conversionButtonGroup.add(this.hapMapRadioButton);
        this.conversionButtonGroup.add(this.hdf5RadioButton);
        this.conversionButtonGroup.add(this.vcfRadioButton);
        this.conversionButtonGroup.add(this.plinkRadioButton);
        this.conversionButtonGroup.add(this.sequenceAlignRadioButton);
        this.conversionButtonGroup.add(this.fastaRadioButton);
        this.conversionButtonGroup.add(this.loadMatrixRadioButton);
        this.conversionButtonGroup.add(this.numericalRadioButton);
        this.conversionButtonGroup.add(this.geneticMapRadioButton);
        this.conversionButtonGroup.add(this.tableReportRadioButton);
        this.conversionButtonGroup.add(this.topmRadioButton);
        this.conversionButtonGroup.add(this.guessRadioButton);
        this.guessRadioButton.setSelected(true);
    }

    private JPanel getMain() {
        JPanel inputs = new JPanel();
        BoxLayout layout = new BoxLayout(inputs, 1);
        inputs.setLayout(layout);
        inputs.setAlignmentX(0.5f);
        inputs.add(Box.createRigidArea(new Dimension(1, 10)));
        inputs.add(this.getLabel());
        inputs.add(Box.createRigidArea(new Dimension(1, 10)));
        inputs.add(this.getOptionPanel());
        inputs.add(Box.createRigidArea(new Dimension(1, 10)));
        inputs.add(this.getButtons());
        inputs.add(Box.createRigidArea(new Dimension(1, 10)));
        return inputs;
    }

    private JPanel getLabel() {
        JPanel result = new JPanel();
        BoxLayout layout = new BoxLayout(result, 1);
        result.setLayout(layout);
        result.setAlignmentX(0.5f);
        JLabel jLabel1 = new JLabel("Choose File Type to Load.");
        jLabel1.setFont(new Font("Dialog", 1, 18));
        result.add(jLabel1);
        return result;
    }

    private JPanel getOptionPanel() {
        JPanel result = new JPanel();
        BoxLayout layout = new BoxLayout(result, 1);
        result.setLayout(layout);
        result.setAlignmentX(0.5f);
        result.setBorder(BorderFactory.createEtchedBorder());
        result.add(this.hapMapRadioButton);
        result.add(this.hdf5RadioButton);
        result.add(this.vcfRadioButton);
        result.add(this.plinkRadioButton);
        result.add(this.projectionAlignmentRadioButton);
        result.add(this.sequenceAlignRadioButton);
        result.add(this.fastaRadioButton);
        result.add(this.numericalRadioButton);
        result.add(this.loadMatrixRadioButton);
        result.add(this.geneticMapRadioButton);
        result.add(this.tableReportRadioButton);
        result.add(this.topmRadioButton);
        result.add(this.guessRadioButton);
        result.add(Box.createRigidArea(new Dimension(1, 20)));
        return result;
    }

    private JPanel getButtons() {
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileLoadPluginDialog.this.cancelButton_actionPerformed(e);
            }
        });
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileLoadPluginDialog.this.okButton_actionPerformed(e);
            }
        });
        JPanel result = new JPanel(new FlowLayout(1));
        result.add(okButton);
        result.add(cancelButton);
        return result;
    }

    public FileLoadPlugin.TasselFileType getTasselFileType() {
        if (this.hapMapRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.Hapmap;
        }
        if (this.hdf5RadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.HDF5;
        }
        if (this.vcfRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.VCF;
        }
        if (this.plinkRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.Plink;
        }
        if (this.projectionAlignmentRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.ProjectionAlignment;
        }
        if (this.sequenceAlignRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.Sequence;
        }
        if (this.fastaRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.Fasta;
        }
        if (this.loadMatrixRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.SqrMatrix;
        }
        if (this.numericalRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.Unknown;
        }
        if (this.geneticMapRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.GeneticMap;
        }
        if (this.tableReportRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.Table;
        }
        if (this.topmRadioButton.isSelected()) {
            return FileLoadPlugin.TasselFileType.TOPM;
        }
        return FileLoadPlugin.TasselFileType.Unknown;
    }

    public void okButton_actionPerformed(ActionEvent e) {
        this.isCancel = false;
        this.setVisible(false);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.isCancel = true;
        this.setVisible(false);
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

