/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.util.SimpleTableReport;
import org.apache.log4j.Logger;

public class GenotypeSummaryPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(GenotypeSummaryPlugin.class);
    private static final String NA = "NA";
    private static final Double ZERO_DOUBLE = 0.0;
    private static final int ZERO_INT = 0;
    private long myNumGametesMissing = 0L;
    private long myNumHeterozygous = 0L;
    private boolean myIsOverview = true;
    private boolean myIsSiteSummary = true;
    private boolean myIsTaxaSummary = true;

    public GenotypeSummaryPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            this.myNumGametesMissing = 0L;
            this.myNumHeterozygous = 0L;
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() != 1) {
                String gpMessage = "Invalid selection.  Please select one genotype alignment.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), gpMessage);
                } else {
                    myLogger.error((Object)gpMessage);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            if (this.isInteractive()) {
                GenotypeSummaryPluginDialog theDialog = new GenotypeSummaryPluginDialog();
                theDialog.setLocationRelativeTo(this.getParentFrame());
                theDialog.setVisible(true);
                if (theDialog.isCancel()) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                this.myIsOverview = theDialog.isOverview();
                this.myIsSiteSummary = theDialog.isSiteSummary();
                this.myIsTaxaSummary = theDialog.isTaxaSummary();
                theDialog.dispose();
            }
            Datum current = alignInList.get(0);
            GenotypeTable alignment = (GenotypeTable)current.getData();
            String name = current.getName();
            ArrayList<Datum> summaryTables = new ArrayList<Datum>();
            SimpleTableReport siteSummary = null;
            if (this.myIsSiteSummary) {
                siteSummary = this.getSiteSummary(alignment);
            }
            SimpleTableReport taxaSummary = null;
            if (this.myIsTaxaSummary) {
                taxaSummary = this.getTaxaSummary(alignment);
            }
            SimpleTableReport[] overallSummaries = null;
            if (this.myIsOverview) {
                overallSummaries = this.getOverallSummary(alignment);
            }
            if (this.myIsOverview) {
                summaryTables.add(new Datum(name + "_OverallSummary", overallSummaries[0], "Overall Summary of " + name));
                summaryTables.add(new Datum(name + "_AlleleSummary", overallSummaries[1], "Allele Summary of " + name));
            }
            if (siteSummary != null) {
                summaryTables.add(new Datum(name + "_SiteSummary", siteSummary, "Site Summary of " + name));
            }
            if (taxaSummary != null) {
                summaryTables.add(new Datum(name + "_TaxaSummary", taxaSummary, "Taxa Summary of " + name));
            }
            if (summaryTables.isEmpty()) {
                DataSet dataSet = null;
                return dataSet;
            }
            DataSet output = new DataSet(summaryTables, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, GenotypeSummaryPlugin.class));
            DataSet dataSet = output;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private SimpleTableReport[] getOverallSummary(GenotypeTable alignment) {
        Long numValue;
        String value;
        int i;
        Object[] firstColumnNames = new String[]{"Stat Type", "Value"};
        long numSites = alignment.numberOfSites();
        long numTaxa = alignment.numberOfTaxa();
        Object[][] diploidValueCounts = alignment.genoCounts();
        int numAlleles = diploidValueCounts[0].length;
        if (!this.myIsSiteSummary) {
            int totalGametes = (int)numTaxa * 2;
            int i2 = 0;
            while ((long)i2 < numSites) {
                int totalGametesNotMissing = alignment.totalGametesNonMissingForSite(i2);
                int totalGametesMissing = totalGametes - totalGametesNotMissing;
                this.myNumGametesMissing += (long)totalGametesMissing;
                int numHeterozygous = alignment.heterozygousCount(i2);
                this.myNumHeterozygous += (long)numHeterozygous;
                ++i2;
            }
        }
        long totalGametes = numSites * numTaxa * 2L;
        long totalGametesNotMissing = totalGametes - this.myNumGametesMissing;
        long numDiploidsMissing = 0L;
        for (int j = 0; j < numAlleles; ++j) {
            if (!diploidValueCounts[0][j].equals("N") && !diploidValueCounts[0][j].equals("N:N")) continue;
            numDiploidsMissing = (Long)diploidValueCounts[1][j];
            break;
        }
        long totalDiploids = numSites * numTaxa;
        long totalDiploidsNotMissing = totalDiploids - numDiploidsMissing;
        int count = 0;
        Object[][] data = new Object[14][firstColumnNames.length];
        data[count][0] = "Number of Taxa";
        data[count++][1] = (double)numTaxa;
        data[count][0] = "Number of Sites";
        data[count++][1] = (double)numSites;
        data[count][0] = "Sites x Taxa";
        data[count++][1] = (double)totalDiploids;
        data[count][0] = "Number Not Missing";
        data[count++][1] = (double)totalDiploidsNotMissing;
        data[count][0] = "Proportion Not Missing";
        data[count++][1] = (double)totalDiploidsNotMissing / (double)totalDiploids;
        data[count][0] = "Number Missing";
        data[count++][1] = (double)numDiploidsMissing;
        data[count][0] = "Proportion Missing";
        data[count++][1] = (double)numDiploidsMissing / (double)totalDiploids;
        data[count][0] = "Number Gametes";
        data[count++][1] = (double)totalGametes;
        data[count][0] = "Gametes Not Missing";
        data[count++][1] = (double)totalGametesNotMissing;
        data[count][0] = "Proportion Gametes Not Missing";
        data[count++][1] = (double)totalGametesNotMissing / (double)totalGametes;
        data[count][0] = "Gametes Missing";
        data[count++][1] = (double)this.myNumGametesMissing;
        data[count][0] = "Proportion Gametes Missing";
        data[count++][1] = (double)this.myNumGametesMissing / (double)totalGametes;
        data[count][0] = "Number Heterozygous";
        data[count++][1] = (double)this.myNumHeterozygous;
        data[count][0] = "Proportion Heterozygous";
        data[count++][1] = (double)this.myNumHeterozygous / (double)totalDiploids;
        Object[][] majorMinorDiploidValueCounts = alignment.majorMinorCounts();
        int numMajorMinorAlleles = majorMinorDiploidValueCounts[0].length;
        Object[] alleleColumnNames = new String[]{"Alleles", "Number", "Proportion", "Frequency"};
        Object[][] data2 = new Object[numAlleles + numMajorMinorAlleles][alleleColumnNames.length];
        count = 0;
        for (i = 0; i < numAlleles; ++i) {
            value = (String)diploidValueCounts[0][i];
            numValue = (Long)diploidValueCounts[1][i];
            data2[count][0] = value;
            data2[count][1] = numValue;
            data2[count][2] = numValue.doubleValue() / (double)totalDiploids;
            data2[count++][3] = numValue.doubleValue() / (double)totalDiploidsNotMissing;
        }
        for (i = 0; i < numMajorMinorAlleles; ++i) {
            value = (String)majorMinorDiploidValueCounts[0][i];
            numValue = (Long)majorMinorDiploidValueCounts[1][i];
            data2[count][0] = value;
            data2[count][1] = numValue;
            data2[count++][2] = numValue.doubleValue() / (double)numSites;
        }
        return new SimpleTableReport[]{new SimpleTableReport("Overall Summary", firstColumnNames, data), new SimpleTableReport("Allele Summary", alleleColumnNames, data2)};
    }

    private SimpleTableReport getSiteSummary(GenotypeTable alignment) {
        String[] firstColumnNames = new String[]{"Site Number", "Site Name", "Chromosome", "Physical Position", "Number of Taxa", "Major Allele", "Major Allele Gametes", "Major Allele Proportion", "Major Allele Frequency", "Minor Allele", "Minor Allele Gametes", "Minor Allele Proportion", "Minor Allele Frequency"};
        String[] lastColumnNames = new String[]{"Gametes Missing", "Proportion Missing", "Number Heterozygous", "Proportion Heterozygous", "Inbreeding Coefficient", "Inbreeding Coefficient Scaled by Missing"};
        ArrayList<String> columnNames = new ArrayList<String>(Arrays.asList(firstColumnNames));
        int maxAlleles = alignment.maxNumAlleles();
        if (alignment.retainsRareAlleles()) {
            ++maxAlleles;
        }
        for (int i = 2; i < maxAlleles; ++i) {
            String alleleHeading = "Allele " + (i + 1);
            columnNames.add(alleleHeading);
            columnNames.add(alleleHeading + " Gametes");
            columnNames.add(alleleHeading + " Proportion");
            columnNames.add(alleleHeading + " Frequency");
        }
        columnNames.addAll(Arrays.asList(lastColumnNames));
        int numSites = alignment.numberOfSites();
        int numTaxa = alignment.numberOfTaxa();
        Object[][] data = new Object[numSites][columnNames.size()];
        int totalGametes = numTaxa * 2;
        for (int i = 0; i < numSites; ++i) {
            int totalNotMissing = alignment.totalNonMissingForSite(i);
            int totalGametesNotMissing = alignment.totalGametesNonMissingForSite(i);
            int count = 0;
            data[i][count++] = i;
            data[i][count++] = alignment.siteName(i);
            data[i][count++] = alignment.chromosomeName(i);
            data[i][count++] = alignment.chromosomalPosition(i);
            data[i][count++] = numTaxa;
            int[][] alleles = alignment.allelesSortedByFrequency(i);
            int numAlleles = alleles[0].length;
            for (int a = 0; a < numAlleles; ++a) {
                data[i][count++] = alignment.genotypeAsString(i, (byte)alleles[0][a]);
                data[i][count++] = alleles[1][a];
                data[i][count++] = (double)alleles[1][a] / (double)totalGametes;
                data[i][count++] = (double)alleles[1][a] / (double)totalGametesNotMissing;
            }
            for (int b = 0; b < maxAlleles - numAlleles; ++b) {
                data[i][count++] = NA;
                data[i][count++] = 0;
                data[i][count++] = ZERO_DOUBLE;
                data[i][count++] = ZERO_DOUBLE;
            }
            int totalGametesMissing = totalGametes - totalGametesNotMissing;
            this.myNumGametesMissing += (long)totalGametesMissing;
            data[i][count++] = totalGametesMissing;
            data[i][count++] = (double)totalGametesMissing / (double)totalGametes;
            int numHeterozygous = alignment.heterozygousCount(i);
            this.myNumHeterozygous += (long)numHeterozygous;
            data[i][count++] = numHeterozygous;
            data[i][count++] = (double)numHeterozygous / (double)totalNotMissing;
            data[i][count++] = "TBD";
            data[i][count++] = "TBD";
        }
        Object[] columnNameStrings = new String[columnNames.size()];
        columnNames.toArray(columnNameStrings);
        return new SimpleTableReport("Site Summary", columnNameStrings, data);
    }

    private SimpleTableReport getTaxaSummary(GenotypeTable alignment) {
        Object[] columnNames = new String[]{"Taxa", "Taxa Name", "Number of Sites", "Gametes Missing", "Proportion Missing", "Number Heterozygous", "Proportion Heterozygous", "Inbreeding Coefficient", "Inbreeding Coefficient Scaled by Missing"};
        int numSites = alignment.numberOfSites();
        int numTaxa = alignment.numberOfTaxa();
        Object[][] data = new Object[numTaxa][columnNames.length];
        int totalGametes = numSites * 2;
        for (int i = 0; i < numTaxa; ++i) {
            int totalGametesNotMissing = alignment.totalGametesNonMissingForTaxon(i);
            int totalGametesMissing = totalGametes - totalGametesNotMissing;
            int numHeterozygous = alignment.heterozygousCountForTaxon(i);
            int totalSitesNotMissing = alignment.totalNonMissingForTaxon(i);
            int count = 0;
            data[i][count++] = i;
            data[i][count++] = alignment.taxaName(i);
            data[i][count++] = numSites;
            data[i][count++] = totalGametesMissing;
            data[i][count++] = (double)totalGametesMissing / (double)totalGametes;
            data[i][count++] = numHeterozygous;
            data[i][count++] = (double)numHeterozygous / (double)totalSitesNotMissing;
            data[i][count++] = "Inbreeding Coefficient";
            data[i][count++] = "ICSBM";
        }
        return new SimpleTableReport("Taxa Summary", columnNames, data);
    }

    public void setCaculateOverview(boolean calculate) {
        this.myIsOverview = calculate;
    }

    public boolean getCalculateOverview() {
        return this.myIsOverview;
    }

    public void setCalculateSiteSummary(boolean calculate) {
        this.myIsSiteSummary = calculate;
    }

    public boolean getCalculateSiteSummary() {
        return this.myIsSiteSummary;
    }

    public void setCalculateTaxaSummary(boolean calculate) {
        this.myIsTaxaSummary = calculate;
    }

    public boolean getCalculateTaxaSummary() {
        return this.myIsTaxaSummary;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = GenotypeSummaryPlugin.class.getResource("/net/maizegenetics/analysis/images/summary.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Geno Summary";
    }

    @Override
    public String getToolTipText() {
        return "Genotype Summary";
    }

    class GenotypeSummaryPluginDialog
    extends JDialog {
        private JTabbedPane myTabbedPane;
        private JRadioButton myOverview;
        private JRadioButton mySiteSummary;
        private JRadioButton myTaxaSummary;
        private boolean myIsCancel;

        public GenotypeSummaryPluginDialog() {
            super((Frame)null, "Genotype Summary", true);
            this.myTabbedPane = new JTabbedPane();
            this.myOverview = new JRadioButton();
            this.mySiteSummary = new JRadioButton();
            this.myTaxaSummary = new JRadioButton();
            this.myIsCancel = true;
            JButton okButton = new JButton();
            okButton.setActionCommand("Ok");
            okButton.setText("Ok");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenotypeSummaryPluginDialog.this.myIsCancel = false;
                    GenotypeSummaryPluginDialog.this.setVisible(false);
                }
            });
            JButton closeButton = new JButton();
            closeButton.setText("Close");
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenotypeSummaryPluginDialog.this.myIsCancel = true;
                    GenotypeSummaryPluginDialog.this.setVisible(false);
                }
            });
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            this.myOverview.setText("Genotype Overview");
            this.myOverview.setSelected(GenotypeSummaryPlugin.this.myIsOverview);
            this.mySiteSummary.setText("Site Summary");
            this.mySiteSummary.setSelected(GenotypeSummaryPlugin.this.myIsSiteSummary);
            this.myTaxaSummary.setText("Taxa Summary");
            this.myTaxaSummary.setSelected(GenotypeSummaryPlugin.this.myIsTaxaSummary);
            panel.add(this.myOverview);
            panel.add(this.mySiteSummary);
            panel.add(this.myTaxaSummary);
            this.myTabbedPane.add((Component)panel, "Genotype Summary");
            JPanel pnlButtons = new JPanel();
            pnlButtons.setLayout(new FlowLayout());
            pnlButtons.add(okButton);
            pnlButtons.add(closeButton);
            this.getContentPane().add((Component)this.myTabbedPane, "Center");
            this.getContentPane().add((Component)pnlButtons, "South");
            this.pack();
        }

        public boolean isCancel() {
            return this.myIsCancel;
        }

        public boolean isOverview() {
            return this.myOverview.isSelected();
        }

        public boolean isSiteSummary() {
            return this.mySiteSummary.isSelected();
        }

        public boolean isTaxaSummary() {
            return this.myTaxaSummary.isSelected();
        }
    }
}

