/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.data;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.io.ProjectionGenotypeIO;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ProjectionLoadPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ProjectionLoadPlugin.class);
    private String myRecombinationBreakpoints = null;
    private String myHighDensityMarkers = null;
    private String myChromosome = null;
    private boolean hasHetSeparator;
    private boolean hasNucleotides = true;
    private boolean isPhysicalMap = true;
    private String hetSeparator;
    private String missingCharacter;

    public ProjectionLoadPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        if (this.isInteractive()) {
            ProjectionPluginDialog theDialog = new ProjectionPluginDialog();
            theDialog.setLocationRelativeTo(this.getParentFrame());
            theDialog.setVisible(true);
            if (theDialog.isCancel()) {
                return null;
            }
            theDialog.dispose();
        }
        if (this.myRecombinationBreakpoints == null || this.myRecombinationBreakpoints.length() == 0) {
            return null;
        }
        if (this.myHighDensityMarkers == null || this.myHighDensityMarkers.length() == 0) {
            return null;
        }
        try {
            DataSet result = this.loadFile(this.myRecombinationBreakpoints, this.myHighDensityMarkers);
            return result;
        }
        catch (Exception e) {
            String msg = "Recombination breakpoints " + this.myRecombinationBreakpoints + " and high density markers" + this.myHighDensityMarkers + " failed to load. " + "Make sure the import options are properly set.";
            if (this.isInteractive()) {
                JOptionPane.showMessageDialog(this.getParentFrame(), msg, "Error uploading Projection files", 0);
            } else {
                myLogger.error((Object)msg);
            }
            return null;
        }
    }

    public String getRecombinationBreakpoints() {
        return this.myRecombinationBreakpoints;
    }

    public String getHighDensityMarkers() {
        return this.myHighDensityMarkers;
    }

    public String getChromosome() {
        return this.myChromosome;
    }

    public void setRecombinationBreakpoints(String filename) {
        this.myRecombinationBreakpoints = filename;
    }

    public void setHighDensityMarkers(String filename) {
        this.myHighDensityMarkers = filename;
    }

    public void setChromosome(String chromosome) {
        this.myChromosome = chromosome;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Load Projection Alignment";
    }

    @Override
    public String getToolTipText() {
        return "Load Projection Alignments";
    }

    public DataSet loadFile(String theRecombinationBreakpoints, String theHighDensityMarkers) {
        GenotypeTable theAlignmentForGenotype = null;
        try {
            theAlignmentForGenotype = ProjectionGenotypeIO.getInstance(theRecombinationBreakpoints, theHighDensityMarkers);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        Datum td = new Datum(Utils.getFilename(theRecombinationBreakpoints, ".hmp.txt"), theAlignmentForGenotype, null);
        DataSet tds = new DataSet(td, (Plugin)this);
        this.fireDataSetReturned(new PluginEvent(tds, ProjectionLoadPlugin.class));
        return tds;
    }

    public void hasHetSeparator(boolean hasSeparator) {
        this.hasHetSeparator = hasSeparator;
    }

    public void hasNucleotides(boolean nucleotides) {
        this.hasNucleotides = nucleotides;
    }

    public void setHetSeparator(String separator) {
        this.hetSeparator = separator;
    }

    public void setMissingCharacter(String missing) {
        this.missingCharacter = missing;
    }

    public void hasPhysicalMap(boolean physicalmap) {
        this.isPhysicalMap = physicalmap;
    }

    class ProjectionPluginDialog
    extends JDialog {
        private JPanel main;
        private static final int TEXT_FIELD_WIDTH = 30;
        private JTextField myHighDensityMarkersField;
        private JTextField myRecombinationBreakpointsField;
        private JTextField myChromosomeField;
        private boolean myIsCancel;
        private JButton myHighDensityMarkersBrowseButton;
        private JButton myRecombinationBreakpointsBrowseButton;
        private final JCheckBox chkHetsSeparated;
        private final JCheckBox chkMarkersAreNucleotides;
        private final JTextField txtHetsep;
        private final JTextField txtMissing;
        private final JRadioButton radioPhysical;
        private final JRadioButton radioGenetic;

        public ProjectionPluginDialog() {
            super((Frame)null, "File Loader", true);
            this.main = null;
            this.myHighDensityMarkersField = null;
            this.myRecombinationBreakpointsField = null;
            this.myChromosomeField = null;
            this.myIsCancel = false;
            this.myHighDensityMarkersBrowseButton = null;
            this.myRecombinationBreakpointsBrowseButton = null;
            this.chkHetsSeparated = new JCheckBox("Heterozygotes are separated by a character (eg, A/T rather than AT)", true);
            this.chkMarkersAreNucleotides = new JCheckBox("Markers are nucleotides (ie, A, C, G, or T)", true);
            this.txtHetsep = new JTextField(5);
            this.txtMissing = new JTextField(5);
            this.radioPhysical = new JRadioButton("Physical", true);
            this.radioGenetic = new JRadioButton("Genetic", false);
            try {
                this.createDialog();
                this.pack();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void createDialog() {
            this.myRecombinationBreakpointsField = new JTextField(30);
            this.myRecombinationBreakpointsField.setText("(Select Recombination Breakpoints File)");
            this.myHighDensityMarkersField = new JTextField(30);
            this.myHighDensityMarkersField.setText("(Select High Density Map)");
            this.myRecombinationBreakpointsBrowseButton = new JButton("Browse...");
            this.myHighDensityMarkersBrowseButton = new JButton("Browse...");
            this.setLocationRelativeTo(ProjectionLoadPlugin.this.getParentFrame());
            this.setTitle("Load Projection Alignment");
            this.setDefaultCloseOperation(1);
            this.setUndecorated(false);
            this.getRootPane().setWindowDecorationStyle(0);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new GridBagLayout());
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent ce) {
                    ProjectionPluginDialog.this.myRecombinationBreakpointsField.requestFocusInWindow();
                }
            });
            this.myRecombinationBreakpointsBrowseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser myFileChooser = new JFileChooser(TasselPrefs.getOpenDir());
                    myFileChooser.setDialogTitle("Open a Recombination Breakpoint File");
                    if (myFileChooser.showOpenDialog(ProjectionPluginDialog.this.main) == 0) {
                        File file = myFileChooser.getSelectedFile();
                        ProjectionPluginDialog.this.myRecombinationBreakpointsField.setText(file.getPath());
                        TasselPrefs.putOpenDir(myFileChooser.getCurrentDirectory().getPath());
                    }
                }
            });
            this.myHighDensityMarkersBrowseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser myFileChooser = new JFileChooser(TasselPrefs.getOpenDir());
                    myFileChooser.setDialogTitle("Open a High-density Map File");
                    if (myFileChooser.showOpenDialog(ProjectionPluginDialog.this.main) == 0) {
                        File file = myFileChooser.getSelectedFile();
                        ProjectionPluginDialog.this.myHighDensityMarkersField.setText(file.getPath());
                        TasselPrefs.putOpenDir(myFileChooser.getCurrentDirectory().getPath());
                    }
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(6, 15, 4, 4);
            gbc.anchor = 17;
            contentPane.add((Component)new JLabel("Recombination Breakpoint File"), gbc);
            ++gbc.gridx;
            gbc.gridwidth = 2;
            gbc.insets.left = 4;
            gbc.anchor = 10;
            contentPane.add((Component)this.myRecombinationBreakpointsField, gbc);
            gbc.gridx += 2;
            gbc.gridwidth = 1;
            gbc.insets.right = 10;
            gbc.anchor = 17;
            contentPane.add((Component)this.myRecombinationBreakpointsBrowseButton, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.anchor = 17;
            gbc.insets.left = 15;
            contentPane.add((Component)new JLabel("High-Density Marker File"), gbc);
            ++gbc.gridx;
            gbc.gridwidth = 2;
            gbc.insets.left = 4;
            gbc.anchor = 10;
            contentPane.add((Component)this.myHighDensityMarkersField, gbc);
            gbc.gridx += 2;
            gbc.gridwidth = 1;
            gbc.insets.right = 10;
            gbc.anchor = 17;
            contentPane.add((Component)this.myHighDensityMarkersBrowseButton, gbc);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            buttonPanel.add(this.getOkButton());
            buttonPanel.add(Box.createHorizontalStrut(30));
            buttonPanel.add(this.getCancelButton());
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 6;
            gbc.insets.top = 25;
            gbc.anchor = 10;
            gbc.fill = 0;
            contentPane.add((Component)buttonPanel, gbc);
            this.pack();
        }

        private JButton getResetButton() {
            JButton resetButton = new JButton("Reset");
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectionPluginDialog.this.myRecombinationBreakpointsField.setText("");
                    ProjectionPluginDialog.this.myHighDensityMarkersField.setText("");
                    ProjectionPluginDialog.this.myChromosomeField.setText("");
                }
            });
            return resetButton;
        }

        private JButton getCancelButton() {
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectionPluginDialog.this.myIsCancel = true;
                    ProjectionPluginDialog.this.setVisible(false);
                }
            });
            return cancelButton;
        }

        private JButton getOkButton() {
            JButton okButton = new JButton();
            okButton.setText("Import");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectionLoadPlugin.this.myRecombinationBreakpoints = ProjectionPluginDialog.this.myRecombinationBreakpointsField.getText();
                    ProjectionLoadPlugin.this.myHighDensityMarkers = ProjectionPluginDialog.this.myHighDensityMarkersField.getText();
                    ProjectionPluginDialog.this.myIsCancel = false;
                    ProjectionPluginDialog.this.setVisible(false);
                }
            });
            return okButton;
        }

        public boolean isCancel() {
            return this.myIsCancel;
        }
    }
}

