/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.maizegenetics.analysis.data.SeparatePlugin;
import net.maizegenetics.analysis.filter.ChromosomeFilterDialog;
import net.maizegenetics.dna.snp.CombineGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.prefs.TasselPrefs;

class DataFilterAlignmentDialog
extends JDialog {
    GenotypeTable theAlignment;
    GenotypeTable chromFilteredAlignment;
    int start = 0;
    int end;
    int startPos;
    int endPos;
    int minCount = 0;
    int totalSeq;
    int siteCount = 0;
    String[] chromsAvailable;
    String[] chromsSelected;
    double minFreq = 0.01;
    double maxFreq = 1.0;
    double minPercentage = 0.5;
    boolean isCanceled = true;
    private static final int TEXT_FIELD_WIDTH = 8;
    private static final int INVALID_VALUE = -999;
    private JPanel mainPanel = new JPanel();
    private JButton filterButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton chromSelectButton = new JButton();
    private JLabel lblFilterAlignment = new JLabel();
    private JLabel lblTotalSequences = new JLabel();
    private JLabel lblMinCount = new JLabel();
    private JLabel lblMinFreq = new JLabel();
    private JLabel lblMaxFreq = new JLabel();
    private JLabel lblStartSite = new JLabel();
    private JLabel lblDistanceFromEndSite = new JLabel();
    private JLabel lblEndSite = new JLabel();
    private JLabel lblSeqLength = new JLabel();
    private JLabel lblWinSize = new JLabel();
    private JLabel lblStepSize = new JLabel();
    private JLabel lblPosType = new JLabel();
    private JLabel lblSiteIndex = new JLabel();
    private JLabel lblSitePos = new JLabel();
    private JTextField countTextField = new JTextField();
    private JTextField endTextField = new JTextField();
    private JTextField startTextField = new JTextField();
    private JTextField endPosTextField = new JTextField();
    private JTextField startPosTextField = new JTextField();
    private JTextField freqTextField = new JTextField();
    private JTextField maxFreqTextField = new JTextField();
    private JTextField winSizeTextField = new JTextField(8);
    private JTextField stepSizeTextField = new JTextField(8);
    private JPanel checkBoxPanel = new JPanel();
    private JCheckBox removeMinorCheckBox = new JCheckBox();
    private JCheckBox slidingHapCheckBox = new JCheckBox();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private String lblEndString = "End Position:";
    private boolean doBatchAnalysis = false;
    private boolean isStartTextFieldNumeric = true;
    private boolean isEndTextFieldNumeric = true;
    private boolean isStartPosTextFieldNumeric = true;
    private boolean isEndPosTextFieldNumeric = true;
    private boolean isChromSelectionValid = true;
    private ChromosomeFilterDialog myChromFilter;

    public DataFilterAlignmentDialog(GenotypeTable a, Frame f) {
        super(f, "Filter Alignment", true);
        this.chromFilteredAlignment = this.theAlignment = a;
        this.chromsAvailable = new String[this.theAlignment.numChromosomes()];
        for (int i = 0; i < this.chromsAvailable.length; ++i) {
            this.chromsAvailable[i] = this.theAlignment.chromosomes()[i].getName().trim();
        }
        this.totalSeq = this.theAlignment.numberOfTaxa();
        this.siteCount = this.theAlignment.numberOfSites();
        this.lblSeqLength.setText(" of " + (this.siteCount - 1) + " sites");
        this.lblMinCount.setText("Minimum PERCENTAGE:");
        this.start = 0;
        this.end = this.siteCount - 1;
        this.startPos = this.theAlignment.chromosomalPosition(0);
        this.endPos = this.theAlignment.chromosomalPosition(this.siteCount - 1);
        this.minCount = TasselPrefs.getFilterAlignPluginMinCount();
        this.minFreq = TasselPrefs.getFilterAlignPluginMinFreq();
        this.maxFreq = TasselPrefs.getFilterAlignPluginMaxFreq();
        this.myChromFilter = new ChromosomeFilterDialog(this.chromsAvailable, f);
        try {
            this.initUI();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void initUI() throws Exception {
        this.mainPanel.setMinimumSize(new Dimension(640, 480));
        this.mainPanel.setPreferredSize(new Dimension(640, 480));
        this.mainPanel.setLayout(this.gridBagLayout2);
        this.filterButton.setText("Filter");
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFilterAlignmentDialog.this.filterButton_actionPerformed(e);
            }
        });
        this.cancelButton.setMaximumSize(new Dimension(63, 27));
        this.cancelButton.setMinimumSize(new Dimension(63, 27));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFilterAlignmentDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.chromSelectButton.setText("Select Chromosomes...");
        this.chromSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFilterAlignmentDialog.this.chromSelectButton_actionPerformed(e);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3));
        buttonPanel.add(this.filterButton);
        if (this.chromsAvailable.length != 1) {
            buttonPanel.add(this.chromSelectButton);
        }
        buttonPanel.add(this.cancelButton);
        this.lblFilterAlignment.setFont(new Font("Dialog", 1, 16));
        this.lblFilterAlignment.setText("Filter Alignment");
        this.lblMinFreq.setText("Minimum Frequency:");
        this.lblMaxFreq.setText("Maximum Frequency:");
        this.lblStartSite.setText("Start Position:");
        this.lblPosType.setText("Position Type:");
        this.lblSiteIndex.setText(" Position index");
        this.lblSitePos.setText(" Physical Position (AGP)");
        this.lblEndSite.setText(this.lblEndString);
        this.countTextField.setMinimumSize(new Dimension(40, 25));
        this.countTextField.setPreferredSize(new Dimension(63, 25));
        if (this.doBatchAnalysis) {
            this.countTextField.setText(this.minPercentage + "");
        } else {
            this.countTextField.setText(this.minCount + "");
        }
        this.countTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DataFilterAlignmentDialog.this.countTextField_focusLost(e);
            }
        });
        this.setEndTextField();
        this.endTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DataFilterAlignmentDialog.this.endTextField_focusLost(e);
            }
        });
        this.endTextField.setPreferredSize(new Dimension(63, 25));
        this.endTextField.setMinimumSize(new Dimension(40, 25));
        this.startTextField.setText(this.start + "");
        this.startTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DataFilterAlignmentDialog.this.startTextField_focusLost(e);
            }
        });
        this.startTextField.setPreferredSize(new Dimension(63, 25));
        this.startTextField.setMinimumSize(new Dimension(40, 25));
        this.endPosTextField.setText(this.endPos + "");
        this.endPosTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DataFilterAlignmentDialog.this.endPosTextField_focusLost(e);
            }
        });
        this.endPosTextField.setPreferredSize(new Dimension(63, 25));
        this.endPosTextField.setMinimumSize(new Dimension(40, 25));
        this.startPosTextField.setText(this.startPos + "");
        this.startPosTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DataFilterAlignmentDialog.this.startPosTextField_focusLost(e);
            }
        });
        this.startPosTextField.setPreferredSize(new Dimension(63, 25));
        this.startPosTextField.setMinimumSize(new Dimension(40, 25));
        try {
            this.minFreq = TasselPrefs.getFilterAlignPluginMinFreq();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            System.err.println(" There is an issue with the settings: " + npe);
        }
        this.freqTextField.setText(this.minFreq + "");
        this.freqTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DataFilterAlignmentDialog.this.freqTextField_focusLost(e);
            }
        });
        this.freqTextField.setPreferredSize(new Dimension(63, 25));
        this.freqTextField.setMinimumSize(new Dimension(40, 25));
        this.maxFreqTextField.setText(this.maxFreq + "");
        this.maxFreqTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DataFilterAlignmentDialog.this.maxFreqTextField_focusLost(e);
            }
        });
        this.maxFreqTextField.setPreferredSize(new Dimension(63, 25));
        this.maxFreqTextField.setMinimumSize(new Dimension(40, 25));
        if (!this.doBatchAnalysis) {
            this.lblMinCount.setText("Minimum Count:");
            this.lblTotalSequences.setText(" out of " + this.totalSeq + " sequences");
        }
        this.removeMinorCheckBox.setText("Remove minor SNP states");
        this.removeMinorCheckBox.setOpaque(false);
        this.slidingHapCheckBox.setText("Generate haplotypes via sliding window");
        this.slidingHapCheckBox.setOpaque(false);
        this.slidingHapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enable = DataFilterAlignmentDialog.this.slidingHapCheckBox.isSelected();
                if (!enable) {
                    DataFilterAlignmentDialog.this.winSizeTextField.setText("");
                    DataFilterAlignmentDialog.this.stepSizeTextField.setText("");
                }
                DataFilterAlignmentDialog.this.winSizeTextField.setEnabled(enable);
                DataFilterAlignmentDialog.this.stepSizeTextField.setEnabled(enable);
                DataFilterAlignmentDialog.this.lblWinSize.setEnabled(enable);
                DataFilterAlignmentDialog.this.lblStepSize.setEnabled(enable);
            }
        });
        this.lblStepSize.setText("Step Length");
        this.lblWinSize.setText("Haplotype Length");
        this.lblStepSize.setLabelFor(this.stepSizeTextField);
        this.lblWinSize.setLabelFor(this.winSizeTextField);
        this.winSizeTextField.setEnabled(false);
        this.stepSizeTextField.setEnabled(false);
        this.lblWinSize.setEnabled(false);
        this.lblStepSize.setEnabled(false);
        JPanel winSizePanel = new JPanel();
        FlowLayout fl = new FlowLayout(2);
        winSizePanel.setLayout(fl);
        winSizePanel.add(this.lblWinSize);
        winSizePanel.add(this.winSizeTextField);
        JPanel stepSizePanel = new JPanel();
        stepSizePanel.setLayout(fl);
        stepSizePanel.add(this.lblStepSize);
        stepSizePanel.add(this.stepSizeTextField);
        this.checkBoxPanel.setLayout(new GridLayout(6, 1));
        this.checkBoxPanel.add(this.removeMinorCheckBox);
        this.checkBoxPanel.add(this.slidingHapCheckBox);
        this.checkBoxPanel.add(winSizePanel);
        this.checkBoxPanel.add(stepSizePanel);
        this.mainPanel.add((Component)this.lblFilterAlignment, new GridBagConstraints(1, 0, 4, 1, 1.0, 1.0, 10, 2, new Insets(5, 0, 0, 5), 0, 12));
        this.mainPanel.add((Component)this.lblMinCount, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
        this.mainPanel.add((Component)this.lblMinFreq, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
        this.mainPanel.add((Component)this.lblMaxFreq, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
        this.mainPanel.add((Component)this.lblPosType, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
        this.mainPanel.add((Component)this.lblStartSite, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
        this.mainPanel.add((Component)this.lblDistanceFromEndSite, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
        this.mainPanel.add((Component)this.countTextField, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
        this.mainPanel.add((Component)this.lblTotalSequences, new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 42, 3));
        this.mainPanel.add((Component)this.freqTextField, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
        this.mainPanel.add((Component)this.maxFreqTextField, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
        this.mainPanel.add((Component)this.lblSiteIndex, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 42, 3));
        this.mainPanel.add((Component)this.startTextField, new GridBagConstraints(2, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
        this.mainPanel.add((Component)this.lblSitePos, new GridBagConstraints(3, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 42, 3));
        this.mainPanel.add((Component)this.startPosTextField, new GridBagConstraints(3, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
        this.lblSitePos.setVisible(this.theAlignment.numChromosomes() == 1 && this.startPos >= 0);
        this.startPosTextField.setVisible(this.theAlignment.numChromosomes() == 1 && this.startPos >= 0);
        if (!this.doBatchAnalysis) {
            this.mainPanel.add((Component)this.lblEndSite, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 37, 14));
            this.mainPanel.add((Component)this.endTextField, new GridBagConstraints(2, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
            this.mainPanel.add((Component)this.endPosTextField, new GridBagConstraints(3, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 12, 0));
            this.endPosTextField.setVisible(this.theAlignment.numChromosomes() == 1 && this.endPos >= 0);
            this.mainPanel.add((Component)this.lblSeqLength, new GridBagConstraints(2, 7, 1, 1, 1.0, 0.6, 17, 0, new Insets(0, 0, 0, 0), 0, 3));
        }
        this.mainPanel.add((Component)this.checkBoxPanel, new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 10, 2, new Insets(15, 2, 11, 19), 0, 15));
        this.mainPanel.add((Component)buttonPanel, new GridBagConstraints(0, 12, 4, 1, 1.0, 1.0, 15, 0, new Insets(20, 50, 14, 12), 25, 12));
        this.add((Component)this.mainPanel, "Center");
    }

    private void filterButton_actionPerformed(ActionEvent e) {
        if (this.start < 0) {
            JOptionPane.showMessageDialog(this.getParent(), "Start site must be non negative.");
        } else if (this.start >= this.siteCount) {
            JOptionPane.showMessageDialog(this.getParent(), "Start site must be less than " + this.siteCount + ".");
        } else if (!this.isStartTextFieldNumeric) {
            JOptionPane.showMessageDialog(this.getParent(), "Start site must be a number between 0 and " + (this.siteCount - 1) + " inclusive.");
        } else if (this.end < 0) {
            JOptionPane.showMessageDialog(this.getParent(), "End site must be non negative.");
        } else if (this.end >= this.siteCount) {
            JOptionPane.showMessageDialog(this.getParent(), "End site must be less than " + this.siteCount + ".");
        } else if (!this.isEndTextFieldNumeric) {
            JOptionPane.showMessageDialog(this.getParent(), "End site must be a number between 0 and " + (this.siteCount - 1) + " inclusive.");
        } else if (this.start > this.end) {
            JOptionPane.showMessageDialog(this.getParent(), "Start site must be less than the end site.");
        } else if (this.startPos < 0 && this.endPos >= 0 && this.theAlignment.numChromosomes() == 1) {
            JOptionPane.showMessageDialog(this.getParent(), "Start position must be non negative.");
        } else if (this.startPos > this.theAlignment.chromosomalPosition(this.siteCount - 1) && this.theAlignment.numChromosomes() == 1) {
            JOptionPane.showMessageDialog(this.getParent(), "No available SNPs with positions greater than " + this.theAlignment.chromosomalPosition(this.siteCount - 1) + ".");
        } else if (!this.isStartPosTextFieldNumeric) {
            JOptionPane.showMessageDialog(this.getParent(), "Start position must be a number between 0 and " + this.theAlignment.chromosomalPosition(this.siteCount - 1) + " inclusive.");
        } else if (this.endPos < 0 && this.startPos >= 0 && this.theAlignment.numChromosomes() == 1) {
            JOptionPane.showMessageDialog(this.getParent(), "End Position must be non negative.");
        } else if (this.endPos < this.theAlignment.chromosomalPosition(0) && this.theAlignment.numChromosomes() == 1) {
            JOptionPane.showMessageDialog(this.getParent(), "No available SNPs with positions less than " + this.theAlignment.chromosomalPosition(0) + ".");
        } else if (!this.isEndPosTextFieldNumeric) {
            JOptionPane.showMessageDialog(this.getParent(), "End position must be a number greater than " + this.theAlignment.chromosomalPosition(0) + ".");
        } else if (this.startPos > this.endPos && this.theAlignment.numChromosomes() == 1) {
            JOptionPane.showMessageDialog(this.getParent(), "Start position must be less than the end position.");
        } else if (!this.isChromSelectionValid) {
            JOptionPane.showMessageDialog(this.getParent(), "Invalid chromosome selection");
        } else {
            this.isCanceled = false;
            this.setVisible(false);
        }
    }

    public boolean isAllSiteIncluded() {
        return true;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public double getMinimumFrequency() {
        return this.minFreq;
    }

    public double getMaximumFrequency() {
        return this.maxFreq;
    }

    public int getMinimumCount() {
        if (this.doBatchAnalysis) {
            throw new RuntimeException("This method should not be called when using an Minimum Sequence Percentage");
        }
        return this.minCount;
    }

    public double getMinPercentage() {
        if (!this.doBatchAnalysis) {
            throw new RuntimeException("This method should not be called when using an absolute Minimum Sequence Count");
        }
        return this.minPercentage;
    }

    public boolean isExtractIndels() {
        return false;
    }

    public boolean isRemoveMinorSNPs() {
        return this.removeMinorCheckBox.isSelected();
    }

    public boolean isUseSlidingWindow() {
        return this.slidingHapCheckBox.isSelected();
    }

    public int getWindowSize() {
        int windowSize = -999;
        if (this.slidingHapCheckBox.isSelected()) {
            try {
                windowSize = Integer.parseInt(this.winSizeTextField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this.getParent(), "Please enter an integer.");
            }
        }
        return windowSize;
    }

    public int getStepSize() {
        int stepSize = -999;
        if (this.slidingHapCheckBox.isSelected()) {
            try {
                stepSize = Integer.parseInt(this.stepSizeTextField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this.getParent(), "Please enter an integer.");
            }
        }
        return stepSize;
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.isCanceled = true;
        this.setVisible(false);
    }

    private void chromSelectButton_actionPerformed(ActionEvent e) {
        this.myChromFilter.setLocationRelativeTo(this);
        this.myChromFilter.setVisible(true);
        if (!this.myChromFilter.isCanceled()) {
            this.chromsSelected = this.myChromFilter.getChromsSelected();
            GenotypeTable[] selectedAlignments = new GenotypeTable[this.chromsSelected.length];
            List<Datum> availableAlignments = SeparatePlugin.separateAlignmentIntoLoci(this.theAlignment, null);
            for (int i = 0; i < this.chromsSelected.length; ++i) {
                for (int j = 0; j < availableAlignments.size(); ++j) {
                    GenotypeTable current = (GenotypeTable)availableAlignments.get(j).getData();
                    if (current.chromosomes().length != 1 || !this.chromsSelected[i].equals(current.chromosomeName(0))) continue;
                    selectedAlignments[i] = current;
                }
            }
            this.chromFilteredAlignment = CombineGenotypeTable.getInstance(selectedAlignments);
            this.lblSitePos.setVisible(this.chromFilteredAlignment.numChromosomes() == 1 && this.startPos >= 0);
            this.startPosTextField.setVisible(this.chromFilteredAlignment.numChromosomes() == 1 && this.startPos >= 0);
            this.endPosTextField.setVisible(this.chromFilteredAlignment.numChromosomes() == 1 && this.endPos >= 0);
            this.totalSeq = this.chromFilteredAlignment.numberOfTaxa();
            this.siteCount = this.chromFilteredAlignment.numberOfSites();
            this.lblSeqLength.setText(" of " + (this.siteCount - 1) + " sites");
            this.lblMinCount.setText("Minimum Count:");
            this.start = 0;
            this.end = this.siteCount - 1;
            this.startPos = this.chromFilteredAlignment.chromosomalPosition(0);
            this.endPos = this.chromFilteredAlignment.chromosomalPosition(this.siteCount - 1);
            if (this.doBatchAnalysis) {
                this.countTextField.setText(this.minPercentage + "");
            } else {
                this.countTextField.setText(this.minCount + "");
            }
            this.setEndTextField();
            this.startTextField.setText(this.start + "");
            this.endPosTextField.setText(this.endPos + "");
            this.startPosTextField.setText(this.startPos + "");
        }
    }

    public String[] getChromsSelected() {
        return this.chromsSelected;
    }

    public GenotypeTable getChromFilteredAlignment() {
        return this.chromFilteredAlignment;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    private void setEndTextField() {
        this.endTextField.setText("" + this.end);
    }

    private void endTextField_focusLost(FocusEvent e) {
        try {
            int endFromField = Integer.parseInt(this.endTextField.getText().trim());
            if (endFromField < 0) {
                throw new IllegalArgumentException("End Site Can't be Negative.");
            }
            if (endFromField >= this.siteCount) {
                throw new IllegalArgumentException("End Site Can't be Greater Than: " + (this.siteCount - 1));
            }
            this.end = endFromField;
            this.endPos = this.theAlignment.chromosomalPosition(this.end);
            this.endPosTextField.setText(String.valueOf(this.endPos));
        }
        catch (Exception ee) {
            StringBuilder builder = new StringBuilder();
            builder.append("\nProblem with End Site: ");
            builder.append(this.endTextField.getText().trim());
            builder.append("\n");
            builder.append("Number Should be a Positive Integer between:\n0 and ");
            builder.append(this.siteCount - 1);
            builder.append("\n");
            builder.append(ee.getMessage());
            builder.append("\n");
            JOptionPane.showMessageDialog(this.getParent(), builder.toString(), "Error", 0);
            try {
                this.end = this.theAlignment.siteOfPhysicalPosition(this.endPos, null);
                this.endTextField.setText(String.valueOf(this.end));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void startTextField_focusLost(FocusEvent e) {
        try {
            int startFromField = Integer.parseInt(this.startTextField.getText().trim());
            if (startFromField < 0) {
                throw new IllegalArgumentException("Start Site Can't be Negative.");
            }
            if (startFromField >= this.siteCount) {
                throw new IllegalArgumentException("Start Site Can't be Greater Than: " + (this.siteCount - 1));
            }
            this.start = startFromField;
            this.startPos = this.theAlignment.chromosomalPosition(this.start);
            this.startPosTextField.setText(String.valueOf(this.startPos));
        }
        catch (Exception ee) {
            StringBuilder builder = new StringBuilder();
            builder.append("\nProblem with Start Site: ");
            builder.append(this.startTextField.getText().trim());
            builder.append("\n");
            builder.append("Number Should be a Positive Integer between:\n0 and ");
            builder.append(this.siteCount - 1);
            builder.append("\n");
            builder.append(ee.getMessage());
            builder.append("\n");
            JOptionPane.showMessageDialog(this.getParent(), builder.toString(), "Error", 0);
            try {
                this.start = this.theAlignment.siteOfPhysicalPosition(this.startPos, null);
                this.startTextField.setText(String.valueOf(this.start));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void endPosTextField_focusLost(FocusEvent e) {
        try {
            int endPosFromField;
            if (this.endPosTextField.getText().toLowerCase().trim().contains("e")) {
                int expandedValue = Double.valueOf(this.endPosTextField.getText().trim()).intValue();
                this.endPosTextField.setText("" + expandedValue);
            }
            if ((endPosFromField = Integer.parseInt(this.endPosTextField.getText().trim())) < 0) {
                throw new IllegalArgumentException("End Position Can't be Negative.");
            }
            int endSite = this.theAlignment.siteOfPhysicalPosition(endPosFromField, null);
            if (endSite < 0) {
                endSite = -(endSite + 1);
            }
            if (endSite >= this.siteCount) {
                endSite = this.siteCount - 1;
            }
            this.end = endSite;
            this.endPos = this.theAlignment.chromosomalPosition(this.end);
            this.endTextField.setText(String.valueOf(this.end));
        }
        catch (Exception ee) {
            ee.printStackTrace();
            StringBuilder builder = new StringBuilder();
            builder.append("\nProblem with End Physical Position: ");
            builder.append(this.endPosTextField.getText().trim());
            builder.append("\n");
            builder.append("Number Should be a Positive Integer between: \n");
            builder.append(this.theAlignment.chromosomalPosition(0));
            builder.append(" and ");
            builder.append(this.theAlignment.chromosomalPosition(this.siteCount - 1));
            builder.append("\n");
            builder.append(ee.getMessage());
            builder.append("\n");
            JOptionPane.showMessageDialog(this.getParent(), builder.toString(), "Error", 0);
            try {
                this.endPos = this.theAlignment.chromosomalPosition(this.end);
                this.endPosTextField.setText(String.valueOf(this.endPos));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void startPosTextField_focusLost(FocusEvent e) {
        try {
            int startPosFromField;
            if (this.startPosTextField.getText().toLowerCase().trim().contains("e")) {
                int expandedValue = Double.valueOf(this.startPosTextField.getText().trim()).intValue();
                this.startPosTextField.setText("" + expandedValue);
            }
            if ((startPosFromField = Integer.parseInt(this.startPosTextField.getText().trim())) < 0) {
                throw new IllegalArgumentException("Start Position Can't be Negative.");
            }
            int startSite = this.theAlignment.siteOfPhysicalPosition(startPosFromField, null);
            if (startSite < 0) {
                startSite = -(startSite + 1);
            }
            if (startSite >= this.siteCount) {
                startSite = this.siteCount - 1;
            }
            this.start = startSite;
            this.startPos = this.theAlignment.chromosomalPosition(this.start);
            this.startTextField.setText(String.valueOf(this.start));
        }
        catch (Exception ee) {
            StringBuilder builder = new StringBuilder();
            builder.append("\nProblem with Start Physical Position: ");
            builder.append(this.startPosTextField.getText().trim());
            builder.append("\n");
            builder.append("Number Should be a Positive Integer between: \n");
            builder.append(this.theAlignment.chromosomalPosition(0));
            builder.append(" and ");
            builder.append(this.theAlignment.chromosomalPosition(this.siteCount - 1));
            builder.append("\n");
            builder.append(ee.getMessage());
            builder.append("\n");
            JOptionPane.showMessageDialog(this.getParent(), builder.toString(), "Error", 0);
            try {
                this.startPos = this.theAlignment.chromosomalPosition(this.start);
                this.startPosTextField.setText(String.valueOf(this.startPos));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void freqTextField_focusLost(FocusEvent e) {
        try {
            String input = this.freqTextField.getText().trim();
            double tmpMinFreq = -0.1;
            if (input != null) {
                tmpMinFreq = Double.parseDouble(input);
            }
            if (tmpMinFreq > 1.0 || tmpMinFreq < 0.0) {
                tmpMinFreq = this.minFreq;
            }
            this.minFreq = tmpMinFreq;
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.getParent(), "Could not parse \"Minimum Frequency\".  Please enter a value between 0.0 and 1.0");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.freqTextField.setText(this.minFreq + "");
        TasselPrefs.putFilterAlignPluginMinFreq(this.minFreq);
    }

    private void maxFreqTextField_focusLost(FocusEvent e) {
        try {
            String input = this.maxFreqTextField.getText().trim();
            double tmpMaxFreq = -0.1;
            if (input != null) {
                tmpMaxFreq = Double.parseDouble(input);
            }
            if (tmpMaxFreq > 1.0 || tmpMaxFreq < 0.0) {
                tmpMaxFreq = this.maxFreq;
            }
            this.maxFreq = tmpMaxFreq;
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.getParent(), "Could not parse \"Maximum Frequency\".  Please enter a value between 0.0 and 1.0");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.maxFreqTextField.setText(this.maxFreq + "");
        TasselPrefs.putFilterAlignPluginMaxFreq(this.maxFreq);
    }

    private void countTextField_focusLost(FocusEvent e) {
        if (this.doBatchAnalysis) {
            double minPercentageOriginal = this.minPercentage;
            try {
                this.minPercentage = Double.parseDouble(this.countTextField.getText().trim());
                if (this.minPercentage > 1.0 || this.minPercentage < 0.0) {
                    this.minPercentage = minPercentageOriginal;
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                this.minPercentage = minPercentageOriginal;
            }
            this.countTextField.setText(this.minPercentage + "");
        } else {
            int minCountOriginal = this.minCount;
            try {
                this.minCount = Integer.parseInt(this.countTextField.getText().trim());
                if (this.minCount > this.theAlignment.numberOfTaxa() || this.minCount < 0) {
                    this.minCount = minCountOriginal;
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                this.minCount = minCountOriginal;
            }
            this.countTextField.setText(this.minCount + "");
            TasselPrefs.putFilterAlignPluginMinCount(this.minCount);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(600, 600);
    }
}

