/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import net.maizegenetics.util.Utils;

class CustomSNPLog {
    private BufferedWriter myWriter;
    private final String HEADER = "Chr\tTagLocusStartPos\tTagLocusStrand\tSNPPosition\tAlleles\tnTagsAtLocus\tnReads\tnTaxa\tnTaxaCovered\tnInbreds\tnInbredsCovered\tnInbreds1Read\tnInbreds1ReadMaj\tnInbreds1ReadMin\tnInbredsGT1Read\tnInbredsGT1ReadHomoMaj\tnInbredsGT1ReadHomoMin\tnInbredHets\tinbredCoverage\tinbredHetScore\tnOutbreds\tnOutbredsCovered\tnOutbreds1Read\tnOutbreds1ReadMaj\tnOutbreds1ReadMin\tnOutbredsGT1Read\tnOutbredsGT1ReadHomoMaj\tnOutbredsGT1ReadHomoMin\tnOutbredHets\tpassed?\n";

    public CustomSNPLog(String locusLogFileName) {
        try {
            String locusLogFileDir = new File(locusLogFileName).getCanonicalFile().getParent();
            String snpLogFileName = locusLogFileDir + File.separator + "CustomSNPLog.txt";
            this.myWriter = Utils.getBufferedWriter(snpLogFileName, false);
            this.myWriter.append("Chr\tTagLocusStartPos\tTagLocusStrand\tSNPPosition\tAlleles\tnTagsAtLocus\tnReads\tnTaxa\tnTaxaCovered\tnInbreds\tnInbredsCovered\tnInbreds1Read\tnInbreds1ReadMaj\tnInbreds1ReadMin\tnInbredsGT1Read\tnInbredsGT1ReadHomoMaj\tnInbredsGT1ReadHomoMin\tnInbredHets\tinbredCoverage\tinbredHetScore\tnOutbreds\tnOutbredsCovered\tnOutbreds1Read\tnOutbreds1ReadMaj\tnOutbreds1ReadMin\tnOutbredsGT1Read\tnOutbredsGT1ReadHomoMaj\tnOutbredsGT1ReadHomoMin\tnOutbredHets\tpassed?\n");
        }
        catch (IOException e) {
            System.out.println("\n\nERROR: problem creating custom SNP log file: " + e + "\n\n");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void writeEntry(String entry) {
        try {
            this.myWriter.append(entry);
        }
        catch (IOException e) {
            System.out.println("\n\nERROR: problem writing to custom SNP log file: " + e + "\n\n");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void close() {
        try {
            this.myWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

