/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.PEParseBarcodeRead;
import net.maizegenetics.analysis.gbs.PEReadBarcodeResult;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.MultiMemberGZIPInputStream;
import org.apache.log4j.Logger;

public class FastqToPETagCountPlugin
extends AbstractPlugin {
    static long timePoint1;
    private ArgsEngine engine = null;
    private Logger logger = Logger.getLogger(FastqToPETagCountPlugin.class);
    String inputFileSWithBarcode = null;
    String inputFileSWithoutBarcode = null;
    String keyfile = null;
    String enzyme = null;
    int tagLengthInLong = 8;
    int minCount = 1;
    String outputDirS = null;

    public FastqToPETagCountPlugin() {
        super(null, false);
    }

    public FastqToPETagCountPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    private void printUsage() {
        this.logger.info((Object)"\n\nUsage is as follows:\n -iF Qseq file with barcode\n -iB Qseq file without barcode\n -k  Key file listing barcodes for each sample\n -e  Enzyme used to create the GBS library, if it differs from the one listed in the key file.\n -l  Tag length in Long type (Default is 2).\n -c  Minimum tag count (default is 1).\n -o  Output directory to contain .pe.cnt files\n");
    }

    @Override
    public DataSet performFunction(DataSet input) {
        this.countTags(this.keyfile, this.enzyme, this.inputFileSWithBarcode, this.inputFileSWithoutBarcode, this.minCount, this.tagLengthInLong);
        return null;
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.engine == null) {
            this.engine = new ArgsEngine();
            this.engine.add("-iF", "--input-barcode", true);
            this.engine.add("-iB", "--input-noBarcode", true);
            this.engine.add("-k", "--key-file", true);
            this.engine.add("-e", "--enzyme", true);
            this.engine.add("-l", "--tag-lengthInLong", true);
            this.engine.add("-c", "--min-count", true);
            this.engine.add("-o", "--output-directory", true);
            this.engine.parse(args);
        }
        if (!this.engine.getBoolean("-iF")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify the Illumina file with barcode");
        }
        this.inputFileSWithBarcode = this.engine.getString("-iF");
        if (!this.engine.getBoolean("-iB")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify the Illumina file without barcode");
        }
        this.inputFileSWithoutBarcode = this.engine.getString("-iB");
        if (!this.engine.getBoolean("-k")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a barcode key file.");
        }
        this.keyfile = this.engine.getString("-k");
        if (this.engine.getBoolean("-e")) {
            this.enzyme = this.engine.getString("-e");
        } else {
            System.out.println("No enzyme specified.  Using enzyme listed in key file.");
        }
        if (this.engine.getBoolean("-l")) {
            this.tagLengthInLong = Integer.parseInt(this.engine.getString("-l"));
        }
        if (this.engine.getBoolean("-c")) {
            this.minCount = Integer.parseInt(this.engine.getString("-c"));
        }
        if (!this.engine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a PETagCount directory.");
        }
        this.outputDirS = this.engine.getString("-o");
    }

    public void countTags(String keyFileS, String enzyme, String inputFileSWithBarcode, String inputFileSWithoutBarcode, int minCount, int tagLengthInLong) {
        Object countFileNames = null;
        int allReads = 0;
        int goodBarcodedReads = 0;
        File inputFileWithBarcode = new File(inputFileSWithBarcode);
        File inputFileWithoutBarcode = new File(inputFileSWithoutBarcode);
        String[] filenameField = inputFileWithBarcode.getName().split("_");
        if (filenameField.length != 4) {
            System.out.println("Error in parsing file name:");
            System.out.println("The filename does not contain either 3 or 5 underscore-delimited values.");
            System.out.println("Expect: flowcell_lane_qseq.txt OR code_flowcell_s_lane_qseq.txt");
            System.out.println("Filename: " + inputFileSWithBarcode);
            return;
        }
        PEParseBarcodeRead thePBR = new PEParseBarcodeRead(keyFileS, enzyme, filenameField[0], filenameField[1]);
        System.out.println("Total barcodes found in lane:" + thePBR.getBarCodeCount());
        if (thePBR.getBarCodeCount() == 0) {
            System.out.println("No barcodes found.  Skipping this flowcell lane.");
            System.exit(1);
        }
        Object[] taxaNames = new String[thePBR.getBarCodeCount()];
        for (int i = 0; i < taxaNames.length; ++i) {
            taxaNames[i] = thePBR.getTheBarcodes(i).getTaxaName();
        }
        Arrays.sort(taxaNames);
        TaxonOutput[] tops = new TaxonOutput[taxaNames.length];
        File outputDir = new File(this.outputDirS);
        for (int i = 0; i < tops.length; ++i) {
            tops[i] = new TaxonOutput(outputDir, (String)taxaNames[i], tagLengthInLong);
        }
        try {
            BufferedReader brB;
            BufferedReader brF;
            if (inputFileWithBarcode.getName().endsWith(".gz")) {
                brF = new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(inputFileWithBarcode))));
                brB = new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(inputFileWithoutBarcode))));
            } else {
                brF = new BufferedReader(new FileReader(inputFileWithBarcode), 65536);
                brB = new BufferedReader(new FileReader(inputFileWithoutBarcode), 65536);
            }
            String sequenceF = null;
            String qualityScoreF = null;
            String temp = null;
            String sequenceB = null;
            String qualityScoreB = null;
            while ((temp = brF.readLine()) != null) {
                try {
                    brB.readLine();
                    sequenceF = brF.readLine();
                    sequenceB = brB.readLine();
                    brF.readLine();
                    brB.readLine();
                    qualityScoreF = brF.readLine();
                    qualityScoreB = brB.readLine();
                    ++allReads;
                }
                catch (NullPointerException e) {
                    System.out.println("Read a line that lacks a sequence and quality score in fields 9 and 10.  Your file may have been corrupted.");
                    System.exit(0);
                }
                PEReadBarcodeResult rr = thePBR.parseReadIntoTagAndTaxa(sequenceF, qualityScoreF, sequenceB, qualityScoreB, true, 0, tagLengthInLong);
                if (rr != null) {
                    ++goodBarcodedReads;
                    int index = Arrays.binarySearch(taxaNames, rr.getTaxonName());
                    tops[index].write(rr);
                }
                if (allReads % 1000000 != 0) continue;
                System.out.println("Total Reads:" + allReads + " Reads with barcode and cut site overhang:" + goodBarcodedReads);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < tops.length; ++i) {
            tops[i].close();
        }
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class TaxonOutput {
        File taxonoutfile;
        DataOutputStream dos;

        TaxonOutput(File parentDir, String taxonName, int tagLengthInLong) {
            this.setupOutput(parentDir, taxonName, tagLengthInLong);
        }

        void setupOutput(File parentDir, String taxonName, int tagLengthInLong) {
            this.taxonoutfile = new File(parentDir, taxonName.replaceAll(":", "_") + ".pe.cnt");
            try {
                this.dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.taxonoutfile), 65536));
                this.dos.writeInt(tagLengthInLong);
                this.dos.writeInt(-1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void write(PEReadBarcodeResult rr) {
            try {
                int i;
                for (i = 0; i < rr.getTagLengthInLong(); ++i) {
                    this.dos.writeLong(rr.getReadF()[i]);
                }
                this.dos.writeShort(rr.getLengthF());
                for (i = 0; i < rr.getTagLengthInLong(); ++i) {
                    this.dos.writeLong(rr.getReadB()[i]);
                }
                this.dos.writeShort(rr.getLengthB());
                this.dos.writeByte(0);
                this.dos.writeShort(0);
                this.dos.writeInt(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void close() {
            try {
                this.dos.flush();
                this.dos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

