/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.VCFUtil;
import org.apache.log4j.Logger;

public class MergeIdenticalTaxaPlugin
extends AbstractPlugin {
    int startChromosome = 1;
    int endChromosome = 10;
    private ArgsEngine myArgsEngine = null;
    private static final Logger myLogger = Logger.getLogger(MergeIdenticalTaxaPlugin.class);
    private String suppliedInputFileName;
    private String suppliedOutputFileName;
    private String infile;
    private String outfile;
    private double majorityRule = 0.8;
    private boolean makeHetCalls = true;
    String[] lowCoverageTaxa = null;
    private INPUT_FORMAT inputFormat = INPUT_FORMAT.hapmap;
    private int myMaxNumAlleles;

    public MergeIdenticalTaxaPlugin() {
        super(null, false);
    }

    public MergeIdenticalTaxaPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        return null;
    }

    public static byte[] consensusCalls(GenotypeTable a, List<String> taxa, boolean callhets, double majority) {
        short[][] siteCnt = new short[2][a.numberOfSites()];
        int[] taxaIndex = new int[taxa.size()];
        for (int t = 0; t < taxaIndex.length; ++t) {
            taxaIndex[t] = a.taxa().indexOf(taxa.get(t));
        }
        byte[] calls = new byte[a.numberOfSites()];
        Arrays.fill(calls, (byte)-1);
        for (int s = 0; s < a.numberOfSites(); ++s) {
            byte mjAllele = a.majorAllele(s);
            byte mnAllele = a.minorAllele(s);
            byte mj = GenotypeTableUtils.getDiploidValue(mjAllele, mjAllele);
            byte mn = GenotypeTableUtils.getDiploidValue(mnAllele, mnAllele);
            byte het = GenotypeTableUtils.getUnphasedDiploidValue(mjAllele, mnAllele);
            for (int t = 0; t < taxaIndex.length; ++t) {
                byte ob = a.genotype(taxaIndex[t], s);
                if (ob == -1) continue;
                if (ob == mj) {
                    short[] sArray = siteCnt[0];
                    int n = s;
                    sArray[n] = (short)(sArray[n] + 1);
                    continue;
                }
                if (ob == mn) {
                    short[] sArray = siteCnt[1];
                    int n = s;
                    sArray[n] = (short)(sArray[n] + 1);
                    continue;
                }
                if (!GenotypeTableUtils.isEqual(ob, het)) continue;
                short[] sArray = siteCnt[0];
                int n = s;
                sArray[n] = (short)(sArray[n] + 1);
                short[] sArray2 = siteCnt[1];
                int n2 = s;
                sArray2[n2] = (short)(sArray2[n2] + 1);
            }
            int totalCnt = siteCnt[0][s] + siteCnt[1][s];
            if (totalCnt == 0) continue;
            if ((double)siteCnt[0][s] / (double)totalCnt > majority) {
                calls[s] = mj;
                continue;
            }
            if ((double)siteCnt[1][s] / (double)totalCnt > majority) {
                calls[s] = mn;
                continue;
            }
            if (!callhets) continue;
            calls[s] = het;
        }
        return calls;
    }

    public static byte[][] consensusCallsForVCF(GenotypeTable a, List<String> taxa, int MaxNumAlleles) {
        byte[][] result;
        for (byte[] row : result = new byte[MaxNumAlleles + 1][a.numberOfSites()]) {
            Arrays.fill(row, (byte)0);
        }
        Arrays.fill(result[0], (byte)-1);
        int[] taxaIndex = new int[taxa.size()];
        for (int t = 0; t < taxa.size(); ++t) {
            taxaIndex[t] = a.taxa().indexOf(taxa.get(t));
        }
        for (int s = 0; s < a.numberOfSites(); ++s) {
            byte[] alleles = a.allelesBySortType(GenotypeTable.ALLELE_SORT_TYPE.Depth, s);
            int[] alleleDepth = new int[alleles.length];
            Arrays.fill(alleleDepth, 0);
            for (int t = 0; t < taxaIndex.length; ++t) {
                int[] myAlleledepth = a.depthForAlleles(taxaIndex[t], s);
                for (int al = 0; al < myAlleledepth.length; ++al) {
                    int n = al;
                    alleleDepth[n] = alleleDepth[n] + myAlleledepth[al];
                }
            }
            result[0][s] = VCFUtil.resolveVCFGeno(alleles, alleleDepth);
            for (int al = 0; al < alleles.length; ++al) {
                result[al + 1][s] = (byte)(alleleDepth[al] > 127 ? 127 : alleleDepth[al]);
            }
        }
        return result;
    }

    private void printUsage() {
        myLogger.info((Object)("Input format:\n-hmp      Input HapMap file; use a plus sign (+) as a wild card character to             specify multiple chromosome numbers.\n-vcf      Input VCF file. Use a plus sign (+) as a wild card character to specify multiple chromosome numbers. Options -hmp and -vcf are mutual exclusive.\n-o        Output HapMap file; use a plus sign (+) as a wild card character to             specify multiple chromosome numbers.\n-xHet     Exclude heterozygotes calls (default: " + this.makeHetCalls + ")" + "-hetFreq  Cutoff frequency between het vs. homozygote calls (default: " + this.majorityRule + ")" + "-sC       Start chromosome (default 1).\n" + "-eC       End chromosome (default 10).\n" + "-maxAlleleVCF   Maximum number of alleles allowed in vcf file.\n"));
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-hmp", "-hmpFile", true);
            this.myArgsEngine.add("-vcf", "-vcfFile", true);
            this.myArgsEngine.add("-o", "--outFile", true);
            this.myArgsEngine.add("-xHets", "--excludeHets", false);
            this.myArgsEngine.add("-hetFreq", "--heterozygoteFreqCutoff", true);
            this.myArgsEngine.add("-sC", "--startChrom", true);
            this.myArgsEngine.add("-eC", "--endChrom", true);
            this.myArgsEngine.add("-maxAlleleVCF", "--maxAlleleVCF", true);
        }
        this.myArgsEngine.parse(args);
        if (!this.myArgsEngine.getBoolean("-sC")) {
            this.printUsage();
            throw new IllegalArgumentException("Please provide a start chromosome.\n");
        }
        this.startChromosome = Integer.parseInt(this.myArgsEngine.getString("-sC"));
        if (!this.myArgsEngine.getBoolean("-eC")) {
            this.printUsage();
            throw new IllegalArgumentException("Please provide an end chromosome.\n");
        }
        this.endChromosome = Integer.parseInt(this.myArgsEngine.getString("-eC"));
        if (this.myArgsEngine.getBoolean("-hmp")) {
            if (this.myArgsEngine.getBoolean("-vcf")) {
                throw new IllegalArgumentException("-hmp and -vcf options are mutual exclusive!\n");
            }
            this.suppliedInputFileName = this.myArgsEngine.getString("-hmp");
            this.inputFormat = INPUT_FORMAT.hapmap;
        } else if (this.myArgsEngine.getBoolean("-vcf")) {
            this.suppliedInputFileName = this.myArgsEngine.getString("-vcf");
            this.inputFormat = INPUT_FORMAT.vcf;
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a HapMap file or VCF to merge taxa.\n");
        }
        if (!this.myArgsEngine.getBoolean("-o")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an output file name.\n");
        }
        this.suppliedOutputFileName = this.myArgsEngine.getString("-o");
        if (this.myArgsEngine.getBoolean("-xHets")) {
            this.makeHetCalls = false;
        }
        if (this.myArgsEngine.getBoolean("-hetFreq")) {
            this.majorityRule = Double.parseDouble(this.myArgsEngine.getString("-hetFreq"));
        }
        if (this.myArgsEngine.getBoolean("-maxAlleleVCF")) {
            if (!this.myArgsEngine.getBoolean("-vcf")) {
                throw new IllegalArgumentException("-maxAlleleVCF option only works with -vcf input.\n");
            }
            this.myMaxNumAlleles = Integer.parseInt(this.myArgsEngine.getString("-maxAlleleVCF"));
        } else {
            this.myMaxNumAlleles = 3;
        }
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static enum INPUT_FORMAT {
        hapmap,
        vcf;

    }
}

