/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import net.maizegenetics.analysis.gbs.Barcode;
import net.maizegenetics.analysis.gbs.PEReadBarcodeResult;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead;
import net.maizegenetics.analysis.gbs.ShortReadBarcodeResult;
import net.maizegenetics.dna.BaseEncoder;

public class PEParseBarcodeRead
extends ParseBarcodeRead {
    String[] bLikelyReadEnd = new String[likelyReadEnd.length / 2];

    public PEParseBarcodeRead(String keyFile, String enzyme, String flowcell, String lane) {
        super(keyFile, enzyme, flowcell, lane);
        for (int i = 0; i < this.bLikelyReadEnd.length; ++i) {
            this.bLikelyReadEnd[i] = likelyReadEnd[i];
        }
    }

    public PEReadBarcodeResult parseReadIntoTagAndTaxa(String seqSF, String qualSF, String seqSB, String qualSB, boolean fastq, int minQual, int tagLengthInLong) {
        int firstBadBase;
        boolean ifMatch = false;
        for (int i = 0; i < initialCutSiteRemnant.length; ++i) {
            if (!seqSB.startsWith(initialCutSiteRemnant[i])) continue;
            ifMatch = true;
            break;
        }
        if (!ifMatch) {
            return null;
        }
        if (minQual > 0 && qualSF != null && (firstBadBase = BaseEncoder.getFirstLowQualityPos(qualSF, minQual)) < maxBarcodeLength + tagLengthInLong * 32) {
            return null;
        }
        if (minQual > 0 && qualSB != null && (firstBadBase = BaseEncoder.getFirstLowQualityPos(qualSB, minQual)) < maxBarcodeLength + tagLengthInLong * 32) {
            return null;
        }
        int miss1 = -1;
        int miss2 = -1;
        if (fastq) {
            miss1 = seqSF.indexOf(78);
            miss2 = seqSB.indexOf(78);
        } else {
            miss1 = seqSF.indexOf(46);
            miss2 = seqSB.indexOf(46);
        }
        if (miss1 != -1 && miss1 < maxBarcodeLength + tagLengthInLong * 32) {
            return null;
        }
        if (miss2 != -1 && miss2 < tagLengthInLong * 32) {
            return null;
        }
        Barcode bestBarcode = this.findBestBarcode(seqSF, this.maximumMismatchInBarcodeAndOverhang);
        if (bestBarcode == null) {
            return null;
        }
        String genomicSeqF = seqSF.substring(bestBarcode.barLength, seqSF.length());
        ShortReadBarcodeResult tagProcessingResultsF = this.removeSeqAfterSecondCutSite(genomicSeqF, (short)(tagLengthInLong * 32), tagLengthInLong, bestBarcode.getTaxaName(), true);
        String genomicSeqB = this.removeSeqAfterBarcode(bestBarcode.barcodeS, genomicSeqF, seqSB);
        ShortReadBarcodeResult tagProcessingResultsB = this.removeSeqAfterSecondCutSite(genomicSeqB, (short)(tagLengthInLong * 32), tagLengthInLong, bestBarcode.getTaxaName(), false);
        return new PEReadBarcodeResult(tagProcessingResultsF, tagProcessingResultsB);
    }

    private String removeSeqAfterBarcode(String bestBarcodeS, String genomicSeqF, String seqSB) {
        String barcodeGenomicS = bestBarcodeS + genomicSeqF.substring(0, readEndCutSiteRemnantLength);
        String rBarcodeGenomicS = BaseEncoder.getReverseComplement(barcodeGenomicS);
        int index = seqSB.indexOf(rBarcodeGenomicS);
        if (index == -1) {
            return seqSB;
        }
        return seqSB.substring(0, index + readEndCutSiteRemnantLength);
    }

    public ShortReadBarcodeResult removeSeqAfterSecondCutSite(String seq, short maxLength, int tagLengthInLong, String taxaName, boolean ifForward) {
        int p;
        int cutSitePosition = 9999;
        ShortReadBarcodeResult returnValue = new ShortReadBarcodeResult(seq);
        returnValue.taxonName = taxaName;
        String match = null;
        for (String potentialCutSite : likelyReadEnd) {
            p = seq.indexOf(potentialCutSite, 1);
            if (p <= 1 || p >= cutSitePosition) continue;
            cutSitePosition = p;
            match = potentialCutSite;
        }
        if (theEnzyme.equalsIgnoreCase("ApeKI") && cutSitePosition == 2 && (match.equalsIgnoreCase("GCAGC") || match.equalsIgnoreCase("GCTGC"))) {
            seq = seq.substring(3, seq.length());
            cutSitePosition = 9999;
            returnValue.unprocessedSequence = seq;
            if (ifForward) {
                for (String potentialCutSite : likelyReadEnd) {
                    p = seq.indexOf(potentialCutSite, 1);
                    if (p <= 1 || p >= cutSitePosition) continue;
                    cutSitePosition = p;
                }
            } else {
                for (String potentialCutSite : this.bLikelyReadEnd) {
                    p = seq.indexOf(potentialCutSite, 1);
                    if (p <= 1 || p >= cutSitePosition) continue;
                    cutSitePosition = p;
                }
            }
        }
        if (cutSitePosition < maxLength) {
            returnValue.length = (short)(cutSitePosition + readEndCutSiteRemnantLength);
            returnValue.processedSequence = seq.substring(0, cutSitePosition + readEndCutSiteRemnantLength);
        } else if (seq.length() <= 0) {
            returnValue.processedSequence = "";
            returnValue.length = 0;
        } else {
            returnValue.length = (short)Math.min(seq.length(), maxLength);
            returnValue.processedSequence = seq.substring(0, returnValue.length);
        }
        if (returnValue.length < maxLength) {
            returnValue.paddedSequence = returnValue.processedSequence + nullS;
            returnValue.paddedSequence = returnValue.paddedSequence.substring(0, maxLength);
        } else {
            returnValue.paddedSequence = returnValue.processedSequence.substring(0, maxLength);
            returnValue.length = (short)maxLength;
        }
        returnValue.read = BaseEncoder.getLongArrayFromSeq(returnValue.paddedSequence);
        return returnValue;
    }
}

