/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.ParseBarcodeRead;
import net.maizegenetics.analysis.gbs.ReadBarcodeResult;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.TagCounts;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaByte;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.util.ArgsEngine;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.MultiMemberGZIPInputStream;
import org.apache.log4j.Logger;

public class QseqToTBTPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(QseqToTBTPlugin.class);
    private ArgsEngine myArgsEngine = null;
    private String[] myQseqFileS = null;
    private String myKeyFile = null;
    private String myEnzyme = null;
    private String myOutputDir = null;
    private int myMinCount = 1;
    private Tags myMasterTags = null;
    private boolean useTBTByte = false;

    public QseqToTBTPlugin() {
        super(null, false);
    }

    public QseqToTBTPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        QseqToTBTPlugin.matchTagsToTaxa(this.myQseqFileS, this.myKeyFile, this.myEnzyme, this.myMasterTags, this.myOutputDir, this.myMinCount, this.useTBTByte);
        return null;
    }

    private void printUsage() {
        myLogger.info((Object)"\nUsage is as follows:\n-i  Input directory containing .qseq files\n-k  Barcode key file\n-e  Enzyme used to create the GBS library, if it differs from the one listed in the key file.\n-o  Output directory\n-c  Minimum taxa count within a qseq file for a tag to be output (default 1)\n-y  Output to tagsByTaxaByte (tag counts per taxon from 0 to 127) instead of tagsByTaxaBit (0 or 1)\nOne of either:\n    -t  Tag count file, OR A\n    -m  Physical map file containing alignments\n");
    }

    @Override
    public void setParameters(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            throw new IllegalArgumentException("\n\nPlease use the above arguments/options.\n\n");
        }
        if (this.myArgsEngine == null) {
            this.myArgsEngine = new ArgsEngine();
            this.myArgsEngine.add("-i", "--input-directory", true);
            this.myArgsEngine.add("-k", "--key-file", true);
            this.myArgsEngine.add("-e", "--enzyme", true);
            this.myArgsEngine.add("-o", "--output-directory", true);
            this.myArgsEngine.add("-c", "--min-count", true);
            this.myArgsEngine.add("-y", "--TBTbyte", false);
            this.myArgsEngine.add("-t", "--tag-count", true);
            this.myArgsEngine.add("-m", "--physical-map", true);
        }
        this.myArgsEngine.parse(args);
        String tempDirectory = this.myArgsEngine.getString("-i");
        if (tempDirectory != null) {
            File qseqDirectory = new File(tempDirectory);
            if (!qseqDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("setParameters: The input name you supplied is not a directory: " + tempDirectory);
            }
            this.myQseqFileS = DirectoryCrawler.listFileNames(".*_qseq\\.txt$|.*_qseq\\.txt\\.gz$", qseqDirectory.getAbsolutePath());
            if (this.myQseqFileS.length == 0 || this.myQseqFileS == null) {
                this.printUsage();
                throw new IllegalArgumentException("Couldn't find any files that end with \"_qseq.txt\" or \"_qseq.txt.gz\" in the supplied directory: " + tempDirectory);
            }
            myLogger.info((Object)"QseqToTBTPlugin: setParameters: Using the following .qseq files:");
            for (String filename : this.myQseqFileS) {
                myLogger.info((Object)filename);
            }
        }
        if (!this.myArgsEngine.getBoolean("-k")) {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a key file (option -k).");
        }
        this.myKeyFile = this.myArgsEngine.getString("-k");
        if (this.myArgsEngine.getBoolean("-e")) {
            this.myEnzyme = this.myArgsEngine.getString("-e");
        } else {
            System.out.println("No enzyme specified.  Using enzyme listed in key file.");
        }
        if (this.myArgsEngine.getBoolean("-o")) {
            this.myOutputDir = this.myArgsEngine.getString("-o");
            File outDirectory = new File(this.myOutputDir);
            if (!outDirectory.isDirectory()) {
                this.printUsage();
                throw new IllegalArgumentException("The output name you supplied (option -o) is not a directory: " + this.myOutputDir);
            }
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify an output directory (option -o).");
        }
        Object var3_3 = null;
        this.myMinCount = this.myArgsEngine.getBoolean("-c") ? Integer.parseInt(this.myArgsEngine.getString("-c")) : 1;
        if (this.myArgsEngine.getBoolean("-y")) {
            this.useTBTByte = true;
        }
        if (this.myArgsEngine.getBoolean("-t")) {
            if (this.myArgsEngine.getBoolean("-m")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -t and -m are mutually exclusive.");
            }
            this.myMasterTags = new TagCounts(this.myArgsEngine.getString("-t"), TagsByTaxa.FilePacking.Byte);
        } else if (this.myArgsEngine.getBoolean("-m")) {
            if (this.myArgsEngine.getBoolean("-t")) {
                this.printUsage();
                throw new IllegalArgumentException("Options -t and -m are mutually exclusive.");
            }
            this.myMasterTags = new TagsOnPhysicalMap(this.myArgsEngine.getString("-m"), true);
        } else {
            this.printUsage();
            throw new IllegalArgumentException("Please specify a tagCounts file (-t) *OR* a TagsOnPhysicalMap file (-m)");
        }
    }

    public static void matchTagsToTaxa(String[] qseqFileS, String keyFileS, String enzyme, Tags theMasterTags, String outputDir, int minCount, boolean useTBTByte) {
        for (int laneNum = 0; laneNum < qseqFileS.length; ++laneNum) {
            ParseBarcodeRead thePBR;
            System.out.println("\nWorking on qseq file: " + qseqFileS[laneNum]);
            TagsByTaxaByte theTBT = null;
            System.gc();
            TagsByTaxa.FilePacking outFormat = TagsByTaxa.FilePacking.Byte;
            String outFileS = outputDir + qseqFileS[laneNum].substring(qseqFileS[laneNum].lastIndexOf(File.separator));
            String replaceS = outFormat == TagsByTaxa.FilePacking.Text ? ".tbt.txt" : (outFormat == TagsByTaxa.FilePacking.Byte ? ".tbt.byte" : ".tbt.bin");
            File outfile = new File(outFileS.replaceAll("_qseq\\.txt$|_qseq\\.txt\\.gz$", replaceS));
            if (outfile.isFile()) {
                System.out.println("An output file " + outfile.getName() + "\n" + " already exists in the output directory for file " + qseqFileS[laneNum] + ".  Skipping.");
                continue;
            }
            int goodBarcodedReads = 0;
            int allReads = 0;
            int goodMatched = 0;
            File qseqFile = new File(qseqFileS[laneNum]);
            String[] np = qseqFile.getName().split("_");
            if (np.length == 3) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[0], np[1]);
            } else if (np.length == 4) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[0], np[2]);
            } else if (np.length == 5) {
                thePBR = new ParseBarcodeRead(keyFileS, enzyme, np[1], np[3]);
            } else {
                System.out.println("Error in parsing file name:");
                System.out.println("   The filename does not contain either 3 or 5 underscore-delimited values.");
                System.out.println("   Expect: flowcell_lane_qseq.txt OR code_flowcell_s_lane_qseq.txt");
                System.out.println("   Filename: " + qseqFileS[laneNum]);
                return;
            }
            System.out.println("Total barcodes found in lane:" + thePBR.getBarCodeCount());
            if (thePBR.getBarCodeCount() == 0) {
                System.out.println("No barcodes found.  Skipping this flowcell lane.");
                continue;
            }
            String[] taxaNames = new String[thePBR.getBarCodeCount()];
            for (int i = 0; i < taxaNames.length; ++i) {
                taxaNames[i] = thePBR.getTheBarcodes(i).getTaxaName();
            }
            if (useTBTByte) {
                theTBT = new TagsByTaxaByte(taxaNames, theMasterTags);
            }
            String temp = "";
            goodBarcodedReads = 0;
            allReads = 0;
            goodMatched = 0;
            try {
                BufferedReader br = qseqFileS[laneNum].endsWith(".gz") ? new BufferedReader(new InputStreamReader(new MultiMemberGZIPInputStream(new FileInputStream(qseqFileS[laneNum])))) : new BufferedReader(new FileReader(qseqFileS[laneNum]), 65536);
                String qualS = "";
                while ((temp = br.readLine()) != null) {
                    String sl;
                    ReadBarcodeResult rr;
                    String[] jj = temp.split("\\s");
                    if (++allReads % 1000000 == 0) {
                        System.out.println("Total Reads:" + allReads + " goodReads:" + goodBarcodedReads + " goodMatched:" + goodMatched);
                    }
                    if ((rr = thePBR.parseReadIntoTagAndTaxa(sl = jj[8], qualS = jj[9], false, 0)) == null) continue;
                    ++goodBarcodedReads;
                    int t = theTBT.getIndexOfTaxaName(rr.getTaxonName());
                    int h = theTBT.getTagIndex(rr.getRead());
                    if (h <= -1) continue;
                    theTBT.addReadsToTagTaxon(h, t, 1);
                    ++goodMatched;
                }
                br.close();
            }
            catch (Exception e) {
                System.out.println("Catch testBasicPipeline c=" + goodBarcodedReads + " e=" + e);
                System.out.println(temp);
                e.printStackTrace();
            }
            System.out.println("Timing process (writing TagsByTaxa file)...");
            long timePoint1 = System.currentTimeMillis();
            theTBT.writeDistFile(outfile, outFormat, minCount);
            System.out.println("...process (writing TagsByTaxa file) took " + (System.currentTimeMillis() - timePoint1) + " milliseconds.");
            System.out.println("Total number of reads in lane=" + allReads);
            System.out.println("Total number of good, barcoded reads=" + goodBarcodedReads);
            int filesDone = laneNum + 1;
            System.out.println("Finished reading " + filesDone + " of " + qseqFileS.length + " sequence files: " + qseqFileS[laneNum] + "\n");
        }
    }

    @Override
    public ImageIcon getIcon() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getButtonName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getToolTipText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

