/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class TagCountToFastqPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(TagCountToFastqPlugin.class);
    private PluginParameter<String> myInputFile = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input File").required(true).inFile().description("Input binary tag count (*.cnt) file").build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output File").required(true).outFile().description("Output fastq file to use as input for BWA or bowtie2").build();
    private PluginParameter<Integer> myMinCount = new PluginParameter.Builder<Integer>("c", Integer.valueOf(1), Integer.class).guiName("Min Count").description("Minimum count of reads for a tag to be output").build();
    private DataInputStream inStream;
    private DataOutputStream outStream;
    private int nTags;
    private int tagLengthInLong;
    private long[] tag = new long[2];
    private int tagCount;
    private byte tagLength;
    private int tagsRead = 0;

    public TagCountToFastqPlugin() {
        super(null, false);
    }

    public TagCountToFastqPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public TagCountToFastqPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        try {
            this.inStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.inputFile()), 655360));
            this.nTags = this.inStream.readInt();
            this.tagLengthInLong = this.inStream.readInt();
            myLogger.info((Object)("Opened the input file: " + this.inputFile() + "  nTags=" + this.nTags));
            this.outStream = Utils.getDataOutputStream(this.outputFile(), 655360);
            int tagsWritten = 0;
            while (this.inStream.available() != 0) {
                this.readNextTag();
                if (this.tagCount >= this.minCount()) {
                    this.writeFASTQ();
                    ++tagsWritten;
                }
                if (this.tagsRead % 500000 != 1) continue;
                System.out.printf("tagsRead=%d tagsWritten=%d %n", this.tagsRead, tagsWritten);
                myLogger.info((Object)BaseEncoder.getSequenceFromLong(this.tag));
            }
            this.outStream.flush();
            this.outStream.close();
            myLogger.info((Object)("Finished converting binary tag count file to fastq.\nTotal number of tags read: " + this.tagsRead + "\nTotal number of tags written: " + tagsWritten + " (above minCount of " + this.minCount() + ")" + "\nOuput fastq file: " + this.outputFile() + "\n\n"));
        }
        catch (Exception e) {
            myLogger.info((Object)("Catch in reading TagCount file e=" + e));
            e.printStackTrace();
        }
        return null;
    }

    private void readNextTag() {
        try {
            for (int j = 0; j < this.tagLengthInLong; ++j) {
                this.tag[j] = this.inStream.readLong();
            }
            this.tagLength = this.inStream.readByte();
            this.tagCount = this.inStream.readInt();
            ++this.tagsRead;
        }
        catch (IOException eof) {
            try {
                myLogger.info((Object)"Finished reading input file.");
                this.inStream.close();
                this.inStream = null;
            }
            catch (IOException eof2) {
                myLogger.info((Object)("Catch closing" + eof2));
                this.inStream = null;
            }
        }
    }

    private void writeFASTQ() {
        try {
            this.outStream.writeBytes("@length=" + this.tagLength + "count=" + this.tagCount + "\n");
            String tagSequence = BaseEncoder.getSequenceFromLong(this.tag);
            tagSequence = tagSequence.substring(0, this.tagLength);
            this.outStream.writeBytes(tagSequence + "\n+\n");
            for (int i = 0; i < this.tagLength; ++i) {
                this.outStream.writeBytes("f");
            }
            this.outStream.writeBytes("\n");
        }
        catch (IOException e) {
            myLogger.info((Object)("Catch in writing TagCount file e=" + e));
            e.printStackTrace();
        }
    }

    public String inputFile() {
        return this.myInputFile.value();
    }

    public TagCountToFastqPlugin inputFile(String value) {
        this.myInputFile = new PluginParameter<String>(this.myInputFile, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public TagCountToFastqPlugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    public Integer minCount() {
        return this.myMinCount.value();
    }

    public TagCountToFastqPlugin minCount(Integer value) {
        this.myMinCount = new PluginParameter<Integer>(this.myMinCount, value);
        return this;
    }

    @Override
    public String getToolTipText() {
        return "Tag Count to Fastq";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Tag Count to Fastq";
    }
}

