/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;

class TagLocusSiteQualityScores {
    private int[] siteIndicesInTAL;
    private double[] inbredCoverage;
    private double[] inbredHetScore;
    private byte[][] alleles;
    private int[] position;
    private int currSize;

    public TagLocusSiteQualityScores(int nSites) {
        this.siteIndicesInTAL = new int[nSites];
        this.inbredCoverage = new double[nSites];
        this.inbredHetScore = new double[nSites];
        this.alleles = new byte[nSites][];
        this.position = new int[nSites];
        this.currSize = 0;
    }

    public void addSite(int siteIndex, double inbredCov, double inbredHetS, byte[] alleles, int position) {
        this.siteIndicesInTAL[this.currSize] = siteIndex;
        this.inbredCoverage[this.currSize] = inbredCov;
        this.inbredHetScore[this.currSize] = inbredHetS;
        this.alleles[this.currSize] = alleles;
        this.position[this.currSize] = position;
        ++this.currSize;
    }

    public int getSize() {
        return this.currSize;
    }

    public int getSiteInTAL(int site) {
        return this.siteIndicesInTAL[site];
    }

    public byte[] getAlleles(int site) {
        return this.alleles[site];
    }

    public int getPosition(int site) {
        return this.position[site];
    }

    public void sortByQuality() {
        Swapper swapperQual = new Swapper(){

            public void swap(int a, int b) {
                int tempInt = TagLocusSiteQualityScores.this.siteIndicesInTAL[a];
                ((TagLocusSiteQualityScores)TagLocusSiteQualityScores.this).siteIndicesInTAL[a] = TagLocusSiteQualityScores.this.siteIndicesInTAL[b];
                ((TagLocusSiteQualityScores)TagLocusSiteQualityScores.this).siteIndicesInTAL[b] = tempInt;
                double score = TagLocusSiteQualityScores.this.inbredCoverage[a];
                ((TagLocusSiteQualityScores)TagLocusSiteQualityScores.this).inbredCoverage[a] = TagLocusSiteQualityScores.this.inbredCoverage[b];
                ((TagLocusSiteQualityScores)TagLocusSiteQualityScores.this).inbredCoverage[b] = score;
                score = TagLocusSiteQualityScores.this.inbredHetScore[a];
                ((TagLocusSiteQualityScores)TagLocusSiteQualityScores.this).inbredHetScore[a] = TagLocusSiteQualityScores.this.inbredHetScore[b];
                ((TagLocusSiteQualityScores)TagLocusSiteQualityScores.this).inbredHetScore[b] = score;
                byte[] tempAlleles = TagLocusSiteQualityScores.this.alleles[a];
                ((TagLocusSiteQualityScores)TagLocusSiteQualityScores.this).alleles[a] = TagLocusSiteQualityScores.this.alleles[b];
                ((TagLocusSiteQualityScores)TagLocusSiteQualityScores.this).alleles[b] = tempAlleles;
                tempInt = TagLocusSiteQualityScores.this.position[a];
                ((TagLocusSiteQualityScores)TagLocusSiteQualityScores.this).position[a] = TagLocusSiteQualityScores.this.position[b];
                ((TagLocusSiteQualityScores)TagLocusSiteQualityScores.this).position[b] = tempInt;
            }
        };
        IntComparator compQual = new IntComparator(){

            public int compare(int a, int b) {
                if (TagLocusSiteQualityScores.this.inbredCoverage[a] > TagLocusSiteQualityScores.this.inbredCoverage[b]) {
                    return -1;
                }
                if (TagLocusSiteQualityScores.this.inbredCoverage[a] < TagLocusSiteQualityScores.this.inbredCoverage[b]) {
                    return 1;
                }
                if (TagLocusSiteQualityScores.this.inbredHetScore[a] < TagLocusSiteQualityScores.this.inbredHetScore[b]) {
                    return -1;
                }
                if (TagLocusSiteQualityScores.this.inbredHetScore[a] > TagLocusSiteQualityScores.this.inbredHetScore[b]) {
                    return 1;
                }
                if (TagLocusSiteQualityScores.this.siteIndicesInTAL[a] < TagLocusSiteQualityScores.this.siteIndicesInTAL[b]) {
                    return -1;
                }
                if (TagLocusSiteQualityScores.this.siteIndicesInTAL[a] > TagLocusSiteQualityScores.this.siteIndicesInTAL[b]) {
                    return 1;
                }
                return 0;
            }
        };
        GenericSorting.quickSort((int)0, (int)this.currSize, (IntComparator)compQual, (Swapper)swapperQual);
    }
}

