/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.imputation.NucleotideImputationUtils;
import net.maizegenetics.analysis.imputation.PopulationData;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class CallParentAllelesPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(CallParentAllelesPlugin.class);
    private String pedfileName = null;
    private int minAlleleCount = 2;
    private int windowSize = 50;
    private double cutHeightSnps = 0.2;
    private double minRforSnps = 0.2;
    private double maxMissing = 0.9;
    private double minMinorAlleleFrequency = -1.0;
    private boolean useBCFilter = true;
    private boolean useMultipleBCFilter = false;
    private boolean useClusterAlgorithm = false;
    private boolean checkSubPops = false;
    private boolean useHets = true;
    private ArrayList<PopulationData> familyList = null;

    public CallParentAllelesPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    @Override
    public DataSet performFunction(DataSet input) {
        if (this.pedfileName == null && this.familyList == null) {
            myLogger.error((Object)this.getUsage());
            return null;
        }
        List<Datum> inputAlignments = input.getDataOfType(GenotypeTable.class);
        LinkedList<Datum> datumList = new LinkedList<Datum>();
        for (Datum d : inputAlignments) {
            GenotypeTable align = (GenotypeTable)d.getData();
            if (this.familyList == null) {
                this.familyList = PopulationData.readPedigreeFile(this.pedfileName);
            }
            for (PopulationData family : this.familyList) {
                myLogger.info((Object)("Calling parent alleles for family " + family.name + ", chromosome " + align.chromosomeName(0) + "."));
                String[] ids = new String[family.members.size()];
                family.members.toArray(ids);
                myLogger.info((Object)("creating family alignment for family " + family.name));
                TaxaList tL = new TaxaListBuilder().addAll(ids).build();
                family.original = GenotypeTableBuilder.getGenotypeCopyInstance((FilterGenotypeTable)FilterGenotypeTable.getInstance(align, tL, false));
                if (!this.useHets) {
                    byte NN = NucleotideAlignmentConstants.getNucleotideDiploidByte('N');
                    GenotypeTableBuilder builder = GenotypeTableBuilder.getSiteIncremental(family.original.taxa());
                    int nsites = family.original.numberOfSites();
                    int ntaxa = family.original.numberOfTaxa();
                    for (int s = 0; s < nsites; ++s) {
                        byte[] siteGeno = family.original.genotypeAllTaxa(s);
                        for (int t = 0; t < ntaxa; ++t) {
                            if (!GenotypeTableUtils.isHeterozygous(siteGeno[t])) continue;
                            siteGeno[t] = NN;
                        }
                        builder.addSite((Position)family.original.positions().get(s), siteGeno);
                    }
                    family.original = builder.build();
                }
                myLogger.info((Object)"family alignment created");
                if (this.useClusterAlgorithm) {
                    NucleotideImputationUtils.callParentAllelesUsingClusters(family, this.maxMissing, this.minMinorAlleleFrequency, this.windowSize, this.checkSubPops);
                } else if (this.useBCFilter && (family.contribution1 == 0.75 || family.contribution1 == 0.25)) {
                    NucleotideImputationUtils.callParentAllelesByWindowForBackcrosses(family, this.maxMissing, this.minMinorAlleleFrequency, this.windowSize, this.minRforSnps);
                } else if (this.useMultipleBCFilter) {
                    NucleotideImputationUtils.callParentAllelesByWindowForMultipleBC(family, this.maxMissing, 1, this.windowSize);
                } else {
                    NucleotideImputationUtils.callParentAllelesByWindow(family, this.maxMissing, this.minMinorAlleleFrequency, this.windowSize, this.minRforSnps);
                }
                String comment = "Parent Calls for family " + family.name + " from " + d.getName() + ".";
                datumList.add(new Datum(family.name, family, comment));
            }
        }
        DataSet resultDS = new DataSet(datumList, (Plugin)this);
        this.fireDataSetReturned(new PluginEvent(resultDS, CallParentAllelesPlugin.class));
        return resultDS;
    }

    @Override
    public void setParameters(String[] args) {
        if (args == null || args.length == 0) {
            myLogger.error((Object)this.getUsage());
            return;
        }
        int narg = args.length;
        for (int i = 0; i < narg; ++i) {
            String param;
            if (args[i].equals("-p") || args[i].equalsIgnoreCase("-pedigrees")) {
                this.pedfileName = args[++i];
                continue;
            }
            if (args[i].equals("-a") || args[i].equalsIgnoreCase("-minAlleleCount")) {
                this.minAlleleCount = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-w") || args[i].equalsIgnoreCase("-windowSize")) {
                this.windowSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-h") || args[i].equalsIgnoreCase("-cutHeight")) {
                this.cutHeightSnps = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equals("-r") || args[i].equalsIgnoreCase("-minR")) {
                this.minRforSnps = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equals("-m") || args[i].equalsIgnoreCase("-maxMissing")) {
                this.maxMissing = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equals("-f") || args[i].equalsIgnoreCase("-minMaf")) {
                this.minMinorAlleleFrequency = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equals("-b") || args[i].equalsIgnoreCase("-bc1")) {
                if (!(param = args[++i]).toUpperCase().startsWith("F")) continue;
                this.useBCFilter = false;
                continue;
            }
            if (args[i].equals("-n") || args[i].equalsIgnoreCase("-bcn")) {
                if (!(param = args[++i]).toUpperCase().startsWith("T")) continue;
                this.useMultipleBCFilter = true;
                continue;
            }
            if (args[i].equals("-l") || args[i].equalsIgnoreCase("-logconfig")) {
                this.addFileLogger(args[++i]);
                continue;
            }
            if (args[i].equals("-logfile")) {
                this.setFileLogger(args[++i]);
                continue;
            }
            if (args[i].startsWith("-clust")) {
                this.useClusterAlgorithm = true;
                continue;
            }
            if (args[i].equals("-subpops")) {
                this.checkSubPops = true;
                continue;
            }
            if (args[i].equals("-nohets")) {
                this.useHets = false;
                continue;
            }
            if (!args[i].equals("?")) continue;
            myLogger.info((Object)this.getUsage());
        }
    }

    private void addFileLogger(String filename) {
        try {
            Appender fileAppender = Logger.getRootLogger().getAppender("fileAppender");
            if (fileAppender == null) {
                FileAppender filelog = new FileAppender((Layout)new PatternLayout("%d %-5p  [%c{1}] %m %n"), filename, true);
                filelog.setName("fileAppender");
                Logger.getRootLogger().addAppender((Appender)filelog);
            }
        }
        catch (Exception e) {
            myLogger.info((Object)"log file could not be instantiated");
            e.printStackTrace();
        }
    }

    private void setFileLogger(String filename) {
        try {
            Appender fileAppender = Logger.getRootLogger().getAppender("fileAppender");
            if (fileAppender != null) {
                Logger.getRootLogger().removeAppender(fileAppender);
            }
            FileAppender filelog = new FileAppender((Layout)new PatternLayout("%d %-5p  [%c{1}] %m %n"), filename, true);
            filelog.setName("fileAppender");
            Logger.getRootLogger().addAppender((Appender)filelog);
        }
        catch (Exception e) {
            myLogger.info((Object)"log file could not be instantiated");
            e.printStackTrace();
        }
    }

    public void setPedfileName(String pedfileName) {
        this.pedfileName = pedfileName;
    }

    public void setMinAlleleCount(int minAlleleCount) {
        this.minAlleleCount = minAlleleCount;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public void setCutHeightSnps(double cutHeightSnps) {
        this.cutHeightSnps = cutHeightSnps;
    }

    public void setMinRforSnps(double minRforSnps) {
        this.minRforSnps = minRforSnps;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Call Parents";
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public String getUsage() {
        StringBuilder usage = new StringBuilder("The CallParentAllelesPlugin requires the following parameter:\n");
        usage.append("-p or -pedigrees : a file containing pedigrees of the individuals to be imputed\n");
        usage.append("The following parameters are optional:\n");
        usage.append("-w or -windowSize : the number of SNPs to examine for LD clusters (default = 50)\n");
        usage.append("-r or -minR : minimum R used to filter SNPs on LD (default = 0.2, use 0 for no ld filter)\n");
        usage.append("-m or -maxMissing : maximum proportion of missing data allowed for a SNP (default = 0.9)\n");
        usage.append("-f or -minMaf : minimum minor allele frequency used to filter SNPs. If negative, filters on expected segregation ratio from parental contribution (default = -1)\n");
        usage.append("-b or -bc1 : use BC1 specific filter (default = true)\n");
        usage.append("-n or -bcn : use multipe backcross specific filter (default = false)\n");
        usage.append("-logfile : the name of a file to which all logged messages will be printed.\n");
        usage.append("-cluster : use the cluster algorithm. minMaf defaults to 0.05.\n");
        usage.append("-subpops : filter sites for heterozygosity in subpopulations.\n");
        usage.append("-nohets : delete het calls from original data before imputing.\n");
        usage.append("? : print the parameter list.\n");
        return usage.toString();
    }

    public void setFamilyList(ArrayList<PopulationData> familyList) {
        this.familyList = familyList;
    }
}

