/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import net.maizegenetics.analysis.imputation.GenotypeImputationPlugin;

class GenotypeImputationPluginDialog
extends JDialog {
    boolean runAnalysis = false;
    private GenotypeImputationPlugin.ImpMethod chosenImpMethod = GenotypeImputationPlugin.ImpMethod.Length;
    private int minLength = 31;
    private int maxMismatch = 1;
    private double minProb = 0.001;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JRadioButton ibdProbRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JRadioButton lengthImputeRadioButton;
    private JTextField lengthTextField;
    private JTextField minProbTextField;
    private JTextField maxMismatchTextField;
    private JRadioButton majorAlleleRadioButton;
    private JButton runButton;
    private JRadioButton similarWindowRadioButton;

    public GenotypeImputationPluginDialog(Frame f) {
        super(f, "Imputation", true);
        try {
            this.initComponents();
            this.lengthImputeRadioButton.setSelected(true);
            this.majorAlleleRadioButton.setEnabled(false);
            this.ibdProbRadioButton.setEnabled(false);
            this.similarWindowRadioButton.setEnabled(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isRunAnalysis() {
        return this.runAnalysis;
    }

    public int getMaxMismatch() {
        return this.maxMismatch;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public double getMinProb() {
        return this.minProb;
    }

    public GenotypeImputationPlugin.ImpMethod getChosenImpMethod() {
        return this.chosenImpMethod;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel("Imputation of Genotypic Data");
        this.lengthImputeRadioButton = new JRadioButton("Maximum shared length");
        this.lengthTextField = new JTextField("" + this.minLength);
        this.maxMismatchTextField = new JTextField("" + this.maxMismatch);
        this.jLabel2 = new JLabel("Min Length");
        this.jLabel4 = new JLabel("Maximum Mismatch");
        this.majorAlleleRadioButton = new JRadioButton("Major Allele");
        this.similarWindowRadioButton = new JRadioButton("Simlarity by window");
        this.ibdProbRadioButton = new JRadioButton("IBD Probabilty");
        this.jLabel3 = new JLabel("Min Probability");
        this.minProbTextField = new JTextField("" + this.minProb);
        this.runButton = new JButton("Run");
        this.cancelButton = new JButton("Close");
        this.buttonGroup1.add(this.lengthImputeRadioButton);
        this.buttonGroup1.add(this.majorAlleleRadioButton);
        this.buttonGroup1.add(this.similarWindowRadioButton);
        this.buttonGroup1.add(this.ibdProbRadioButton);
        this.jLabel1.setFont(new Font("Tahoma", 0, 18));
        this.lengthTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GenotypeImputationPluginDialog.this.lengthTextFieldFocusLost(e);
            }
        });
        this.maxMismatchTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GenotypeImputationPluginDialog.this.maxMismatchTextFieldFocusLost(e);
            }
        });
        this.minProbTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                GenotypeImputationPluginDialog.this.minProbTextFieldFocusLost(e);
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenotypeImputationPluginDialog.this.runButtonActionPerformed(evt);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenotypeImputationPluginDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lengthImputeRadioButton).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.majorAlleleRadioButton).addGap(58, 58, 58)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxMismatchTextField, -2, 44, -2).addComponent(this.lengthTextField, -2, 44, -2))).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.similarWindowRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addComponent(this.ibdProbRadioButton, GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.runButton, -2, 64, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minProbTextField, -2, 64, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addGap(156, 156, 156)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(29, 29, 29).addComponent(this.lengthImputeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lengthTextField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxMismatchTextField, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.majorAlleleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.similarWindowRadioButton).addGap(5, 5, 5).addComponent(this.ibdProbRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minProbTextField, -2, -1, -2).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.runButton).addComponent(this.cancelButton)).addContainerGap(28, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 340, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2));
        this.pack();
    }

    private void lengthTextFieldFocusLost(FocusEvent evt) {
        try {
            int v = Integer.parseInt(this.lengthTextField.getText().trim());
            if (v < 0) {
                v = this.minLength;
            }
            this.minLength = v;
        }
        catch (Exception ee) {
            System.err.println(ee);
        }
    }

    private void maxMismatchTextFieldFocusLost(FocusEvent evt) {
        try {
            int v = Integer.parseInt(this.maxMismatchTextField.getText().trim());
            if (v >= 0) {
                v = this.maxMismatch;
            }
            this.maxMismatch = v;
        }
        catch (Exception ee) {
            System.err.println(ee);
        }
    }

    private void minProbTextFieldFocusLost(FocusEvent evt) {
        try {
            double v = Double.parseDouble(this.minProbTextField.getText().trim());
            if (v < 0.0 || v > 1.0) {
                v = this.minProb;
            }
            this.minProb = v;
        }
        catch (Exception ee) {
            System.err.println(ee);
        }
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        if (this.lengthImputeRadioButton.isSelected()) {
            this.chosenImpMethod = GenotypeImputationPlugin.ImpMethod.Length;
        } else if (this.ibdProbRadioButton.isSelected()) {
            this.chosenImpMethod = GenotypeImputationPlugin.ImpMethod.IBDProb;
        } else if (this.majorAlleleRadioButton.isSelected()) {
            this.chosenImpMethod = GenotypeImputationPlugin.ImpMethod.MajorAllele;
        } else if (this.similarWindowRadioButton.isSelected()) {
            this.chosenImpMethod = GenotypeImputationPlugin.ImpMethod.SimilarWindow;
        }
        this.lengthTextFieldFocusLost(null);
        this.maxMismatchTextFieldFocusLost(null);
        this.minProbTextFieldFocusLost(null);
        this.runAnalysis = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.runAnalysis = false;
        this.setVisible(false);
    }
}

