/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.data.ExportPlugin;
import net.maizegenetics.analysis.data.GenotypeSummaryPlugin;
import net.maizegenetics.analysis.imputation.PopulationData;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class QualityChecksPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(QualityChecksPlugin.class);
    private String pedigreeFile;
    private int windowSizeForR2 = 15;
    private double minNonMissingProportionForTaxon = 0.1;
    private double minNonMissingProportionForSNP = 0.1;
    private String avgr2Filename = null;
    private String avgr2Plotname = null;
    private String propNonconsensusFilename = null;
    private String summaryFilename = null;
    private String logfileName = null;
    private boolean hasFileAppender = false;

    public QualityChecksPlugin(Frame parentFrame) {
        super(parentFrame, false);
        BasicConfigurator.configure();
    }

    @Override
    public DataSet performFunction(DataSet input) {
        if (!this.hasFileAppender) {
            try {
                myLogger.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%-5p [%t]: %m%n"), this.logfileName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.hasFileAppender = true;
        }
        List<Datum> datumList = input.getDataOfType(GenotypeTable.class);
        ArrayList<PopulationData> familyList = this.pedigreeFile != null ? PopulationData.readPedigreeFile(this.pedigreeFile) : new ArrayList();
        for (Datum datum : datumList) {
            GenotypeTable anAlignment = (GenotypeTable)datum.getData();
            if (this.pedigreeFile == null) {
                this.processFamily(anAlignment, null);
                continue;
            }
            for (PopulationData family : familyList) {
                String[] names = new String[family.members.size()];
                family.members.toArray(names);
                TaxaList tL = new TaxaListBuilder().addAll(names).build();
                GenotypeTable align = FilterGenotypeTable.getInstance(anAlignment, tL, false);
                this.processFamily(align, family.name);
            }
        }
        return null;
    }

    private void processFamily(GenotypeTable align, String familyname) {
        myLogger.info((Object)("\nResults for chromosome " + align.chromosomeName(0) + ", family " + familyname));
        align = this.preFilterAlignment(align);
        if (this.avgr2Filename != null || this.avgr2Plotname != null) {
            this.calculateAverageR2ForSnps(align, familyname);
        }
        if (this.propNonconsensusFilename != null) {
            double[] proportion = this.calculateProportionNonConsensusPerTaxon(align);
            this.saveProportionNonConsensusToFile(proportion, align, this.addFamilyToFilename(this.propNonconsensusFilename, familyname, align.chromosomeName(0), ".txt"));
        }
        if (this.summaryFilename != null) {
            this.runAndExportGenotypeSummaryForTaxa(align, this.addFamilyToFilename(this.summaryFilename, familyname, align.chromosomeName(0), ".txt"));
        }
    }

    private String addFamilyToFilename(String filename, String family, String chr, String extension) {
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        StringBuilder sb = new StringBuilder();
        if (filename.endsWith(extension)) {
            sb.append(filename.substring(0, filename.length() - extension.length()));
        } else {
            sb.append(filename);
        }
        if (family == null) {
            if (chr != null) {
                sb.append(".chr").append(chr);
            }
            sb.append(extension);
        } else {
            family = family.replace('/', '_');
            sb.append(".").append(family);
            if (chr != null) {
                sb.append(".chr").append(chr);
            }
            sb.append(extension);
        }
        return sb.toString();
    }

    public GenotypeTable preFilterAlignment(GenotypeTable align) {
        int ntaxa = align.numberOfTaxa();
        int nsites = align.numberOfSites();
        int nTaxaGametes = 2 * nsites;
        int nSiteGametes = 2 * ntaxa;
        int minTaxaGametes = (int)Math.ceil((double)nTaxaGametes * this.minNonMissingProportionForTaxon);
        int minSiteGametes = (int)Math.ceil((double)nSiteGametes * this.minNonMissingProportionForSNP);
        myLogger.info((Object)"preFilter Alignment: ");
        myLogger.info((Object)("Before filter alignment has " + ntaxa + " taxa and " + nsites + " sites."));
        LinkedList<Taxon> taxaDiscardList = new LinkedList<Taxon>();
        for (int t = 0; t < ntaxa; ++t) {
            if (align.totalGametesNonMissingForTaxon(t) >= minTaxaGametes) continue;
            taxaDiscardList.add((Taxon)align.taxa().get(t));
        }
        if (taxaDiscardList.size() > 0) {
            myLogger.info((Object)("\nThe following taxa will not be included in the analysis because the proportion of nonMissing data is below " + this.minNonMissingProportionForTaxon + ":\n"));
            for (Taxon id : taxaDiscardList) {
                myLogger.info((Object)id.getName());
            }
            TaxaList tL = new TaxaListBuilder().addAll(taxaDiscardList).build();
            align = FilterGenotypeTable.getInstanceRemoveIDs(align, tL);
        }
        myLogger.info((Object)("After filtering for taxa, there are " + align.numberOfTaxa() + " taxa."));
        int[] sitesToKeep = new int[nsites];
        int nsitesKept = 0;
        for (int s = 0; s < nsites; ++s) {
            if (align.totalGametesNonMissingForSite(s) < minSiteGametes) continue;
            sitesToKeep[nsitesKept++] = s;
        }
        if (nsitesKept < nsites) {
            myLogger.info((Object)(nsitesKept + " sites had more than " + minSiteGametes + " and were retained."));
            sitesToKeep = Arrays.copyOf(sitesToKeep, nsitesKept);
            align = FilterGenotypeTable.getInstance(align, sitesToKeep);
        }
        return align;
    }

    private void calculateAverageR2ForSnps(GenotypeTable align, String familyname) {
        int nsites = align.numberOfSites();
        int[] polysites = new int[nsites];
        int sitecount = 0;
        for (int s = 0; s < nsites; ++s) {
            if (!(align.minorAlleleFrequency(s) > 0.15)) continue;
            polysites[sitecount++] = s;
        }
        polysites = Arrays.copyOf(polysites, sitecount);
        align = FilterGenotypeTable.getInstance(align, polysites);
        myLogger.info((Object)("Chromosome " + align.chromosomeName(0) + ", family " + familyname + " has " + sitecount + " polymorphic snps."));
        nsites = align.numberOfSites();
        double[] avgRsq = new double[nsites];
        for (int s = 0; s < nsites; ++s) {
            int start = Math.max(s - this.windowSizeForR2, 0);
            int end = Math.min(nsites - 1, s + this.windowSizeForR2);
            double sum = 0.0;
            double count = 0.0;
            BitSet sMj = align.allelePresenceForAllTaxa(s, WHICH_ALLELE.Major);
            BitSet sMn = align.allelePresenceForAllTaxa(s, WHICH_ALLELE.Minor);
            for (int i = start; i <= end; ++i) {
                if (i == s) continue;
                int[][] contig = new int[2][2];
                BitSet iMj = align.allelePresenceForAllTaxa(i, WHICH_ALLELE.Major);
                BitSet iMn = align.allelePresenceForAllTaxa(i, WHICH_ALLELE.Minor);
                contig[0][0] = (int)OpenBitSet.intersectionCount(sMj, iMj);
                contig[1][0] = (int)OpenBitSet.intersectionCount(sMn, iMj);
                contig[0][1] = (int)OpenBitSet.intersectionCount(sMj, iMn);
                contig[1][1] = (int)OpenBitSet.intersectionCount(sMn, iMn);
                double rsq = QualityChecksPlugin.calculateRSqr(contig[0][0], contig[1][0], contig[0][1], contig[1][1], 4);
                if (Double.isNaN(rsq)) continue;
                sum += Math.sqrt(rsq);
                count += 1.0;
            }
            avgRsq[s] = count > 0.0 ? sum / count : Double.NaN;
        }
        String chrname = align.chromosomeName(0);
        if (this.avgr2Filename != null) {
            this.saveToFileAverageR2(avgRsq, align, this.addFamilyToFilename(this.avgr2Filename, familyname, chrname, ".txt"));
        }
        if (this.avgr2Plotname != null) {
            this.plotAverageR2(avgRsq, align, this.addFamilyToFilename(this.avgr2Plotname, familyname, chrname, ".png"));
        }
    }

    static double calculateRSqr(int countAB, int countAb, int countaB, int countab, int minTaxaForEstimate) {
        double nonmissingSampleSize = countAB + countAb + countaB + countab;
        if (nonmissingSampleSize < (double)minTaxaForEstimate) {
            return Double.NaN;
        }
        double freqA = (double)(countAB + countAb) / nonmissingSampleSize;
        double freqB = (double)(countAB + countaB) / nonmissingSampleSize;
        if (freqA == 0.0 || freqB == 0.0 || freqA == 1.0 || freqB == 1.0) {
            return Double.NaN;
        }
        double rsqr = (double)countAB / nonmissingSampleSize * ((double)countab / nonmissingSampleSize);
        rsqr -= (double)countaB / nonmissingSampleSize * ((double)countAb / nonmissingSampleSize);
        rsqr *= rsqr;
        return rsqr /= freqA * (1.0 - freqA) * freqB * (1.0 - freqB);
    }

    private void saveToFileAverageR2(double[] avgr2, GenotypeTable align, String saveFilename) {
        BufferedWriter bw = Utils.getBufferedWriter(saveFilename);
        int nsites = align.numberOfSites();
        try {
            bw.write("Site\tchr\tpos\tr2");
            bw.newLine();
            for (int s = 0; s < nsites; ++s) {
                bw.write(align.siteName(s));
                bw.write("\t");
                bw.write(align.chromosomeName(s));
                bw.write("\t");
                bw.write(Integer.toString(align.chromosomalPosition(s)));
                bw.write("\t");
                bw.write(Double.toString(avgr2[s]));
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            myLogger.error((Object)("error opening file for avgr2data\n" + e.getMessage() + e.getStackTrace()));
        }
    }

    private void plotAverageR2(double[] avgr2, GenotypeTable align, String saveFilename) {
        int nsites = align.numberOfSites();
        String title = "Average R2 in " + this.windowSizeForR2 + " bp window, chromosome " + align.chromosomeName(0);
        String xLabel = "position(Mbp)";
        String yLabel = "Average R-squared";
        DefaultXYDataset xydata = new DefaultXYDataset();
        double[][] dataset = new double[2][nsites];
        for (int s = 0; s < nsites; ++s) {
            dataset[0][s] = (double)align.chromosomalPosition(s) / 1000000.0;
        }
        dataset[1] = avgr2;
        xydata.addSeries((Comparable)((Object)"avgr2"), dataset);
        JFreeChart chart = ChartFactory.createScatterPlot((String)title, (String)xLabel, (String)yLabel, (XYDataset)xydata, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        try {
            ChartUtilities.saveChartAsPNG((File)new File(saveFilename), (JFreeChart)chart, (int)800, (int)300);
        }
        catch (IOException e) {
            myLogger.error((Object)("error saving png in plotAverageR2\n" + e.getMessage() + e.getStackTrace()));
        }
    }

    private double[] calculateProportionNonConsensusPerTaxon(GenotypeTable align) {
        double maxMaf = 0.05;
        int ntaxa = align.numberOfTaxa();
        int nsites = align.numberOfSites();
        OpenBitSet lowmaf = new OpenBitSet(nsites);
        for (int s = 0; s < nsites; ++s) {
            if (!(align.minorAlleleFrequency(s) < maxMaf)) continue;
            lowmaf.set(s);
        }
        double[] proportionMinor = new double[ntaxa];
        for (int t = 0; t < ntaxa; ++t) {
            BitSet major = align.allelePresenceForAllSites(t, WHICH_ALLELE.Major);
            BitSet minor = align.allelePresenceForAllSites(t, WHICH_ALLELE.Minor);
            long minorCount = OpenBitSet.intersectionCount(lowmaf, minor);
            OpenBitSet notMissing = new OpenBitSet(major.getBits(), major.getNumWords());
            notMissing.union(minor);
            long notMissingCount = OpenBitSet.unionCount(lowmaf, notMissing);
            proportionMinor[t] = (double)minorCount / (double)notMissingCount;
        }
        return proportionMinor;
    }

    private void saveProportionNonConsensusToFile(double[] propNonconsensus, GenotypeTable align, String saveFilename) {
        BufferedWriter bw = Utils.getBufferedWriter(saveFilename);
        int ntaxa = align.numberOfTaxa();
        try {
            bw.write("Taxon\tchr\tpropNC");
            bw.newLine();
            String chr = align.chromosomeName(0);
            for (int t = 0; t < ntaxa; ++t) {
                bw.write(align.taxaName(t));
                bw.write("\t");
                bw.write(chr);
                bw.write("\t");
                bw.write(Double.toString(propNonconsensus[t]));
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            myLogger.error((Object)("error opening file for proportion nonconsensus\n" + e.getMessage() + e.getStackTrace()));
        }
    }

    private void runAndExportGenotypeSummaryForTaxa(GenotypeTable align, String outfile) {
        GenotypeSummaryPlugin gsp = new GenotypeSummaryPlugin(null, false);
        gsp.setCaculateOverview(false);
        gsp.setCalculateSiteSummary(false);
        gsp.setCalculateTaxaSummary(true);
        DataSet result = gsp.performFunction(new DataSet(new Datum("alignment", align, "alignment"), (Plugin)this));
        ExportPlugin exporter = new ExportPlugin(null, false);
        exporter.setSaveFile(outfile);
        exporter.performFunction(result);
    }

    @Override
    public void setParameters(String[] args) {
        if (args == null || args.length == 0) {
            myLogger.error((Object)this.getUsage());
            return;
        }
        int narg = args.length;
        for (int i = 0; i < narg - 1; ++i) {
            if (args[i].equals("-p") || args[i].equalsIgnoreCase("-pedigrees")) {
                this.pedigreeFile = args[++i];
                continue;
            }
            if (args[i].equals("-w") || args[i].equalsIgnoreCase("-window")) {
                this.windowSizeForR2 = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-s") || args[i].equalsIgnoreCase("-nmsnp")) {
                this.minNonMissingProportionForSNP = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equals("-t") || args[i].equalsIgnoreCase("-nmtaxon")) {
                this.minNonMissingProportionForTaxon = Double.parseDouble(args[++i]);
                continue;
            }
            if (args[i].equals("-r") || args[i].equalsIgnoreCase("-r2file")) {
                this.avgr2Filename = args[++i];
                continue;
            }
            if (args[i].equals("-x") || args[i].equalsIgnoreCase("-r2xyplot")) {
                this.avgr2Plotname = args[++i];
                if (this.avgr2Plotname.endsWith(".png")) continue;
                this.avgr2Plotname = this.avgr2Plotname + ".png";
                continue;
            }
            if (args[i].equals("-c") || args[i].equalsIgnoreCase("-confile")) {
                this.propNonconsensusFilename = args[++i];
                continue;
            }
            if (args[i].equals("-s") || args[i].equalsIgnoreCase("-summaryfile")) {
                this.propNonconsensusFilename = args[++i];
                continue;
            }
            if (args[i].equals("-l") || args[i].equalsIgnoreCase("-logfile")) {
                this.logfileName = args[++i];
                continue;
            }
            if (!args[i].equals("?")) continue;
            myLogger.error((Object)this.getUsage());
        }
    }

    public String getUsage() {
        StringBuilder usage = new StringBuilder("The QualityChecksPlugin can take the following parameters:\n");
        usage.append("-p or -pedigrees : a file containing pedigrees of the individuals to be evaluated\n");
        usage.append("-w or -window : use a window of +/- this size to evaluate average R-square (default = 25).\n");
        usage.append("-s or -nmsnp : the minimum proportion of non-missing values allowed for a snp (default = 0.1)\n");
        usage.append("-t or -nmtaxon : the minimum proportion of non-missing values allowed for a taxon (default = 0.1)\n");
        usage.append("-r or -r2file : the name of the file to save the average R2 value for each SNP\n");
        usage.append("-x or -r2xyplot : name of the png file of the average R2 of each SNP, .png will be appended\n");
        usage.append("-c or -confile : name of the file to save the proportion of nonConsensus SNPs for each taxon\n");
        usage.append("-s or -summaryfile : name of the file for the taxa summary\n");
        usage.append("-l or -logfile: name of the file to which the log will be appended\n");
        usage.append("? : print the parameter list.\n");
        return usage.toString();
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public void setWindowSizeForR2(int windowSizeForR2) {
        this.windowSizeForR2 = windowSizeForR2;
    }

    public void setMinNonMissingProportionForTaxon(double minNonMissingProportionForTaxon) {
        this.minNonMissingProportionForTaxon = minNonMissingProportionForTaxon;
    }

    public void setMinNonMissingProportionForSNP(double minNonMissingProportionForSNP) {
        this.minNonMissingProportionForSNP = minNonMissingProportionForSNP;
    }

    public void setAvgr2Filename(String avgr2Filename) {
        this.avgr2Filename = avgr2Filename;
    }

    public void setAvgr2Plotname(String avgr2Plotname) {
        this.avgr2Plotname = avgr2Plotname;
    }

    public void setPropNonconsensusFilename(String propNonconsensusFilename) {
        this.propNonconsensusFilename = propNonconsensusFilename;
    }

    public void setPedigreeFile(String pedigreeFile) {
        this.pedigreeFile = pedigreeFile;
    }

    public void setLogfileName(String logfileName) {
        this.logfileName = logfileName;
    }

    public void setSummaryFilename(String summaryFilename) {
        this.summaryFilename = summaryFilename;
    }
}

