/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.maizegenetics.analysis.numericaltransform.KNN;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.SimplePhenotype;
import net.maizegenetics.trait.Trait;

public class ImputePanel
extends JPanel {
    private Datum theDatum;
    private static final String DEFAULT_MIN_REQ_DATA = "0.80";
    private double minRequiredData;
    private Phenotype aCharacterAlignment;
    private JTextField tfdMinPercentRequired = new JTextField();
    private JSpinner spnK;
    private JRadioButton rdoUnweightedAverage = new JRadioButton("Unweighted Average");
    private JRadioButton rdoWeightedAverage = new JRadioButton("Weighted Average");
    private JRadioButton rdoManhattenDistance = new JRadioButton("Manhatten Distance");
    private JRadioButton rdoEuclidDistance = new JRadioButton("Euclid Distance");
    private ButtonGroup bgrpAverage = new ButtonGroup();
    private ButtonGroup bgrpDistance = new ButtonGroup();
    private JCheckBox cbxUseStandardizedData = new JCheckBox();

    public ImputePanel(Datum theDatum) {
        try {
            if (!(theDatum.getData() instanceof Phenotype)) {
                throw new Exception("Must be Character Alignment");
            }
            this.theDatum = theDatum;
            this.aCharacterAlignment = (Phenotype)theDatum.getData();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel fillerPanel = new JPanel();
        this.setLayout(new BorderLayout());
        JPanel optPanel = new JPanel(new GridLayout(6, 1, 5, 5));
        optPanel.add(this.rdoManhattenDistance);
        optPanel.add(this.rdoEuclidDistance);
        this.bgrpDistance.add(this.rdoManhattenDistance);
        this.bgrpDistance.add(this.rdoEuclidDistance);
        this.rdoManhattenDistance.setSelected(true);
        optPanel.add(this.rdoUnweightedAverage);
        optPanel.add(this.rdoWeightedAverage);
        this.bgrpAverage.add(this.rdoUnweightedAverage);
        this.bgrpAverage.add(this.rdoWeightedAverage);
        this.rdoUnweightedAverage.setSelected(true);
        JPanel spnPanel = new JPanel(new BorderLayout());
        SpinnerNumberModel aSpinnerNumberModel = new SpinnerNumberModel(1, 1, this.aCharacterAlignment.getData().length, 1);
        this.spnK = new JSpinner(aSpinnerNumberModel);
        spnPanel.add((Component)new JLabel("Number of Neighbors (K):"), "West");
        spnPanel.add((Component)this.spnK, "Center");
        this.spnK.setOpaque(true);
        this.spnK.setValue(3);
        optPanel.add(spnPanel);
        JPanel minPPanel = new JPanel(new BorderLayout());
        this.tfdMinPercentRequired.setText(DEFAULT_MIN_REQ_DATA);
        minPPanel.add((Component)new JLabel("Min. Freq. of Row Data:"), "West");
        minPPanel.add((Component)this.tfdMinPercentRequired, "Center");
        this.minRequiredData = new Double(DEFAULT_MIN_REQ_DATA);
        optPanel.add(minPPanel);
        this.add((Component)optPanel, "North");
        this.add((Component)fillerPanel, "Center");
        this.tfdMinPercentRequired.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                boolean failed = true;
                String text = ImputePanel.this.tfdMinPercentRequired.getText();
                BigDecimal bd = null;
                try {
                    bd = new BigDecimal(text, new MathContext(2, RoundingMode.HALF_UP));
                    failed = false;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (failed) {
                    ImputePanel.this.tfdMinPercentRequired.setText(ImputePanel.DEFAULT_MIN_REQ_DATA);
                } else {
                    ImputePanel.this.tfdMinPercentRequired.setText(bd.toString());
                    ImputePanel.this.minRequiredData = bd.doubleValue();
                }
            }
        });
    }

    public Datum createImputedData(JTable tblTraits) {
        int[] colsSelected = null;
        colsSelected = tblTraits.getSelectedRows();
        int colCount = colsSelected.length;
        int includedCount = 0;
        int[] includedRowTemp = new int[this.aCharacterAlignment.getNumberOfTaxa()];
        for (int i = 0; i < this.aCharacterAlignment.getNumberOfTaxa(); ++i) {
            double goodData = 0.0;
            for (int j = 0; j < colCount; ++j) {
                if (Double.isNaN(this.aCharacterAlignment.getData(i, colsSelected[j]))) continue;
                goodData += 1.0;
            }
            if (!((goodData /= (double)colCount) >= this.minRequiredData)) continue;
            includedRowTemp[includedCount++] = i;
        }
        Taxon[] newIDs = new Taxon[includedCount];
        int traitCount = colsSelected.length;
        ArrayList<Trait> newtraits = new ArrayList<Trait>();
        for (int t = 0; t < traitCount; ++t) {
            newtraits.add(Trait.getInstance(this.aCharacterAlignment.getTrait(colsSelected[t])));
        }
        double[][] tempData = new double[includedCount][colsSelected.length];
        for (int i = 0; i < includedCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                newIDs[i] = (Taxon)this.aCharacterAlignment.getTaxa().get(includedRowTemp[i]);
                tempData[i][j] = this.aCharacterAlignment.getData(includedRowTemp[i], colsSelected[j]);
            }
        }
        int kNeighbors = Integer.parseInt(this.spnK.getValue().toString());
        double[][] theImputedData = KNN.impute(tempData, kNeighbors, this.rdoManhattenDistance.isSelected(), this.rdoUnweightedAverage.isSelected());
        TaxaList tL = new TaxaListBuilder().addAll(newIDs).build();
        SimplePhenotype sca = new SimplePhenotype(tL, newtraits, theImputedData);
        StringWriter sw = new StringWriter();
        String theComment = sw.toString() + "\nImputed Phenotypic Values." + "\nTaxa with insufficient data: " + (this.aCharacterAlignment.getNumberOfTaxa() - sca.getNumberOfTaxa()) + "\nK = " + kNeighbors + this.minRequiredData + "% cutoff):\n";
        String theName = this.theDatum.getName() + "_" + colCount + "_imputed";
        Datum result = new Datum(theName, sca, theComment);
        return result;
    }
}

