/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import net.maizegenetics.analysis.numericaltransform.Conversion;

public class KNN {
    public static double[][] impute(double[][] data, int kNeighbors, boolean isManhattenDist, boolean isUnweighted) {
        int rows = data.length;
        int cols = data[0].length;
        double[][] normData = Conversion.normalizeData(data);
        double[][] distMat = KNN.createDistWithNaN(normData, isManhattenDist);
        double[][] result = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                result[i][j] = !Double.isNaN(data[i][j]) ? data[i][j] : KNN.calcKNN(i, j, data, distMat, kNeighbors, isUnweighted);
            }
        }
        return result;
    }

    public static double calcKNN(int row, int col, double[][] data, double[][] distMat, int kNeighbors, boolean isUnweighted) {
        int theNextNeighbor = -1;
        double num = 0.0;
        double denom = 0.0;
        ArrayList<Integer> usedTaxa = new ArrayList<Integer>();
        usedTaxa.add(row);
        for (int kCount = 0; kCount < kNeighbors; ++kCount) {
            double minDist = 1.0E9;
            for (int i = 0; i < distMat.length; ++i) {
                if (!(distMat[row][i] < minDist) || usedTaxa.contains(i) || Double.isNaN(data[i][col])) continue;
                minDist = distMat[row][i];
                theNextNeighbor = i;
            }
            usedTaxa.add(theNextNeighbor);
            if (!isUnweighted) {
                num += data[theNextNeighbor][col] * distMat[theNextNeighbor][col];
                denom += distMat[theNextNeighbor][col];
                continue;
            }
            num += data[theNextNeighbor][col];
            denom += 1.0;
        }
        return num / denom;
    }

    public static double[][] createDistWithNaN(double[][] data, boolean isManhattenDist) {
        int rows = data.length;
        int cols = data[0].length;
        double[][] result = new double[rows][rows];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j <= i; ++j) {
                double r = 0.0;
                double count = 0.0;
                for (int k = 0; k < cols; ++k) {
                    if (Double.isNaN(data[i][k]) || Double.isNaN(data[j][k])) continue;
                    double diff = Math.abs(data[i][k] - data[j][k]);
                    count += 1.0;
                    if (isManhattenDist) {
                        r += diff;
                        continue;
                    }
                    r += diff * diff;
                }
                if (count > 0.0) {
                    double d = KNN.nNumD(r / count);
                    result[j][i] = d;
                    result[i][j] = d;
                    continue;
                }
                result[j][i] = Double.NaN;
                result[i][j] = Double.NaN;
            }
        }
        return result;
    }

    private static double nNumD(double d) {
        return new BigDecimal(d, new MathContext(5)).doubleValue();
    }
}

