/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.numericaltransform.NumTransformDialog;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.trait.Phenotype;

public class NumericalTransformPlugin
extends AbstractPlugin {
    public NumericalTransformPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> phenotypeList = input.getDataOfType(Phenotype.class);
            List<Datum> alignmentList = input.getDataOfType(GenotypeTable.class);
            if (phenotypeList.size() + alignmentList.size() < 1) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Invalid selection. Please select genotype or phenotype data.");
                DataSet dataSet = null;
                return dataSet;
            }
            ArrayList<Datum> outputList = new ArrayList<Datum>();
            for (Datum current : phenotypeList) {
                List<Datum> td = this.processDatum(current, this.isInteractive());
                if (td == null) continue;
                outputList.addAll(td);
            }
            for (Datum current : alignmentList) {
                List<Datum> td = this.processDatum(current, this.isInteractive());
                if (td == null) continue;
                outputList.addAll(td);
            }
            if (outputList.isEmpty()) {
                Datum current;
                current = null;
                return current;
            }
            DataSet output = new DataSet(outputList, (Plugin)this);
            this.fireDataSetReturned(new PluginEvent(output, NumericalTransformPlugin.class));
            DataSet dataSet = output;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Datum> processDatum(Datum inDatum, boolean isInteractive) {
        List<Datum> resultList = null;
        if (isInteractive) {
            Window dialog = null;
            try {
                dialog = new NumTransformDialog(this.getParentFrame(), inDatum);
                dialog.setLocationRelativeTo(this.getParentFrame());
                ((Dialog)dialog).setVisible(true);
                resultList = ((NumTransformDialog)dialog).getResults();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                dialog.dispose();
            }
        }
        return resultList;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = NumericalTransformPlugin.class.getResource("Transform.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Transform";
    }

    @Override
    public String getToolTipText() {
        return "Transform Numerical Dataset";
    }
}

