/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.maizegenetics.analysis.numericaltransform.Conversion;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.stats.PCA.PrinComp;
import net.maizegenetics.trait.Phenotype;
import net.maizegenetics.trait.SimplePhenotype;
import net.maizegenetics.trait.Trait;
import net.maizegenetics.util.SimpleTableReport;
import net.maizegenetics.util.TableReport;

public class PCAPanel
extends JPanel {
    private Datum theDatum;
    private JPanel pnlPCA = new JPanel();
    private String DEFAULT_EIGEN = "0";
    private String DEFAULT_CUM = "0.10";
    private String DEFAULT_COMP = "0";
    private JTextField tfdEigenvalue = new JTextField(5);
    private JTextField tfdCumulative = new JTextField(5);
    private JTextField tfdNumComp = new JTextField(5);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JSpinner spnComp;
    private StringBuffer procedure;
    private StringBuffer procedureReport;
    private ButtonGroup bgrpPCA = new ButtonGroup();
    private ButtonGroup bgrpVar = new ButtonGroup();
    private Phenotype aCharacterAlignment;
    private String[] columnNames;
    private JRadioButton rdoEigen = new JRadioButton();
    private JRadioButton rdoCum = new JRadioButton();
    private JRadioButton rdoNum = new JRadioButton();
    private JRadioButton rdoCor = new JRadioButton();
    private JRadioButton rdoCovar = new JRadioButton();
    private JLabel lblMethod = new JLabel("Method");
    private JLabel lblOutput = new JLabel("Output");
    private double eigenvalue;
    private double userMinPropOfVar;
    private Frame myParentFrame = null;

    public PCAPanel(Datum theDatum, Frame parentFrame) throws Exception {
        this.myParentFrame = parentFrame;
        try {
            if (!(theDatum.getData() instanceof Phenotype)) {
                throw new Exception("Must be Character Alignment");
            }
            this.theDatum = theDatum;
            this.aCharacterAlignment = (Phenotype)theDatum.getData();
            Object[] trColumnNames = this.aCharacterAlignment.getTableColumnNames();
            String[] tempColNames = new String[trColumnNames.length];
            this.columnNames = new String[trColumnNames.length - 1];
            for (int i = 1; i < trColumnNames.length; ++i) {
                if (trColumnNames instanceof String[]) {
                    tempColNames = (String[])trColumnNames;
                }
                this.columnNames = new String[tempColNames.length - 1];
                System.arraycopy(tempColNames, 1, this.columnNames, 0, this.columnNames.length);
            }
            this.DEFAULT_CUM = "" + PCAPanel.nNum(1.0 / (double)this.aCharacterAlignment.getNumberOfTraits());
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.pnlPCA.setLayout(this.gridBagLayout1);
        this.rdoEigen.setText("Eigenvalue \u2265");
        this.rdoCum.setText("Var Prop % \u2265");
        this.rdoNum.setText("Components = ");
        this.rdoCor.setText("Correlation");
        this.rdoCovar.setText("Covariance");
        this.tfdEigenvalue.setText(this.DEFAULT_EIGEN);
        this.tfdCumulative.setText(this.DEFAULT_CUM);
        this.tfdNumComp.setText(this.DEFAULT_COMP);
        this.bgrpPCA.add(this.rdoEigen);
        this.bgrpPCA.add(this.rdoCum);
        this.bgrpPCA.add(this.rdoNum);
        this.bgrpPCA.setSelected(this.rdoEigen.getModel(), true);
        this.bgrpVar.add(this.rdoCor);
        this.bgrpVar.add(this.rdoCovar);
        this.bgrpVar.setSelected(this.rdoCovar.getModel(), true);
        SpinnerNumberModel aSpinnerNumberModel = new SpinnerNumberModel(this.columnNames.length, 1, this.columnNames.length, 1);
        this.spnComp = new JSpinner(aSpinnerNumberModel);
        this.spnComp.setMinimumSize(new Dimension(100, 100));
        this.spnComp.setOpaque(true);
        this.pnlPCA.add((Component)this.lblMethod, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 7));
        this.pnlPCA.add((Component)this.rdoCovar, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 7));
        this.pnlPCA.add((Component)this.rdoCor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 7));
        this.pnlPCA.add((Component)this.lblOutput, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 7));
        this.pnlPCA.add((Component)this.rdoEigen, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 11, 0, new Insets(34, -10, 0, 50), 0, 7));
        this.pnlPCA.add((Component)this.rdoCum, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 10, 0, 50), 7, 7));
        this.pnlPCA.add((Component)this.rdoNum, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 50), 0, 7));
        this.pnlPCA.add((Component)this.tfdEigenvalue, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(40, -50, 5, 10), 1, 1));
        this.pnlPCA.add((Component)this.tfdCumulative, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(6, -50, 3, 10), 1, 1));
        this.pnlPCA.setBorder(BorderFactory.createEtchedBorder());
        this.pnlPCA.add((Component)this.spnComp, new GridBagConstraints(2, 6, 15, 15, 1.0, 1.0, 11, 0, new Insets(5, -50, 0, 10), 1, 1));
        this.add(this.pnlPCA);
        this.eigenvalue = new BigDecimal(this.DEFAULT_EIGEN).doubleValue();
        this.tfdEigenvalue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String minEigenvalue = PCAPanel.this.tfdEigenvalue.getText();
                boolean failed = true;
                BigDecimal bd = null;
                try {
                    bd = new BigDecimal(minEigenvalue, new MathContext(2, RoundingMode.HALF_UP));
                    failed = false;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (failed) {
                    JOptionPane.showMessageDialog(PCAPanel.this.myParentFrame, "Please enter numbers only.");
                    PCAPanel.this.tfdEigenvalue.setText(PCAPanel.this.DEFAULT_EIGEN);
                } else {
                    PCAPanel.this.tfdEigenvalue.setText(bd.toString());
                    PCAPanel.this.eigenvalue = bd.doubleValue();
                    if (PCAPanel.this.eigenvalue < 0.0) {
                        JOptionPane.showMessageDialog(PCAPanel.this.myParentFrame, "Eigenvalue must be greater than or equal to 0.");
                        PCAPanel.this.tfdEigenvalue.setText(PCAPanel.this.DEFAULT_EIGEN);
                    }
                }
            }
        });
        this.userMinPropOfVar = new BigDecimal(this.DEFAULT_CUM).doubleValue();
        this.tfdCumulative.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String minCumulative = PCAPanel.this.tfdCumulative.getText();
                boolean failed = true;
                BigDecimal bd = null;
                try {
                    bd = new BigDecimal(minCumulative, new MathContext(2, RoundingMode.HALF_UP));
                    failed = false;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (failed) {
                    JOptionPane.showMessageDialog(PCAPanel.this.myParentFrame, "Please enter numbers only.");
                    PCAPanel.this.tfdCumulative.setText(PCAPanel.this.DEFAULT_CUM);
                } else {
                    PCAPanel.this.tfdCumulative.setText(bd.toString());
                    PCAPanel.this.userMinPropOfVar = bd.doubleValue();
                    if (PCAPanel.this.userMinPropOfVar > 1.0 || PCAPanel.this.userMinPropOfVar <= 0.0) {
                        JOptionPane.showMessageDialog(PCAPanel.this.myParentFrame, "Cumulative proportion must be between 0 and 1.");
                        PCAPanel.this.tfdCumulative.setText(PCAPanel.this.DEFAULT_CUM);
                    }
                }
            }
        });
    }

    public List<Datum> createPCAData(JTable tblTraits) {
        int[] colSelected = tblTraits.getSelectedRows();
        if (colSelected == null || colSelected.length == 0) {
            JOptionPane.showMessageDialog(this.myParentFrame, "Please select a column to test.");
            return null;
        }
        PrinComp thePCA = null;
        try {
            thePCA = this.doPrinCompAnalysis(colSelected, this.aCharacterAlignment);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.myParentFrame, "There is bad data in the PCA.  Impute missing data or remove non-variable columns.");
            return null;
        }
        if (thePCA != null) {
            return this.makeOutputFiles(thePCA);
        }
        return null;
    }

    private PrinComp doPrinCompAnalysis(int[] colSelected, Phenotype ca) {
        double[][] tempData = null;
        tempData = Conversion.parseColumnData(ca, colSelected);
        if (tempData == null) {
            return null;
        }
        DoubleMatrix values = DoubleMatrixFactory.DEFAULT.make(tempData);
        this.procedure = new StringBuffer("(");
        this.procedureReport = new StringBuffer("\nProcedure(s) applied:");
        this.procedure.append(" eigenvalues");
        this.procedureReport.append("\n\tPCA Eigenvalues: ");
        PrinComp.PC_TYPE type = this.rdoCor.getModel().isSelected() ? PrinComp.PC_TYPE.corr : PrinComp.PC_TYPE.cov;
        return new PrinComp(values, type);
    }

    private List<Datum> makeOutputFiles(PrinComp thePCAAnalysis) {
        int n;
        ArrayList<Datum> resultList = new ArrayList<Datum>();
        DoubleMatrix principalComponents = thePCAAnalysis.getPrincipalComponents();
        double[] eigenvalueArray = thePCAAnalysis.getEigenValues();
        DoubleMatrix eigenvectors = thePCAAnalysis.getEigenVectors();
        int numberOfPC = eigenvalueArray.length;
        int filterNumberOfPC = 0;
        int taxaNumber = principalComponents.numberOfRows();
        String compString = this.spnComp.getValue().toString();
        int maxcomp = Integer.parseInt(compString);
        double rsum = 0.0;
        for (n = 0; n < numberOfPC; ++n) {
            rsum += eigenvalueArray[n];
        }
        for (n = 0; n < numberOfPC; ++n) {
            if (!(this.rdoEigen.isSelected() && eigenvalueArray[n] >= this.eigenvalue || this.rdoNum.isSelected() && n < maxcomp) && (!this.rdoCum.isSelected() || !(eigenvalueArray[n] / rsum > this.userMinPropOfVar))) continue;
            ++filterNumberOfPC;
        }
        if (filterNumberOfPC == 0) {
            filterNumberOfPC = 1;
        }
        double[][] eigenFilter = new double[taxaNumber][filterNumberOfPC];
        for (int r = 0; r < taxaNumber; ++r) {
            for (int c = 0; c < filterNumberOfPC; ++c) {
                eigenFilter[r][c] = principalComponents.get(r, c);
            }
        }
        ArrayList<Trait> PCNames = new ArrayList<Trait>();
        for (int n2 = 1; n2 < filterNumberOfPC + 1; ++n2) {
            PCNames.add(new Trait("PC " + n2, false, "covariate"));
        }
        int numberOfEigenVecRows = eigenvectors.numberOfRows();
        double[][] eigenVectorsArray = new double[numberOfEigenVecRows][filterNumberOfPC];
        for (int r = 0; r < numberOfEigenVecRows; ++r) {
            for (int c = 0; c < filterNumberOfPC; ++c) {
                eigenVectorsArray[r][c] = eigenvectors.get(r, c);
            }
        }
        if (this.eigenvalue >= 0.0) {
            SimplePhenotype sca = new SimplePhenotype(this.aCharacterAlignment.getTaxa(), PCNames, eigenFilter);
            TableReport sca2 = this.createEigenVectorReport(eigenVectorsArray);
            TableReport sca3 = this.createCumulativeVarianceReport(eigenvalueArray);
            StringWriter sw = new StringWriter();
            String reportPanelMsg = new StringBuffer() + sw.toString() + "Converted Column:\n" + this.procedureReport.toString().toString();
            resultList.add(new Datum("PC for " + this.theDatum.getName(), sca, reportPanelMsg));
            resultList.add(new Datum("Eigenvectors for  " + this.theDatum.getName(), sca2, reportPanelMsg));
            resultList.add(new Datum("Eigenvalues for  " + this.theDatum.getName(), sca3, reportPanelMsg));
        }
        return resultList;
    }

    TableReport createEigenVectorReport(double[][] eigenVectorsArray) {
        Object[] evColNames = new String[eigenVectorsArray[0].length + 1];
        evColNames[0] = "Trait.Env";
        for (int n = 0; n < eigenVectorsArray[0].length; ++n) {
            evColNames[n + 1] = "EigenVector" + (n + 1);
        }
        Object[][] evOutput = new Object[eigenVectorsArray.length][eigenVectorsArray[0].length + 1];
        for (int i = 0; i < eigenVectorsArray.length; ++i) {
            evOutput[i][0] = this.aCharacterAlignment.getTrait(i).getName() + "." + this.aCharacterAlignment.getTrait(i).getProperty("env");
            for (int n = 0; n < eigenVectorsArray[0].length; ++n) {
                evOutput[i][n + 1] = PCAPanel.nNum(eigenVectorsArray[i][n]);
            }
        }
        SimpleTableReport str = new SimpleTableReport("EigenVectors", evColNames, evOutput);
        return str;
    }

    TableReport createCumulativeVarianceReport(double[] eigenvalueArray) {
        double[] propVariancePC = new double[eigenvalueArray.length];
        double[] cumPropVariancePC = new double[propVariancePC.length];
        double sum = 0.0;
        for (int n = 0; n < eigenvalueArray.length; ++n) {
            sum += eigenvalueArray[n];
        }
        double[] rpropVariancePC = new double[eigenvalueArray.length];
        for (int n = 0; n < eigenvalueArray.length; ++n) {
            propVariancePC[n] = eigenvalueArray[n] / sum;
        }
        Object[] cumlativeColNames = new String[]{"PC", "Eigenvalues", "Individual Proportion", "Cumulative Proportion"};
        cumPropVariancePC[0] = propVariancePC[0];
        for (int n = 1; n < eigenvalueArray.length; ++n) {
            cumPropVariancePC[n] = propVariancePC[n] + cumPropVariancePC[n - 1];
        }
        Object[][] propOutput = new Object[eigenvalueArray.length][4];
        for (int n = 0; n < eigenvalueArray.length; ++n) {
            propOutput[n][0] = n + 1;
            propOutput[n][1] = PCAPanel.nNum(eigenvalueArray[n]);
            propOutput[n][2] = PCAPanel.nNum(propVariancePC[n]);
            propOutput[n][3] = PCAPanel.nNum(cumPropVariancePC[n]);
        }
        SimpleTableReport sca3 = new SimpleTableReport("Prop of Variance", cumlativeColNames, propOutput);
        return sca3;
    }

    private static String nNum(double d) {
        return new BigDecimal(d, new MathContext(5)).toString();
    }

    private static double nNumD(double d) {
        return new BigDecimal(d, new MathContext(5)).doubleValue();
    }
}

