/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.popgen.DiversityAnalyses;
import net.maizegenetics.analysis.popgen.DiversityDialog;
import net.maizegenetics.analysis.popgen.PolymorphismDistribution;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.util.SimpleTableReport;

public class SequenceDiversityPlugin
extends AbstractPlugin {
    boolean isSlidingWindowAnalysis = false;
    int startSite = 0;
    int endSite = 0;
    int windowSize = 500;
    int stepSize = 100;

    public SequenceDiversityPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() < 1) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Invalid selection.  Please select sequence or marker alignment.");
                DataSet dataSet = null;
                return dataSet;
            }
            ArrayList<DataSet> result = new ArrayList<DataSet>();
            Iterator<Datum> itr = alignInList.iterator();
            while (itr.hasNext()) {
                DataSet tds = null;
                Datum current = itr.next();
                GenotypeTable aa = (GenotypeTable)current.getData();
                if (this.isInteractive()) {
                    DiversityDialog myDialog = new DiversityDialog(aa);
                    myDialog.setLocationRelativeTo(this.getParentFrame());
                    myDialog.setVisible(true);
                    if (myDialog.isCancel()) {
                        DataSet dataSet = null;
                        return dataSet;
                    }
                    this.isSlidingWindowAnalysis = myDialog.isSlidingWindowAnalysis();
                    this.startSite = myDialog.getStartSite();
                    this.endSite = myDialog.getEndSite();
                    this.windowSize = myDialog.getWindowSize();
                    this.stepSize = myDialog.getStepSize();
                } else {
                    if (this.startSite + 1 > aa.numberOfSites()) {
                        this.startSite = 0;
                    }
                    if (this.endSite < 1 || this.endSite + 1 > aa.numberOfSites()) {
                        this.endSite = aa.numberOfSites() - 1;
                    }
                    if (this.windowSize + 1 > aa.numberOfSites()) {
                        this.windowSize = aa.numberOfSites() - 1;
                    }
                    if (this.stepSize + 1 > aa.numberOfSites()) {
                        this.stepSize = aa.numberOfSites() - 1;
                    }
                }
                if ((tds = this.processDatum(current)) == null) continue;
                result.add(tds);
                this.fireDataSetReturned(new PluginEvent(tds, SequenceDiversityPlugin.class));
            }
            DataSet dataSet = DataSet.getDataSet(result, this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    public DataSet processDatum(Datum input) {
        GenotypeTable aa = (GenotypeTable)input.getData();
        PolymorphismDistribution pda = new PolymorphismDistribution();
        DiversityAnalyses theDA = new DiversityAnalyses(aa, this.isSlidingWindowAnalysis, this.startSite, this.endSite, this.windowSize, this.stepSize, pda);
        ArrayList<Datum> results = new ArrayList<Datum>();
        results.add(new Datum("PolyDist:" + input.getName(), new SimpleTableReport(pda), "Polymorphism Distribution"));
        results.add(new Datum("Diversity:" + input.getName(), new SimpleTableReport(theDA), "Diversity Analysis"));
        DataSet tds = new DataSet(results, (Plugin)this);
        return tds;
    }

    public boolean isSlidingWindowAnalysis() {
        return this.isSlidingWindowAnalysis;
    }

    public void setSlidingWindowAnalysis(boolean slidingWindowAnalysis) {
        this.isSlidingWindowAnalysis = slidingWindowAnalysis;
    }

    public int getStartSite() {
        return this.startSite;
    }

    public void setStartSite(int startSite) {
        this.startSite = startSite;
    }

    public int getEndSite() {
        return this.endSite;
    }

    public void setEndSite(int endSite) {
        this.endSite = endSite;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(int stepSize) {
        this.stepSize = stepSize;
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = SequenceDiversityPlugin.class.getResource("/net/maizegenetics/analysis/images/Diversity.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Diversity";
    }

    @Override
    public String getToolTipText() {
        return "Basic description of diversity";
    }
}

