/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.tree;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.taxa.tree.Node;
import net.maizegenetics.taxa.tree.Tree;
import org.apache.log4j.Logger;
import org.forester.archaeopteryx.Archaeopteryx;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.PhylogenyNodeI;

public class ArchaeopteryxPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ArchaeopteryxPlugin.class);

    public ArchaeopteryxPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            List<Datum> treeInList = input.getDataOfType(Tree.class);
            if (treeInList.size() != 1) {
                String message = "Invalid selection.  Please select one tree.";
                if (this.isInteractive()) {
                    JOptionPane.showMessageDialog(this.getParentFrame(), message);
                } else {
                    System.out.println(message);
                }
                DataSet dataSet = null;
                return dataSet;
            }
            Tree myTree = (Tree)treeInList.get(0).getData();
            ArchaeopteryxPlugin.makeTree(myTree, this.isInteractive(), this.getParentFrame());
            DataSet dataSet = null;
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = ArchaeopteryxPlugin.class.getResource("/net/maizegenetics/analysis/images/Tree.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Archaeopteryx Tree";
    }

    @Override
    public String getToolTipText() {
        return "Archaeopteryx Tree Viewer";
    }

    public static void makeTree(Tree theTree, boolean isInteractive, Frame frame) {
        Phylogeny phy = new Phylogeny();
        PhylogenyNode root = new PhylogenyNode();
        Node palroot = theTree.getRoot();
        root.setName(palroot.getIdentifier().getName());
        LinkedList<NodePair> nodeList = new LinkedList<NodePair>();
        class NodePair {
            PhylogenyNode fNode;
            Node pNode;

            NodePair(PhylogenyNode node1, Node node2) {
                this.fNode = node1;
                this.pNode = node2;
            }
        }
        nodeList.add(new NodePair(root, palroot));
        while (!nodeList.isEmpty()) {
            NodePair pair = (NodePair)nodeList.remove();
            int n = pair.pNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                PhylogenyNode newNode = new PhylogenyNode();
                pair.fNode.addAsChild((PhylogenyNodeI)newNode);
                newNode.setName(pair.pNode.getChild(i).getIdentifier().getName());
                newNode.setDistanceToParent(pair.pNode.getChild(i).getBranchLength());
                nodeList.add(new NodePair(newNode, pair.pNode.getChild(i)));
            }
        }
        phy.setRoot(root);
        phy.setRooted(true);
        if (!isInteractive) {
            myLogger.info((Object)"Archaeopteryx plugin non-interactive mode is not implemented.");
            return;
        }
        Archaeopteryx.createApplication((Phylogeny)phy).setLocationRelativeTo((Component)frame);
    }
}

