/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

public class TagGWASMapInfo {
    public int readCount = Integer.MIN_VALUE;
    public int pChr = Integer.MIN_VALUE;
    public int pPos = Integer.MIN_VALUE;
    public boolean ifMap = false;
    public boolean ifRef = false;
    public boolean ifUnique = false;
    public int gChr = Integer.MIN_VALUE;
    public int gPos = Integer.MIN_VALUE;
    public double gwasPValue = 1.0;
    public int numSigSite = Integer.MIN_VALUE;
    public int tagTaxaCount = Integer.MIN_VALUE;
    public int numSigChr = Integer.MIN_VALUE;
    public double lRatioSB = 0.0;
    public double lRatioMB = 0.0;
    public int numSiteOnBestChrThanSecondBest = Integer.MIN_VALUE;
    public int sigSiteStart = Integer.MIN_VALUE;
    public int sigSiteEnd = Integer.MIN_VALUE;
    public double predictedDistance = Double.NaN;

    public TagGWASMapInfo() {
    }

    public TagGWASMapInfo(int readCount, int gChr, int gPos, double gwasPValue, int numSigSite, int tagTaxaCount, int numSigChr, double lRatioSB, double lRatioMB, int numSiteOnBestChrThanSecondBest, int sigSiteStart, int sigSiteEnd) {
        this.readCount = readCount;
        this.pChr = this.pChr;
        this.pPos = this.pPos;
        this.ifMap = this.ifMap;
        this.ifRef = this.ifRef;
        this.ifUnique = this.ifUnique;
        this.gChr = gChr;
        this.gPos = gPos;
        this.gwasPValue = gwasPValue;
        this.numSigSite = numSigSite;
        this.tagTaxaCount = tagTaxaCount;
        this.numSigChr = numSigChr;
        this.lRatioSB = lRatioSB;
        this.lRatioMB = lRatioMB;
        this.numSiteOnBestChrThanSecondBest = numSiteOnBestChrThanSecondBest;
        this.sigSiteStart = sigSiteStart;
        this.sigSiteEnd = sigSiteEnd;
    }

    public TagGWASMapInfo(int readCount, int pChr, int pPos, boolean ifMap, boolean ifRef, boolean ifUnique, int gChr, int gPos, double gwasPValue, int numSigSite, int tagTaxaCount, int numSigChr, double lRatioSB, double lRatioMB, int numSiteOnBestChrThanSecondBest, int sigSiteStart, int sigSiteEnd) {
        this.readCount = readCount;
        this.pChr = pChr;
        this.pPos = pPos;
        this.ifMap = ifMap;
        this.ifRef = ifRef;
        this.ifUnique = ifUnique;
        this.gChr = gChr;
        this.gPos = gPos;
        this.gwasPValue = gwasPValue;
        this.numSigSite = numSigSite;
        this.tagTaxaCount = tagTaxaCount;
        this.numSigChr = numSigChr;
        this.lRatioSB = lRatioSB;
        this.lRatioMB = lRatioMB;
        this.numSiteOnBestChrThanSecondBest = numSiteOnBestChrThanSecondBest;
        this.sigSiteStart = sigSiteStart;
        this.sigSiteEnd = sigSiteEnd;
    }

    public void setAlignment(int pChr, int pPos, boolean ifMap, boolean ifRef, boolean ifUnique) {
        this.pChr = pChr;
        this.pPos = pPos;
        this.ifMap = ifMap;
        this.ifRef = ifRef;
        this.ifUnique = ifUnique;
    }

    public void setPredictedDistance(double predictedDistance) {
        this.predictedDistance = predictedDistance;
    }

    public boolean isUniqueRef() {
        return this.ifRef && this.ifUnique;
    }

    public String getBoxcoxAttributesStr(double[] lamdas, String delimiter) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.boxcoxTransform(this.readCount, lamdas[0])).append(delimiter);
        sb.append(this.boxcoxTransform(this.tagTaxaCount, lamdas[1])).append(delimiter);
        sb.append(this.boxcoxTransform(this.getMinusLog10PValue(), lamdas[2])).append(delimiter);
        sb.append(this.boxcoxTransform(this.lRatioSB, lamdas[3])).append(delimiter);
        sb.append(this.boxcoxTransform(this.lRatioMB, lamdas[4])).append(delimiter);
        sb.append(this.boxcoxTransform(this.getAdjustedNumSigChr(), lamdas[5])).append(delimiter);
        sb.append(this.boxcoxTransform(this.getAdjustedNumSigSite(), lamdas[6])).append(delimiter);
        sb.append(this.boxcoxTransform(this.getAdjustedNumSigSiteBC(), lamdas[7])).append(delimiter);
        sb.append(this.boxcoxTransform(this.getSigWidthBC(), lamdas[8])).append(delimiter);
        sb.append(this.getLog10GDist());
        return sb.toString();
    }

    public String getAttributesStr(String delimiter) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.readCount).append(delimiter);
        sb.append(this.tagTaxaCount).append(delimiter);
        sb.append(this.getMinusLog10PValue()).append(delimiter);
        sb.append(this.lRatioSB).append(delimiter);
        sb.append(this.lRatioMB).append(delimiter);
        sb.append(this.getAdjustedNumSigChr()).append(delimiter);
        sb.append(this.getAdjustedNumSigSite()).append(delimiter);
        sb.append(this.getAdjustedNumSigSiteBC()).append(delimiter);
        sb.append(this.getSigWidthBC()).append(delimiter);
        sb.append(this.getLog10GDist());
        return sb.toString();
    }

    private double getMinusLog10PValue() {
        double value = -Math.log10(this.gwasPValue);
        if (value == Double.POSITIVE_INFINITY) {
            value = 308.0;
        }
        return value;
    }

    private int getAdjustedNumSigSiteBC() {
        if (this.numSiteOnBestChrThanSecondBest == 0) {
            return 1;
        }
        return this.numSiteOnBestChrThanSecondBest;
    }

    private int getAdjustedNumSigSite() {
        if (this.numSigSite == 0) {
            return 1;
        }
        return this.numSigSite;
    }

    private int getAdjustedNumSigChr() {
        if (this.numSigChr == 0) {
            return 1;
        }
        return this.numSigChr;
    }

    private int getSigWidthBC() {
        return Math.abs(this.sigSiteEnd - this.sigSiteStart) + 1;
    }

    private double getLog10GDist() {
        if (this.gChr == this.pChr) {
            int value = Math.abs(this.gPos - this.pPos);
            if (value < 2) {
                value = 2;
            }
            return Math.log10(value);
        }
        return Math.log10(2.147483647E9);
    }

    private double boxcoxTransform(double y, double lambda) {
        if (lambda != 0.0) {
            return (Math.pow(y, lambda) - 1.0) / lambda;
        }
        return Math.log(y);
    }
}

