/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.CombineGenotypeTable;
import net.maizegenetics.dna.snp.CoreGenotypeTable;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.depth.AlleleDepth;
import net.maizegenetics.dna.snp.depth.AlleleDepthBuilder;
import net.maizegenetics.dna.snp.depth.AlleleDepthUtil;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.GenotypeMergeRule;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.Tassel5HDF5Constants;

public class GenotypeTableBuilder {
    private GenotypeCallTable genotype = null;
    private PositionList positionList = null;
    private TaxaListBuilder taxaListBuilder = null;
    private ArrayList<byte[]> incGeno = null;
    private ArrayList<byte[][]> incDepth = null;
    private HashMap<Taxon, Integer> incTaxonIndex = null;
    private boolean sortAlphabetically = false;
    private final TaxaList taxaList;
    private PositionListBuilder posListBuilder = null;
    private boolean isTaxaMerge = false;
    private GenotypeMergeRule mergeRule = null;
    private boolean isHDF5 = false;
    private IHDF5Writer writer = null;
    private BuildType myBuildType;

    private GenotypeTableBuilder(PositionList positionList, GenotypeMergeRule mergeRule) {
        this.positionList = positionList;
        this.myBuildType = BuildType.TAXA_INC;
        this.mergeRule = mergeRule;
        if (mergeRule != null) {
            this.isTaxaMerge = true;
        }
        this.incGeno = new ArrayList();
        this.incDepth = new ArrayList();
        this.incTaxonIndex = new HashMap();
        this.taxaListBuilder = new TaxaListBuilder();
        this.taxaList = null;
    }

    private GenotypeTableBuilder(TaxaList taxaList) {
        this.taxaList = taxaList;
        this.myBuildType = BuildType.SITE_INC;
        this.incGeno = new ArrayList();
        this.posListBuilder = new PositionListBuilder();
    }

    private GenotypeTableBuilder(String hdf5File, PositionList positionList, GenotypeMergeRule mergeRule) {
        IHDF5WriterConfigurator config = HDF5Factory.configure((String)hdf5File);
        config.dontUseExtendableDataTypes();
        this.writer = config.writer();
        if (HDF5Utils.doesGenotypeModuleExist((IHDF5Reader)this.writer) && HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)this.writer)) {
            this.writer.close();
            throw new UnsupportedOperationException("This file is locked for genotypic additions");
        }
        if (positionList != null) {
            this.positionList = new PositionListBuilder(this.writer, positionList).build();
            this.setupGenotypeTaxaInHDF5(this.writer);
        } else {
            this.positionList = PositionListBuilder.getInstance((IHDF5Reader)this.writer);
        }
        this.mergeRule = mergeRule;
        if (mergeRule != null) {
            this.isTaxaMerge = true;
        }
        this.myBuildType = BuildType.TAXA_INC;
        this.isHDF5 = true;
        this.taxaList = null;
    }

    private GenotypeTableBuilder(String hdf5File, TaxaList taxaList, int numberOfSites) {
        IHDF5WriterConfigurator config = HDF5Factory.configure((String)hdf5File);
        config.dontUseExtendableDataTypes();
        this.writer = config.writer();
        if (HDF5Utils.doesGenotypeModuleExist((IHDF5Reader)this.writer) && HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)this.writer)) {
            this.writer.close();
            throw new UnsupportedOperationException("This file is locked for genotypic additions");
        }
        this.taxaList = taxaList;
        this.setupGenotypeTaxaInHDF5(this.writer);
        this.posListBuilder = new PositionListBuilder(numberOfSites);
        byte[] missingGenotypes = new byte[numberOfSites];
        Arrays.fill(missingGenotypes, (byte)-1);
        for (Taxon taxon : taxaList) {
            HDF5Utils.addTaxon(this.writer, taxon);
            HDF5Utils.writeHDF5GenotypesCalls(this.writer, taxon.getName(), missingGenotypes);
        }
        this.myBuildType = BuildType.SITE_INC;
        this.isHDF5 = true;
    }

    public static GenotypeTableBuilder getTaxaIncremental(PositionList positionList) {
        return new GenotypeTableBuilder(positionList, null);
    }

    public static GenotypeTableBuilder getTaxaIncremental(PositionList positionList, GenotypeMergeRule mergeRule) {
        return new GenotypeTableBuilder(positionList, mergeRule);
    }

    public static GenotypeTableBuilder getTaxaIncremental(GenotypeTable genotypeTable, GenotypeMergeRule mergeRule) {
        PositionList positionList = genotypeTable.positions();
        GenotypeTableBuilder gtb = new GenotypeTableBuilder(positionList, mergeRule);
        boolean hasDepth = genotypeTable.hasDepth();
        for (int i = 0; i < genotypeTable.numberOfTaxa(); ++i) {
            if (hasDepth) {
                gtb.addTaxon((Taxon)genotypeTable.taxa().get(i), genotypeTable.genotypeAllSites(i), genotypeTable.depth().depthAllSitesByte(i));
                continue;
            }
            gtb.addTaxon((Taxon)genotypeTable.taxa().get(i), genotypeTable.genotypeAllSites(i));
        }
        return gtb;
    }

    public static GenotypeTableBuilder getTaxaIncremental(PositionList positionList, String newHDF5File) {
        return new GenotypeTableBuilder(newHDF5File, positionList, null);
    }

    public static GenotypeTableBuilder mergeTaxaIncremental(String existingHDFFile, GenotypeMergeRule mergeRule) {
        return new GenotypeTableBuilder(existingHDFFile, null, mergeRule);
    }

    public static GenotypeTableBuilder getTaxaIncrementalWithMerging(String newHDFFile, PositionList positionList, GenotypeMergeRule mergeRule) {
        return new GenotypeTableBuilder(newHDFFile, positionList, mergeRule);
    }

    public static GenotypeTableBuilder getSiteIncremental(TaxaList taxaList) {
        return new GenotypeTableBuilder(taxaList);
    }

    public static GenotypeTableBuilder getSiteIncremental(TaxaList taxaList, int numberOfPositions, String newHDF5File) {
        return new GenotypeTableBuilder(newHDF5File, taxaList, numberOfPositions);
    }

    public static GenotypeTable getInstance(GenotypeCallTable genotype, PositionList positionList, TaxaList taxaList, SiteScore siteScore, AlleleDepth alleleDepth) {
        if (genotype.numberOfSites() != positionList.numberOfSites()) {
            throw new IllegalArgumentException("GenotypeTableBuilder: getInstance: number of sites in genotype: " + genotype.numberOfSites() + " doesn't equal number of sites in position list: " + positionList.numberOfSites());
        }
        if (genotype.numberOfTaxa() != taxaList.numberOfTaxa()) {
            throw new IllegalArgumentException("GenotypeTableBuilder: getInstance: number of taxa in genotype: " + genotype.numberOfTaxa() + " doesn't equal number of taxa in taaxa list: " + taxaList.numberOfTaxa());
        }
        return new CoreGenotypeTable(genotype, positionList, taxaList, siteScore, alleleDepth);
    }

    public static GenotypeTable getInstance(GenotypeCallTable genotype, PositionList positionList, TaxaList taxaList) {
        if (genotype.numberOfSites() != positionList.numberOfSites()) {
            throw new IllegalArgumentException("GenotypeTableBuilder: getInstance: number of sites in genotype: " + genotype.numberOfSites() + " doesn't equal number of sites in position list: " + positionList.numberOfSites());
        }
        if (genotype.numberOfTaxa() != taxaList.numberOfTaxa()) {
            throw new IllegalArgumentException("GenotypeTableBuilder: getInstance: number of taxa in genotype: " + genotype.numberOfTaxa() + " doesn't equal number of taxa in taaxa list: " + taxaList.numberOfTaxa());
        }
        return new CoreGenotypeTable(genotype, positionList, taxaList);
    }

    public static GenotypeTable getInstance(GenotypeCallTable genotype, PositionList positionList, TaxaList taxaList, String hdf5File) {
        if (genotype.numberOfSites() != positionList.numberOfSites()) {
            throw new IllegalArgumentException("GenotypeTableBuilder: getInstance: number of sites in genotype: " + genotype.numberOfSites() + " doesn't equal number of sites in position list: " + positionList.numberOfSites());
        }
        if (genotype.numberOfTaxa() != taxaList.numberOfTaxa()) {
            throw new IllegalArgumentException("GenotypeTableBuilder: getInstance: number of taxa in genotype: " + genotype.numberOfTaxa() + " doesn't equal number of taxa in taaxa list: " + taxaList.numberOfTaxa());
        }
        GenotypeTableBuilder aB = GenotypeTableBuilder.getTaxaIncremental(positionList, hdf5File);
        for (int i = 0; i < taxaList.numberOfTaxa(); ++i) {
            aB.addTaxon((Taxon)taxaList.get(i), genotype.genotypeAllSites(i));
        }
        return aB.build();
    }

    public static GenotypeTable getInstance(GenotypeTable a, String hdf5File) {
        return GenotypeTableBuilder.getInstance(a.genotypeMatrix(), a.positions(), a.taxa(), hdf5File);
    }

    public static GenotypeTable getInstance(String hdf5File) {
        IHDF5Reader reader = HDF5Factory.openForReading((String)hdf5File);
        TaxaList tL = new TaxaListBuilder().buildFromHDF5Genotypes(reader);
        PositionList pL = PositionListBuilder.getInstance(reader);
        GenotypeCallTable geno = GenotypeCallTableBuilder.buildHDF5(reader);
        AlleleDepth depth = AlleleDepthBuilder.getExistingHDF5Instance(reader);
        return GenotypeTableBuilder.getInstance(geno, pL, tL, null, depth);
    }

    public static GenotypeTable getInstanceOnlyMajorMinor(GenotypeTable alignment) {
        int numTaxa = alignment.numberOfTaxa();
        int numSites = alignment.numberOfSites();
        GenotypeCallTableBuilder builder = GenotypeCallTableBuilder.getInstance(numTaxa, numSites);
        byte[] majorAllele = new byte[64];
        byte[] minorAllele = new byte[64];
        for (int bigS = 0; bigS < numSites; bigS += 64) {
            int blockSize = Math.min(64, numSites - bigS);
            for (int s = 0; s < blockSize; ++s) {
                majorAllele[s] = alignment.majorAllele(s + bigS);
                minorAllele[s] = alignment.minorAllele(s + bigS);
            }
            for (int t = 0; t < numTaxa; ++t) {
                for (int s = 0; s < blockSize; ++s) {
                    byte[] currentAlleles = alignment.genotypeArray(t, s + bigS);
                    if (currentAlleles[0] != majorAllele[s] && currentAlleles[0] != minorAllele[s]) {
                        currentAlleles[0] = 15;
                    }
                    if (currentAlleles[1] != majorAllele[s] && currentAlleles[1] != minorAllele[s]) {
                        currentAlleles[1] = 15;
                    }
                    builder.setBase(t, s, GenotypeTableUtils.getDiploidValue(currentAlleles[0], currentAlleles[1]));
                }
            }
        }
        return new CoreGenotypeTable(builder.build(), alignment.positions(), alignment.taxa());
    }

    public static GenotypeTable getHomozygousInstance(GenotypeTable alignment) {
        int numTaxa = alignment.numberOfTaxa();
        int numSites = alignment.numberOfSites();
        GenotypeCallTableBuilder builder = GenotypeCallTableBuilder.getInstance(numTaxa, numSites);
        for (int t = 0; t < numTaxa; ++t) {
            for (int s = 0; s < numSites; ++s) {
                byte currGeno = alignment.genotype(t, s);
                if (GenotypeTableUtils.isHeterozygous(currGeno)) {
                    builder.setBase(t, s, (byte)-1);
                    continue;
                }
                builder.setBase(t, s, currGeno);
            }
        }
        return new CoreGenotypeTable(builder.build(), alignment.positions(), alignment.taxa());
    }

    public static GenotypeTable getGenotypeCopyInstance(FilterGenotypeTable alignment) {
        return GenotypeTableBuilder.copyGenotypeInstance(alignment);
    }

    public static GenotypeTable getGenotypeCopyInstance(CombineGenotypeTable alignment) {
        return GenotypeTableBuilder.copyGenotypeInstance(alignment);
    }

    private static GenotypeTable copyGenotypeInstance(GenotypeTable alignment) {
        int numTaxa = alignment.numberOfTaxa();
        int numSites = alignment.numberOfSites();
        GenotypeCallTableBuilder builder = GenotypeCallTableBuilder.getInstance(numTaxa, numSites);
        for (int t = 0; t < numTaxa; ++t) {
            for (int s = 0; s < numSites; ++s) {
                builder.setBase(t, s, alignment.genotype(t, s));
            }
        }
        return new CoreGenotypeTable(builder.build(), alignment.positions(), alignment.taxa());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenotypeTableBuilder addSite(Position pos, byte[] genos) {
        if (this.myBuildType != BuildType.SITE_INC || this.isHDF5) {
            throw new IllegalArgumentException("addSite only be used with AlignmentBuilder.getSiteIncremental and without HDF5");
        }
        if (genos.length != this.taxaList.numberOfTaxa()) {
            throw new IndexOutOfBoundsException("Number of taxa and genotypes do not agree");
        }
        TaxaList taxaList = this.taxaList;
        synchronized (taxaList) {
            this.posListBuilder.add(pos);
            this.incGeno.add(genos);
        }
        return this;
    }

    public synchronized void addSiteBlock(int startSite, PositionList blkPositionList, byte[][] blockGenotypes, byte[][][] blockDepths) {
        if (this.myBuildType != BuildType.SITE_INC || !this.isHDF5) {
            throw new IllegalArgumentException("addSite only be used with AlignmentBuilder.getSiteIncremental and with HDF5");
        }
        if (blockGenotypes.length != this.taxaList.numberOfTaxa()) {
            throw new IndexOutOfBoundsException("Number of taxa and genotypes do not agree");
        }
        int s = startSite;
        System.out.println("startSite = [" + startSite + "], blkPositionList = [" + blkPositionList.size() + "], blockGenotypes = [" + blockGenotypes.length + "], blockDepths = [" + blockDepths + "]");
        for (Position position : blkPositionList) {
            this.posListBuilder.set(s++, position);
        }
        for (int t = 0; t < this.taxaList.numberOfTaxa(); ++t) {
            HDF5Utils.replaceHDF5GenotypesCalls(this.writer, this.taxaList.taxaName(t), startSite, blockGenotypes[t]);
        }
    }

    public GenotypeTableBuilder addTaxon(Taxon taxon, byte[] genos) {
        return this.addTaxon(taxon, genos, (byte[][])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenotypeTableBuilder addTaxon(Taxon taxon, byte[] genos, byte[][] depth) {
        if (this.myBuildType != BuildType.TAXA_INC) {
            throw new IllegalArgumentException("addTaxon only be used with AlignmentBuilder.getTaxaIncremental");
        }
        if (genos.length != this.positionList.numberOfSites()) {
            throw new IndexOutOfBoundsException("Number of sites and genotypes do not agree");
        }
        if (this.isHDF5) {
            if (this.isTaxaMerge && HDF5Utils.doTaxonCallsExist((IHDF5Reader)this.writer, taxon)) {
                this.mergeTaxonInHDF5(this.writer, taxon, genos, depth);
            } else {
                this.addTaxon(this.writer, taxon, genos, depth);
            }
        } else {
            TaxaListBuilder taxaListBuilder = this.taxaListBuilder;
            synchronized (taxaListBuilder) {
                if (this.isTaxaMerge && this.incTaxonIndex.containsKey(taxon)) {
                    this.mergeTaxonInMemory(taxon, genos, depth);
                } else {
                    this.taxaListBuilder.add(taxon);
                    this.incGeno.add(genos);
                    this.incDepth.add(depth);
                    this.incTaxonIndex.put(taxon, this.incGeno.size() - 1);
                }
            }
        }
        return this;
    }

    public GenotypeTableBuilder addTaxon(Taxon taxon, int[][] depths, byte[] genos) {
        byte[][] byteDepths = AlleleDepthUtil.depthIntToByte(depths);
        return this.addTaxon(taxon, genos, byteDepths);
    }

    private void mergeTaxonInMemory(Taxon taxon, byte[] genos, byte[][] depth) {
        int taxonIndex = this.incTaxonIndex.get(taxon);
        byte[] combGenos = new byte[genos.length];
        if (depth != null) {
            byte[][] existingDepth = this.incDepth.get(taxonIndex);
            byte[][] combDepth = new byte[6][genos.length];
            byte[] currDepths = new byte[6];
            for (int site = 0; site < combDepth[0].length; ++site) {
                for (int allele = 0; allele < combDepth.length; ++allele) {
                    byte by = AlleleDepthUtil.addByteDepths(depth[allele][site], existingDepth[allele][site]);
                    combDepth[allele][site] = by;
                    currDepths[allele] = by;
                }
                combGenos[site] = this.mergeRule.callBasedOnDepth(currDepths);
            }
            this.incGeno.set(taxonIndex, combGenos);
            this.incDepth.set(taxonIndex, combDepth);
        } else {
            byte[] existingGenos = this.incGeno.get(taxonIndex);
            for (int site = 0; site < combGenos.length; ++site) {
                combGenos[site] = this.mergeRule.mergeCalls(genos[site], existingGenos[site]);
            }
            this.incGeno.set(taxonIndex, combGenos);
        }
    }

    public boolean isHDF5() {
        return this.isHDF5;
    }

    public GenotypeTableBuilder sortTaxa() {
        if (this.myBuildType != BuildType.TAXA_INC) {
            throw new IllegalArgumentException("sortTaxa can only be used with AlignmentBuilder.getTaxaIncremental");
        }
        this.sortAlphabetically = true;
        return this;
    }

    public GenotypeTable build() {
        if (this.isHDF5) {
            switch (this.myBuildType) {
                case TAXA_INC: {
                    break;
                }
                case SITE_INC: {
                    this.positionList = new PositionListBuilder(this.writer, this.posListBuilder.build()).build();
                }
            }
            String name = this.writer.getFile().getAbsolutePath();
            GenotypeTableBuilder.annotateHDF5File(this.writer);
            HDF5Utils.lockHDF5GenotypeModule(this.writer);
            HDF5Utils.lockHDF5TaxaModule(this.writer);
            this.writer.close();
            return GenotypeTableBuilder.getInstance(name);
        }
        switch (this.myBuildType) {
            case TAXA_INC: {
                TaxaList tl = this.sortAlphabetically ? this.taxaListBuilder.sortTaxaAlphabetically().build() : this.taxaListBuilder.build();
                GenotypeCallTableBuilder gB = GenotypeCallTableBuilder.getInstance(tl.numberOfTaxa(), this.positionList.numberOfSites());
                boolean hasDepth = this.incDepth.size() == tl.numberOfTaxa() && this.incDepth.get(0) != null;
                AlleleDepthBuilder adb = null;
                if (hasDepth) {
                    adb = AlleleDepthBuilder.getNucleotideInstance(tl.numberOfTaxa(), this.positionList.numberOfSites());
                }
                for (int i = 0; i < this.incGeno.size(); ++i) {
                    gB.setBaseRangeForTaxon(i, 0, this.incGeno.get(this.incTaxonIndex.get(tl.get(i))));
                    if (!hasDepth) continue;
                    adb.setDepth(i, this.incDepth.get(this.incTaxonIndex.get(tl.get(i))));
                }
                AlleleDepth ad = hasDepth ? adb.build() : null;
                return new CoreGenotypeTable(gB.build(), this.positionList, tl, null, ad);
            }
            case SITE_INC: {
                GenotypeCallTableBuilder gB = GenotypeCallTableBuilder.getInstance(this.taxaList.numberOfTaxa(), this.posListBuilder.size());
                for (int s = 0; s < this.posListBuilder.size(); ++s) {
                    byte[] b = this.incGeno.get(s);
                    for (int t = 0; t < b.length; ++t) {
                        gB.setBase(t, s, b[t]);
                    }
                }
                PositionList pl = this.posListBuilder.build(gB);
                return new CoreGenotypeTable(gB.build(), pl, this.taxaList);
            }
        }
        return null;
    }

    public void closeUnfinished() {
        if (!this.isHDF5) {
            throw new UnsupportedOperationException("Only a HDF5 GenotypeTableBuilder can be closed");
        }
        this.taxaListBuilder = null;
        this.writer.close();
    }

    private synchronized void setupGenotypeTaxaInHDF5(IHDF5Writer writer) {
        HDF5Utils.createHDF5TaxaModule(writer);
        HDF5Utils.createHDF5GenotypeModule(writer);
        HDF5Utils.writeHDF5GenotypesMaxNumAlleles(writer, 6);
        HDF5Utils.writeHDF5GenotypesRetainRareAlleles(writer, false);
        HDF5Utils.writeHDF5GenotypesNumTaxa(writer, 0);
        HDF5Utils.writeHDF5GenotypesAlleleStates(writer, NucleotideAlignmentConstants.NUCLEOTIDE_ALLELES);
    }

    private synchronized void addTaxon(IHDF5Writer myWriter, Taxon id, byte[] genotype, byte[][] depth) {
        boolean goodAdd = HDF5Utils.addTaxon(myWriter, id);
        if (!goodAdd) {
            throw new IllegalStateException("Taxon [" + id.getName() + "] already exists in the HDF5 file.  Duplicated taxa not allowed.");
        }
        HDF5Utils.writeHDF5GenotypesCalls(myWriter, id.getName(), genotype);
        if (depth != null) {
            if (depth.length != 6) {
                throw new IllegalStateException("Just set A, C, G, T, -, + all at once");
            }
            if (depth[0].length != this.positionList.numberOfSites()) {
                throw new IllegalStateException("Setting all depth in addTaxon.  Wrong number of sites");
            }
            HDF5Utils.writeHDF5GenotypesDepth(myWriter, id.getName(), depth);
        }
    }

    private synchronized void mergeTaxonInHDF5(IHDF5Writer myWriter, Taxon id, byte[] genotype, byte[][] depth) {
        String[] existingFlowCellLanes = HDF5Utils.getTaxon((IHDF5Reader)this.writer, id.getName()).getTextAnnotation("Flowcell_Lane");
        String[] newFlowCellLanes = id.getTextAnnotation("Flowcell_Lane");
        if (newFlowCellLanes.length > 0) {
            for (String existingFL : existingFlowCellLanes) {
                if (!existingFL.equals(newFlowCellLanes[0])) continue;
                throw new IllegalStateException("mergeTaxonInHDF5: Reads from flowcell_lane " + id.getTextAnnotation("Flowcell_Lane")[0] + " previously added to taxon " + id.getName());
            }
            Taxon modifiedTaxon = new Taxon.Builder(HDF5Utils.getTaxon((IHDF5Reader)this.writer, id.getName())).addAnno("Flowcell_Lane", newFlowCellLanes[0]).build();
            HDF5Utils.replaceTaxonAnnotations(myWriter, modifiedTaxon);
        }
        byte[] combGenos = new byte[genotype.length];
        if (depth != null) {
            byte[][] existingDepth = HDF5Utils.getHDF5GenotypesDepth((IHDF5Reader)myWriter, id.getName());
            if (existingDepth == null) {
                throw new IllegalStateException("mergeTaxonInHDF5: Trying to merge genotypes with and without depth.");
            }
            byte[][] combDepth = new byte[6][genotype.length];
            byte[] currDepths = new byte[6];
            for (int site = 0; site < combDepth[0].length; ++site) {
                for (int allele = 0; allele < combDepth.length; ++allele) {
                    byte by = AlleleDepthUtil.addByteDepths(depth[allele][site], existingDepth[allele][site]);
                    combDepth[allele][site] = by;
                    currDepths[allele] = by;
                }
                combGenos[site] = this.mergeRule.callBasedOnDepth(currDepths);
            }
            HDF5Utils.replaceHDF5GenotypesCalls(myWriter, id.getName(), combGenos);
            HDF5Utils.replaceHDF5GenotypesDepth(myWriter, id.getName(), combDepth);
        } else {
            byte[] existingGenos = HDF5Utils.getHDF5GenotypesCalls((IHDF5Reader)myWriter, id.getName());
            for (int site = 0; site < combGenos.length; ++site) {
                combGenos[site] = this.mergeRule.mergeCalls(genotype[site], existingGenos[site]);
            }
            HDF5Utils.replaceHDF5GenotypesCalls(myWriter, id.getName(), combGenos);
        }
    }

    public static void annotateHDF5File(IHDF5Writer writer) {
        if (HDF5Utils.isHDF5GenotypeLocked((IHDF5Reader)writer)) {
            throw new UnsupportedOperationException("This is a locked HDF5 file");
        }
        int hdf5GenoBlock = 65536;
        int sites = writer.getIntAttribute("Positions/", "numSites");
        TaxaList tL = new TaxaListBuilder().buildFromHDF5Genotypes((IHDF5Reader)writer);
        int taxa = tL.numberOfTaxa();
        writer.setIntAttribute("Genotypes/", "numTaxa", taxa);
        int[][] af = new int[6][sites];
        byte[][] afOrder = new byte[6][sites];
        float[] coverage = new float[taxa];
        float[] hets = new float[taxa];
        for (int taxon = 0; taxon < taxa; ++taxon) {
            String basesPath = Tassel5HDF5Constants.getGenotypesCallsPath(tL.taxaName(taxon));
            byte[] genotype = writer.readByteArray(basesPath);
            int covSum = 0;
            int hetSum = 0;
            for (int s = 0; s < sites; ++s) {
                byte[] b = GenotypeTableUtils.getDiploidValues(genotype[s]);
                if (b[0] < 6) {
                    int[] nArray = af[b[0]];
                    int n = s;
                    nArray[n] = nArray[n] + 1;
                }
                if (b[1] < 6) {
                    int[] nArray = af[b[1]];
                    int n = s;
                    nArray[n] = nArray[n] + 1;
                }
                if (GenotypeTableUtils.isHeterozygous(genotype[s])) {
                    ++hetSum;
                }
                if (genotype[s] == -1) continue;
                ++covSum;
            }
            coverage[taxon] = (float)covSum / (float)sites;
            hets[taxon] = (float)hetSum / (float)covSum;
        }
        float[] maf = new float[sites];
        float[] paf = new float[sites];
        int baseMask = 15;
        for (int s = 0; s < sites; ++s) {
            int i;
            int sum = 0;
            int[] cntAndAllele = new int[6];
            for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
                cntAndAllele[i] = af[i][s] << 4 | 5 - i;
                sum += af[i][s];
            }
            Arrays.sort(cntAndAllele);
            for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
                afOrder[5 - i][s] = cntAndAllele[i] > 15 ? (int)(5 - (baseMask & cntAndAllele[i])) : 15;
            }
            if (afOrder[1][s] != 15) {
                maf[s] = (float)af[afOrder[1][s]][s] / (float)sum;
            }
            paf[s] = (float)sum / (float)(2 * taxa);
        }
        writer.createGroup("Genotypes/_Descriptors/");
        int chunk = sites < hdf5GenoBlock ? sites : hdf5GenoBlock;
        writer.createIntMatrix("Genotypes/_Descriptors/AlleleCnt", 6L, (long)sites, 1, chunk, Tassel5HDF5Constants.intDeflation);
        writer.createByteMatrix("Genotypes/_Descriptors/AlleleFreqOrder", 6L, (long)sites, 1, chunk, Tassel5HDF5Constants.intDeflation);
        writer.createFloatArray("Genotypes/_Descriptors/MAF", (long)sites, chunk, Tassel5HDF5Constants.floatDeflation);
        writer.createFloatArray("Genotypes/_Descriptors/SiteCoverage", (long)sites, chunk, Tassel5HDF5Constants.floatDeflation);
        chunk = tL.numberOfTaxa() < hdf5GenoBlock ? tL.numberOfTaxa() : hdf5GenoBlock;
        writer.createFloatArray("Genotypes/_Descriptors/TaxaCoverage", (long)tL.numberOfTaxa(), chunk, Tassel5HDF5Constants.floatDeflation);
        writer.createFloatArray("Genotypes/_Descriptors/TaxaHet", (long)tL.numberOfTaxa(), chunk, Tassel5HDF5Constants.floatDeflation);
        if (af[0].length > 0) {
            HDF5Utils.writeHDF5EntireArray("Genotypes/_Descriptors/AlleleCnt", writer, af[0].length, 65536, af);
        }
        if (afOrder[0].length > 0) {
            HDF5Utils.writeHDF5EntireArray("Genotypes/_Descriptors/AlleleFreqOrder", writer, afOrder[0].length, 65536, afOrder);
        }
        if (maf.length > 0) {
            HDF5Utils.writeHDF5EntireArray("Genotypes/_Descriptors/MAF", writer, maf.length, 65536, maf);
        }
        if (paf.length > 0) {
            HDF5Utils.writeHDF5EntireArray("Genotypes/_Descriptors/SiteCoverage", writer, paf.length, 65536, paf);
        }
        if (coverage.length > 0) {
            HDF5Utils.writeHDF5EntireArray("Genotypes/_Descriptors/TaxaCoverage", writer, coverage.length, 65536, coverage);
        }
        if (hets.length > 0) {
            System.out.println("Number of taxa in HDF5 file:" + hets.length);
            HDF5Utils.writeHDF5EntireArray("Genotypes/_Descriptors/TaxaHet", writer, hets.length, 65536, hets);
        }
    }

    public static void annotateHDF5FileWithRefAllele(IHDF5Writer writer, byte[] refAlleles) {
    }

    private static enum BuildType {
        TAXA_INC,
        SITE_INC;

    }
}

