/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class GenotypeTableUtils {
    private static final Integer ONE = 1;
    private static final byte HIGHMASK = 15;

    private GenotypeTableUtils() {
    }

    public static int[][] getAllelesSortedByFrequency(byte[] data) {
        int[] stateCnt = new int[16];
        for (int i = 0; i < data.length; ++i) {
            byte first = (byte)(data[i] >>> 4 & 0xF);
            byte second = (byte)(data[i] & 0xF);
            if (first < 14) {
                byte by = first;
                stateCnt[by] = stateCnt[by] + 1;
            }
            if (second >= 14) continue;
            byte by = second;
            stateCnt[by] = stateCnt[by] + 1;
        }
        int count = 0;
        for (int j = 0; j < 16; ++j) {
            if (stateCnt[j] == 0) continue;
            ++count;
        }
        int[][] result = new int[2][count];
        int index = 0;
        for (int k = 0; k < 16; ++k) {
            if (stateCnt[k] == 0) continue;
            result[0][index] = k;
            result[1][index] = stateCnt[k];
            ++index;
        }
        boolean change = true;
        while (change) {
            change = false;
            for (int k = 0; k < count - 1; ++k) {
                if (result[1][k] >= result[1][k + 1]) continue;
                int temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                int tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    public static int[][] getAllelesSortedByFrequency(byte[][] data, int site) {
        int[] stateCnt = new int[16];
        for (int i = 0; i < data.length; ++i) {
            byte first = (byte)(data[i][site] >>> 4 & 0xF);
            byte second = (byte)(data[i][site] & 0xF);
            if (first < 14) {
                byte by = first;
                stateCnt[by] = stateCnt[by] + 1;
            }
            if (second >= 14) continue;
            byte by = second;
            stateCnt[by] = stateCnt[by] + 1;
        }
        int count = 0;
        for (int j = 0; j < 16; ++j) {
            if (stateCnt[j] == 0) continue;
            ++count;
        }
        int[][] result = new int[2][count];
        int index = 0;
        for (int k = 0; k < 16; ++k) {
            if (stateCnt[k] == 0) continue;
            result[0][index] = k;
            result[1][index] = stateCnt[k];
            ++index;
        }
        boolean change = true;
        while (change) {
            change = false;
            for (int k = 0; k < count - 1; ++k) {
                if (result[1][k] >= result[1][k + 1]) continue;
                int temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                int tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    public static byte[] getAlleles(byte[][] data, int site) {
        int[][] alleles = GenotypeTableUtils.getAllelesSortedByFrequency(data, site);
        int resultSize = alleles[0].length;
        byte[] result = new byte[resultSize];
        for (int i = 0; i < resultSize; ++i) {
            result[i] = (byte)alleles[0][i];
        }
        return result;
    }

    public static Object[][] getAllelesSortedByFrequency(String[][] data, int site) {
        HashMap<String, Integer> stateCnt = new HashMap<String, Integer>();
        for (int i = 0; i < data.length; ++i) {
            Integer count;
            String first;
            String second;
            String[] temp = data[i][site].split(":");
            if (temp == null || temp.length == 0) {
                second = "N";
                first = "N";
            } else if (temp.length == 1) {
                first = second = temp[0].trim();
            } else {
                first = temp[0].trim();
                second = temp[1].trim();
            }
            if (!first.equalsIgnoreCase("N")) {
                count = (Integer)stateCnt.get(first);
                if (count == null) {
                    stateCnt.put(first, ONE);
                } else {
                    stateCnt.put(first, count + 1);
                }
            }
            if (second.equalsIgnoreCase("N")) continue;
            count = (Integer)stateCnt.get(second);
            if (count == null) {
                stateCnt.put(second, ONE);
                continue;
            }
            stateCnt.put(second, count + 1);
        }
        int count = stateCnt.size();
        Object[][] result = new Object[2][count];
        Iterator itr = stateCnt.keySet().iterator();
        int index = 0;
        while (itr.hasNext()) {
            String key = (String)itr.next();
            result[0][index] = key;
            result[1][index] = (Integer)stateCnt.get(key);
            ++index;
        }
        boolean change = true;
        while (change) {
            change = false;
            for (int k = 0; k < count - 1; ++k) {
                if ((Integer)result[1][k] >= (Integer)result[1][k + 1]) continue;
                Object temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                Object tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    public static List<String> convertNucleotideGenotypesToStringList(byte[] data) {
        ArrayList<String> result = new ArrayList<String>();
        for (byte b : data) {
            result.add(NucleotideAlignmentConstants.getHaplotypeNucleotide(b));
        }
        return result;
    }

    public static List<String> getAlleles(String[][] data, int site) {
        Object[][] alleles = GenotypeTableUtils.getAllelesSortedByFrequency(data, site);
        if (alleles == null || alleles.length == 0) {
            return null;
        }
        int resultSize = alleles[0].length;
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < resultSize; ++i) {
            result.add((String)alleles[0][i]);
        }
        return result;
    }

    public static int[][] getAllelesSortedByFrequency(GenotypeTable alignment, int site) {
        int[] stateCnt = new int[16];
        for (int i = 0; i < alignment.numberOfTaxa(); ++i) {
            byte[] dipB = alignment.genotypeArray(i, site);
            if (dipB[0] != 15) {
                byte by = dipB[0];
                stateCnt[by] = stateCnt[by] + 1;
            }
            if (dipB[1] == 15) continue;
            byte by = dipB[1];
            stateCnt[by] = stateCnt[by] + 1;
        }
        int count = 0;
        for (int j = 0; j < 16; ++j) {
            if (stateCnt[j] == 0) continue;
            ++count;
        }
        int[][] result = new int[2][count];
        int index = 0;
        for (int k = 0; k < 16; ++k) {
            if (stateCnt[k] == 0) continue;
            result[0][index] = k;
            result[1][index] = stateCnt[k];
            ++index;
        }
        boolean change = true;
        while (change) {
            change = false;
            for (int k = 0; k < count - 1; ++k) {
                if (result[1][k] >= result[1][k + 1]) continue;
                int temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                int tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    public static Object[][] getDiploidsSortedByFrequency(GenotypeTable alignment, int site) {
        Integer ONE_INTEGER = 1;
        int numTaxa = alignment.numberOfTaxa();
        HashMap<String, Integer> diploidValueCounts = new HashMap<String, Integer>();
        for (int r = 0; r < numTaxa; ++r) {
            String current = alignment.genotypeAsString(r, site);
            Integer num = (Integer)diploidValueCounts.get(current);
            if (num == null) {
                diploidValueCounts.put(current, ONE_INTEGER);
                continue;
            }
            num = num + 1;
            diploidValueCounts.put(current, num);
        }
        Object[][] result = new Object[2][diploidValueCounts.size()];
        int i = 0;
        for (String key : diploidValueCounts.keySet()) {
            Integer count = (Integer)diploidValueCounts.get(key);
            result[0][i] = key;
            result[1][i++] = count;
        }
        boolean change = true;
        while (change) {
            change = false;
            int n = diploidValueCounts.size() - 1;
            for (int k = 0; k < n; ++k) {
                if ((Integer)result[1][k] >= (Integer)result[1][k + 1]) continue;
                Object temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                Object tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    public static String[][] getAlleleStates(String[][] data, int maxNumAlleles) {
        int numSites = data[0].length;
        String[][] alleleStates = new String[numSites][16];
        for (int i = 0; i < numSites; ++i) {
            for (int j = 0; j < 16; ++j) {
                alleleStates[i][j] = j == 14 ? "Z" : "N";
            }
        }
        for (int site = 0; site < numSites; ++site) {
            List<String> alleles = GenotypeTableUtils.getAlleles(data, site);
            if (alleles == null) continue;
            int numAlleles = Math.min(alleles.size(), maxNumAlleles);
            for (int k = 0; k < numAlleles; ++k) {
                alleleStates[site][k] = alleles.get(k);
            }
        }
        return alleleStates;
    }

    public static byte[][] getDataBytes(String[] data) {
        int numTaxa = data.length;
        int numSites = data[0].length();
        byte[][] dataBytes = new byte[numTaxa][numSites];
        for (int site = 0; site < numSites; ++site) {
            for (int taxon = 0; taxon < numTaxa; ++taxon) {
                dataBytes[taxon][site] = NucleotideAlignmentConstants.getNucleotideDiploidByte(data[taxon].charAt(site));
            }
        }
        return dataBytes;
    }

    public static byte[][] getDataBytes(String[][] data, String[][] alleleStates, int maxNumAlleles) {
        int numTaxa = data.length;
        int numSites = data[0].length;
        byte[][] dataBytes = new byte[numTaxa][numSites];
        if (alleleStates.length == 1) {
            for (int site = 0; site < numSites; ++site) {
                GenotypeTableUtils.setDataBytes(data, alleleStates[0], maxNumAlleles, numTaxa, site, dataBytes);
            }
        } else {
            for (int site = 0; site < numSites; ++site) {
                GenotypeTableUtils.setDataBytes(data, alleleStates[site], maxNumAlleles, numTaxa, site, dataBytes);
            }
        }
        return dataBytes;
    }

    private static void setDataBytes(String[][] data, String[] alleleStates, int maxNumAlleles, int numTaxa, int site, byte[][] dataBytes) {
        if (data[0][0].contains(":")) {
            Pattern colon = Pattern.compile(":");
            for (int taxon = 0; taxon < numTaxa; ++taxon) {
                if (data[taxon][site].equalsIgnoreCase("N:N")) {
                    dataBytes[taxon][site] = -1;
                    continue;
                }
                if (data[taxon][site].equals("?") || data[taxon][site].equals("?:?")) {
                    dataBytes[taxon][site] = -1;
                    continue;
                }
                String[] siteval = colon.split(data[taxon][site]);
                int[] byteval = new int[]{14, 14};
                for (int k = 0; k < maxNumAlleles; ++k) {
                    if (alleleStates[k].equals(siteval[0])) {
                        byteval[0] = k;
                    }
                    if (!alleleStates[k].equals(siteval[1])) continue;
                    byteval[1] = k;
                }
                dataBytes[taxon][site] = (byte)(byteval[0] << 4 | byteval[1]);
            }
        } else {
            block2: for (int taxon = 0; taxon < numTaxa; ++taxon) {
                if (data[taxon][site].equalsIgnoreCase("N")) {
                    dataBytes[taxon][site] = -1;
                    continue;
                }
                if (data[taxon][site].equals("?")) {
                    dataBytes[taxon][site] = -1;
                    continue;
                }
                dataBytes[taxon][site] = -18;
                for (int k = 0; k < maxNumAlleles; k = (int)((byte)(k + 1))) {
                    if (!alleleStates[k].equals(data[taxon][site])) continue;
                    dataBytes[taxon][site] = (byte)(k | k << 4);
                    continue block2;
                }
            }
        }
    }

    public static GenotypeTable removeSitesBasedOnFreqIgnoreMissing(GenotypeTable aa, double minimumProportion, double maximumProportion, int minimumCount) {
        int[] includeSites = GenotypeTableUtils.getIncludedSitesBasedOnFreqIgnoreMissing(aa, minimumProportion, maximumProportion, minimumCount);
        FilterGenotypeTable mlaa = FilterGenotypeTable.getInstance(aa, includeSites);
        return mlaa;
    }

    public static int[] getIncludedSitesBasedOnFreqIgnoreMissing(GenotypeTable aa, double minimumProportion, double maximumProportion, int minimumCount) {
        ArrayList<Integer> includeAL = new ArrayList<Integer>();
        int n = aa.numberOfSites();
        for (int i = 0; i < n; ++i) {
            int totalNonMissing = aa.totalGametesNonMissingForSite(i);
            if (totalNonMissing <= 0 || totalNonMissing < minimumCount * 2) continue;
            double minorCount = aa.minorAlleleCount(i);
            double obsMinProp = 0.0;
            if (minorCount != 0.0) {
                obsMinProp = minorCount / (double)totalNonMissing;
            }
            if (!(obsMinProp >= minimumProportion) || !(obsMinProp <= maximumProportion)) continue;
            includeAL.add(i);
        }
        int[] includeSites = new int[includeAL.size()];
        for (int i = 0; i < includeAL.size(); ++i) {
            includeSites[i] = (Integer)includeAL.get(i);
        }
        return includeSites;
    }

    public static GenotypeTable removeSitesOutsideRange(GenotypeTable aa, int firstSite, int lastSite) {
        if (firstSite < 0 || firstSite > lastSite) {
            return null;
        }
        if (lastSite > aa.numberOfSites() - 1) {
            return null;
        }
        return FilterGenotypeTable.getInstance(aa, firstSite, lastSite);
    }

    public static boolean isHeterozygous(byte diploidAllele) {
        return (diploidAllele >>> 4 & 0xF) != (diploidAllele & 0xF);
    }

    public static boolean isEqual(byte[] alleles1, byte[] alleles2) {
        return alleles1[0] == alleles2[0] && alleles1[1] == alleles2[1] || alleles1[0] == alleles2[1] && alleles1[1] == alleles2[0];
    }

    public static boolean isEqual(byte diploidAllele1, byte diploidAllele2) {
        byte reversed;
        return diploidAllele1 == diploidAllele2 || (reversed = (byte)(diploidAllele1 << 4 | diploidAllele1 >>> 4)) == diploidAllele2;
    }

    public static boolean isEqualOrUnknown(byte[] alleles1, byte[] alleles2) {
        if (alleles1[0] == 15 && alleles1[1] == 15 || alleles2[0] == 15 && alleles2[1] == 15) {
            return true;
        }
        return alleles1[0] == alleles2[0] && alleles1[1] == alleles2[1] || alleles1[0] == alleles2[1] && alleles1[1] == alleles2[0];
    }

    public static boolean isEqualOrUnknown(byte diploidAllele1, byte diploidAllele2) {
        byte reversed;
        if (diploidAllele1 == -1 || diploidAllele2 == -1) {
            return true;
        }
        return diploidAllele1 == diploidAllele2 || (reversed = (byte)(diploidAllele1 << 4 | diploidAllele1 >>> 4)) == diploidAllele2;
    }

    public static boolean isPartiallyEqual(byte genotype1, byte genotype2) {
        int low1 = 0xF & genotype1;
        int low2 = 0xF & genotype2;
        if (low1 == low2) {
            return true;
        }
        int high1 = genotype1 >>> 4;
        if (high1 == low2) {
            return true;
        }
        int high2 = genotype2 >>> 4;
        if (low1 == high2) {
            return true;
        }
        return high1 == high2;
    }

    public static boolean areEncodingsEqual(String[][][] encodings) {
        int numEncodings = encodings.length;
        for (int i = 1; i < numEncodings; ++i) {
            int numSites = encodings[0].length;
            if (numSites != encodings[i].length) {
                return false;
            }
            for (int s = 0; s < numSites; ++s) {
                int numCodes = encodings[0][s].length;
                if (numCodes != encodings[i][s].length) {
                    return false;
                }
                for (int c = 0; c < numCodes; ++c) {
                    if (encodings[0][s][c].equals(encodings[i][s][c])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static byte getDiploidValuePhased(byte a, byte b) {
        return (byte)(a << 4 | 0xF & b);
    }

    public static byte getDiploidValue(byte a, byte b) {
        return GenotypeTableUtils.getDiploidValuePhased(a, b);
    }

    public static byte getUnphasedDiploidValue(byte a, byte b) {
        if ((a = (byte)(0xF & a)) < (b = (byte)(0xF & b))) {
            return (byte)(a << 4 | b);
        }
        return (byte)(b << 4 | a);
    }

    public static byte getUnphasedDiploidValueNoHets(byte g1, byte g2) {
        if (g2 == g1 && !GenotypeTableUtils.isHeterozygous(g1)) {
            return g1;
        }
        if (g1 == -1) {
            return -1;
        }
        if (g2 == -1) {
            return -1;
        }
        if (GenotypeTableUtils.isHeterozygous(g1)) {
            return -1;
        }
        if (GenotypeTableUtils.isHeterozygous(g2)) {
            return -1;
        }
        return GenotypeTableUtils.getUnphasedDiploidValue(g1, g2);
    }

    public static byte[] getDiploidValues(byte genotype) {
        byte[] result = new byte[]{(byte)(genotype >>> 4 & 0xF), (byte)(genotype & 0xF)};
        return result;
    }

    public static BitSet[] calcBitPresenceFromGenotype(byte[] genotype, byte[] mjA, byte[] mnA) {
        int sites = genotype.length;
        if (genotype.length != mjA.length || genotype.length != mnA.length) {
            throw new ArrayIndexOutOfBoundsException("Input genotypes unequal in length");
        }
        OpenBitSet rMj = new OpenBitSet(genotype.length);
        OpenBitSet rMn = new OpenBitSet(genotype.length);
        for (int i = 0; i < sites; ++i) {
            byte g = genotype[i];
            byte mj = mjA[i];
            byte mn = mnA[i];
            if (mj == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mj, mj)) {
                rMj.fastSet(i);
                continue;
            }
            if (mn == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mn, mn)) {
                rMn.fastSet(i);
                continue;
            }
            byte het = GenotypeTableUtils.getUnphasedDiploidValue(mj, mn);
            if (!GenotypeTableUtils.isEqual(g, het)) continue;
            rMj.fastSet(i);
            rMn.fastSet(i);
        }
        return new BitSet[]{rMj, rMn};
    }

    public static BitSet calcBitPresenceFromGenotype(byte[] genotype, byte[] referenceValues) {
        int sites = genotype.length;
        if (genotype.length != referenceValues.length) {
            throw new ArrayIndexOutOfBoundsException("GenotypeTableUtils: calcBitPresenceFromGenotype: Input genotypes unequal in length");
        }
        OpenBitSet result = new OpenBitSet(genotype.length);
        for (int i = 0; i < sites; ++i) {
            if (referenceValues[i] == 15) continue;
            if (referenceValues[i] == (byte)(genotype[i] & 0xF)) {
                result.fastSet(i);
                continue;
            }
            if (referenceValues[i] != (byte)(genotype[i] >>> 4 & 0xF)) continue;
            result.fastSet(i);
        }
        return result;
    }

    public static BitSet[] calcBitPresenceFromGenotype15(byte[] genotype, byte[] mjA, byte[] mnA) {
        int sites = genotype.length;
        if (genotype.length != mjA.length || genotype.length != mnA.length) {
            throw new ArrayIndexOutOfBoundsException("Input genotypes unequal in length");
        }
        ByteBuffer gBB = ByteBuffer.wrap(genotype);
        ByteBuffer mjBB = ByteBuffer.wrap(mjA);
        ByteBuffer mnBB = ByteBuffer.wrap(mnA);
        OpenBitSet rMj = new OpenBitSet(genotype.length);
        OpenBitSet rMn = new OpenBitSet(genotype.length);
        for (int i = 0; i < sites; ++i) {
            byte g = gBB.get();
            byte mj = mjBB.get();
            byte mn = mnBB.get();
            if (mj == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mj, mj)) {
                rMj.fastSet(i);
                continue;
            }
            if (mn == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mn, mn)) {
                rMn.fastSet(i);
                continue;
            }
            byte het = GenotypeTableUtils.getUnphasedDiploidValue(mj, mn);
            if (!GenotypeTableUtils.isEqual(g, het)) continue;
            rMj.fastSet(i);
            rMn.fastSet(i);
        }
        return new BitSet[]{rMj, rMn};
    }

    public static BitSet[] calcBitPresenceFromGenotype(byte[] genotype, byte mj, byte mn) {
        int sites = genotype.length;
        OpenBitSet rMj = new OpenBitSet(genotype.length);
        OpenBitSet rMn = new OpenBitSet(genotype.length);
        for (int i = 0; i < sites; ++i) {
            byte g = genotype[i];
            if (mj == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mj, mj)) {
                rMj.fastSet(i);
                continue;
            }
            if (mn == 15) continue;
            if (g == GenotypeTableUtils.getDiploidValuePhased(mn, mn)) {
                rMn.fastSet(i);
                continue;
            }
            byte het = GenotypeTableUtils.getUnphasedDiploidValue(mj, mn);
            if (!GenotypeTableUtils.isEqual(g, het)) continue;
            rMj.fastSet(i);
            rMn.fastSet(i);
        }
        return new BitSet[]{rMj, rMn};
    }

    public static BitSet calcBitPresenceFromGenotype(byte[] genotype, byte referenceValue) {
        int sites = genotype.length;
        OpenBitSet result = new OpenBitSet(genotype.length);
        if (referenceValue == 15) {
            return result;
        }
        for (int i = 0; i < sites; ++i) {
            if (referenceValue == (byte)(genotype[i] & 0xF)) {
                result.fastSet(i);
                continue;
            }
            if (referenceValue != (byte)(genotype[i] >>> 4 & 0xF)) continue;
            result.fastSet(i);
        }
        return result;
    }
}

