/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class NucleotideAlignmentConstants {
    public static final byte A_ALLELE = 0;
    public static final byte C_ALLELE = 1;
    public static final byte G_ALLELE = 2;
    public static final byte T_ALLELE = 3;
    public static final byte INSERT_ALLELE = 4;
    public static final byte GAP_ALLELE = 5;
    public static final byte UNDEFINED_ALLELE = 6;
    public static final byte GAP_DIPLOID_ALLELE = 85;
    public static final byte UNDEFINED_DIPLOID_ALLELE = 102;
    public static final String INSERT_ALLELE_STR = "+";
    public static final String GAP_ALLELE_STR = "-";
    public static final String UNDEFINED_ALLELE_STR = "X";
    public static final String[][] NUCLEOTIDE_ALLELES = new String[][]{{"A", "C", "G", "T", "+", "-", "X", "X", "X", "X", "X", "X", "X", "X", "Z", "N"}};
    public static final int NUMBER_NUCLEOTIDE_ALLELES = 6;
    private static final Map<String, Byte> NUCLEOTIDE_DIPLOID_HASH = new HashMap<String, Byte>();
    private static final byte[] NUCLEOTIDE_DIPLOID_ARRAY;
    private static final int mask = 47;
    private static final int mask2 = 129;
    private static final int shift = 2;
    public static final Map<Byte, String> NUCLEOTIDE_IUPAC_HASH;
    private static final String[] NUCLEOTIDE_IUPAC_ARRAY;
    private static final char[] NUCLEOTIDE_IUPAC_CHARARRAY;
    private static final char[] NUCLEOTIDE_IUPAC_CHARCOMPLEMENT_ARRAY;
    private static final Map<String, Byte> NUCLEOTIDE_ALLELE_HASH;
    private static final byte[] NUCLEOTIDE_ALLELE_ARRAY;

    private static int getNucleotideDiploidArrayIndex(String str) {
        if (str.length() == 1) {
            return str.charAt(0);
        }
        if (str.length() == 2) {
            return (str.charAt(1) << 2 ^ 0xFFFFFF81 ^ str.charAt(0) & 0x2F) & 0xFF;
        }
        throw new IllegalStateException("NucleotideAlignmentConstants: getIndex: str length: " + str.length());
    }

    private NucleotideAlignmentConstants() {
    }

    public static byte getNucleotideDiploidByte(String value) {
        try {
            return NUCLEOTIDE_DIPLOID_ARRAY[NucleotideAlignmentConstants.getNucleotideDiploidArrayIndex(value)];
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("NucleotideAlignmentConstants: getNucleotideDiploidByte: unknown allele value: " + value);
        }
    }

    public static byte getNucleotideAlleleByte(String value) {
        try {
            return NUCLEOTIDE_ALLELE_HASH.get(value);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("NucleotideAlignmentConstants: getNucleotideAlleleByte: unknown allele value: " + value);
        }
    }

    public static byte getNucleotideAlleleByte(char value) {
        try {
            return NUCLEOTIDE_ALLELE_ARRAY[value];
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("NucleotideAlignmentConstants: getNucleotideAlleleByte: unknown allele value: " + value);
        }
    }

    public static byte getNucleotideDiploidByte(char value) {
        try {
            return NUCLEOTIDE_DIPLOID_ARRAY[value];
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("NucleotideAlignmentConstants: getNucleotideDiploidByte: unknown allele value: " + value);
        }
    }

    public static String getNucleotideIUPAC(byte value) {
        return NUCLEOTIDE_IUPAC_ARRAY[value & 0xFF];
    }

    public static char getNucleotideIUPACChar(byte value) {
        return NUCLEOTIDE_IUPAC_CHARARRAY[value & 0xFF];
    }

    public static String getHaplotypeNucleotide(byte value) {
        return NUCLEOTIDE_ALLELES[0][value];
    }

    public static byte getNucleotideComplement(byte nucleotide) {
        if (nucleotide == 0) {
            return 3;
        }
        if (nucleotide == 3) {
            return 0;
        }
        if (nucleotide == 1) {
            return 2;
        }
        if (nucleotide == 2) {
            return 1;
        }
        return nucleotide;
    }

    public static byte getNucleotideDiploidComplement(byte diploidAllele) {
        byte first = (byte)(diploidAllele >>> 4 & 0xF);
        byte second = (byte)(diploidAllele & 0xF);
        first = NucleotideAlignmentConstants.getNucleotideComplement(first);
        second = NucleotideAlignmentConstants.getNucleotideComplement(second);
        return (byte)(first << 4 | second);
    }

    public static char getNucleotideDiploidIUPACComplement(char diploidAllele) {
        if (diploidAllele > '\u0100') {
            return UNDEFINED_ALLELE_STR.charAt(0);
        }
        return NUCLEOTIDE_IUPAC_CHARCOMPLEMENT_ARRAY[diploidAllele];
    }

    public static boolean isNucleotideEncodings(String[][] alleleStates) {
        boolean isNucleotide = false;
        if (alleleStates.length == 1) {
            isNucleotide = true;
            if (alleleStates[0].length == NUCLEOTIDE_ALLELES[0].length) {
                for (int i = 0; i < alleleStates.length; ++i) {
                    if (alleleStates[0][i].equals(NUCLEOTIDE_ALLELES[0][i])) continue;
                    isNucleotide = false;
                }
            }
        }
        return isNucleotide;
    }

    static {
        NUCLEOTIDE_DIPLOID_HASH.put("AA", (byte)0);
        NUCLEOTIDE_DIPLOID_HASH.put("AC", (byte)1);
        NUCLEOTIDE_DIPLOID_HASH.put("AG", (byte)2);
        NUCLEOTIDE_DIPLOID_HASH.put("AT", (byte)3);
        NUCLEOTIDE_DIPLOID_HASH.put("A+", (byte)4);
        NUCLEOTIDE_DIPLOID_HASH.put("A-", (byte)5);
        NUCLEOTIDE_DIPLOID_HASH.put("AN", (byte)15);
        NUCLEOTIDE_DIPLOID_HASH.put("AX", (byte)15);
        NUCLEOTIDE_DIPLOID_HASH.put("AZ", (byte)14);
        NUCLEOTIDE_DIPLOID_HASH.put("CA", (byte)16);
        NUCLEOTIDE_DIPLOID_HASH.put("CC", (byte)17);
        NUCLEOTIDE_DIPLOID_HASH.put("CG", (byte)18);
        NUCLEOTIDE_DIPLOID_HASH.put("CT", (byte)19);
        NUCLEOTIDE_DIPLOID_HASH.put("C+", (byte)20);
        NUCLEOTIDE_DIPLOID_HASH.put("C-", (byte)21);
        NUCLEOTIDE_DIPLOID_HASH.put("CN", (byte)31);
        NUCLEOTIDE_DIPLOID_HASH.put("CX", (byte)31);
        NUCLEOTIDE_DIPLOID_HASH.put("CZ", (byte)30);
        NUCLEOTIDE_DIPLOID_HASH.put("GA", (byte)32);
        NUCLEOTIDE_DIPLOID_HASH.put("GC", (byte)33);
        NUCLEOTIDE_DIPLOID_HASH.put("GG", (byte)34);
        NUCLEOTIDE_DIPLOID_HASH.put("GT", (byte)35);
        NUCLEOTIDE_DIPLOID_HASH.put("G+", (byte)36);
        NUCLEOTIDE_DIPLOID_HASH.put("G-", (byte)37);
        NUCLEOTIDE_DIPLOID_HASH.put("GN", (byte)47);
        NUCLEOTIDE_DIPLOID_HASH.put("GX", (byte)47);
        NUCLEOTIDE_DIPLOID_HASH.put("GZ", (byte)46);
        NUCLEOTIDE_DIPLOID_HASH.put("TA", (byte)48);
        NUCLEOTIDE_DIPLOID_HASH.put("TC", (byte)49);
        NUCLEOTIDE_DIPLOID_HASH.put("TG", (byte)50);
        NUCLEOTIDE_DIPLOID_HASH.put("TT", (byte)51);
        NUCLEOTIDE_DIPLOID_HASH.put("T+", (byte)52);
        NUCLEOTIDE_DIPLOID_HASH.put("T-", (byte)53);
        NUCLEOTIDE_DIPLOID_HASH.put("TN", (byte)63);
        NUCLEOTIDE_DIPLOID_HASH.put("TX", (byte)63);
        NUCLEOTIDE_DIPLOID_HASH.put("TZ", (byte)62);
        NUCLEOTIDE_DIPLOID_HASH.put("+A", (byte)64);
        NUCLEOTIDE_DIPLOID_HASH.put("+C", (byte)65);
        NUCLEOTIDE_DIPLOID_HASH.put("+G", (byte)66);
        NUCLEOTIDE_DIPLOID_HASH.put("+T", (byte)67);
        NUCLEOTIDE_DIPLOID_HASH.put("++", (byte)68);
        NUCLEOTIDE_DIPLOID_HASH.put("+-", (byte)69);
        NUCLEOTIDE_DIPLOID_HASH.put("+N", (byte)79);
        NUCLEOTIDE_DIPLOID_HASH.put("+X", (byte)79);
        NUCLEOTIDE_DIPLOID_HASH.put("+Z", (byte)78);
        NUCLEOTIDE_DIPLOID_HASH.put("-A", (byte)80);
        NUCLEOTIDE_DIPLOID_HASH.put("-C", (byte)81);
        NUCLEOTIDE_DIPLOID_HASH.put("-G", (byte)82);
        NUCLEOTIDE_DIPLOID_HASH.put("-T", (byte)83);
        NUCLEOTIDE_DIPLOID_HASH.put("-+", (byte)84);
        NUCLEOTIDE_DIPLOID_HASH.put("--", (byte)85);
        NUCLEOTIDE_DIPLOID_HASH.put("-N", (byte)95);
        NUCLEOTIDE_DIPLOID_HASH.put("-X", (byte)95);
        NUCLEOTIDE_DIPLOID_HASH.put("-Z", (byte)94);
        NUCLEOTIDE_DIPLOID_HASH.put("NA", (byte)-16);
        NUCLEOTIDE_DIPLOID_HASH.put("NC", (byte)-15);
        NUCLEOTIDE_DIPLOID_HASH.put("NG", (byte)-14);
        NUCLEOTIDE_DIPLOID_HASH.put("NT", (byte)-13);
        NUCLEOTIDE_DIPLOID_HASH.put("N+", (byte)-12);
        NUCLEOTIDE_DIPLOID_HASH.put("N-", (byte)-11);
        NUCLEOTIDE_DIPLOID_HASH.put("NN", (byte)-1);
        NUCLEOTIDE_DIPLOID_HASH.put("NX", (byte)-1);
        NUCLEOTIDE_DIPLOID_HASH.put("NZ", (byte)-2);
        NUCLEOTIDE_DIPLOID_HASH.put("XA", (byte)-16);
        NUCLEOTIDE_DIPLOID_HASH.put("XC", (byte)-15);
        NUCLEOTIDE_DIPLOID_HASH.put("XG", (byte)-14);
        NUCLEOTIDE_DIPLOID_HASH.put("XT", (byte)-13);
        NUCLEOTIDE_DIPLOID_HASH.put("X+", (byte)-12);
        NUCLEOTIDE_DIPLOID_HASH.put("X-", (byte)-11);
        NUCLEOTIDE_DIPLOID_HASH.put("XN", (byte)-1);
        NUCLEOTIDE_DIPLOID_HASH.put("XX", (byte)-1);
        NUCLEOTIDE_DIPLOID_HASH.put("XZ", (byte)-2);
        NUCLEOTIDE_DIPLOID_HASH.put("ZA", (byte)-32);
        NUCLEOTIDE_DIPLOID_HASH.put("ZC", (byte)-31);
        NUCLEOTIDE_DIPLOID_HASH.put("ZG", (byte)-30);
        NUCLEOTIDE_DIPLOID_HASH.put("ZT", (byte)-29);
        NUCLEOTIDE_DIPLOID_HASH.put("Z+", (byte)-28);
        NUCLEOTIDE_DIPLOID_HASH.put("Z-", (byte)-27);
        NUCLEOTIDE_DIPLOID_HASH.put("ZN", (byte)-17);
        NUCLEOTIDE_DIPLOID_HASH.put("ZX", (byte)-17);
        NUCLEOTIDE_DIPLOID_HASH.put("ZZ", (byte)-18);
        NUCLEOTIDE_DIPLOID_HASH.put("A", (byte)0);
        NUCLEOTIDE_DIPLOID_HASH.put("C", (byte)17);
        NUCLEOTIDE_DIPLOID_HASH.put("G", (byte)34);
        NUCLEOTIDE_DIPLOID_HASH.put("T", (byte)51);
        NUCLEOTIDE_DIPLOID_HASH.put(INSERT_ALLELE_STR, (byte)68);
        NUCLEOTIDE_DIPLOID_HASH.put(GAP_ALLELE_STR, (byte)85);
        NUCLEOTIDE_DIPLOID_HASH.put("Z", (byte)-18);
        NUCLEOTIDE_DIPLOID_HASH.put("N", (byte)-1);
        NUCLEOTIDE_DIPLOID_HASH.put(UNDEFINED_ALLELE_STR, (byte)-1);
        NUCLEOTIDE_DIPLOID_HASH.put("R", (byte)2);
        NUCLEOTIDE_DIPLOID_HASH.put("Y", (byte)19);
        NUCLEOTIDE_DIPLOID_HASH.put("S", (byte)33);
        NUCLEOTIDE_DIPLOID_HASH.put("W", (byte)3);
        NUCLEOTIDE_DIPLOID_HASH.put("K", (byte)35);
        NUCLEOTIDE_DIPLOID_HASH.put("M", (byte)1);
        NUCLEOTIDE_DIPLOID_HASH.put("0", (byte)84);
        NUCLEOTIDE_DIPLOID_ARRAY = new byte[256];
        Arrays.fill(NUCLEOTIDE_DIPLOID_ARRAY, (byte)102);
        for (String string : NUCLEOTIDE_DIPLOID_HASH.keySet()) {
            NucleotideAlignmentConstants.NUCLEOTIDE_DIPLOID_ARRAY[NucleotideAlignmentConstants.getNucleotideDiploidArrayIndex((String)string)] = NUCLEOTIDE_DIPLOID_HASH.get(string);
        }
        NUCLEOTIDE_IUPAC_HASH = new HashMap<Byte, String>();
        NUCLEOTIDE_IUPAC_HASH.put((byte)0, "A");
        NUCLEOTIDE_IUPAC_HASH.put((byte)1, "M");
        NUCLEOTIDE_IUPAC_HASH.put((byte)2, "R");
        NUCLEOTIDE_IUPAC_HASH.put((byte)3, "W");
        NUCLEOTIDE_IUPAC_HASH.put((byte)4, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)5, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)14, "A");
        NUCLEOTIDE_IUPAC_HASH.put((byte)15, "A");
        NUCLEOTIDE_IUPAC_HASH.put((byte)16, "M");
        NUCLEOTIDE_IUPAC_HASH.put((byte)17, "C");
        NUCLEOTIDE_IUPAC_HASH.put((byte)18, "S");
        NUCLEOTIDE_IUPAC_HASH.put((byte)19, "Y");
        NUCLEOTIDE_IUPAC_HASH.put((byte)20, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)21, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)30, "C");
        NUCLEOTIDE_IUPAC_HASH.put((byte)31, "C");
        NUCLEOTIDE_IUPAC_HASH.put((byte)32, "R");
        NUCLEOTIDE_IUPAC_HASH.put((byte)33, "S");
        NUCLEOTIDE_IUPAC_HASH.put((byte)34, "G");
        NUCLEOTIDE_IUPAC_HASH.put((byte)35, "K");
        NUCLEOTIDE_IUPAC_HASH.put((byte)36, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)37, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)46, "G");
        NUCLEOTIDE_IUPAC_HASH.put((byte)47, "G");
        NUCLEOTIDE_IUPAC_HASH.put((byte)48, "W");
        NUCLEOTIDE_IUPAC_HASH.put((byte)49, "Y");
        NUCLEOTIDE_IUPAC_HASH.put((byte)50, "K");
        NUCLEOTIDE_IUPAC_HASH.put((byte)51, "T");
        NUCLEOTIDE_IUPAC_HASH.put((byte)52, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)53, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)62, "T");
        NUCLEOTIDE_IUPAC_HASH.put((byte)63, "T");
        NUCLEOTIDE_IUPAC_HASH.put((byte)64, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)65, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)66, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)67, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)68, INSERT_ALLELE_STR);
        NUCLEOTIDE_IUPAC_HASH.put((byte)69, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)78, INSERT_ALLELE_STR);
        NUCLEOTIDE_IUPAC_HASH.put((byte)79, INSERT_ALLELE_STR);
        NUCLEOTIDE_IUPAC_HASH.put((byte)80, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)81, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)82, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)83, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)84, "0");
        NUCLEOTIDE_IUPAC_HASH.put((byte)85, GAP_ALLELE_STR);
        NUCLEOTIDE_IUPAC_HASH.put((byte)94, GAP_ALLELE_STR);
        NUCLEOTIDE_IUPAC_HASH.put((byte)95, GAP_ALLELE_STR);
        NUCLEOTIDE_IUPAC_HASH.put((byte)-32, "A");
        NUCLEOTIDE_IUPAC_HASH.put((byte)-31, "C");
        NUCLEOTIDE_IUPAC_HASH.put((byte)-30, "G");
        NUCLEOTIDE_IUPAC_HASH.put((byte)-29, "T");
        NUCLEOTIDE_IUPAC_HASH.put((byte)-28, INSERT_ALLELE_STR);
        NUCLEOTIDE_IUPAC_HASH.put((byte)-27, GAP_ALLELE_STR);
        NUCLEOTIDE_IUPAC_HASH.put((byte)-18, "Z");
        NUCLEOTIDE_IUPAC_HASH.put((byte)-17, "N");
        NUCLEOTIDE_IUPAC_HASH.put((byte)-16, "A");
        NUCLEOTIDE_IUPAC_HASH.put((byte)-15, "C");
        NUCLEOTIDE_IUPAC_HASH.put((byte)-14, "G");
        NUCLEOTIDE_IUPAC_HASH.put((byte)-13, "T");
        NUCLEOTIDE_IUPAC_HASH.put((byte)-12, INSERT_ALLELE_STR);
        NUCLEOTIDE_IUPAC_HASH.put((byte)-11, GAP_ALLELE_STR);
        NUCLEOTIDE_IUPAC_HASH.put((byte)-2, "N");
        NUCLEOTIDE_IUPAC_HASH.put((byte)-1, "N");
        NUCLEOTIDE_IUPAC_ARRAY = new String[256];
        NUCLEOTIDE_IUPAC_CHARARRAY = new char[256];
        NUCLEOTIDE_IUPAC_CHARCOMPLEMENT_ARRAY = new char[256];
        Arrays.fill(NUCLEOTIDE_IUPAC_ARRAY, UNDEFINED_ALLELE_STR);
        Arrays.fill(NUCLEOTIDE_IUPAC_CHARARRAY, UNDEFINED_ALLELE_STR.charAt(0));
        Arrays.fill(NUCLEOTIDE_IUPAC_CHARCOMPLEMENT_ARRAY, UNDEFINED_ALLELE_STR.charAt(0));
        for (Byte by : NUCLEOTIDE_IUPAC_HASH.keySet()) {
            NucleotideAlignmentConstants.NUCLEOTIDE_IUPAC_ARRAY[by.byteValue() & 0xFF] = NUCLEOTIDE_IUPAC_HASH.get(by);
            NucleotideAlignmentConstants.NUCLEOTIDE_IUPAC_CHARARRAY[by.byteValue() & 0xFF] = NUCLEOTIDE_IUPAC_HASH.get(by).charAt(0);
            byte compByte = NucleotideAlignmentConstants.getNucleotideDiploidComplement(by);
            NucleotideAlignmentConstants.NUCLEOTIDE_IUPAC_CHARCOMPLEMENT_ARRAY[NucleotideAlignmentConstants.NUCLEOTIDE_IUPAC_HASH.get((Object)by).charAt((int)0)] = NUCLEOTIDE_IUPAC_HASH.get(compByte).charAt(0);
        }
        NUCLEOTIDE_ALLELE_HASH = new HashMap<String, Byte>();
        NUCLEOTIDE_ALLELE_ARRAY = new byte[256];
        NUCLEOTIDE_ALLELE_HASH.put("A", (byte)0);
        NUCLEOTIDE_ALLELE_HASH.put("C", (byte)1);
        NUCLEOTIDE_ALLELE_HASH.put("G", (byte)2);
        NUCLEOTIDE_ALLELE_HASH.put("T", (byte)3);
        NUCLEOTIDE_ALLELE_HASH.put(INSERT_ALLELE_STR, (byte)4);
        NUCLEOTIDE_ALLELE_HASH.put(GAP_ALLELE_STR, (byte)5);
        NUCLEOTIDE_ALLELE_HASH.put("N", (byte)15);
        Arrays.fill(NUCLEOTIDE_ALLELE_ARRAY, (byte)6);
        for (Map.Entry entry : NUCLEOTIDE_ALLELE_HASH.entrySet()) {
            NucleotideAlignmentConstants.NUCLEOTIDE_ALLELE_ARRAY[((String)entry.getKey()).charAt((int)0)] = (Byte)entry.getValue();
        }
    }
}

