/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.map.TOPMInterface;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.bit.BitStorage;
import net.maizegenetics.dna.snp.depth.AlleleDepth;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;

public class TOPMGenotypeTable
implements GenotypeTable {
    private final TOPMInterface myTOPM;
    private int[] myIndicesOfSortByPosition;
    private int[] mySiteOffsetForEachTag;
    private final int myNumTags;
    private final PositionList myPositionList;
    private final TaxaList myTaxaList;
    private int myBlankCount = 0;

    public TOPMGenotypeTable(TOPMInterface topm) {
        this.myTOPM = topm;
        this.myNumTags = this.myTOPM.getTagCount();
        this.sortByTag();
        this.myPositionList = this.getPositionList();
        this.myTaxaList = this.getTaxaList();
    }

    private int getStartPosition(int index) {
        if (this.myTOPM.getStrand(index) == -1) {
            int tagLength = this.myTOPM.getTagLength(index);
            if (tagLength < 64) {
                return this.myTOPM.getStartPosition(index) - (tagLength - 1);
            }
            return this.myTOPM.getEndPosition(index);
        }
        return this.myTOPM.getStartPosition(index);
    }

    private int getEndPosition(int index) {
        if (this.myTOPM.getStrand(index) == -1) {
            return this.myTOPM.getStartPosition(index);
        }
        return this.myTOPM.getEndPosition(index);
    }

    private void sortByTag() {
        int k;
        int i;
        final int[] indicesOfSortByPosition = new int[this.myNumTags];
        for (int i2 = 0; i2 < indicesOfSortByPosition.length; ++i2) {
            indicesOfSortByPosition[i2] = i2;
        }
        Swapper swapTag = new Swapper(){

            public void swap(int a, int b) {
                int temp = indicesOfSortByPosition[a];
                indicesOfSortByPosition[a] = indicesOfSortByPosition[b];
                indicesOfSortByPosition[b] = temp;
            }
        };
        IntComparator compTag = new IntComparator(){

            public int compare(int a, int b) {
                int startPosB;
                int chra = TOPMGenotypeTable.this.myTOPM.getChromosome(indicesOfSortByPosition[a]);
                int chrb = TOPMGenotypeTable.this.myTOPM.getChromosome(indicesOfSortByPosition[b]);
                if (chra == Integer.MIN_VALUE && chrb == Integer.MIN_VALUE) {
                    return 0;
                }
                if (chra < chrb) {
                    return -1;
                }
                if (chra > chrb) {
                    return 1;
                }
                int startPosA = TOPMGenotypeTable.this.getStartPosition(indicesOfSortByPosition[a]);
                if (startPosA < (startPosB = TOPMGenotypeTable.this.getStartPosition(indicesOfSortByPosition[b]))) {
                    return -1;
                }
                if (startPosB < startPosA) {
                    return 1;
                }
                return 0;
            }
        };
        GenericSorting.quickSort((int)0, (int)indicesOfSortByPosition.length, (IntComparator)compTag, (Swapper)swapTag);
        for (i = 0; i < this.myNumTags && this.myTOPM.getChromosome(indicesOfSortByPosition[i]) == Integer.MIN_VALUE; ++i) {
        }
        int numTagsMapped = this.myNumTags - i;
        ArrayList<Integer> tempIndicesOfSortByPosition = new ArrayList<Integer>(numTagsMapped * 3 / 2);
        ArrayList<Integer> siteOffsetForEachTag = new ArrayList<Integer>(numTagsMapped * 3 / 2);
        int previousEndPosition = -1;
        int previousChr = -1;
        int previousIndex = -1;
        for (int j = 0; j < numTagsMapped; ++j) {
            int startPosition;
            int currentIndex = indicesOfSortByPosition[j + i];
            tempIndicesOfSortByPosition.add(currentIndex);
            if (this.myTOPM.getChromosome(currentIndex) != previousChr) {
                previousEndPosition = -1;
                previousChr = this.myTOPM.getChromosome(currentIndex);
            }
            if (previousEndPosition >= (startPosition = this.getStartPosition(currentIndex))) {
                int previousStartPosition = this.getStartPosition(previousIndex);
                siteOffsetForEachTag.add(startPosition - previousStartPosition + (Integer)siteOffsetForEachTag.get(siteOffsetForEachTag.size() - 1));
            } else {
                tempIndicesOfSortByPosition.add(tempIndicesOfSortByPosition.size() - 1, -1);
                siteOffsetForEachTag.add(-1);
                siteOffsetForEachTag.add(0);
            }
            previousEndPosition = this.getEndPosition(currentIndex);
            previousIndex = currentIndex;
        }
        this.myIndicesOfSortByPosition = new int[tempIndicesOfSortByPosition.size()];
        for (k = 0; k < tempIndicesOfSortByPosition.size(); ++k) {
            this.myIndicesOfSortByPosition[k] = (Integer)tempIndicesOfSortByPosition.get(k);
        }
        this.mySiteOffsetForEachTag = new int[siteOffsetForEachTag.size()];
        for (k = 0; k < siteOffsetForEachTag.size(); ++k) {
            this.mySiteOffsetForEachTag[k] = (Integer)siteOffsetForEachTag.get(k);
        }
    }

    private PositionList getPositionList() {
        LinkedHashMap<String, GeneralPosition> positions = new LinkedHashMap<String, GeneralPosition>();
        Chromosome chrObj = new Chromosome(String.valueOf(0));
        for (int t = 0; t < this.myIndicesOfSortByPosition.length; ++t) {
            if (this.myIndicesOfSortByPosition[t] == -1) continue;
            for (int p = this.mySiteOffsetForEachTag[t]; p < this.mySiteOffsetForEachTag[t] + 64; ++p) {
                String key = String.valueOf(p);
                if (positions.containsKey(key)) continue;
                GeneralPosition currentPos = new GeneralPosition.Builder(chrObj, p).build();
                positions.put(key, currentPos);
            }
        }
        PositionListBuilder builder = new PositionListBuilder();
        builder.addAll(positions.values());
        return builder.build();
    }

    private TaxaList getTaxaList() {
        TaxaListBuilder builder = new TaxaListBuilder();
        for (int i = 0; i < this.myIndicesOfSortByPosition.length; ++i) {
            if (this.myIndicesOfSortByPosition[i] != -1) {
                int startPosition = this.getStartPosition(this.myIndicesOfSortByPosition[i]);
                String taxaName = String.valueOf(this.myTOPM.getStrand(this.myIndicesOfSortByPosition[i])) + String.valueOf(this.myIndicesOfSortByPosition[i]) + "_" + String.valueOf(this.myTOPM.getChromosome(this.myIndicesOfSortByPosition[i])) + "_" + String.valueOf(startPosition);
                builder.add(new Taxon.Builder(taxaName).build());
                continue;
            }
            builder.add(new Taxon.Builder("Blank " + String.valueOf(this.myBlankCount++)).build());
        }
        return builder.build();
    }

    @Override
    public GenotypeCallTable genotypeMatrix() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isSNP(int taxon, int site) {
        if (this.myIndicesOfSortByPosition[taxon] == -1) {
            return false;
        }
        byte[] offsets = this.myTOPM.getVariantPosOffArray(this.myIndicesOfSortByPosition[taxon]);
        if (offsets == null || offsets.length == 0) {
            return false;
        }
        int tagLength = this.myTOPM.getTagLength(this.myIndicesOfSortByPosition[taxon]);
        if (this.myTOPM.getStrand(this.myIndicesOfSortByPosition[taxon]) == -1) {
            int index = -this.myTOPM.getStartPosition(this.myIndicesOfSortByPosition[taxon]) + this.getStartPosition(this.myIndicesOfSortByPosition[taxon]) + site - this.mySiteOffsetForEachTag[taxon];
            if (index <= 0 && index > -tagLength) {
                for (byte offset : offsets) {
                    if (offset != index) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        int index = site - this.mySiteOffsetForEachTag[taxon];
        if (index >= 0 && index < tagLength) {
            for (byte offset : offsets) {
                if (offset != index) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public byte genotype(int taxon, int site) {
        if (this.myIndicesOfSortByPosition[taxon] == -1) {
            return 102;
        }
        int tagLength = this.myTOPM.getTagLength(this.myIndicesOfSortByPosition[taxon]);
        if (this.myTOPM.getStrand(this.myIndicesOfSortByPosition[taxon]) == -1) {
            int index = tagLength - site + this.mySiteOffsetForEachTag[taxon] - 1;
            if (index >= 0 && index < tagLength) {
                String tag = BaseEncoder.getSequenceFromLong(this.myTOPM.getTag(this.myIndicesOfSortByPosition[taxon]));
                return NucleotideAlignmentConstants.getNucleotideDiploidComplement(NucleotideAlignmentConstants.getNucleotideDiploidByte(tag.charAt(index)));
            }
            return 102;
        }
        int index = site - this.mySiteOffsetForEachTag[taxon];
        if (index >= 0 && index < tagLength) {
            String tag = BaseEncoder.getSequenceFromLong(this.myTOPM.getTag(this.myIndicesOfSortByPosition[taxon]));
            return NucleotideAlignmentConstants.getNucleotideDiploidByte(tag.charAt(index));
        }
        return 102;
    }

    @Override
    public byte[] genotypeArray(int taxon, int site) {
        return GenotypeTableUtils.getDiploidValues(this.genotype(taxon, site));
    }

    @Override
    public byte genotype(int taxon, Chromosome chromosome, int physicalPosition) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] genotypeRange(int taxon, int startSite, int endSite) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] genotypeAllSites(int taxon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] genotypeAllTaxa(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSet allelePresenceForAllSites(int taxon, WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long[] allelePresenceForSitesBlock(int taxon, WHICH_ALLELE allele, int startBlock, int endBlock) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllSites(int taxon, boolean firstParent, WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllTaxa(int site, boolean firstParent, WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long[] haplotypeAllelePresenceForSitesBlock(int taxon, boolean firstParent, WHICH_ALLELE allele, int startBlock, int endBlock) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        byte genotype = this.genotype(taxon, site);
        if (genotype == 102) {
            return "";
        }
        return NucleotideAlignmentConstants.getNucleotideIUPAC(genotype);
    }

    @Override
    public String genotypeAsStringRange(int taxon, int startSite, int endSite) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String genotypeAsStringRow(int taxon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] genotypeAsStringArray(int taxon, int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasReference() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isHeterozygous(int taxon, int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int heterozygousCount(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String siteName(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int numberOfSites() {
        return this.myPositionList.numberOfSites();
    }

    @Override
    public int chromosomeSiteCount(Chromosome chromosome) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[] firstLastSiteOfChromosome(Chromosome chromosome) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int numberOfTaxa() {
        return this.myIndicesOfSortByPosition.length;
    }

    @Override
    public PositionList positions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int chromosomalPosition(int site) {
        return this.myPositionList.chromosomalPosition(site);
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome) {
        return this.myPositionList.siteOfPhysicalPosition(physicalPosition, chromosome);
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome, String snpName) {
        return this.myPositionList.siteOfPhysicalPosition(physicalPosition, chromosome, snpName);
    }

    @Override
    public int[] physicalPositions() {
        return this.myPositionList.physicalPositions();
    }

    @Override
    public String chromosomeName(int site) {
        return this.myPositionList.chromosomeName(site);
    }

    @Override
    public Chromosome chromosome(int site) {
        return this.myPositionList.chromosome(site);
    }

    @Override
    public Chromosome chromosome(String name) {
        return this.myPositionList.chromosome(name);
    }

    @Override
    public Chromosome[] chromosomes() {
        return this.myPositionList.chromosomes();
    }

    @Override
    public int numChromosomes() {
        return this.myPositionList.numChromosomes();
    }

    @Override
    public int[] chromosomesOffsets() {
        return this.myPositionList.chromosomesOffsets();
    }

    @Override
    public float siteScore(int taxon, int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float[][] siteScores() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasDepth() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasSiteScores() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GenotypeTable.SITE_SCORE_TYPE siteScoreType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int indelSize(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isIndel(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isAllPolymorphic() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPolymorphic(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte majorAllele(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String majorAlleleAsString(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte minorAllele(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String minorAlleleAsString(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] minorAlleles(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] alleles(int site) {
        int[][] alleles = this.allelesSortedByFrequency(site);
        int resultSize = alleles[0].length;
        byte[] result = new byte[resultSize];
        for (int i = 0; i < resultSize; ++i) {
            result[i] = (byte)alleles[0][i];
        }
        return result;
    }

    @Override
    public double minorAlleleFrequency(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double majorAlleleFrequency(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TaxaList taxa() {
        return this.myTaxaList;
    }

    @Override
    public String taxaName(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String genomeVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPositiveStrand(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GenotypeTable[] compositeAlignments() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[][] allelesSortedByFrequency(int site) {
        return GenotypeTableUtils.getAllelesSortedByFrequency(this, site);
    }

    @Override
    public Object[][] genosSortedByFrequency(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isPhased() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainsRareAlleles() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[][] alleleDefinitions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] alleleDefinitions(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String genotypeAsString(int site, byte value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String diploidAsString(int site, byte value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int maxNumAlleles() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int totalGametesNonMissingForSite(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int totalNonMissingForSite(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int minorAlleleCount(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int majorAlleleCount(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object[][] genoCounts() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object[][] majorMinorCounts() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int totalGametesNonMissingForTaxon(int taxon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int heterozygousCountForTaxon(int taxon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int totalNonMissingForTaxon(int taxon) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AlleleDepth depth() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[] depthForAlleles(int taxon, int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] allelesBySortType(GenotypeTable.ALLELE_SORT_TYPE scope, int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSet allelePresenceForAllTaxa(int site, WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitStorage bitStorage(WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte referenceAllele(int site) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] referenceAlleles(int startSite, int endSite) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] referenceAlleleForAllSites() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

