/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.byte3d;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.util.ArrayList;
import java.util.List;
import net.maizegenetics.dna.snp.byte3d.Byte3D;
import net.maizegenetics.dna.snp.byte3d.HDF5Byte3D;
import net.maizegenetics.dna.snp.byte3d.MemoryByte3D;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.HDF5Utils;
import net.maizegenetics.util.SuperByteMatrix;
import net.maizegenetics.util.SuperByteMatrixBuilder;

public class Byte3DBuilder {
    private List<SuperByteMatrix> myValues = null;
    private final boolean myIsHDF5;
    private IHDF5Writer myHDF5Writer = null;
    private final int myMaxNumAlleles;
    private final int myNumSites;
    private int myNumTaxa = 0;

    private Byte3DBuilder(IHDF5Writer writer, int numSites, int maxNumAlleles) {
        this.myIsHDF5 = true;
        this.myHDF5Writer = writer;
        this.myMaxNumAlleles = maxNumAlleles;
        this.myNumSites = numSites;
    }

    private Byte3DBuilder(int numSites, int maxNumAlleles) {
        this.myIsHDF5 = false;
        this.myHDF5Writer = null;
        this.myMaxNumAlleles = maxNumAlleles;
        this.myNumSites = numSites;
        this.myValues = new ArrayList<SuperByteMatrix>();
    }

    private Byte3DBuilder(int numTaxa, int numSites, int maxNumAlleles) {
        this.myIsHDF5 = false;
        this.myHDF5Writer = null;
        this.myMaxNumAlleles = maxNumAlleles;
        this.myNumSites = numSites;
        this.myNumTaxa = numTaxa;
        this.myValues = new ArrayList<SuperByteMatrix>();
        for (int i = 0; i < this.myNumTaxa; ++i) {
            this.myValues.add(SuperByteMatrixBuilder.getInstance(this.myNumSites, this.myMaxNumAlleles));
        }
    }

    public static Byte3DBuilder getInstance(int numTaxa, int numSites, int maxNumAlleles) {
        return new Byte3DBuilder(numTaxa, numSites, maxNumAlleles);
    }

    public static Byte3DBuilder getNucleotideInstance(int numTaxa, int numSites) {
        return new Byte3DBuilder(numTaxa, numSites, 6);
    }

    public static Byte3DBuilder getHDF5NucleotideInstance(IHDF5Writer writer, int numSites) {
        return new Byte3DBuilder(writer, numSites, 6);
    }

    public Byte3DBuilder setRangeForTaxon(int taxon, int siteOffset, byte[][] values) {
        if (this.myIsHDF5) {
            throw new IllegalStateException("Byte3DBuilder: setDepth: use addTaxon for HDF5 files.");
        }
        int numAlleles = values.length;
        if (numAlleles != this.myMaxNumAlleles) {
            throw new IllegalArgumentException("Byte3DBuilder: setDepth: value number of alleles: " + numAlleles + " should have: " + this.myMaxNumAlleles);
        }
        for (int a = 0; a < this.myMaxNumAlleles; ++a) {
            for (int s = 0; s < values[0].length; ++s) {
                this.set(taxon, s + siteOffset, (byte)a, values[a][s]);
            }
        }
        return this;
    }

    public Byte3DBuilder set(int taxon, int site, byte allele, byte value) {
        if (this.myIsHDF5) {
            throw new IllegalStateException("Byte3DBuilder: set: use addTaxon for HDF5 files.");
        }
        this.myValues.get(taxon).set(site, allele, value);
        return this;
    }

    public Byte3DBuilder set(int taxon, byte[][] values) {
        if (this.myIsHDF5) {
            throw new IllegalStateException("Byte3DBuilder: setDepth: use addTaxon for HDF5 files.");
        }
        int numAlleles = values.length;
        if (numAlleles != this.myMaxNumAlleles) {
            throw new IllegalArgumentException("Byte3DBuilder: setDepth: value number of alleles: " + numAlleles + " should have: " + this.myMaxNumAlleles);
        }
        int numSites = values[0].length;
        if (numSites != this.myNumSites) {
            throw new IllegalArgumentException("Byte3DBuilder: setDepth: value number of sites: " + numSites + " should have: " + this.myNumSites);
        }
        for (int a = 0; a < this.myMaxNumAlleles; ++a) {
            for (int s = 0; s < this.myNumSites; ++s) {
                this.set(taxon, s, (byte)a, values[a][s]);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Byte3DBuilder addTaxon(Taxon taxon, byte[][] values) {
        if (this.myIsHDF5) {
            if (values == null || values.length != this.myMaxNumAlleles) {
                throw new IllegalStateException("Byte3DBuilder: addTaxon: Set A, C, G, T, -, + at once");
            }
            if (values[0].length != this.myNumSites) {
                throw new IllegalStateException("Byte3DBuilder: addTaxon: Number of sites: " + values[0].length + " should be: " + this.myNumSites);
            }
            IHDF5Writer iHDF5Writer = this.myHDF5Writer;
            synchronized (iHDF5Writer) {
                HDF5Utils.writeHDF5GenotypesDepth(this.myHDF5Writer, taxon.getName(), values);
            }
            ++this.myNumTaxa;
        } else {
            this.myValues.add(SuperByteMatrixBuilder.getInstance(this.myNumSites, this.myMaxNumAlleles));
            this.set(this.myNumTaxa, values);
            ++this.myNumTaxa;
        }
        return this;
    }

    public Byte3D build() {
        if (this.myIsHDF5) {
            IHDF5Writer reader = this.myHDF5Writer;
            this.myHDF5Writer = null;
            return new HDF5Byte3D((IHDF5Reader)reader);
        }
        SuperByteMatrix[] temp = new SuperByteMatrix[this.myValues.size()];
        temp = this.myValues.toArray(temp);
        this.myValues = null;
        return new MemoryByte3D(temp, this.myNumTaxa, this.myNumSites);
    }
}

