/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.byte3d;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import net.maizegenetics.dna.snp.byte3d.AbstractByte3D;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.util.Tassel5HDF5Constants;

public class HDF5Byte3D
extends AbstractByte3D {
    private static final int MAX_CACHE_SIZE = 65536;
    private static final int HDF5_BLOCK = 65536;
    private final Map<Long, byte[][]> myDepthCache = new LinkedHashMap<Long, byte[][]>(98304){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, byte[][]> eldest) {
            return this.size() > 65536;
        }
    };
    private final IHDF5Reader myReader;
    private final int myNumSites;
    private final TaxaList myTaxa;
    private final int myNumAlleles;

    HDF5Byte3D(IHDF5Reader reader) {
        super(6, reader.getIntAttribute("Genotypes", "numTaxa"), reader.getIntAttribute("Positions/", "numSites"));
        this.myReader = reader;
        this.myNumSites = reader.getIntAttribute("Positions/", "numSites");
        this.myTaxa = new TaxaListBuilder().buildFromHDF5(reader);
        this.myNumAlleles = 6;
    }

    private static long getCacheKey(int taxon, int site) {
        return ((long)taxon << 33) + (long)(site / 65536);
    }

    private byte[][] cacheValuesBlock(int taxon, int site, long key) {
        int start = site / 65536 * 65536;
        int realSiteCache = this.myNumSites - start < 65536 ? this.myNumSites - start : 65536;
        byte[][] data = this.myReader.readByteMatrixBlockWithOffset(Tassel5HDF5Constants.getGenotypesDepthPath(this.myTaxa.taxaName(taxon)), this.myNumAlleles, realSiteCache, 0L, (long)start);
        if (data == null) {
            return null;
        }
        this.myDepthCache.put(key, data);
        return data;
    }

    @Override
    public byte valueForAllele(int taxon, int site, int allele) {
        long key = HDF5Byte3D.getCacheKey(taxon, site);
        byte[][] data = this.myDepthCache.get(key);
        if (data == null) {
            data = this.cacheValuesBlock(taxon, site, key);
        }
        return data[allele][site % 65536];
    }
}

