/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.depth;

import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import net.maizegenetics.dna.snp.depth.AbstractAlleleDepth;
import net.maizegenetics.dna.snp.depth.AlleleDepthUtil;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.util.Tassel5HDF5Constants;

public class HDF5AlleleDepth
extends AbstractAlleleDepth {
    private static int MAX_CACHE_SIZE = 65536;
    private static final int HDF5_BLOCK = 65536;
    private final Map<Long, byte[][]> myDepthCache = new LinkedHashMap<Long, byte[][]>(3 * MAX_CACHE_SIZE / 2){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > MAX_CACHE_SIZE;
        }
    };
    private final IHDF5Reader myReader;
    private final int myNumSites;
    private final TaxaList myTaxa;

    HDF5AlleleDepth(IHDF5Reader reader) {
        super(6, reader.getIntAttribute("Genotypes", "numTaxa"), reader.getIntAttribute("Positions/", "numSites"));
        this.myReader = reader;
        this.myNumSites = reader.getIntAttribute("Positions/", "numSites");
        this.myTaxa = new TaxaListBuilder().buildFromHDF5(reader);
    }

    private static long getCacheKey(int taxon, int site) {
        return ((long)taxon << 33) + (long)(site / 65536);
    }

    public byte[] depthForAllelesBytes(int taxon, int site) {
        long key = HDF5AlleleDepth.getCacheKey(taxon, site);
        byte[][] data = this.myDepthCache.get(key);
        if (data == null) {
            data = this.cacheDepthBlock(taxon, site, key);
        }
        byte[] result = new byte[6];
        for (int i = 0; i < 6; ++i) {
            result[i] = data[i][site % MAX_CACHE_SIZE];
        }
        return result;
    }

    public byte[][] depthForAllelesBytes(int taxon) {
        byte[][] result = new byte[6][this.myNumSites];
        for (int site = 0; site < this.myNumSites; ++site) {
            long key = HDF5AlleleDepth.getCacheKey(taxon, site);
            byte[][] data = this.myDepthCache.get(key);
            if (data == null) {
                data = this.cacheDepthBlock(taxon, site, key);
            }
            for (int i = 0; i < 6; ++i) {
                result[i][site] = data[i][site % MAX_CACHE_SIZE];
            }
        }
        return result;
    }

    private byte[][] cacheDepthBlock(int taxon, int site, long key) {
        int start = site / MAX_CACHE_SIZE * MAX_CACHE_SIZE;
        int realSiteCache = this.myNumSites - start < MAX_CACHE_SIZE ? this.myNumSites - start : MAX_CACHE_SIZE;
        byte[][] data = this.myReader.readByteMatrixBlockWithOffset(Tassel5HDF5Constants.getGenotypesDepthPath(this.myTaxa.taxaName(taxon)), 6, realSiteCache, 0L, (long)start);
        if (data == null) {
            return null;
        }
        this.myDepthCache.put(key, data);
        return data;
    }

    @Override
    public int[] depthForAlleles(int taxon, int site) {
        return AlleleDepthUtil.depthByteToInt(this.depthForAllelesBytes(taxon, site));
    }

    @Override
    public int depthForAllele(int taxon, int site, int allele) {
        return AlleleDepthUtil.depthByteToInt(this.depthForAlleleByte(taxon, site, allele));
    }

    @Override
    public byte depthForAlleleByte(int taxon, int site, int allele) {
        long key = HDF5AlleleDepth.getCacheKey(taxon, site);
        byte[][] data = this.myDepthCache.get(key);
        if (data == null) {
            data = this.cacheDepthBlock(taxon, site, key);
        }
        return data[allele][site % MAX_CACHE_SIZE];
    }
}

