/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.genotypecall;

import java.util.HashMap;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.genotypecall.AlleleFreqCache;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import org.apache.log4j.Logger;

abstract class AbstractGenotypeCallTable
implements GenotypeCallTable {
    private static final Logger myLogger = Logger.getLogger(AbstractGenotypeCallTable.class);
    private static final int DEFAULT_MAX_NUM_ALLELES = 6;
    protected final int myTaxaCount;
    protected final int mySiteCount;
    private final String[][] myAlleleEncodings;
    private final boolean myIsPhased;
    private final AlleleFreqCache myAlleleFreqCache;

    AbstractGenotypeCallTable(int numTaxa, int numSites, boolean phased, String[][] alleleEncodings, int maxNumAlleles) {
        this.myTaxaCount = numTaxa;
        this.mySiteCount = numSites;
        this.myIsPhased = phased;
        this.myAlleleEncodings = alleleEncodings;
        this.myAlleleFreqCache = new AlleleFreqCache(this, maxNumAlleles);
    }

    AbstractGenotypeCallTable(int numTaxa, int numSites, boolean phased, String[][] alleleEncodings) {
        this(numTaxa, numSites, phased, alleleEncodings, 6);
    }

    @Override
    public byte[] genotypeArray(int taxon, int site) {
        return GenotypeTableUtils.getDiploidValues(this.genotype(taxon, site));
    }

    @Override
    public byte[] genotypeRange(int taxon, int startSite, int endSite) {
        byte[] result = new byte[endSite - startSite];
        for (int i = startSite; i < endSite; ++i) {
            result[i - startSite] = this.genotype(taxon, i);
        }
        return result;
    }

    @Override
    public byte[] genotypeAllSites(int taxon) {
        byte[] result = new byte[this.mySiteCount];
        for (int i = 0; i < this.mySiteCount; ++i) {
            result[i] = this.genotype(taxon, i);
        }
        return result;
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        String[][] alleleStates = this.alleleDefinitions();
        byte[] temp = this.genotypeArray(taxon, site);
        return alleleStates[0][temp[0]] + ":" + alleleStates[0][temp[1]];
    }

    @Override
    public String genotypeAsStringRange(int taxon, int startSite, int endSite) {
        StringBuilder builder = new StringBuilder();
        for (int i = startSite; i < endSite; ++i) {
            if (i != startSite) {
                builder.append(";");
            }
            builder.append(this.genotypeAsString(taxon, i));
        }
        return builder.toString();
    }

    @Override
    public String genotypeAsStringRow(int taxon) {
        return this.genotypeAsStringRange(taxon, 0, this.mySiteCount);
    }

    @Override
    public String[] genotypeAsStringArray(int taxon, int site) {
        String[][] alleleStates = this.alleleDefinitions();
        byte[] temp = this.genotypeArray(taxon, site);
        return new String[]{alleleStates[0][temp[0]], alleleStates[0][temp[1]]};
    }

    @Override
    public int[][] allelesSortedByFrequency(int site) {
        return this.myAlleleFreqCache.getAllelesSortedByFrequency(site);
    }

    @Override
    public boolean isHeterozygous(int taxon, int site) {
        byte[] values = this.genotypeArray(taxon, site);
        return values[0] != values[1];
    }

    @Override
    public int heterozygousCount(int site) {
        int result = 0;
        int n = this.myTaxaCount;
        for (int i = 0; i < n; ++i) {
            if (!this.isHeterozygous(i, site)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public boolean isPolymorphic(int site) {
        byte first = 15;
        int n = this.myTaxaCount;
        for (int i = 0; i < n; ++i) {
            byte[] current = this.genotypeArray(i, site);
            if (current[0] != 15) {
                if (first == 15) {
                    first = current[0];
                } else if (first != current[0]) {
                    return true;
                }
            }
            if (current[1] == 15) continue;
            if (first == 15) {
                first = current[1];
                continue;
            }
            if (first == current[1]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllPolymorphic() {
        int n = this.mySiteCount;
        for (int i = 0; i < n; ++i) {
            if (this.isPolymorphic(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPhased() {
        return this.myIsPhased;
    }

    @Override
    public boolean retainsRareAlleles() {
        return true;
    }

    @Override
    public String[][] alleleDefinitions() {
        return this.myAlleleEncodings;
    }

    @Override
    public String[] alleleDefinitions(int site) {
        if (this.myAlleleEncodings.length == 1) {
            return this.myAlleleEncodings[0];
        }
        return this.myAlleleEncodings[site];
    }

    @Override
    public String genotypeAsString(int site, byte value) {
        return this.alleleDefinitions(site)[value];
    }

    @Override
    public String diploidAsString(int site, byte value) {
        String[] alleleStates = this.alleleDefinitions(site);
        return alleleStates[value >>> 4 & 0xF] + ":" + alleleStates[value & 0xF];
    }

    @Override
    public int maxNumAlleles() {
        return 6;
    }

    @Override
    public int totalGametesNonMissingForSite(int site) {
        int result = 0;
        int n = this.myTaxaCount;
        for (int i = 0; i < n; ++i) {
            byte[] current = this.genotypeArray(i, site);
            if (current[0] != 15) {
                ++result;
            }
            if (current[1] == 15) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int totalNonMissingForSite(int site) {
        int result = 0;
        int n = this.myTaxaCount;
        for (int i = 0; i < n; ++i) {
            byte current = this.genotype(i, site);
            if (current == -1) continue;
            ++result;
        }
        return result;
    }

    @Override
    public byte[] majorAlleleForAllSites() {
        byte[] result = new byte[this.mySiteCount];
        for (int i = 0; i < this.mySiteCount; ++i) {
            result[i] = this.majorAllele(i);
        }
        return result;
    }

    @Override
    public byte[] minorAlleleForAllSites() {
        byte[] result = new byte[this.mySiteCount];
        for (int i = 0; i < this.mySiteCount; ++i) {
            result[i] = this.minorAllele(i);
        }
        return result;
    }

    @Override
    public int minorAlleleCount(int site) {
        int[][] alleles = this.allelesSortedByFrequency(site);
        if (alleles[0].length >= 2) {
            return alleles[1][1];
        }
        return 0;
    }

    @Override
    public byte minorAllele(int site) {
        int[][] alleles = this.allelesSortedByFrequency(site);
        if (alleles[0].length >= 2) {
            return (byte)alleles[0][1];
        }
        return 15;
    }

    @Override
    public String minorAlleleAsString(int site) {
        return this.genotypeAsString(site, this.minorAllele(site));
    }

    @Override
    public byte[] minorAlleles(int site) {
        int[][] alleles = this.allelesSortedByFrequency(site);
        int resultSize = alleles[0].length - 1;
        byte[] result = new byte[resultSize];
        for (int i = 0; i < resultSize; ++i) {
            result[i] = (byte)alleles[0][i + 1];
        }
        return result;
    }

    @Override
    public int majorAlleleCount(int site) {
        int[][] alleles = this.allelesSortedByFrequency(site);
        if (alleles[0].length >= 1) {
            return alleles[1][0];
        }
        return 0;
    }

    @Override
    public byte majorAllele(int site) {
        int[][] alleles = this.allelesSortedByFrequency(site);
        if (alleles[0].length >= 1) {
            return (byte)alleles[0][0];
        }
        return 15;
    }

    @Override
    public String majorAlleleAsString(int site) {
        return this.genotypeAsString(site, this.majorAllele(site));
    }

    @Override
    public double majorAlleleFrequency(int site) {
        int[][] alleles = this.allelesSortedByFrequency(site);
        int numAlleles = alleles[0].length;
        if (numAlleles >= 1) {
            int totalNonMissing = 0;
            for (int i = 0; i < numAlleles; ++i) {
                totalNonMissing += alleles[1][i];
            }
            return (double)alleles[1][0] / (double)totalNonMissing;
        }
        return 0.0;
    }

    @Override
    public double minorAlleleFrequency(int site) {
        int[][] alleles = this.allelesSortedByFrequency(site);
        int numAlleles = alleles[0].length;
        if (numAlleles >= 2) {
            int totalNonMissing = 0;
            for (int i = 0; i < numAlleles; ++i) {
                totalNonMissing += alleles[1][i];
            }
            return (double)alleles[1][1] / (double)totalNonMissing;
        }
        return 0.0;
    }

    @Override
    public Object[][] genosSortedByFrequency(int site) {
        Integer ONE_INTEGER = 1;
        HashMap<String, Integer> diploidValueCounts = new HashMap<String, Integer>();
        for (int r = 0; r < this.myTaxaCount; ++r) {
            String current = this.genotypeAsString(r, site);
            Integer num = (Integer)diploidValueCounts.get(current);
            if (num == null) {
                diploidValueCounts.put(current, ONE_INTEGER);
                continue;
            }
            num = num + 1;
            diploidValueCounts.put(current, num);
        }
        Object[][] result = new Object[2][diploidValueCounts.size()];
        int i = 0;
        for (String key : diploidValueCounts.keySet()) {
            Integer count = (Integer)diploidValueCounts.get(key);
            result[0][i] = key;
            result[1][i++] = count;
        }
        boolean change = true;
        while (change) {
            change = false;
            int n = diploidValueCounts.size() - 1;
            for (int k = 0; k < n; ++k) {
                if ((Integer)result[1][k] >= (Integer)result[1][k + 1]) continue;
                Object temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                Object tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    @Override
    public Object[][] genoCounts() {
        Long count;
        HashMap<String, Long> diploidValueCounts = new HashMap<String, Long>();
        for (int c = 0; c < this.mySiteCount; ++c) {
            Object[][] diploids = this.genosSortedByFrequency(c);
            for (int i = 0; i < diploids[0].length; ++i) {
                String current = (String)diploids[0][i];
                count = (long)((Integer)diploids[1][i]);
                Long num = (Long)diploidValueCounts.get(current);
                if (num == null) {
                    diploidValueCounts.put(current, count);
                    continue;
                }
                diploidValueCounts.put(current, num + count);
            }
        }
        Object[][] result = new Object[2][diploidValueCounts.size()];
        int i = 0;
        for (String key : diploidValueCounts.keySet()) {
            count = (Long)diploidValueCounts.get(key);
            result[0][i] = key;
            result[1][i++] = count;
        }
        boolean change = true;
        while (change) {
            change = false;
            int n = diploidValueCounts.size() - 1;
            for (int k = 0; k < n; ++k) {
                if ((Long)result[1][k] >= (Long)result[1][k + 1]) continue;
                Object temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                Object tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    @Override
    public Object[][] majorMinorCounts() {
        String[][] alleleStates = this.alleleDefinitions();
        if (alleleStates.length != 1) {
            return new Object[0][0];
        }
        long[][] counts = new long[16][16];
        for (int site = 0; site < this.mySiteCount; ++site) {
            byte[] alleles = this.alleles(site);
            if (alleles == null || alleles.length == 0) continue;
            if (alleles.length == 1) {
                long[] lArray = counts[alleles[0]];
                byte by = alleles[0];
                lArray[by] = lArray[by] + 1L;
                continue;
            }
            long[] lArray = counts[alleles[0]];
            byte by = alleles[1];
            lArray[by] = lArray[by] + 1L;
        }
        int numAlleles = 0;
        for (int x = 0; x < 16; x = (int)((byte)(x + 1))) {
            for (int y = 0; y < 16; y = (int)((byte)(y + 1))) {
                if (counts[x][y] == 0L) continue;
                ++numAlleles;
            }
        }
        Object[][] result = new Object[2][numAlleles];
        int nextResult = 0;
        for (byte x = 0; x < 16; x = (byte)((byte)(x + 1))) {
            for (byte y = 0; y < 16; y = (byte)((byte)(y + 1))) {
                if (counts[x][y] == 0L) continue;
                result[0][nextResult] = this.genotypeAsString(0, x) + ":" + this.genotypeAsString(0, y);
                result[1][nextResult++] = counts[x][y];
            }
        }
        boolean change = true;
        while (change) {
            change = false;
            for (int k = 0; k < numAlleles - 1; ++k) {
                if ((Long)result[1][k] >= (Long)result[1][k + 1]) continue;
                Object temp = result[0][k];
                result[0][k] = result[0][k + 1];
                result[0][k + 1] = temp;
                Object tempCount = result[1][k];
                result[1][k] = result[1][k + 1];
                result[1][k + 1] = tempCount;
                change = true;
            }
        }
        return result;
    }

    @Override
    public int totalGametesNonMissingForTaxon(int taxon) {
        int result = 0;
        int n = this.mySiteCount;
        for (int i = 0; i < n; ++i) {
            byte[] current = this.genotypeArray(taxon, i);
            if (current[0] != 15) {
                ++result;
            }
            if (current[1] == 15) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int heterozygousCountForTaxon(int taxon) {
        int result = 0;
        int n = this.mySiteCount;
        for (int i = 0; i < n; ++i) {
            if (!this.isHeterozygous(taxon, i)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int totalNonMissingForTaxon(int taxon) {
        int result = 0;
        int n = this.mySiteCount;
        for (int i = 0; i < n; ++i) {
            byte current = this.genotype(taxon, i);
            if (current == -1) continue;
            ++result;
        }
        return result;
    }

    @Override
    public byte[] alleles(int site) {
        int[][] alleles = this.allelesSortedByFrequency(site);
        int resultSize = alleles[0].length;
        byte[] result = new byte[resultSize];
        for (int i = 0; i < resultSize; ++i) {
            result[i] = (byte)alleles[0][i];
        }
        return result;
    }

    @Override
    public int numberOfSites() {
        return this.mySiteCount;
    }

    @Override
    public int numberOfTaxa() {
        return this.myTaxaCount;
    }

    @Override
    public byte[] genotypeForAllSites(int taxon) {
        int numSites = this.numberOfSites();
        byte[] result = new byte[numSites];
        for (int i = 0; i < numSites; ++i) {
            result[i] = this.genotype(taxon, i);
        }
        return result;
    }

    @Override
    public byte[] genotypeForSiteRange(int taxon, int start, int end) {
        int numSites = end - start;
        byte[] result = new byte[numSites];
        for (int i = start; i < end; ++i) {
            result[i] = this.genotype(taxon, i);
        }
        return result;
    }

    @Override
    public byte[] genotypeForAllTaxa(int site) {
        int numTaxa = this.numberOfTaxa();
        byte[] result = new byte[numTaxa];
        for (int i = 0; i < numTaxa; ++i) {
            result[i] = this.genotype(i, site);
        }
        return result;
    }
}

