/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.io;

import com.google.common.collect.SetMultimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.dna.snp.io.ProcessHapMapBlock;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.SuperByteMatrix;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class BuilderFromHapMap {
    private static final Logger myLogger = Logger.getLogger(BuilderFromHapMap.class);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    private static final int NUM_HAPMAP_NON_TAXA_HEADERS = 11;
    private final String infile;
    private int[] taxaRedirect;
    private boolean sortAlphabetically = false;

    private BuilderFromHapMap(String infile) {
        this.infile = infile;
    }

    public static BuilderFromHapMap getBuilder(String infile) {
        return new BuilderFromHapMap(infile);
    }

    public GenotypeTable build() {
        long time = System.nanoTime();
        GenotypeTable result = null;
        try {
            ProcessHapMapBlock pb;
            String currLine;
            int numThreads = Runtime.getRuntime().availableProcessors();
            ExecutorService pool = Executors.newFixedThreadPool(numThreads);
            System.out.print("Reading :" + this.infile + " ");
            BufferedReader r = Utils.getBufferedReader(this.infile, -1);
            TreeMap<String, SetMultimap<String, String>> sampAnnoBuild = new TreeMap<String, SetMultimap<String, String>>();
            while ((currLine = r.readLine()) != null && currLine.startsWith("##")) {
                String[] cat = currLine.split("=", 2);
                if (cat.length < 2 || !cat[0].startsWith("##SAMPLE")) continue;
                SetMultimap<String, String> mapOfAnno = TaxaListIOUtils.parseVCFHeadersIntoMap(cat[1]);
                String taxaID = (String)mapOfAnno.get((Object)"ID").iterator().next();
                if (taxaID == null) break;
                sampAnnoBuild.put(taxaID, mapOfAnno);
            }
            TaxaList taxaList = BuilderFromHapMap.processTaxa(currLine, sampAnnoBuild);
            int linesAtTime = 4096;
            ArrayList commentLines = new ArrayList();
            ArrayList<String> txtLines = new ArrayList<String>(linesAtTime);
            ArrayList<ProcessHapMapBlock> pbs = new ArrayList<ProcessHapMapBlock>();
            int lines = 0;
            while ((currLine = r.readLine()) != null) {
                txtLines.add(currLine);
                if (++lines % linesAtTime != 0) continue;
                pb = ProcessHapMapBlock.getInstance(taxaList.numberOfTaxa(), txtLines);
                pbs.add(pb);
                pool.execute(pb);
                txtLines = new ArrayList(linesAtTime);
                System.out.print(".");
            }
            r.close();
            if (txtLines.size() > 0) {
                pb = ProcessHapMapBlock.getInstance(taxaList.numberOfTaxa(), txtLines);
                pbs.add(pb);
                pool.execute(pb);
            }
            pool.shutdown();
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("BuilderFromHapMap: processing threads timed out.");
            }
            int currentSite = 0;
            PositionListBuilder posBuild = new PositionListBuilder();
            taxaList = this.sortTaxaListIfNeeded(taxaList);
            GenotypeCallTableBuilder gb = GenotypeCallTableBuilder.getUnphasedNucleotideGenotypeBuilder(taxaList.numberOfTaxa(), lines);
            for (ProcessHapMapBlock pb2 : pbs) {
                posBuild.addAll(pb2.getBlkPosList());
                SuperByteMatrix bgTS = pb2.getGenoTS();
                for (int t = 0; t < bgTS.getNumRows(); ++t) {
                    int currentTaxa = this.taxaRedirect[t];
                    for (int s = 0; s < bgTS.getNumColumns(); ++s) {
                        gb.setBase(currentTaxa, currentSite + s, bgTS.get(t, s));
                    }
                }
                currentSite += pb2.getSiteNumber();
            }
            if (!posBuild.validateOrdering()) {
                throw new IllegalStateException("BuilderFromHapMap: Ordering incorrect HapMap must be ordered by position");
            }
            GenotypeCallTable g = gb.build();
            result = GenotypeTableBuilder.getInstance(g, posBuild.build(), taxaList);
            System.out.println(" finished");
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        long totalTime = System.nanoTime() - time;
        return result;
    }

    public BuilderFromHapMap sortTaxa() {
        this.sortAlphabetically = true;
        return this;
    }

    private TaxaList sortTaxaListIfNeeded(TaxaList origTL) {
        TaxaList resultTL = this.sortAlphabetically ? new TaxaListBuilder().addAll(origTL).sortTaxaAlphabetically().build() : origTL;
        this.taxaRedirect = new int[origTL.numberOfTaxa()];
        for (int i = 0; i < this.taxaRedirect.length; ++i) {
            this.taxaRedirect[i] = resultTL.indexOf((Taxon)origTL.get(i));
        }
        return resultTL;
    }

    private static TaxaList processTaxa(String readLn, Map<String, SetMultimap<String, String>> taxaAnnotation) {
        String[] header = WHITESPACE_PATTERN.split(readLn);
        int numTaxa = header.length - 11;
        TaxaListBuilder tlb = new TaxaListBuilder();
        for (int i = 0; i < numTaxa; ++i) {
            String taxonID = header[i + 11];
            Taxon.Builder at = new Taxon.Builder(taxonID);
            SetMultimap<String, String> taMap = taxaAnnotation.get(taxonID);
            if (taMap != null) {
                for (Map.Entry en : taMap.entries()) {
                    if (((String)en.getKey()).equals("ID")) continue;
                    String s = ((String)en.getValue()).replace("\"", "");
                    at.addAnno((String)en.getKey(), s);
                }
            }
            tlb.add(at.build());
        }
        return tlb.build();
    }
}

