/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp.score;

import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.byte3d.Byte3D;
import net.maizegenetics.dna.snp.score.SiteScoreUtil;

public class SiteScore {
    private final GenotypeTable.SITE_SCORE_TYPE myScoreType;
    private final Byte3D myValues;

    SiteScore(Byte3D values, GenotypeTable.SITE_SCORE_TYPE scoreType) {
        this.myScoreType = scoreType;
        this.myValues = values;
    }

    public float siteScore(int taxon, int site, int allele) {
        return SiteScoreUtil.byteToFloatPercentage(this.myValues.valueForAllele(taxon, site, allele));
    }

    public float siteScore(int taxon, int site) {
        return this.siteScore(taxon, site, 0);
    }

    public float[][] siteScores() {
        float[][] result = new float[this.numTaxa()][this.numSites()];
        for (int t = 0; t < this.numTaxa(); ++t) {
            for (int s = 0; s < this.numSites(); ++s) {
                result[t][s] = this.siteScore(t, s, 0);
            }
        }
        return result;
    }

    public GenotypeTable.SITE_SCORE_TYPE siteScoreType() {
        return this.myScoreType;
    }

    public int numTaxa() {
        return this.myValues.numTaxa();
    }

    public int numSites() {
        return this.myValues.numSites();
    }

    public int numAlleles() {
        return this.myValues.numAlleles();
    }
}

