/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import java.io.File;
import net.maizegenetics.dna.tag.AbstractTagsByTaxa;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;

public class TagsByTaxaByte
extends AbstractTagsByTaxa {
    private byte[][] tagDist;

    public TagsByTaxaByte() {
    }

    public TagsByTaxaByte(String infile, TagsByTaxa.FilePacking binary) {
        this.readDistFile(new File(infile), binary);
    }

    public TagsByTaxaByte(String[] taxaNames, Tags theDistinctReads) {
        int i;
        this.taxaNames = (String[])taxaNames.clone();
        this.taxaNum = taxaNames.length;
        int tagNum = theDistinctReads.getTagCount();
        this.tagLengthInLong = theDistinctReads.getTagSizeInLong();
        this.initMatrices(this.taxaNum, tagNum);
        for (i = 0; i < tagNum; ++i) {
            long[] h = theDistinctReads.getTag(i);
            for (int j = 0; j < h.length; ++j) {
                this.tags[j][i] = h[j];
            }
            this.tagLength[i] = (byte)theDistinctReads.getTagLength(i);
        }
        for (i = 0; i < taxaNames.length; ++i) {
            this.taxaNames[i] = taxaNames[i];
        }
    }

    public TagsByTaxaByte(long[][] tags, byte[] tagLength, byte[][] tagDist, String[] namesForTaxa) {
        this.tags = tags;
        this.tagLength = tagLength;
        this.tagDist = tagDist;
        this.taxaNames = namesForTaxa;
        this.taxaNum = namesForTaxa.length;
        this.tagLengthInLong = tags.length;
    }

    public TagsByTaxaByte(long[][] reads, byte[][] readDist, String[] namesForTaxa) {
        this.tags = reads;
        this.tagDist = readDist;
        this.taxaNames = namesForTaxa;
        this.taxaNum = namesForTaxa.length;
    }

    @Override
    public void setReadCountForTagTaxon(int tagIndex, int taxaIndex, int value) {
        this.tagDist[taxaIndex][tagIndex] = value > 127 ? 127 : (value < 0 ? 0 : (int)value);
    }

    @Override
    public int getReadCountForTagTaxon(int tagIndex, int taxaIndex) {
        return this.tagDist[taxaIndex][tagIndex];
    }

    @Override
    public void initMatrices(int taxaNum, int tagNum) {
        this.taxaNames = new String[taxaNum];
        this.tags = new long[this.tagLengthInLong][tagNum];
        this.tagDist = new byte[taxaNum][tagNum];
        this.tagLength = new byte[tagNum];
    }

    @Override
    public void addTaxa(String[] addTaxaNames) {
        this.taxaNum = this.tagDist.length + addTaxaNames.length;
        byte[][] newTagDist = new byte[this.taxaNum][];
        String[] newTaxaNames = new String[this.taxaNum];
        for (int i = 0; i < newTagDist.length; ++i) {
            if (i < this.tagDist.length) {
                newTagDist[i] = this.tagDist[i];
                newTaxaNames[i] = this.taxaNames[i];
                continue;
            }
            newTagDist[i] = new byte[this.getTagCount()];
            newTaxaNames[i] = addTaxaNames[i - this.tagDist.length];
        }
        this.tagDist = newTagDist;
        this.taxaNames = newTaxaNames;
    }

    @Override
    public void setMethodByRows(boolean rowSetMethod) {
        throw new NoSuchMethodError("This method is only implemented in classes that use a RandomAccessFile.");
    }

    @Override
    public void getFileReadyForClosing() {
        throw new NoSuchMethodError("This method is only implemented in classes that use a RandomAccessFile.");
    }
}

