/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import java.util.concurrent.ExecutionException;
import net.maizegenetics.dna.tag.AbstractTagsByTaxa;
import net.maizegenetics.util.HDF5Utils;

public class TagsByTaxaHDF5
extends AbstractTagsByTaxa {
    private final boolean inTaxaChunking;
    private final int tagCount;
    private final IHDF5Reader reader;
    private final BiMap<String, Integer> taxaNameIndexBiMap;
    private LoadingCache<Long, byte[]> taxaCache = null;
    private CacheLoader<Long, byte[]> taxaLoader = new CacheLoader<Long, byte[]>(){

        public byte[] load(Long key) {
            return HDF5Utils.getTagDistBlockForTaxon(TagsByTaxaHDF5.this.reader, TagsByTaxaHDF5.this.getTaxonFromKey(key), TagsByTaxaHDF5.this.getTaxaBlockFromKey(key));
        }
    };
    private LoadingCache<Integer, byte[]> tagCache = null;
    private CacheLoader<Integer, byte[]> tagLoader = new CacheLoader<Integer, byte[]>(){

        public byte[] load(Integer key) {
            return HDF5Utils.getTaxaDistForTag(TagsByTaxaHDF5.this.reader, key);
        }
    };

    public TagsByTaxaHDF5(String infile) {
        this.reader = HDF5Factory.openForReading((String)infile);
        this.tagCount = HDF5Utils.getHDF5TagCount(this.reader);
        this.inTaxaChunking = HDF5Utils.isTagsByTaxaInTaxaDirection(this.reader);
        this.tagLengthInLong = HDF5Utils.getHDF5TagLengthInLong(this.reader);
        this.taxaNum = HDF5Utils.getNumberOfTaxaInTBT(this.reader);
        this.tags = HDF5Utils.getTags(this.reader);
        this.taxaNameIndexBiMap = HDF5Utils.getTBTMapOfRowIndices(this.reader);
        this.taxaList = HDF5Utils.getTaxaListInTBTOrder(this.reader);
        int[] tL = HDF5Utils.getTagLengths(this.reader);
        this.tagLength = new byte[tL.length];
        for (int i = 0; i < this.tagLength.length; ++i) {
            this.tagLength[i] = (byte)tL[i];
        }
        if (this.inTaxaChunking) {
            this.taxaCache = CacheBuilder.newBuilder().maximumSize(1000L).build(this.taxaLoader);
        } else {
            this.tagCache = CacheBuilder.newBuilder().maximumSize(100000L).build(this.tagLoader);
        }
    }

    private long getTaxaCacheKey(int taxonIndex, int tagIndex) {
        return (long)taxonIndex << 32 | (long)(tagIndex / 65536);
    }

    private int getTaxonFromKey(long key) {
        return (int)(key >>> 32);
    }

    private int getTaxaBlockFromKey(long key) {
        return (int)(key << 32 >>> 32);
    }

    private int getOffsetWithinBlock(int tagIndex) {
        return tagIndex % 65536;
    }

    @Override
    public int getIndexOfTaxaName(String taxon) {
        return (Integer)this.taxaNameIndexBiMap.get((Object)taxon);
    }

    @Override
    public int getReadCountForTagTaxon(int tagIndex, int taxaIndex) {
        if (this.inTaxaChunking) {
            return this.getReadForTaxon(taxaIndex, tagIndex);
        }
        return this.getTaxaReadCountsForTag(tagIndex)[taxaIndex];
    }

    public byte[] getReadCountDistributionForTaxon(int taxonIndex) {
        byte[] readsCnts = new byte[this.tagCount];
        for (int i = 0; i < readsCnts.length; ++i) {
            readsCnts[i] = this.getReadForTaxon(i, taxonIndex);
        }
        return readsCnts;
    }

    private byte getReadForTaxon(int tagIndex, int taxonIndex) {
        try {
            return ((byte[])this.taxaCache.get((Object)this.getTaxaCacheKey(taxonIndex, tagIndex)))[this.getOffsetWithinBlock(tagIndex)];
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public byte[] getTaxaReadCountsForTag(int tagIndex) {
        try {
            return (byte[])this.tagCache.get((Object)tagIndex);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setMethodByRows(boolean rowSetMethod) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setReadCountForTagTaxon(int tagIndex, int taxaIndex, int value) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void initMatrices(int taxaNum, int tagNum) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void addTaxa(String[] addTaxaNames) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void getFileReadyForClosing() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getTaxaCount() {
        return this.taxaNum;
    }

    @Override
    public String getTaxaName(int taxaIndex) {
        return (String)this.taxaNameIndexBiMap.inverse().get((Object)taxaIndex);
    }

    @Override
    public String[] getTaxaNames() {
        String[] taxaNames = new String[this.taxaList.size()];
        for (int i = 0; i < this.taxaList.numberOfTaxa(); ++i) {
            taxaNames[i] = this.taxaList.taxaName(i);
        }
        return taxaNames;
    }

    public static enum Chunking {
        Taxa,
        Tags;

    }
}

