/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import com.google.common.collect.BiMap;
import java.io.File;
import net.maizegenetics.dna.tag.Tags;
import net.maizegenetics.dna.tag.TagsByTaxa;
import net.maizegenetics.dna.tag.TagsByTaxaHDF5;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.HDF5Utils;

public class TagsByTaxaHDF5Builder {
    private final TagsByTaxaHDF5.Chunking cnkDir;
    private int tagCount = 0;
    private final IHDF5Writer h5;
    private final BiMap<String, Integer> taxonNameToIndexMap;

    public static final TagsByTaxaHDF5Builder createTaxaIncremental(String newHDF5file, Tags tags) {
        return new TagsByTaxaHDF5Builder(newHDF5file, TagsByTaxaHDF5.Chunking.Taxa, tags, null);
    }

    public static final TagsByTaxaHDF5Builder openTaxaIncremental(String existingHDF5file) {
        return new TagsByTaxaHDF5Builder(existingHDF5file, TagsByTaxaHDF5.Chunking.Taxa, null, null);
    }

    public static final TagsByTaxaHDF5Builder createTagOriented(String newHDF5file, Tags tags, TaxaList taxaList) {
        return new TagsByTaxaHDF5Builder(newHDF5file, TagsByTaxaHDF5.Chunking.Tags, tags, taxaList);
    }

    private TagsByTaxaHDF5Builder(String theHDF5file, TagsByTaxaHDF5.Chunking chunkDirection, Tags tags, TaxaList taxaList) {
        this.cnkDir = chunkDirection;
        this.h5 = HDF5Factory.configure((File)new File(theHDF5file)).useUTF8CharacterEncoding().writer();
        if (tags == null) {
            if (!HDF5Utils.doTagsExist((IHDF5Reader)this.h5)) {
                throw new IllegalStateException("File :" + theHDF5file + " does not have the needed tags" + " to build a TBT file.");
            }
        } else {
            if (!HDF5Utils.doesTaxaModuleExist((IHDF5Reader)this.h5)) {
                HDF5Utils.createHDF5TaxaModule(this.h5);
            }
            HDF5Utils.createHDF5TagModule(this.h5, tags.getTagSizeInLong());
            HDF5Utils.writeHDF5Tags(this.h5, tags);
        }
        this.tagCount = HDF5Utils.getHDF5TagCount((IHDF5Reader)this.h5);
        if (!HDF5Utils.doTagsByTaxaExist((IHDF5Reader)this.h5)) {
            HDF5Utils.createHDF5TagByTaxaDist(this.h5, chunkDirection == TagsByTaxaHDF5.Chunking.Taxa, taxaList);
        }
        this.taxonNameToIndexMap = HDF5Utils.getTBTMapOfRowIndices((IHDF5Reader)this.h5);
    }

    public TagsByTaxaHDF5Builder addTag(long[] tag, byte[] dist) {
        if (this.cnkDir != TagsByTaxaHDF5.Chunking.Tags) {
            throw new IllegalStateException("This builder with these options can only add Tags");
        }
        return this;
    }

    public TagsByTaxa build() {
        this.h5.close();
        return new TagsByTaxaHDF5(this.h5.getFile().getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagsByTaxaHDF5Builder addTaxon(Taxon taxon, byte[] values) {
        if (this.cnkDir != TagsByTaxaHDF5.Chunking.Taxa) {
            throw new IllegalStateException("This builder with these options can only add Taxa");
        }
        IHDF5Writer iHDF5Writer = this.h5;
        synchronized (iHDF5Writer) {
            if (values.length != this.tagCount) {
                System.err.printf("Taxon (%s) does not have the right number of sites (%d)%n", taxon.getName(), values.length);
                throw new IllegalStateException(String.format("Taxon (%s) does not have the right number of sites (%d)%n", taxon.getName(), values.length));
            }
            if (this.taxonNameToIndexMap.containsKey((Object)taxon.getName())) {
                throw new IllegalStateException(String.format("Taxon (%s) already exists in the TBT table, please use replace if this is not an error%n", taxon.getName()));
            }
            int rowIndex = HDF5Utils.addTaxonTagDistribution(this.h5, taxon, values);
            this.taxonNameToIndexMap.put((Object)taxon.getName(), (Object)rowIndex);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagsByTaxaHDF5Builder replaceTaxon(Taxon oldTaxon, Taxon newTaxon, byte[] values) {
        IHDF5Writer iHDF5Writer = this.h5;
        synchronized (iHDF5Writer) {
            return this;
        }
    }
}

