/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.tag;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class UTagPairs {
    int tagLengthInLong;
    long[][] tags;
    byte[] tagLength;
    int[] order;
    Swapper swapper = new Swapper(){

        public void swap(int a, int b) {
            for (int i = 0; i < UTagPairs.this.tagLengthInLong; ++i) {
                long t1 = UTagPairs.this.tags[i][a];
                UTagPairs.this.tags[i][a] = UTagPairs.this.tags[i][b];
                UTagPairs.this.tags[i][b] = t1;
            }
            byte t3 = UTagPairs.this.tagLength[a];
            UTagPairs.this.tagLength[a] = UTagPairs.this.tagLength[b];
            UTagPairs.this.tagLength[b] = t3;
            int t4 = UTagPairs.this.order[a];
            UTagPairs.this.order[a] = UTagPairs.this.order[b];
            UTagPairs.this.order[b] = t4;
        }
    };
    IntComparator compSeq = new IntComparator(){

        public int compare(int a, int b) {
            for (int i = 0; i < UTagPairs.this.tagLengthInLong; ++i) {
                if (UTagPairs.this.tags[i][a] < UTagPairs.this.tags[i][b]) {
                    return -1;
                }
                if (UTagPairs.this.tags[i][a] <= UTagPairs.this.tags[i][b]) continue;
                return 1;
            }
            return 0;
        }
    };
    IntComparator compOrder = new IntComparator(){

        public int compare(int a, int b) {
            return UTagPairs.this.order[a] < UTagPairs.this.order[b] ? -1 : 1;
        }
    };

    public UTagPairs(String infileS) {
        this.readTagPair(infileS);
    }

    public int getTagNum() {
        return this.tags[0].length;
    }

    public byte getTagLength(int index) {
        return this.tagLength[index];
    }

    public long[] getTag(int index) {
        long[] tag = new long[this.tagLengthInLong];
        for (int i = 0; i < tag.length; ++i) {
            tag[i] = this.tags[i][index];
        }
        return tag;
    }

    public void readTagPair(String infileS) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(infileS), 65536));
            int tagNum = dis.readInt();
            this.tagLengthInLong = dis.readInt();
            this.tags = new long[this.tagLengthInLong][tagNum];
            this.tagLength = new byte[tagNum];
            this.order = new int[tagNum];
            for (int i = 0; i < tagNum; ++i) {
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    this.tags[j][i] = dis.readLong();
                }
                this.tagLength[i] = dis.readByte();
                this.order[i] = dis.readInt();
            }
            System.out.println(tagNum / 2 + " TagPairs are read");
        }
        catch (Exception e) {
            System.out.println("Error occurred while reading " + infileS + " " + e.toString());
        }
    }

    public void writeTagPair(String outfileS) {
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfileS), 65536));
            dos.writeInt(this.tags[0].length);
            dos.writeInt(this.tagLengthInLong);
            for (int i = 0; i < this.tags[0].length; ++i) {
                for (int j = 0; j < this.tagLengthInLong; ++j) {
                    dos.writeLong(this.tags[j][i]);
                }
                dos.writeByte(this.tagLength[i]);
                dos.writeInt(this.order[i]);
            }
            dos.flush();
            dos.close();
            System.out.println(this.tags[0].length / 2 + " TagPairs are written");
        }
        catch (Exception e) {
            System.out.println("Error occurred while writing " + outfileS + " " + e.toString());
        }
    }

    public void sortBySeq() {
        GenericSorting.quickSort((int)0, (int)this.tags[0].length, (IntComparator)this.compSeq, (Swapper)this.swapper);
        System.out.println("TagPair is sorted by sequence");
    }

    public void sortByOrder() {
        GenericSorting.quickSort((int)0, (int)this.tags[0].length, (IntComparator)this.compOrder, (Swapper)this.swapper);
        System.out.println("TagPair is sorted by pair order");
    }
}

