/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Component;
import javax.swing.JOptionPane;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.Utils;

public class DialogUtils {
    private DialogUtils() {
    }

    public static void showError(String str, Component parent) {
        JOptionPane.showMessageDialog(parent, str, "Error", 0);
    }

    public static void showError(Throwable e, Component parent) {
        String str = Utils.shortenStrLineLen(ExceptionUtils.getExceptionCauses(e), 50, 7);
        JOptionPane.showMessageDialog(parent, str, "Error", 0);
    }

    public static void showErrorCause(Throwable e, Component parent) {
        Throwable temp = e.getCause();
        if (temp != null) {
            DialogUtils.showError(temp, parent);
        } else {
            DialogUtils.showError(e, parent);
        }
    }
}

