/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.maizegenetics.gui.AbstractAvailableListModel;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class SelectFromAvailableDialog
extends JDialog {
    private static final int LIST_ROW_COUNT = 20;
    private JList<String> myAvailable;
    private JList<String> mySelected;
    private AbstractAvailableListModel myAvailableListModel;
    private SelectedListModel mySelectedListModel;
    private boolean myIsCanceled = false;
    private boolean myIsCaptureSelected = true;

    public SelectFromAvailableDialog(Frame frame, String title, AbstractAvailableListModel availableModel) {
        super(frame, true);
        this.myAvailableListModel = availableModel;
        this.myAvailable = new JList<String>(this.myAvailableListModel);
        this.myAvailable.setPrototypeCellValue("XXXXXXXXXXXXXXXXXXXX");
        this.mySelectedListModel = new SelectedListModel();
        this.mySelected = new JList<String>(this.mySelectedListModel);
        this.mySelected.setPrototypeCellValue("XXXXXXXXXXXXXXXXXXXX");
        this.setTitle(title);
        this.setDefaultCloseOperation(1);
        this.setUndecorated(false);
        this.getRootPane().setWindowDecorationStyle(0);
        Container contentPane = this.getContentPane();
        BoxLayout layout = new BoxLayout(contentPane, 1);
        contentPane.setLayout(layout);
        JPanel whole = new JPanel(new BorderLayout());
        whole.add((Component)this.getMain(), "Center");
        whole.add((Component)this.getBottomPanel(), "South");
        contentPane.add(whole);
        this.pack();
        this.validate();
        this.setResizable(true);
    }

    private JPanel getMain() {
        JPanel result = new JPanel();
        BoxLayout layout = new BoxLayout(result, 0);
        result.setLayout(layout);
        result.add(Box.createRigidArea(new Dimension(15, 1)));
        JPanel available = this.getLabeledListWSearch("Available", this.myAvailable);
        result.add(available);
        result.add(Box.createRigidArea(new Dimension(15, 1)));
        result.add(this.getAddButton());
        result.add(Box.createRigidArea(new Dimension(15, 1)));
        JPanel selected = this.getLabeledList("Selected", this.mySelected);
        result.add(selected);
        result.add(Box.createRigidArea(new Dimension(15, 1)));
        return result;
    }

    private JPanel getLabeledList(String label, JList list) {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.setPreferredSize(new Dimension(150, 200));
        result.add((Component)new JLabel(label), "North");
        list.setVisibleRowCount(20);
        list.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setHorizontalScrollBarPolicy(30);
        result.add((Component)scrollPane, "Center");
        return result;
    }

    private JPanel getLabeledListWSearch(String label, JList list) {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.setPreferredSize(new Dimension(150, 200));
        result.add((Component)new JLabel(label), "North");
        JTextField search = new JTextField();
        CaretListener caret = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                String text = ((JTextField)e.getSource()).getText();
                SelectFromAvailableDialog.this.myAvailableListModel.setShown(text);
            }
        };
        search.addCaretListener(caret);
        result.add((Component)search, "South");
        list.setVisibleRowCount(20);
        list.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setHorizontalScrollBarPolicy(30);
        result.add((Component)scrollPane, "Center");
        return result;
    }

    private JButton getAddButton() {
        JButton result = new JButton("Add ->");
        result.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SelectFromAvailableDialog.this.myAvailable.getSelectedIndices();
                selected = SelectFromAvailableDialog.this.myAvailableListModel.translateToRealIndices(selected);
                int n = selected.length;
                for (int i = 0; i < n; ++i) {
                    SelectFromAvailableDialog.this.mySelectedListModel.add(selected[i]);
                }
            }
        });
        return result;
    }

    private JPanel getBottomPanel() {
        JPanel result = new JPanel(new FlowLayout());
        result.add(this.getSelectedButton());
        result.add(Box.createRigidArea(new Dimension(15, 1)));
        result.add(this.getUnselectedButton());
        result.add(Box.createRigidArea(new Dimension(15, 1)));
        result.add(this.getRemoveButton());
        result.add(Box.createRigidArea(new Dimension(15, 1)));
        result.add(this.getCancelButton());
        return result;
    }

    private JButton getSelectedButton() {
        JButton okButton = new JButton("Capture Selected");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFromAvailableDialog.this.setVisible(false);
                SelectFromAvailableDialog.this.myIsCanceled = false;
                SelectFromAvailableDialog.this.myIsCaptureSelected = true;
            }
        });
        return okButton;
    }

    private JButton getUnselectedButton() {
        JButton okButton = new JButton("Capture Unselected");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFromAvailableDialog.this.setVisible(false);
                SelectFromAvailableDialog.this.myIsCanceled = false;
                SelectFromAvailableDialog.this.myIsCaptureSelected = false;
            }
        });
        return okButton;
    }

    private JButton getCancelButton() {
        JButton okButton = new JButton("Cancel");
        okButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFromAvailableDialog.this.setVisible(false);
                SelectFromAvailableDialog.this.myIsCanceled = true;
            }
        });
        return okButton;
    }

    private JButton getRemoveButton() {
        JButton result = new JButton("Remove");
        result.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = SelectFromAvailableDialog.this.mySelected.getSelectedIndices();
                Arrays.sort(indices);
                for (int i = indices.length - 1; i >= 0; --i) {
                    SelectFromAvailableDialog.this.mySelectedListModel.remove(indices[i]);
                    SelectFromAvailableDialog.this.mySelected.clearSelection();
                }
            }
        });
        return result;
    }

    public boolean isCanceled() {
        return this.myIsCanceled;
    }

    public int[] getDesiredIndices() {
        if (this.myIsCaptureSelected) {
            return this.mySelectedListModel.getBitSet().getIndicesOfSetBits();
        }
        BitSet temp = this.mySelectedListModel.getBitSet();
        temp.flip(0L, this.myAvailableListModel.getRealSize());
        return temp.getIndicesOfSetBits();
    }

    public class SelectedListModel
    extends AbstractListModel<String> {
        private BitSet mySelectedIndices;

        public SelectedListModel() {
            this.mySelectedIndices = new OpenBitSet(SelectFromAvailableDialog.this.myAvailableListModel.getRealSize());
        }

        @Override
        public int getSize() {
            return (int)this.mySelectedIndices.cardinality();
        }

        @Override
        public String getElementAt(int index) {
            return SelectFromAvailableDialog.this.myAvailableListModel.getRealElementAt(this.mySelectedIndices.indexOfNthSetBit(index + 1));
        }

        public void add(int index) {
            this.mySelectedIndices.fastSet(index);
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public void remove(int index) {
            this.mySelectedIndices.fastClear(this.mySelectedIndices.indexOfNthSetBit(index + 1));
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public BitSet getBitSet() {
            return this.mySelectedIndices;
        }
    }
}

