/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import net.maizegenetics.dna.snp.TOPMGenotypeTable;
import net.maizegenetics.gui.AlignmentTableCellRenderer;
import net.maizegenetics.gui.AlignmentTableModel;

public class TOPMGenotypeTableCellRenderer
extends AlignmentTableCellRenderer {
    private static AlignmentTableCellRenderer.RENDERING_TYPE[] SUPPORTED_RENDERING_TYPES = new AlignmentTableCellRenderer.RENDERING_TYPE[]{AlignmentTableCellRenderer.RENDERING_TYPE.Nucleotide, AlignmentTableCellRenderer.RENDERING_TYPE.None, AlignmentTableCellRenderer.RENDERING_TYPE.TOPM, AlignmentTableCellRenderer.RENDERING_TYPE.SNPs};
    private final TOPMGenotypeTable myGenotypeTable;

    public TOPMGenotypeTableCellRenderer(AlignmentTableModel model, TOPMGenotypeTable genotypeTable) {
        super(model, genotypeTable, null);
        this.myGenotypeTable = genotypeTable;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        switch (this.getRenderingType()) {
            case TOPM: {
                return this.getTOPMRendering(table, value, isSelected, hasFocus, row, col);
            }
            case SNPs: {
                return this.getSNPsRendering(table, value, isSelected, hasFocus, row, col);
            }
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
    }

    private Component getTOPMRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setHorizontalAlignment(0);
        if (isSelected) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            comp.setBackground(Color.DARK_GRAY);
            return comp;
        }
        if (this.myGenotypeTable.isSNP(row, this.myAlignmentTableModel.getRealColumnIndex(col))) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            comp.setBackground(Color.GREEN);
            return comp;
        }
        return super.getNucleotideRendering(table, value, isSelected, hasFocus, row, col);
    }

    private Component getSNPsRendering(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setHorizontalAlignment(0);
        if (isSelected) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            comp.setBackground(Color.DARK_GRAY);
            return comp;
        }
        if (this.myGenotypeTable.isSNP(row, this.myAlignmentTableModel.getRealColumnIndex(col))) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            comp.setBackground(Color.GREEN);
            return comp;
        }
        return super.getDefaultRendering(table, value, isSelected, hasFocus, row, col);
    }

    @Override
    public AlignmentTableCellRenderer.RENDERING_TYPE[] getRenderingTypes() {
        return SUPPORTED_RENDERING_TYPES;
    }
}

