/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.Matrix;

import java.util.Arrays;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.decomposition.BlasEigenvalueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.BlasSingularValueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.EigenvalueDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.QRDecomposition;
import net.maizegenetics.matrixalgebra.decomposition.SingularValueDecomposition;
import org.apache.log4j.Logger;

public class BlasDoubleMatrix
implements DoubleMatrix {
    private static Logger myLogger = Logger.getLogger(BlasDoubleMatrix.class);
    protected double[] myMatrix;
    protected int nrows;
    protected int ncols;
    protected int size;

    public static native void multMatrices(double[] var0, int var1, int var2, double[] var3, int var4, int var5, double[] var6, double var7, double var9, boolean var11, boolean var12);

    public static native int solveLSdgelsd(double[] var0, int var1, int var2, double[] var3, int var4, double var5, int[] var7);

    public static native int solveLSdgelsy(double[] var0, int var1, int var2, double[] var3, int var4, double var5, int[] var7);

    public static native int singularValueDecompositionDgesvd(char var0, char var1, int var2, int var3, double[] var4, int var5, double[] var6, double[] var7, int var8, double[] var9, int var10);

    public static native int singularValueDecompositionDgesdd(char var0, int var1, int var2, double[] var3, int var4, double[] var5, double[] var6, int var7, double[] var8, int var9);

    public static native int eigenValueSymmetricDecomposition(int var0, double[] var1, double[] var2, double[] var3);

    public BlasDoubleMatrix() {
    }

    public BlasDoubleMatrix(double[][] values) {
        this.nrows = values.length;
        this.ncols = values[0].length;
        this.size = this.nrows * this.ncols;
        this.myMatrix = new double[this.size];
        int ptr = 0;
        for (int c = 0; c < this.ncols; ++c) {
            for (int r = 0; r < this.nrows; ++r) {
                this.myMatrix[ptr++] = values[r][c];
            }
        }
    }

    public BlasDoubleMatrix(int nrows, int ncols) {
        this.nrows = nrows;
        this.ncols = ncols;
        this.size = nrows * ncols;
        this.myMatrix = new double[this.size];
    }

    public static BlasDoubleMatrix getInstance(int nrows, int ncols, double[] values, boolean columnMajor) {
        if (columnMajor) {
            BlasDoubleMatrix bdm = new BlasDoubleMatrix();
            bdm.nrows = nrows;
            bdm.ncols = ncols;
            bdm.myMatrix = values;
            bdm.size = nrows * ncols;
            return bdm;
        }
        BlasDoubleMatrix bdm = new BlasDoubleMatrix();
        bdm.nrows = ncols;
        bdm.ncols = nrows;
        bdm.myMatrix = values;
        bdm.size = nrows * ncols;
        return (BlasDoubleMatrix)bdm.transpose();
    }

    public static BlasDoubleMatrix getInstance(int nrows, int ncols, double dblValue) {
        BlasDoubleMatrix bdm = new BlasDoubleMatrix(nrows, ncols);
        Arrays.fill(bdm.myMatrix, dblValue);
        return bdm;
    }

    @Override
    public double get(int row, int col) {
        return this.myMatrix[this.getIndex(row, col)];
    }

    @Override
    public double getChecked(int row, int col) {
        if (row < this.nrows && col < this.ncols) {
            return this.myMatrix[this.getIndex(row, col)];
        }
        return Double.NaN;
    }

    @Override
    public void set(int row, int col, double value) {
        this.myMatrix[this.getIndex((int)row, (int)col)] = value;
    }

    @Override
    public void setChecked(int row, int col, double value) {
        if (row < this.nrows && col < this.ncols) {
            this.myMatrix[this.getIndex((int)row, (int)col)] = value;
        }
    }

    @Override
    public DoubleMatrix transpose() {
        BlasDoubleMatrix bdm;
        if (this.nrows > 1 && this.ncols > 1) {
            bdm = new BlasDoubleMatrix(this.ncols, this.nrows);
            int ptr = 0;
            for (int i = 0; i < this.size; ++i) {
                bdm.myMatrix[ptr] = this.myMatrix[i];
                if ((ptr += bdm.nrows) < this.size) continue;
                ptr -= this.size - 1;
            }
        } else {
            bdm = (BlasDoubleMatrix)this.copy();
            bdm.nrows = this.ncols;
            bdm.ncols = this.nrows;
        }
        return bdm;
    }

    public void transposeInPlace() {
        BlasDoubleMatrix bdm = (BlasDoubleMatrix)this.transpose();
        this.ncols = bdm.ncols;
        this.nrows = bdm.nrows;
        this.myMatrix = bdm.myMatrix;
    }

    @Override
    public DoubleMatrix mult(DoubleMatrix dm, boolean transpose, boolean transposedm) {
        BlasDoubleMatrix B = (BlasDoubleMatrix)dm;
        BlasDoubleMatrix C = new BlasDoubleMatrix();
        C.nrows = transpose ? this.ncols : this.nrows;
        C.ncols = transposedm ? B.nrows : B.ncols;
        C.size = C.nrows * C.ncols;
        C.myMatrix = new double[C.size];
        BlasDoubleMatrix.multMatrices(this.myMatrix, this.nrows, this.ncols, B.myMatrix, B.nrows, B.ncols, C.myMatrix, 1.0, 0.0, transpose, transposedm);
        return C;
    }

    @Override
    public DoubleMatrix multadd(DoubleMatrix A, DoubleMatrix B, double alpha, double beta, boolean transpose, boolean transposeA) {
        BlasDoubleMatrix D;
        BlasDoubleMatrix C = (BlasDoubleMatrix)A;
        if (B == null) {
            int drows = transpose ? this.ncols : this.nrows;
            int dcols = transposeA ? C.nrows : C.ncols;
            D = new BlasDoubleMatrix(drows, dcols);
        } else {
            D = (BlasDoubleMatrix)B.copy();
        }
        BlasDoubleMatrix.multMatrices(this.myMatrix, this.nrows, this.ncols, C.myMatrix, C.nrows, C.ncols, D.myMatrix, alpha, beta, transpose, transposeA);
        return D;
    }

    @Override
    public DoubleMatrix mult(DoubleMatrix dm) {
        return this.mult(dm, false, false);
    }

    @Override
    public DoubleMatrix crossproduct() {
        return this.mult(this, true, false);
    }

    @Override
    public DoubleMatrix crossproduct(DoubleMatrix dm) {
        return this.mult(dm, true, false);
    }

    @Override
    public DoubleMatrix tcrossproduct() {
        return this.mult(this, false, true);
    }

    @Override
    public DoubleMatrix tcrossproduct(DoubleMatrix dm) {
        return this.mult(dm, false, true);
    }

    @Override
    public DoubleMatrix concatenate(DoubleMatrix dm, boolean rows) {
        BlasDoubleMatrix B = (BlasDoubleMatrix)dm;
        BlasDoubleMatrix bdm = new BlasDoubleMatrix();
        bdm.size = this.size + B.size;
        bdm.myMatrix = new double[bdm.size];
        if (rows & this.ncols == B.ncols) {
            bdm.nrows = this.nrows + B.nrows;
            bdm.ncols = this.ncols;
            int myptr = 0;
            int Bptr = 0;
            int bdmptr = 0;
            for (int c = 0; c < this.ncols; ++c) {
                System.arraycopy(this.myMatrix, myptr, bdm.myMatrix, bdmptr, this.nrows);
                myptr += this.nrows;
                System.arraycopy(B.myMatrix, Bptr, bdm.myMatrix, bdmptr += this.nrows, B.nrows);
                bdmptr += B.nrows;
                Bptr += B.nrows;
            }
        } else if (this.nrows == B.nrows) {
            bdm.nrows = this.nrows;
            bdm.ncols = this.ncols + B.ncols;
            System.arraycopy(this.myMatrix, 0, bdm.myMatrix, 0, this.size);
            System.arraycopy(B.myMatrix, 0, bdm.myMatrix, this.size, B.size);
        }
        return bdm;
    }

    @Override
    public DoubleMatrix inverse() {
        return this.generalizedInverse();
    }

    @Override
    public void invert() {
        BlasDoubleMatrix inv = (BlasDoubleMatrix)this.generalizedInverseWithRank(new int[]{0});
        this.myMatrix = inv.myMatrix;
    }

    @Override
    public DoubleMatrix generalizedInverse() {
        return this.generalizedInverseWithRank(new int[]{0});
    }

    @Override
    public DoubleMatrix generalizedInverseWithRank(int[] rank) {
        BlasDoubleMatrix B = BlasDoubleMatrix.getIdentityMatrix(this.nrows);
        int info = BlasDoubleMatrix.solveLSdgelsd(Arrays.copyOf(this.myMatrix, this.size), this.nrows, this.ncols, B.myMatrix, B.ncols, 1.0E-10, rank);
        if (info == 0) {
            return B;
        }
        myLogger.error((Object)String.format("inverse failed in BlasDoubleMatrix, info = %d\n", info));
        return null;
    }

    @Override
    public DoubleMatrix solve(DoubleMatrix Y) {
        BlasDoubleMatrix bdy = (BlasDoubleMatrix)Y.copy();
        int[] rank = new int[]{0};
        int info = BlasDoubleMatrix.solveLSdgelsd(this.myMatrix, this.nrows, this.ncols, bdy.myMatrix, bdy.ncols, 1.0E-10, rank);
        if (info == 0) {
            return bdy;
        }
        myLogger.error((Object)String.format("solve failed in BlasDoubleMatrix, info = %d\n", info));
        return null;
    }

    @Override
    public int numberOfRows() {
        return this.nrows;
    }

    @Override
    public int numberOfColumns() {
        return this.ncols;
    }

    @Override
    public DoubleMatrix row(int i) {
        if (i >= this.nrows) {
            return null;
        }
        BlasDoubleMatrix bdm = new BlasDoubleMatrix();
        bdm.nrows = this.ncols;
        bdm.ncols = 1;
        bdm.size = this.ncols;
        bdm.myMatrix = new double[this.ncols];
        int bdmptr = 0;
        for (int myptr = i; myptr < this.size; myptr += this.nrows) {
            bdm.myMatrix[bdmptr++] = this.myMatrix[myptr];
        }
        return bdm;
    }

    @Override
    public DoubleMatrix column(int j) {
        if (j >= this.ncols) {
            return null;
        }
        BlasDoubleMatrix bdm = new BlasDoubleMatrix();
        bdm.nrows = this.nrows;
        bdm.ncols = 1;
        bdm.size = this.nrows;
        int start = j * this.nrows;
        int end = start + this.nrows;
        bdm.myMatrix = Arrays.copyOfRange(this.myMatrix, start, end);
        return bdm;
    }

    @Override
    public DoubleMatrix[] getXtXGM() {
        DoubleMatrix xtx = this.crossproduct();
        DoubleMatrix g = xtx.inverse();
        BlasDoubleMatrix xg = (BlasDoubleMatrix)this.mult(g);
        BlasDoubleMatrix m = BlasDoubleMatrix.getIdentityMatrix(this.nrows);
        BlasDoubleMatrix.multMatrices(xg.myMatrix, xg.nrows, xg.ncols, this.myMatrix, this.nrows, this.ncols, m.myMatrix, -1.0, 1.0, false, true);
        return new DoubleMatrix[]{xtx, g, m};
    }

    @Override
    public DoubleMatrix copy() {
        BlasDoubleMatrix bdm = new BlasDoubleMatrix();
        bdm.myMatrix = Arrays.copyOf(this.myMatrix, this.size);
        bdm.ncols = this.ncols;
        bdm.nrows = this.nrows;
        bdm.size = this.size;
        return bdm;
    }

    @Override
    public EigenvalueDecomposition getEigenvalueDecomposition() {
        return new BlasEigenvalueDecomposition(this);
    }

    @Override
    public SingularValueDecomposition getSingularValueDecomposition() {
        return new BlasSingularValueDecomposition(this);
    }

    @Override
    public QRDecomposition getQRDecomposition() {
        return null;
    }

    @Override
    public DoubleMatrix minus(DoubleMatrix dm) {
        BlasDoubleMatrix A = (BlasDoubleMatrix)this.copy();
        A.minusEquals(dm);
        return A;
    }

    @Override
    public void minusEquals(DoubleMatrix dm) {
        BlasDoubleMatrix bdm = (BlasDoubleMatrix)dm;
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.myMatrix[n] = this.myMatrix[n] - bdm.myMatrix[i];
        }
    }

    @Override
    public DoubleMatrix plus(DoubleMatrix dm) {
        BlasDoubleMatrix A = (BlasDoubleMatrix)this.copy();
        A.plusEquals(dm);
        return A;
    }

    @Override
    public void plusEquals(DoubleMatrix dm) {
        BlasDoubleMatrix bdm = (BlasDoubleMatrix)dm;
        for (int i = 0; i < this.size; ++i) {
            int n = i;
            this.myMatrix[n] = this.myMatrix[n] + bdm.myMatrix[i];
        }
    }

    @Override
    public DoubleMatrix scalarAdd(double s) {
        BlasDoubleMatrix A = (BlasDoubleMatrix)this.copy();
        A.scalarAddEquals(s);
        return A;
    }

    @Override
    public void scalarAddEquals(double s) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.myMatrix[n] = this.myMatrix[n] + s;
        }
    }

    @Override
    public DoubleMatrix scalarMult(double s) {
        BlasDoubleMatrix A = (BlasDoubleMatrix)this.copy();
        A.scalarMultEquals(s);
        return A;
    }

    @Override
    public void scalarMultEquals(double s) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.myMatrix[n] = this.myMatrix[n] * s;
        }
    }

    @Override
    public DoubleMatrix getSelection(int[] rows, int[] columns) {
        BlasDoubleMatrix bdm = new BlasDoubleMatrix();
        bdm.nrows = rows == null ? this.nrows : rows.length;
        bdm.ncols = columns == null ? this.ncols : columns.length;
        bdm.size = bdm.nrows * bdm.ncols;
        bdm.myMatrix = BlasDoubleMatrix.getSelectionFromDoubleArray(this.myMatrix, this.nrows, this.ncols, rows, columns);
        return bdm;
    }

    public static double[] getSelectionFromDoubleArray(double[] original, int nrows, int ncols, int[] rows, int[] columns) {
        double[] selectedArray;
        if (rows == null && columns == null) {
            return Arrays.copyOf(original, original.length);
        }
        if (rows == null) {
            int numberOfSelectedRows = nrows;
            int numberOfSelectedColumns = columns.length;
            selectedArray = new double[numberOfSelectedRows * numberOfSelectedColumns];
            int ptr = 0;
            int myptr = 0;
            for (int c : columns) {
                int colstart = c * nrows;
                for (int r = 0; r < nrows; ++r) {
                    myptr = colstart + r;
                    selectedArray[ptr++] = original[myptr];
                }
            }
        } else if (columns == null) {
            int numberOfSelectedRows = rows.length;
            int numberOfSelectedColumns = ncols;
            selectedArray = new double[numberOfSelectedRows * numberOfSelectedColumns];
            int ptr = 0;
            int myptr = 0;
            for (int c = 0; c < ncols; ++c) {
                int colstart = c * nrows;
                for (int r : rows) {
                    myptr = colstart + r;
                    selectedArray[ptr++] = original[myptr];
                }
            }
        } else {
            int numberOfSelectedRows = rows.length;
            int numberOfSelectedColumns = columns.length;
            selectedArray = new double[numberOfSelectedRows * numberOfSelectedColumns];
            int ptr = 0;
            int myptr = 0;
            for (int c : columns) {
                int colstart = c * nrows;
                for (int r : rows) {
                    myptr = colstart + r;
                    selectedArray[ptr++] = original[myptr];
                }
            }
        }
        return selectedArray;
    }

    @Override
    public double rowSum(int row) {
        double sum = 0.0;
        int ptr = row;
        for (int c = 0; c < this.ncols; ++c) {
            sum += this.myMatrix[ptr];
            ptr += this.nrows;
        }
        return sum;
    }

    @Override
    public double columnSum(int column) {
        double sum = 0.0;
        int start = column * this.nrows;
        int end = start + this.nrows;
        for (int ptr = start; ptr < end; ++ptr) {
            sum += this.myMatrix[ptr];
        }
        return sum;
    }

    @Override
    public int columnRank() {
        BlasSingularValueDecomposition svd = new BlasSingularValueDecomposition(this, 'N');
        return svd.getRank();
    }

    public double[] getMatrix() {
        return this.myMatrix;
    }

    public double[] getMatrixCopy() {
        return Arrays.copyOf(this.myMatrix, this.size);
    }

    public int getSize() {
        return this.size;
    }

    public static BlasDoubleMatrix getDiagonalMatrix(double[] diag) {
        int dim;
        BlasDoubleMatrix bdm = new BlasDoubleMatrix();
        bdm.nrows = bdm.ncols = (dim = diag.length);
        bdm.size = bdm.nrows * bdm.ncols;
        bdm.myMatrix = new double[bdm.size];
        int ptr = 0;
        for (int i = 0; i < bdm.size; i += dim + 1) {
            bdm.myMatrix[i] = diag[ptr++];
        }
        return bdm;
    }

    private int getIndex(int row, int col) {
        return col * this.nrows + row;
    }

    public static BlasDoubleMatrix getIdentityMatrix(int dim) {
        BlasDoubleMatrix bdm = new BlasDoubleMatrix();
        bdm.nrows = bdm.ncols = dim;
        bdm.size = dim * dim;
        bdm.myMatrix = new double[bdm.size];
        for (int i = 0; i < bdm.size; i += dim + 1) {
            bdm.myMatrix[i] = 1.0;
        }
        return bdm;
    }

    public static DoubleMatrix compose(DoubleMatrix[][] input) {
        int nr = input.length;
        int nc = input[0].length;
        int[] numberOfColumns = new int[nc];
        int[] numberOfRows = new int[nr];
        int totalrows = 0;
        int totalcols = 0;
        for (int r = 0; r < nr; ++r) {
            numberOfRows[r] = input[r][0].numberOfRows();
            totalrows += numberOfRows[r];
        }
        for (int c = 0; c < nc; ++c) {
            numberOfColumns[c] = input[0][c].numberOfColumns();
            totalcols += numberOfColumns[c];
        }
        BlasDoubleMatrix[][] matrices = new BlasDoubleMatrix[nr][nc];
        for (int r = 0; r < nr; ++r) {
            for (int c = 0; c < nc; ++c) {
                if (input[r][c].numberOfRows() != numberOfRows[r] || input[r][c].numberOfColumns() != numberOfColumns[c]) {
                    throw new IllegalArgumentException("Incongruent matrices input to BlasDoubleMatrix.compose");
                }
                matrices[r][c] = (BlasDoubleMatrix)input[r][c];
            }
        }
        int resultSize = totalrows * totalcols;
        double[] result = new double[resultSize];
        int ptr0 = 0;
        for (int c = 0; c < nc; ++c) {
            int nc2 = numberOfColumns[c];
            int ptr1 = 0;
            for (int r = 0; r < nr; ++r) {
                int srcptr = 0;
                int destptr = ptr0 + ptr1;
                for (int c2 = 0; c2 < nc2; ++c2) {
                    System.arraycopy(matrices[r][c].myMatrix, srcptr, result, destptr, numberOfRows[r]);
                    srcptr += numberOfRows[r];
                    destptr += totalrows;
                }
                ptr1 += numberOfRows[r];
            }
            ptr0 += totalrows * numberOfColumns[c];
        }
        return BlasDoubleMatrix.getInstance(totalrows, totalcols, result, true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int maxrow = Math.min(20, this.nrows);
        int maxcol = Math.min(20, this.ncols);
        for (int r = 0; r < maxrow; ++r) {
            sb.append(this.get(r, 0));
            for (int c = 1; c < maxcol; ++c) {
                sb.append(" ").append(this.get(r, c));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

