/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.matrixalgebra.decomposition;

import net.maizegenetics.matrixalgebra.Matrix.BlasDoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.decomposition.SingularValueDecomposition;
import org.apache.log4j.Logger;

public class BlasSingularValueDecomposition
implements SingularValueDecomposition {
    private BlasDoubleMatrix bdS = null;
    private BlasDoubleMatrix bdU = null;
    private BlasDoubleMatrix bdVT = null;
    public boolean successful = false;
    private static final Logger myLogger = Logger.getLogger(BlasSingularValueDecomposition.class);
    private double tol = 1.0E-12;

    public BlasSingularValueDecomposition(BlasDoubleMatrix bdm, char jobz) {
        int ldvt;
        double[] VT;
        int ldu;
        double[] U;
        int nrows = bdm.numberOfRows();
        int ncols = bdm.numberOfColumns();
        int ns = Math.min(nrows, ncols);
        double[] A = bdm.getMatrixCopy();
        double[] S = new double[ns];
        int usize = nrows * nrows;
        int lda = nrows;
        if (jobz == 'N' || jobz == 'O' & nrows >= ncols) {
            U = new double[]{0.0};
            ldu = 1;
        } else {
            U = new double[usize];
            ldu = nrows;
        }
        int vtsize = ncols * ncols;
        if (jobz == 'N' || jobz == 'O' & nrows < ncols) {
            VT = new double[]{0.0};
            ldvt = 1;
        } else {
            VT = new double[vtsize];
            ldvt = ncols;
        }
        int result = BlasDoubleMatrix.singularValueDecompositionDgesdd(jobz, nrows, ncols, A, lda, S, U, ldu, VT, ldvt);
        if (result == 0) {
            this.successful = true;
            this.bdS = BlasDoubleMatrix.getInstance(ns, 1, S, true);
            if (jobz == 'A') {
                this.bdU = BlasDoubleMatrix.getInstance(nrows, nrows, U, true);
                this.bdVT = BlasDoubleMatrix.getInstance(ncols, ncols, VT, true);
            } else if (jobz == 'S') {
                if (nrows < ncols) {
                    this.bdU = BlasDoubleMatrix.getInstance(nrows, nrows, U, true);
                    int[] selection = new int[nrows];
                    for (int i = 0; i < nrows; ++i) {
                        selection[i] = i;
                    }
                    double[] subvt = BlasDoubleMatrix.getSelectionFromDoubleArray(VT, ncols, ncols, selection, null);
                    this.bdVT = BlasDoubleMatrix.getInstance(nrows, ncols, subvt, true);
                } else if (nrows > ncols) {
                    int[] selection = new int[ncols];
                    for (int i = 0; i < ncols; ++i) {
                        selection[i] = i;
                    }
                    double[] subu = BlasDoubleMatrix.getSelectionFromDoubleArray(U, nrows, nrows, null, selection);
                    this.bdU = BlasDoubleMatrix.getInstance(nrows, ncols, subu, true);
                    this.bdVT = BlasDoubleMatrix.getInstance(ncols, ncols, VT, true);
                } else {
                    this.bdU = BlasDoubleMatrix.getInstance(nrows, nrows, U, true);
                    this.bdVT = BlasDoubleMatrix.getInstance(ncols, ncols, VT, true);
                }
            } else if (jobz == 'O') {
                if (nrows >= ncols) {
                    this.bdVT = BlasDoubleMatrix.getInstance(ncols, ncols, VT, true);
                    int[] selection = new int[ncols];
                    for (int i = 0; i < ncols; ++i) {
                        selection[i] = i;
                    }
                    U = BlasDoubleMatrix.getSelectionFromDoubleArray(A, nrows, ncols, null, selection);
                    this.bdU = BlasDoubleMatrix.getInstance(nrows, ncols, U, true);
                } else {
                    this.bdU = BlasDoubleMatrix.getInstance(nrows, nrows, U, true);
                    int[] selection = new int[nrows];
                    for (int i = 0; i < nrows; ++i) {
                        selection[i] = i;
                    }
                    VT = BlasDoubleMatrix.getSelectionFromDoubleArray(A, nrows, ncols, selection, null);
                    this.bdVT = BlasDoubleMatrix.getInstance(nrows, ncols, VT, true);
                }
            }
        } else {
            myLogger.error((Object)("BlasSVD failed with a return value of " + result));
        }
    }

    public BlasSingularValueDecomposition(BlasDoubleMatrix bdm) {
        this(bdm, 'O');
    }

    @Override
    public DoubleMatrix getU(boolean transpose) {
        if (transpose) {
            return this.bdU.transpose();
        }
        return this.bdU;
    }

    @Override
    public DoubleMatrix getV(boolean transpose) {
        if (transpose) {
            return this.bdVT;
        }
        return this.bdVT.transpose();
    }

    @Override
    public DoubleMatrix getS() {
        return this.bdS;
    }

    @Override
    public double[] getSingularValues() {
        return this.bdS.getMatrix();
    }

    @Override
    public int getRank() {
        int rank = 0;
        double[] sv = this.bdS.getMatrix();
        int n = sv.length;
        for (int i = 0; i < n; ++i) {
            if (!(sv[i] > this.tol)) continue;
            ++rank;
        }
        return rank;
    }

    public double getTolerance() {
        return this.tol;
    }

    public void setTolerance(double tolerance) {
        this.tol = tolerance;
    }

    public boolean wasSuccessful() {
        return this.successful;
    }
}

