/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.phenotype;

import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import net.maizegenetics.phenotype.CorePhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.TableReport;

public class FilterPhenotype
implements Phenotype,
TableReport {
    private int[] myRowRedirect;
    private int numberOfObservations;
    private List<Phenotype.ATTRIBUTE_TYPE> attributeTypeList;
    private Multimap<Phenotype.ATTRIBUTE_TYPE, Integer> attributeTypeMap;
    private CorePhenotype basePhenotype;
    private String name;

    FilterPhenotype(CorePhenotype basePheno, List<Taxon> taxaToKeep, String name) {
        this.name = name;
    }

    FilterPhenotype(FilterPhenotype basePheno, List<Taxon> taxaToKeep, String name) {
        this.name = name;
    }

    @Override
    public Object[] getTableColumnNames() {
        return this.basePhenotype.getTableColumnNames();
    }

    @Override
    public Object[][] getTableData() {
        Object[][] tableData = new Object[this.numberOfObservations][];
        for (int i = 0; i < this.numberOfObservations; ++i) {
            tableData[i] = this.basePhenotype.getRow(this.myRowRedirect[i]);
        }
        return null;
    }

    @Override
    public String getTableTitle() {
        return this.name;
    }

    @Override
    public int getColumnCount() {
        return this.basePhenotype.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.numberOfObservations;
    }

    @Override
    public int getElementCount() {
        return this.getRowCount() * this.getColumnCount();
    }

    @Override
    public Object[] getRow(int row) {
        return this.basePhenotype.getRow(this.myRowRedirect[row]);
    }

    @Override
    public Object[][] getTableData(int start, int end) {
        int numberOfRows = end - start + 1;
        Object[][] tableData = new Object[numberOfRows][];
        for (int i = 0; i < numberOfRows; ++i) {
            tableData[i] = this.basePhenotype.getRow(i + start);
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.basePhenotype.getValueAt(this.myRowRedirect[row], col);
    }

    @Override
    public Object value(int obs, int attrnum) {
        return this.basePhenotype.value(this.myRowRedirect[obs], attrnum);
    }

    @Override
    public boolean isMissing(int obs, int attrnum) {
        return this.basePhenotype.isMissing(this.myRowRedirect[obs], attrnum);
    }

    @Override
    public PhenotypeAttribute attribute(int attrnum) {
        return this.basePhenotype.attribute(attrnum).subset(this.myRowRedirect);
    }

    @Override
    public int numberOfAttributes() {
        return this.basePhenotype.numberOfAttributes;
    }

    @Override
    public int numberOfObservations() {
        return this.numberOfObservations;
    }

    @Override
    public TaxaList taxa() {
        if (!this.basePhenotype.hasTaxaAttribute()) {
            return null;
        }
        Taxon[] taxaArray = this.basePhenotype.taxaAttribute().allTaxa();
        TreeSet<Taxon> taxaSet = new TreeSet<Taxon>();
        for (int ndx : this.myRowRedirect) {
            taxaSet.add(taxaArray[ndx]);
        }
        return new TaxaListBuilder().addAll(taxaSet).build();
    }

    @Override
    public int numberOfAttributesOfType(Phenotype.ATTRIBUTE_TYPE type) {
        return this.attributeTypeMap.get((Object)type).size();
    }

    @Override
    public int[] attributeIndicesOfType(Phenotype.ATTRIBUTE_TYPE type) {
        return Ints.toArray((Collection)this.attributeTypeMap.get((Object)type));
    }

    @Override
    public Phenotype.ATTRIBUTE_TYPE attributeType(int attrnum) {
        return this.attributeTypeList.get(attrnum);
    }

    @Override
    public void setAttributeType(int attrnum, Phenotype.ATTRIBUTE_TYPE type) {
        Phenotype.ATTRIBUTE_TYPE oldType = this.attributeTypeList.get(attrnum);
        this.attributeTypeList.set(attrnum, type);
        this.attributeTypeMap.remove((Object)oldType, (Object)attrnum);
        this.attributeTypeMap.put((Object)type, (Object)attrnum);
    }

    @Override
    public String attributeName(int attrnum) {
        return this.basePhenotype.attributeName(attrnum);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean hasTaxaAttribute() {
        return this.basePhenotype.hasTaxaAttribute();
    }

    @Override
    public TaxaAttribute taxaAttribute() {
        return (TaxaAttribute)this.basePhenotype.taxaAttribute().subset(this.myRowRedirect);
    }
}

