/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.pipeline;

import java.awt.Frame;
import java.io.BufferedReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.maizegenetics.analysis.association.FixedEffectLMPlugin;
import net.maizegenetics.analysis.association.MLMPlugin;
import net.maizegenetics.analysis.association.RidgeRegressionEmmaPlugin;
import net.maizegenetics.analysis.chart.AbstractDisplayPlugin;
import net.maizegenetics.analysis.chart.TableDisplayPlugin;
import net.maizegenetics.analysis.data.CombineDataSetsPlugin;
import net.maizegenetics.analysis.data.ConvertAlignmentCoordinatesPlugin;
import net.maizegenetics.analysis.data.ExportMultiplePlugin;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.analysis.data.GenotypeSummaryPlugin;
import net.maizegenetics.analysis.data.HetsToUnknownPlugin;
import net.maizegenetics.analysis.data.IntersectionAlignmentPlugin;
import net.maizegenetics.analysis.data.MergeAlignmentsSameSitesPlugin;
import net.maizegenetics.analysis.data.MergeGenotypeTablesPlugin;
import net.maizegenetics.analysis.data.PlinkLoadPlugin;
import net.maizegenetics.analysis.data.SeparatePlugin;
import net.maizegenetics.analysis.data.SynonymizerPlugin;
import net.maizegenetics.analysis.data.UnionAlignmentPlugin;
import net.maizegenetics.analysis.distance.DistanceMatrixPlugin;
import net.maizegenetics.analysis.distance.DistanceMatrixRangesPlugin;
import net.maizegenetics.analysis.distance.KinshipPlugin;
import net.maizegenetics.analysis.filter.FilterAlignmentPlugin;
import net.maizegenetics.analysis.filter.FilterSiteNamePlugin;
import net.maizegenetics.analysis.filter.FilterSubsetPlugin;
import net.maizegenetics.analysis.filter.FilterTaxaAlignmentPlugin;
import net.maizegenetics.analysis.filter.FilterTraitsPlugin;
import net.maizegenetics.analysis.numericaltransform.NumericalGenotypePlugin;
import net.maizegenetics.analysis.popgen.LinkageDiseqDisplayPlugin;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;
import net.maizegenetics.analysis.popgen.LinkageDisequilibriumPlugin;
import net.maizegenetics.analysis.popgen.SequenceDiversityPlugin;
import net.maizegenetics.analysis.tree.CreateTreePlugin;
import net.maizegenetics.dna.map.TagsOnPhysMapHDF5;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.snp.io.BuilderFromHapMap;
import net.maizegenetics.pipeline.TasselPipelineXMLUtil;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import net.maizegenetics.plugindef.PluginListener;
import net.maizegenetics.plugindef.ThreadedPluginListener;
import net.maizegenetics.prefs.TasselPrefs;
import net.maizegenetics.progress.ProgressPanel;
import net.maizegenetics.tassel.TASSELMainFrame;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.ExceptionUtils;
import net.maizegenetics.util.LoggingUtils;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TasselPipeline
implements PluginListener {
    private static final Logger myLogger = Logger.getLogger(TasselPipeline.class);
    private final TASSELMainFrame myMainFrame;
    private final Map<String, List> myForks = new LinkedHashMap<String, List>();
    private String myCurrentFork = null;
    private List<Plugin> myCurrentPipe = null;
    private Plugin myFirstPlugin = null;
    private final List<ThreadedPluginListener> myThreads = new ArrayList<ThreadedPluginListener>();
    private final Map<Plugin, Integer> myProgressValues = new HashMap<Plugin, Integer>();

    public TasselPipeline(String[] args, TASSELMainFrame frame) {
        this.myMainFrame = frame;
        LoggingUtils.setupLogging();
        try {
            ProgressPanel progressPanel;
            if (args.length == 1 && args[0].equalsIgnoreCase("-versionComment")) {
                System.out.println("Version 5.0.7 on June 5, 2014");
                return;
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("-versionTag")) {
                System.out.println("V5.0.7");
                return;
            }
            myLogger.info((Object)"Tassel Version: 5.0.7  Date: June 5, 2014");
            myLogger.info((Object)("Max Available Memory Reported by JVM: " + Utils.getMaxHeapSizeMB() + " MB"));
            myLogger.info((Object)("Java Version: " + System.getProperty("java.version")));
            this.parseArgs(args);
            if (this.myMainFrame != null && (progressPanel = this.myMainFrame.getProgressPanel()) != null) {
                for (String key : this.myForks.keySet()) {
                    List current = this.myForks.get(key);
                    progressPanel.addPipelineSegment(current);
                }
            }
            for (int i = 0; i < this.myThreads.size(); ++i) {
                ThreadedPluginListener current = this.myThreads.get(i);
                current.start();
            }
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        if (args.length >= 2 && args[0].equalsIgnoreCase("-createXML")) {
            String xmlFilename = args[1].trim();
            String[] temp = new String[args.length - 2];
            System.arraycopy(args, 2, temp, 0, temp.length);
            temp = TasselPipeline.addForkFlagsIfNeeded(temp);
            TasselPipelineXMLUtil.writeArgsAsXML(xmlFilename, temp);
        } else if (args.length >= 2 && args[0].equalsIgnoreCase("-translateXML")) {
            String xmlFilename = args[1].trim();
            String[] result = TasselPipelineXMLUtil.readXMLAsArgs(xmlFilename);
            for (int i = 0; i < result.length; ++i) {
                System.out.print(result[i]);
                System.out.print(" ");
            }
            System.out.println("");
        } else {
            TasselPrefs.setPersistPreferences(false);
            new TasselPipeline(args, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseArgs(String[] args) {
        if (args.length >= 2 && args[0].equalsIgnoreCase("-configFile")) {
            String xmlFilename = args[1].trim();
            args = TasselPipelineXMLUtil.readXMLAsArgs(xmlFilename);
        }
        args = TasselPipeline.addForkFlagsIfNeeded(args);
        int index = 0;
        while (index < args.length) {
            try {
                Taxon[] ids;
                int i;
                String inputline;
                Plugin plugin;
                String file;
                String hapFile;
                String key;
                String current = args[index++];
                String emDash = "\u2014";
                current = current.replaceFirst(emDash, "-");
                if (!current.startsWith("-")) {
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: expecting argument beginning with dash: " + current);
                }
                if (current.startsWith("-runfork")) {
                    key = current.replaceFirst("-runfork", "-fork");
                    List specifiedPipe = this.myForks.get(key);
                    if (specifiedPipe == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: unknown fork: " + current);
                    }
                    if (specifiedPipe.size() == 0) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: empty fork: " + current);
                    }
                    PluginEvent event = new PluginEvent(new DataSet((Datum)null, null));
                    ThreadedPluginListener thread = new ThreadedPluginListener((Plugin)specifiedPipe.get(0), event);
                    this.myThreads.add(thread);
                    continue;
                }
                if (current.startsWith("-fork")) {
                    if (this.myCurrentPipe != null && this.myCurrentPipe.size() != 0) {
                        this.myCurrentPipe.get(this.myCurrentPipe.size() - 1).setThreaded(true);
                    }
                    this.myCurrentFork = current;
                    this.myCurrentPipe = new ArrayList<Plugin>();
                    this.myForks.put(this.myCurrentFork, this.myCurrentPipe);
                    continue;
                }
                if (current.startsWith("-input")) {
                    key = current.replaceFirst("-input", "-fork");
                    List specifiedPipe = this.myForks.get(key);
                    if (specifiedPipe == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: unknown input: " + current);
                    }
                    Plugin lastCurrentPipe = null;
                    try {
                        lastCurrentPipe = this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -input must come after plugin in current fork.");
                    }
                    Plugin endSpecifiedPipe = (Plugin)specifiedPipe.get(specifiedPipe.size() - 1);
                    lastCurrentPipe.receiveInput(endSpecifiedPipe);
                    continue;
                }
                if (current.startsWith("-inputOnce")) {
                    key = current.replaceFirst("-input", "-fork");
                    List specifiedPipe = this.myForks.get(key);
                    if (specifiedPipe == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: unknown input: " + current);
                    }
                    CombineDataSetsPlugin combinePlugin = null;
                    try {
                        combinePlugin = (CombineDataSetsPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -inputOnce must follow -combine flag.");
                    }
                    Plugin endSpecifiedPipe = (Plugin)specifiedPipe.get(specifiedPipe.size() - 1);
                    combinePlugin.receiveDataSetOnceFrom(endSpecifiedPipe);
                    continue;
                }
                if (current.startsWith("-combine")) {
                    current = current.replaceFirst("-combine", "-fork");
                    if (this.myCurrentPipe != null && this.myCurrentPipe.size() != 0) {
                        this.myCurrentPipe.get(this.myCurrentPipe.size() - 1).setThreaded(true);
                    }
                    this.myCurrentFork = current;
                    this.myCurrentPipe = new ArrayList<Plugin>();
                    this.myForks.put(this.myCurrentFork, this.myCurrentPipe);
                    this.integratePlugin(new CombineDataSetsPlugin(), false);
                    continue;
                }
                if (current.equalsIgnoreCase("-t")) {
                    String traitFile = args[index++].trim();
                    this.loadFile(traitFile, FileLoadPlugin.TasselFileType.Phenotype);
                    continue;
                }
                if (current.equalsIgnoreCase("-s")) {
                    String inputFile = args[index++].trim();
                    this.loadFile(inputFile, FileLoadPlugin.TasselFileType.Sequence);
                    continue;
                }
                if (current.equalsIgnoreCase("-k")) {
                    String kinshipFile = args[index++].trim();
                    this.loadFile(kinshipFile, FileLoadPlugin.TasselFileType.SqrMatrix);
                    continue;
                }
                if (current.equalsIgnoreCase("-q")) {
                    String populationFile = args[index++].trim();
                    this.loadFile(populationFile, FileLoadPlugin.TasselFileType.Phenotype);
                    continue;
                }
                if (current.equalsIgnoreCase("-h")) {
                    hapFile = args[index++].trim();
                    this.loadFile(hapFile, FileLoadPlugin.TasselFileType.Hapmap);
                    continue;
                }
                if (current.equalsIgnoreCase("-nh")) {
                    hapFile = args[index++].trim();
                    BuilderFromHapMap.getBuilder(hapFile).build();
                    continue;
                }
                if (current.equalsIgnoreCase("-h5")) {
                    String hdf5File = args[index++].trim();
                    this.loadFile(hdf5File, FileLoadPlugin.TasselFileType.HDF5);
                    continue;
                }
                if (current.equalsIgnoreCase("-r")) {
                    String phenotypeFile = args[index++].trim();
                    this.loadFile(phenotypeFile, FileLoadPlugin.TasselFileType.Phenotype);
                    continue;
                }
                if (current.equalsIgnoreCase("-plink")) {
                    String pedFile = null;
                    String mapFile = null;
                    for (int i2 = 0; i2 < 2; ++i2) {
                        String fileType = args[index++].trim();
                        String filename = args[index++].trim();
                        if (fileType.equalsIgnoreCase("-ped")) {
                            pedFile = filename;
                            continue;
                        }
                        if (fileType.equalsIgnoreCase("-map")) {
                            mapFile = filename;
                            continue;
                        }
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -plink: unknown file type: " + fileType);
                    }
                    if (pedFile == null || mapFile == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -plink must specify both ped and map files.");
                    }
                    PlinkLoadPlugin plugin2 = new PlinkLoadPlugin(this.myMainFrame, false);
                    plugin2.setPedFile(pedFile);
                    plugin2.setMapFile(mapFile);
                    this.integratePlugin(plugin2, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-fasta")) {
                    String fastaFile = args[index++].trim();
                    this.loadFile(fastaFile, FileLoadPlugin.TasselFileType.Fasta);
                    continue;
                }
                if (current.equalsIgnoreCase("-geneticMap")) {
                    String geneticMapFile = args[index++].trim();
                    this.loadFile(geneticMapFile, FileLoadPlugin.TasselFileType.GeneticMap);
                    continue;
                }
                if (current.equalsIgnoreCase("-table")) {
                    String tableFile = args[index++].trim();
                    this.loadFile(tableFile, FileLoadPlugin.TasselFileType.Table);
                    continue;
                }
                if (current.equalsIgnoreCase("-vcf")) {
                    String vcfFile = args[index++].trim();
                    this.loadFile(vcfFile, FileLoadPlugin.TasselFileType.VCF);
                    continue;
                }
                if (current.equalsIgnoreCase("-readSerialAlignment")) {
                    file = args[index++].trim();
                    this.loadFile(file, FileLoadPlugin.TasselFileType.Serial);
                    continue;
                }
                if (current.equalsIgnoreCase("-importGuess")) {
                    file = args[index++].trim();
                    this.loadFile(file, FileLoadPlugin.TasselFileType.Unknown);
                    continue;
                }
                if (current.equalsIgnoreCase("-convertTOPMtoHDF5")) {
                    String filename = args[index++].trim();
                    TagsOnPhysicalMap topm = null;
                    String h5Filename = null;
                    if (filename.endsWith(".topm.txt")) {
                        topm = new TagsOnPhysicalMap(filename, false);
                        h5Filename = filename.replaceAll(".topm.txt", ".topm.h5");
                    } else if (filename.endsWith(".topm.bin")) {
                        topm = new TagsOnPhysicalMap(filename, true);
                        h5Filename = filename.replaceAll(".topm.bin", ".topm.h5");
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -convertTOPMtoHDF5: Unknown file extension: " + filename);
                    }
                    TagsOnPhysMapHDF5.createFile(topm, h5Filename, 4, 8);
                    continue;
                }
                if (current.equalsIgnoreCase("-retainRareAlleles")) {
                    String temp = args[index++].trim();
                    boolean retain = true;
                    if (temp.equalsIgnoreCase("false")) {
                        retain = false;
                    } else if (temp.equalsIgnoreCase("true")) {
                        retain = true;
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -retainRareAlleles parameter must be true or false.");
                    }
                    TasselPrefs.putAlignmentRetainRareAlleles(retain);
                    continue;
                }
                if (current.equalsIgnoreCase("-union")) {
                    plugin = new UnionAlignmentPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-intersect")) {
                    plugin = new IntersectionAlignmentPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-separate")) {
                    plugin = new SeparatePlugin(this.myMainFrame, false);
                    String temp = args[index].trim();
                    if (!temp.startsWith("-")) {
                        String[] chromosomes = temp.split(",");
                        ((SeparatePlugin)plugin).setChromosomesToSeparate(chromosomes);
                        ++index;
                    }
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-homozygous")) {
                    plugin = new HetsToUnknownPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-synonymizer")) {
                    plugin = new SynonymizerPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-mergeGenotypeTables")) {
                    plugin = new MergeGenotypeTablesPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-mergeAlignmentsSameSites")) {
                    plugin = new MergeAlignmentsSameSitesPlugin(this.myMainFrame);
                    try {
                        for (int i3 = 0; i3 < 2; ++i3) {
                            String paraType = args[index++].trim();
                            String value = args[index++].trim();
                            if (paraType.equalsIgnoreCase("-input")) {
                                String[] files = value.split(",");
                                ArrayList<String> filenames = new ArrayList<String>();
                                for (int j = 0; j < files.length; ++j) {
                                    filenames.add(files[j]);
                                }
                                ((MergeAlignmentsSameSitesPlugin)plugin).setInputFiles(filenames);
                                continue;
                            }
                            if (paraType.equalsIgnoreCase("-output")) {
                                ((MergeAlignmentsSameSitesPlugin)plugin).setOutputFile(value);
                                continue;
                            }
                            throw new IllegalArgumentException("TasselPipeline: parseArgs: -mergeAlignmentsSameSites: unknown descriptor: " + paraType);
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -mergeAlignmentsSameSites: not specified correctly.");
                    }
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-excludeLastTrait")) {
                    plugin = new FilterTraitsPlugin(this.myMainFrame, false);
                    ArrayList<int[]> input = new ArrayList<int[]>();
                    int[] excludeLast = new int[]{-1};
                    input.add(excludeLast);
                    ((FilterTraitsPlugin)plugin).setIncludeList(input);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-mlm")) {
                    plugin = new MLMPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-mlmVarCompEst")) {
                    plugin = (MLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{MLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No MLM step defined: " + current);
                    }
                    String method = args[index++].trim();
                    ((MLMPlugin)plugin).setVarCompEst(method);
                    continue;
                }
                if (current.equalsIgnoreCase("-mlmCompressionLevel")) {
                    String type;
                    plugin = (MLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{MLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No MLM step defined: " + current);
                    }
                    if ((type = args[index++].trim()).equalsIgnoreCase("Optimum")) {
                        ((MLMPlugin)plugin).setCompressionType(MLMPlugin.CompressionType.Optimum);
                        continue;
                    }
                    if (type.equalsIgnoreCase("Custom")) {
                        ((MLMPlugin)plugin).setCompressionType(MLMPlugin.CompressionType.Custom);
                        continue;
                    }
                    if (type.equalsIgnoreCase("None")) {
                        ((MLMPlugin)plugin).setCompressionType(MLMPlugin.CompressionType.None);
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: Unknown compression type: " + type);
                }
                if (current.equalsIgnoreCase("-mlmCustomCompression")) {
                    plugin = (MLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{MLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No MLM step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    double value = 0.0;
                    try {
                        value = Double.parseDouble(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing custom compression: " + temp);
                    }
                    ((MLMPlugin)plugin).setCustomCompression(value);
                    continue;
                }
                if (current.equalsIgnoreCase("-mlmOutputFile")) {
                    plugin = (MLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{MLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No MLM step defined: " + current);
                    }
                    String filename = args[index++].trim();
                    ((MLMPlugin)plugin).setOutputName(filename);
                    continue;
                }
                if (current.equalsIgnoreCase("-mlmMaxP")) {
                    plugin = (MLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{MLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No MLM step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    double maxP = 0.0;
                    try {
                        maxP = Double.parseDouble(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing max P: " + temp);
                    }
                    ((MLMPlugin)plugin).setMaxp(maxP);
                    continue;
                }
                if (current.equalsIgnoreCase("-glm")) {
                    plugin = new FixedEffectLMPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-glmOutputFile")) {
                    plugin = (FixedEffectLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FixedEffectLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No GLM step defined: " + current);
                    }
                    String filename = args[index++].trim();
                    ((FixedEffectLMPlugin)plugin).setOutputFile(filename);
                    continue;
                }
                if (current.equalsIgnoreCase("-glmMaxP")) {
                    plugin = (FixedEffectLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FixedEffectLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No GLM step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    double maxP = 0.0;
                    try {
                        maxP = Double.parseDouble(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing max P: " + temp);
                    }
                    ((FixedEffectLMPlugin)plugin).setMaxP(maxP);
                    continue;
                }
                if (current.equalsIgnoreCase("-glmPermutations")) {
                    plugin = (FixedEffectLMPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FixedEffectLMPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No GLM step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int permutations = 0;
                    try {
                        permutations = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing number of permutations: " + temp);
                    }
                    ((FixedEffectLMPlugin)plugin).setPermute(true);
                    ((FixedEffectLMPlugin)plugin).setNumberOfPermutations(permutations);
                    continue;
                }
                if (current.equalsIgnoreCase("-td_csv")) {
                    String csvFile = args[index++].trim();
                    this.getTableDisplayPlugin(csvFile, current);
                    continue;
                }
                if (current.equalsIgnoreCase("-td_tab")) {
                    String tabFile = args[index++].trim();
                    this.getTableDisplayPlugin(tabFile, current);
                    continue;
                }
                if (current.equalsIgnoreCase("-td_gui")) {
                    this.getTableDisplayPlugin(null, current);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversity")) {
                    plugin = new SequenceDiversityPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversityStartBase")) {
                    plugin = null;
                    try {
                        plugin = (SequenceDiversityPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No SequenceDiversityPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int start = -1;
                    try {
                        start = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with Diversity Start Base number: " + str);
                    }
                    if (start < 0) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Diversity Start Base can't be less than 0.");
                    }
                    ((SequenceDiversityPlugin)plugin).setStartSite(start);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversityEndBase")) {
                    plugin = null;
                    try {
                        plugin = (SequenceDiversityPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No SequenceDiversityPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int end = -1;
                    try {
                        end = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with Diversity Start Base number: " + str);
                    }
                    ((SequenceDiversityPlugin)plugin).setEndSite(end);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversitySlidingWin")) {
                    plugin = null;
                    try {
                        plugin = (SequenceDiversityPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No SequenceDiversityPlugin step defined: " + current);
                    }
                    ((SequenceDiversityPlugin)plugin).setSlidingWindowAnalysis(true);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversitySlidingWinStep")) {
                    plugin = null;
                    try {
                        plugin = (SequenceDiversityPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No SequenceDiversityPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int step = -1;
                    try {
                        step = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with Diversity Sliding Win Step number: " + str);
                    }
                    ((SequenceDiversityPlugin)plugin).setStepSize(step);
                    ((SequenceDiversityPlugin)plugin).setSlidingWindowAnalysis(true);
                    continue;
                }
                if (current.equalsIgnoreCase("-diversitySlidingWinSize")) {
                    plugin = null;
                    try {
                        plugin = (SequenceDiversityPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No SequenceDiversityPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int size = -1;
                    try {
                        size = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with Diversity Sliding Win Size number: " + str);
                    }
                    ((SequenceDiversityPlugin)plugin).setWindowSize(size);
                    ((SequenceDiversityPlugin)plugin).setSlidingWindowAnalysis(true);
                    continue;
                }
                if (current.equalsIgnoreCase("-ld")) {
                    plugin = new LinkageDisequilibriumPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldPermNum")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int permNum = -1;
                    try {
                        permNum = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with LD Permutation number: " + str);
                    }
                    if (permNum < 1) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Permutation size can't be less than 1.");
                    }
                    ((LinkageDisequilibriumPlugin)plugin).setPermutationNumber(permNum);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldTestSite")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int testSite = -1;
                    try {
                        testSite = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with LD Test Site number: " + str);
                    }
                    if (testSite < 0) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Test Site can't be less than 0.");
                    }
                    ((LinkageDisequilibriumPlugin)plugin).setTestSite(testSite);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldWinSize")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int winSize = -1;
                    try {
                        winSize = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with LD Window Size: " + str);
                    }
                    if (winSize < 1) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Window Size can't be less than 1.");
                    }
                    ((LinkageDisequilibriumPlugin)plugin).setWinSize(winSize);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldRapidAnalysis")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    boolean rapid = true;
                    if (temp.equalsIgnoreCase("false")) {
                        rapid = false;
                    } else if (temp.equalsIgnoreCase("true")) {
                        rapid = true;
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Rapid Analysis parameter must be true or false.");
                    }
                    ((LinkageDisequilibriumPlugin)plugin).setRapidAnalysis(rapid);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldType")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    if (temp.equalsIgnoreCase("All")) {
                        ((LinkageDisequilibriumPlugin)plugin).setLDType(LinkageDisequilibrium.testDesign.All);
                        continue;
                    }
                    if (temp.equalsIgnoreCase("SlidingWindow")) {
                        ((LinkageDisequilibriumPlugin)plugin).setLDType(LinkageDisequilibrium.testDesign.SlidingWindow);
                        continue;
                    }
                    if (temp.equalsIgnoreCase("SiteByAll")) {
                        ((LinkageDisequilibriumPlugin)plugin).setLDType(LinkageDisequilibrium.testDesign.SiteByAll);
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Type parameter must be All, SlidingWindow, or SiteByAll.");
                }
                if (current.equalsIgnoreCase("-ldHetTreatment")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDisequilibriumPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDisequilibriumPlugin step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    if (temp.equalsIgnoreCase("Haplotype")) {
                        ((LinkageDisequilibriumPlugin)plugin).setHetTreatment(LinkageDisequilibrium.HetTreatment.Haplotype);
                        continue;
                    }
                    if (temp.equalsIgnoreCase("Homozygous")) {
                        ((LinkageDisequilibriumPlugin)plugin).setHetTreatment(LinkageDisequilibrium.HetTreatment.Homozygous);
                        continue;
                    }
                    if (temp.equalsIgnoreCase("Genotype")) {
                        ((LinkageDisequilibriumPlugin)plugin).setHetTreatment(LinkageDisequilibrium.HetTreatment.Genotype);
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Het Treatment parameter must be Haplotype, Homozygous, or Genotype.");
                }
                if (current.equalsIgnoreCase("-ldd")) {
                    String outputType = args[index++].trim();
                    this.getLinkageDiseqDisplayPlugin(outputType);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldplotsize")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDiseqDisplayPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDiseqDisplay step defined: " + current);
                    }
                    String str = args[index++].trim();
                    int plotSize = -1;
                    try {
                        plotSize = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem with LD Plot size number: " + str);
                    }
                    if (plotSize < 1) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Plot size can't be less than 1.");
                    }
                    ((AbstractDisplayPlugin)plugin).setImageSize(plotSize, plotSize);
                    continue;
                }
                if (current.equalsIgnoreCase("-ldplotlabels")) {
                    plugin = null;
                    try {
                        plugin = (LinkageDiseqDisplayPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDiseqDisplay step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    boolean ldPlotLabels = true;
                    if (temp.equalsIgnoreCase("false")) {
                        ldPlotLabels = false;
                    } else if (temp.equalsIgnoreCase("true")) {
                        ldPlotLabels = true;
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: LD Plot labels parameter must be true or false.");
                    }
                    ((LinkageDiseqDisplayPlugin)plugin).setShowLabels(ldPlotLabels);
                    continue;
                }
                if (current.equalsIgnoreCase("-o")) {
                    plugin = this.findLastPluginFromCurrentPipe(new Class[]{LinkageDiseqDisplayPlugin.class});
                    String temp = args[index++].trim();
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No LinkageDiseqDisplay step defined: " + current + " " + temp);
                    }
                    if (!(plugin instanceof LinkageDiseqDisplayPlugin)) continue;
                    ((LinkageDiseqDisplayPlugin)plugin).setSaveFile(temp);
                    continue;
                }
                if (current.equalsIgnoreCase("-ck")) {
                    plugin = new KinshipPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-ckModelHets")) {
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: -ckModelHets not needed in Tassel 4.0. It is designed to handle heterzygotes.");
                }
                if (current.equalsIgnoreCase("-ckRescale")) {
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: -ckRescale not needed in Tassel 4.0. It is designed to handle heterzygotes.");
                }
                if (current.equalsIgnoreCase("-tree")) {
                    plugin = new CreateTreePlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    String temp = args[index++].trim();
                    if (temp.equalsIgnoreCase("Neighbor")) {
                        ((CreateTreePlugin)plugin).setNeighborJoining(true);
                        continue;
                    }
                    if (temp.equalsIgnoreCase("UPGMA")) {
                        ((CreateTreePlugin)plugin).setNeighborJoining(false);
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: tree clustering method must be Neighbor or UPGMA: " + temp);
                }
                if (current.equalsIgnoreCase("-treeSaveDistance")) {
                    plugin = (CreateTreePlugin)this.findLastPluginFromCurrentPipe(new Class[]{CreateTreePlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Create Tree step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    boolean value = true;
                    if (temp.equalsIgnoreCase("false")) {
                        value = false;
                    } else if (temp.equalsIgnoreCase("true")) {
                        value = true;
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: tree save distance matrix parameter must be true or false: " + value);
                    }
                    ((CreateTreePlugin)plugin).setReturnDistanceMatrix(value);
                    continue;
                }
                if (current.equalsIgnoreCase("-gs")) {
                    plugin = new RidgeRegressionEmmaPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-distanceMatrix")) {
                    plugin = new DistanceMatrixPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-distMatrixRanges")) {
                    plugin = new DistanceMatrixRangesPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-distMatrixRangesLocus")) {
                    plugin = null;
                    try {
                        plugin = (DistanceMatrixRangesPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No DistanceMatrixRangesPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    ((DistanceMatrixRangesPlugin)plugin).setLocus(str);
                    continue;
                }
                if (current.equalsIgnoreCase("-distMatrixRangesTaxon")) {
                    plugin = null;
                    try {
                        plugin = (DistanceMatrixRangesPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No DistanceMatrixRangesPlugin step defined: " + current);
                    }
                    String str = args[index++].trim();
                    ((DistanceMatrixRangesPlugin)plugin).setTaxon(str);
                    continue;
                }
                if (current.equalsIgnoreCase("-distMatrixRangesPos")) {
                    plugin = null;
                    try {
                        plugin = (DistanceMatrixRangesPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No DistanceMatrixRangesPlugin step defined: " + current);
                    }
                    String[] positions = args[index++].trim().split(",");
                    ((DistanceMatrixRangesPlugin)plugin).setPhysicalPositions(positions);
                    continue;
                }
                if (current.equalsIgnoreCase("-distMatrixRangesPosFile")) {
                    plugin = null;
                    try {
                        plugin = (DistanceMatrixRangesPlugin)this.myCurrentPipe.get(this.myCurrentPipe.size() - 1);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No DistanceMatrixRangesPlugin step defined: " + current);
                    }
                    String posFile = args[index++].trim();
                    ArrayList<String> positions = new ArrayList<String>();
                    try (BufferedReader br = null;){
                        br = Utils.getBufferedReader(posFile);
                        inputline = br.readLine();
                        Pattern sep = Pattern.compile("\\s+");
                        while (inputline != null) {
                            inputline = inputline.trim();
                            String[] parsedline = sep.split(inputline);
                            for (i = 0; i < parsedline.length; ++i) {
                                if (parsedline[i] == null && parsedline[i].length() == 0) continue;
                                positions.add(parsedline[i]);
                            }
                            inputline = br.readLine();
                        }
                    }
                    String[] positionArray = new String[positions.size()];
                    positionArray = positions.toArray(positionArray);
                    ((DistanceMatrixRangesPlugin)plugin).setPhysicalPositions(positionArray);
                    continue;
                }
                if (current.equalsIgnoreCase("-genotypeSummary")) {
                    plugin = new GenotypeSummaryPlugin(this.myMainFrame, false);
                    String temp = args[index++].trim();
                    String[] types = temp.split(",");
                    ((GenotypeSummaryPlugin)plugin).setCaculateOverview(false);
                    ((GenotypeSummaryPlugin)plugin).setCalculateSiteSummary(false);
                    ((GenotypeSummaryPlugin)plugin).setCalculateTaxaSummary(false);
                    for (int i4 = 0; i4 < types.length; ++i4) {
                        if (types[i4].equalsIgnoreCase("overall")) {
                            ((GenotypeSummaryPlugin)plugin).setCaculateOverview(true);
                            continue;
                        }
                        if (types[i4].equalsIgnoreCase("site")) {
                            ((GenotypeSummaryPlugin)plugin).setCalculateSiteSummary(true);
                            continue;
                        }
                        if (types[i4].equalsIgnoreCase("taxa")) {
                            ((GenotypeSummaryPlugin)plugin).setCalculateTaxaSummary(true);
                            continue;
                        }
                        if (types[i4].equalsIgnoreCase("all")) {
                            ((GenotypeSummaryPlugin)plugin).setCaculateOverview(true);
                            ((GenotypeSummaryPlugin)plugin).setCalculateSiteSummary(true);
                            ((GenotypeSummaryPlugin)plugin).setCalculateTaxaSummary(true);
                            continue;
                        }
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -genotypeSummary illegal types: " + temp);
                    }
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-export")) {
                    plugin = new ExportMultiplePlugin(this.myMainFrame);
                    String temp = args[index].trim();
                    if (!temp.startsWith("-")) {
                        String[] filenames = temp.split(",");
                        ((ExportMultiplePlugin)plugin).setSaveFiles(filenames);
                        ++index;
                    }
                    this.integratePlugin(plugin, false);
                    continue;
                }
                if (current.equalsIgnoreCase("-exportType")) {
                    plugin = (ExportMultiplePlugin)this.findLastPluginFromCurrentPipe(new Class[]{ExportMultiplePlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Export step defined: " + current);
                    }
                    String type = args[index++].trim();
                    FileLoadPlugin.TasselFileType fileType = null;
                    try {
                        fileType = FileLoadPlugin.TasselFileType.valueOf(type);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: -exportType: Unknown type: " + type + "  Should be: " + Arrays.toString((Object[])FileLoadPlugin.TasselFileType.values()));
                    }
                    ((ExportMultiplePlugin)plugin).setAlignmentFileType(fileType);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlign")) {
                    plugin = new FilterAlignmentPlugin(this.myMainFrame, false);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignMinCount")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int minCount = 0;
                    try {
                        minCount = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment min count: " + temp);
                    }
                    ((FilterAlignmentPlugin)plugin).setMinCount(minCount);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignMinFreq")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    double minFreq = 0.0;
                    try {
                        minFreq = Double.parseDouble(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment min frequency: " + temp);
                    }
                    ((FilterAlignmentPlugin)plugin).setMinFreq(minFreq);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignMaxFreq")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    double maxFreq = 0.0;
                    try {
                        maxFreq = Double.parseDouble(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment max frequency: " + temp);
                    }
                    ((FilterAlignmentPlugin)plugin).setMaxFreq(maxFreq);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignStart")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int start = 0;
                    try {
                        start = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment start: " + temp);
                    }
                    ((FilterAlignmentPlugin)plugin).setStart(start);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignEnd")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int end = 0;
                    try {
                        end = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment end: " + temp);
                    }
                    ((FilterAlignmentPlugin)plugin).setEnd(end);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignStartPos")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int startPos = 0;
                    try {
                        startPos = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment start physical position: " + temp);
                    }
                    ((FilterAlignmentPlugin)plugin).setStartPos(startPos);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignEndPos")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int endPos = 0;
                    try {
                        endPos = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment end physical position: " + temp);
                    }
                    ((FilterAlignmentPlugin)plugin).setEndPos(endPos);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignLocus")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    ((FilterAlignmentPlugin)plugin).setLocusStr(temp);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignExtInd")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    ((FilterAlignmentPlugin)plugin).setExtractIndels(true);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignRemMinor")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    ((FilterAlignmentPlugin)plugin).setFilterMinorSNPs(true);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignSliding")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    ((FilterAlignmentPlugin)plugin).setDoSlidingHaps(true);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignHapLen")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int hapLen = 0;
                    try {
                        hapLen = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment haplotype length: " + temp);
                    }
                    ((FilterAlignmentPlugin)plugin).setWinSize(hapLen);
                    continue;
                }
                if (current.equalsIgnoreCase("-filterAlignStepLen")) {
                    plugin = (FilterAlignmentPlugin)this.findLastPluginFromCurrentPipe(new Class[]{FilterAlignmentPlugin.class});
                    if (plugin == null) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: No Filter Alignment step defined: " + current);
                    }
                    String temp = args[index++].trim();
                    int stepLen = 0;
                    try {
                        stepLen = Integer.parseInt(temp);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Problem parsing filter alignment step length: " + temp);
                    }
                    ((FilterAlignmentPlugin)plugin).setStepSize(stepLen);
                    continue;
                }
                if (current.equalsIgnoreCase("-numericalGenoTransform")) {
                    String temp;
                    plugin = new NumericalGenotypePlugin();
                    if ((temp = args[index++].trim()).equalsIgnoreCase(NumericalGenotypePlugin.TRANSFORM_TYPE.collapse.toString())) {
                        ((NumericalGenotypePlugin)plugin).setTransformType(NumericalGenotypePlugin.TRANSFORM_TYPE.collapse);
                    } else if (temp.equalsIgnoreCase(NumericalGenotypePlugin.TRANSFORM_TYPE.separated.toString())) {
                        ((NumericalGenotypePlugin)plugin).setTransformType(NumericalGenotypePlugin.TRANSFORM_TYPE.separated);
                    } else {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Not defined genotype transform type: " + temp);
                    }
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-includeTaxa")) {
                    plugin = new FilterTaxaAlignmentPlugin(this.myMainFrame, false);
                    String[] taxa = args[index++].trim().split(",");
                    Taxon[] ids2 = new Taxon[taxa.length];
                    for (int i5 = 0; i5 < taxa.length; ++i5) {
                        ids2[i5] = new Taxon(taxa[i5]);
                    }
                    ((FilterTaxaAlignmentPlugin)plugin).setIdsToKeep(new TaxaListBuilder().addAll(ids2).build());
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-includeTaxaInFile")) {
                    plugin = new FilterTaxaAlignmentPlugin(this.myMainFrame, false);
                    String taxaListFile = args[index++].trim();
                    ArrayList<String> taxa = new ArrayList<String>();
                    try (BufferedReader br = null;){
                        br = Utils.getBufferedReader(taxaListFile);
                        inputline = br.readLine();
                        Pattern sep = Pattern.compile("\\s+");
                        while (inputline != null) {
                            inputline = inputline.trim();
                            String[] parsedline = sep.split(inputline);
                            for (i = 0; i < parsedline.length; ++i) {
                                if (parsedline[i] == null && parsedline[i].length() == 0) continue;
                                taxa.add(parsedline[i]);
                            }
                            inputline = br.readLine();
                        }
                    }
                    ids = new Taxon[taxa.size()];
                    for (int i6 = 0; i6 < taxa.size(); ++i6) {
                        ids[i6] = new Taxon((String)taxa.get(i6));
                    }
                    ((FilterTaxaAlignmentPlugin)plugin).setIdsToKeep(new TaxaListBuilder().addAll(ids).build());
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-excludeTaxa")) {
                    plugin = new FilterTaxaAlignmentPlugin(this.myMainFrame, false);
                    String[] taxa = args[index++].trim().split(",");
                    Taxon[] ids3 = new Taxon[taxa.length];
                    for (int i7 = 0; i7 < taxa.length; ++i7) {
                        ids3[i7] = new Taxon(taxa[i7]);
                    }
                    ((FilterTaxaAlignmentPlugin)plugin).setIdsToRemove(new TaxaListBuilder().addAll(ids3).build());
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-excludeTaxaInFile")) {
                    plugin = new FilterTaxaAlignmentPlugin(this.myMainFrame, false);
                    String taxaListFile = args[index++].trim();
                    ArrayList<String> taxa = new ArrayList<String>();
                    try (BufferedReader br = null;){
                        br = Utils.getBufferedReader(taxaListFile);
                        inputline = br.readLine();
                        Pattern sep = Pattern.compile("\\s+");
                        while (inputline != null) {
                            inputline = inputline.trim();
                            String[] parsedline = sep.split(inputline);
                            for (i = 0; i < parsedline.length; ++i) {
                                if (parsedline[i] == null && parsedline[i].length() == 0) continue;
                                taxa.add(parsedline[i]);
                            }
                            inputline = br.readLine();
                        }
                    }
                    ids = new Taxon[taxa.size()];
                    for (int i8 = 0; i8 < taxa.size(); ++i8) {
                        ids[i8] = new Taxon((String)taxa.get(i8));
                    }
                    ((FilterTaxaAlignmentPlugin)plugin).setIdsToRemove(new TaxaListBuilder().addAll(ids).build());
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-includeSiteNames")) {
                    plugin = new FilterSiteNamePlugin(this.myMainFrame, false);
                    String[] names = args[index++].trim().split(",");
                    ((FilterSiteNamePlugin)plugin).setSiteNamesToKeep(names);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-includeSiteNamesInFile")) {
                    plugin = new FilterSiteNamePlugin(this.myMainFrame, false);
                    String siteNameListFile = args[index++].trim();
                    ArrayList<String> siteNames = new ArrayList<String>();
                    try (BufferedReader br = null;){
                        br = Utils.getBufferedReader(siteNameListFile);
                        inputline = br.readLine();
                        Pattern sep = Pattern.compile("\\s+");
                        while (inputline != null) {
                            inputline = inputline.trim();
                            String[] parsedline = sep.split(inputline);
                            for (i = 0; i < parsedline.length; ++i) {
                                if (parsedline[i] == null && parsedline[i].length() == 0) continue;
                                siteNames.add(parsedline[i]);
                            }
                            inputline = br.readLine();
                        }
                    }
                    String[] siteNameArray = new String[siteNames.size()];
                    siteNameArray = siteNames.toArray(siteNameArray);
                    ((FilterSiteNamePlugin)plugin).setSiteNamesToKeep(siteNameArray);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-excludeSiteNames")) {
                    plugin = new FilterSiteNamePlugin(this.myMainFrame, false);
                    String[] sites = args[index++].trim().split(",");
                    ((FilterSiteNamePlugin)plugin).setSiteNamesToRemove(sites);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-excludeSiteNamesInFile")) {
                    plugin = new FilterSiteNamePlugin(this.myMainFrame, false);
                    String siteNameListFile = args[index++].trim();
                    ArrayList<String> siteNames = new ArrayList<String>();
                    try (BufferedReader br = null;){
                        br = Utils.getBufferedReader(siteNameListFile);
                        inputline = br.readLine();
                        Pattern sep = Pattern.compile("\\s+");
                        while (inputline != null) {
                            inputline = inputline.trim();
                            String[] parsedline = sep.split(inputline);
                            for (i = 0; i < parsedline.length; ++i) {
                                if (parsedline[i] == null && parsedline[i].length() == 0) continue;
                                siteNames.add(parsedline[i]);
                            }
                            inputline = br.readLine();
                        }
                    }
                    String[] names = new String[siteNames.size()];
                    for (int i9 = 0; i9 < siteNames.size(); ++i9) {
                        names[i9] = (String)siteNames.get(i9);
                    }
                    ((FilterSiteNamePlugin)plugin).setSiteNamesToRemove(names);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-subsetSites")) {
                    plugin = new FilterSubsetPlugin(this.myMainFrame, false);
                    try {
                        double siteVal = Double.parseDouble(args[index++].trim());
                        ((FilterSubsetPlugin)plugin).setSiteSubset(siteVal);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Value following -subsetSites must be a number (decimal or integer)");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (args[index].equalsIgnoreCase("-step")) {
                        ((FilterSubsetPlugin)plugin).setIsRandom(false);
                        ++index;
                    }
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-subsetTaxa")) {
                    plugin = new FilterSubsetPlugin(this.myMainFrame, false);
                    try {
                        double taxaVal = Double.parseDouble(args[index++].trim());
                        ((FilterSubsetPlugin)plugin).setTaxaSubset(taxaVal);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("TasselPipeline: parseArgs: Value following -subsetTaxa must be a number (decimal or integer)");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (args[index].equalsIgnoreCase("-step")) {
                        ((FilterSubsetPlugin)plugin).setIsRandom(false);
                        ++index;
                    }
                    this.integratePlugin(plugin, true);
                    continue;
                }
                if (current.equalsIgnoreCase("-newCoordinates")) {
                    plugin = new ConvertAlignmentCoordinatesPlugin(this.myMainFrame);
                    String mapFile = args[index++].trim();
                    ((ConvertAlignmentCoordinatesPlugin)plugin).setMapFilename(mapFile);
                    this.integratePlugin(plugin, true);
                    continue;
                }
                try {
                    String match;
                    plugin = null;
                    String possibleClassName = current.substring(1);
                    List<String> matches = Utils.getFullyQualifiedClassNames(possibleClassName);
                    Iterator<String> i$ = matches.iterator();
                    while (i$.hasNext() && (plugin = this.getPluginInstance(match = i$.next())) == null) {
                    }
                    if (plugin == null) {
                        plugin = this.getPluginInstance(possibleClassName);
                    }
                    if (plugin != null) {
                        ArrayList<String> pluginArgs = new ArrayList<String>();
                        if (index == args.length) {
                            this.integratePlugin(plugin, true);
                        }
                        String temp = args[index++].trim();
                        while (!temp.equalsIgnoreCase("-endPlugin")) {
                            if (temp.startsWith("-runfork")) {
                                --index;
                                break;
                            }
                            pluginArgs.add(temp);
                            if (index == args.length) {
                                this.integratePlugin(plugin, true);
                                myLogger.warn((Object)"TasselPipeline: parseArgs: No -endPlugin flag specified.");
                            }
                            temp = args[index++].trim();
                        }
                        String[] result = new String[pluginArgs.size()];
                        result = pluginArgs.toArray(result);
                        try {
                            plugin.setParameters(result);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ExceptionUtils.logExceptionCauses(e, myLogger, Level.ERROR);
                            System.exit(1);
                        }
                        this.integratePlugin(plugin, true);
                        continue;
                    }
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: Unknown parameter: " + current);
                }
                catch (UnsupportedOperationException usoe) {
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: this plugin is not self-described: " + current);
                }
                catch (Exception e) {
                    ExceptionUtils.logExceptionCauses(e, myLogger, Level.ERROR);
                    throw new IllegalArgumentException("TasselPipeline: parseArgs: Unknown parameter: " + current);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (this.myFirstPlugin != null) {
            this.tracePipeline();
        } else {
            myLogger.warn((Object)"parseArgs: no arguments specified.");
        }
    }

    private Plugin getPluginInstance(String className) {
        try {
            Class<?> currentMatch = Class.forName(className);
            Constructor<?> constructor = currentMatch.getConstructor(Frame.class);
            return (Plugin)constructor.newInstance(this.myMainFrame);
        }
        catch (Exception ex) {
            try {
                Class<?> currentMatch = Class.forName(className);
                Constructor<?> constructor = currentMatch.getConstructor(Frame.class, Boolean.TYPE);
                return (Plugin)constructor.newInstance(this.myMainFrame, false);
            }
            catch (NoSuchMethodException nsme) {
                myLogger.warn((Object)("Self-describing Plugins should implement this constructor: " + className));
                myLogger.warn((Object)"public Plugin(Frame parentFrame, boolean isInteractive) {");
                myLogger.warn((Object)"   super(parentFrame, isInteractive);");
                myLogger.warn((Object)"}");
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static String[] addForkFlagsIfNeeded(String[] args) {
        if (args == null || args.length == 0) {
            return args;
        }
        for (String a : args) {
            if (!a.toLowerCase().startsWith("-fork") && !a.toLowerCase().startsWith("-runfork")) continue;
            return args;
        }
        String[] newArgs = new String[args.length + 2];
        newArgs[0] = "-fork1";
        newArgs[newArgs.length - 1] = "-runfork1";
        System.arraycopy(args, 0, newArgs, 1, args.length);
        return newArgs;
    }

    private void tracePipeline() {
        for (int i = 0; i < this.myThreads.size(); ++i) {
            Plugin current = (Plugin)this.myThreads.get(i).getPluginListener();
            ((AbstractPlugin)current).trace(0);
        }
    }

    public FileLoadPlugin loadFile(String filename, FileLoadPlugin.TasselFileType fileType) {
        myLogger.info((Object)("loadFile: " + filename));
        FileLoadPlugin plugin = new FileLoadPlugin(this.myMainFrame, false);
        if (fileType == null) {
            plugin.setTheFileType(FileLoadPlugin.TasselFileType.Unknown);
        } else {
            plugin.setTheFileType(fileType);
        }
        plugin.setOpenFiles(new String[]{filename});
        this.integratePlugin(plugin, true);
        return plugin;
    }

    public TableDisplayPlugin getTableDisplayPlugin(String filename, String flag) {
        TableDisplayPlugin plugin = null;
        if (flag.equalsIgnoreCase("-td_gui")) {
            plugin = new TableDisplayPlugin(this.myMainFrame, true);
            this.integratePlugin(plugin, false);
        } else if (flag.equalsIgnoreCase("-td_tab")) {
            filename = Utils.addSuffixIfNeeded(filename, ".txt");
            myLogger.info((Object)("getTableDisplayPlugin: " + filename));
            plugin = new TableDisplayPlugin(this.myMainFrame, false);
            plugin.setDelimiter("\t");
            plugin.setSaveFile(filename);
            this.integratePlugin(plugin, false);
        } else if (flag.equalsIgnoreCase("-td_csv")) {
            filename = Utils.addSuffixIfNeeded(filename, ".csv");
            myLogger.info((Object)("getTableDisplayPlugin: " + filename));
            plugin = new TableDisplayPlugin(this.myMainFrame, false);
            plugin.setDelimiter(",");
            plugin.setSaveFile(filename);
            this.integratePlugin(plugin, false);
        }
        return plugin;
    }

    public LinkageDiseqDisplayPlugin getLinkageDiseqDisplayPlugin(String type) {
        LinkageDiseqDisplayPlugin plugin = new LinkageDiseqDisplayPlugin(this.myMainFrame, true);
        if (type.equalsIgnoreCase("gui")) {
            plugin = new LinkageDiseqDisplayPlugin(null, true);
            plugin.setBlockSchematic(false);
            plugin.setLowerCorner(0);
            plugin.setUpperCorner(2);
        } else {
            plugin = new LinkageDiseqDisplayPlugin(null, false);
            plugin.setBlockSchematic(false);
            plugin.setLowerCorner(0);
            plugin.setUpperCorner(2);
            if (type.equalsIgnoreCase("png")) {
                plugin.setOutformat(AbstractDisplayPlugin.Outformat.png);
            } else if (type.equalsIgnoreCase("gif")) {
                plugin.setOutformat(AbstractDisplayPlugin.Outformat.gif);
            } else if (type.equalsIgnoreCase("bmp")) {
                plugin.setOutformat(AbstractDisplayPlugin.Outformat.bmp);
            } else if (type.equalsIgnoreCase("jpg")) {
                plugin.setOutformat(AbstractDisplayPlugin.Outformat.jpg);
            } else if (type.equalsIgnoreCase("svg")) {
                plugin.setOutformat(AbstractDisplayPlugin.Outformat.svg);
            } else {
                throw new IllegalArgumentException("TasselPipeline: getLinkageDiseqDisplayPlugin: unknown output type: " + type);
            }
        }
        this.integratePlugin(plugin, false);
        return plugin;
    }

    private void integratePlugin(Plugin plugin, boolean displayDataTree) {
        if (this.myFirstPlugin == null) {
            this.myFirstPlugin = plugin;
        }
        if (displayDataTree) {
            plugin.addListener(this);
        }
        if (this.myCurrentPipe == null) {
            this.myCurrentPipe = new ArrayList<Plugin>();
        }
        if (this.myCurrentPipe.size() == 0) {
            this.myCurrentPipe.add(plugin);
        } else {
            plugin.receiveInput(this.myCurrentPipe.get(this.myCurrentPipe.size() - 1));
            this.myCurrentPipe.add(plugin);
        }
    }

    private Plugin findLastPluginFromAll(Class[] types) {
        if (this.myCurrentPipe != null && this.myCurrentPipe.size() != 0) {
            for (int i = this.myCurrentPipe.size() - 1; i >= 0; --i) {
                Plugin current = this.myCurrentPipe.get(i);
                if (!this.matchType(types, current)) continue;
                return current;
            }
        }
        ArrayList<String> keys = new ArrayList<String>(this.myForks.keySet());
        for (int i = keys.size() - 1; i >= 0; --i) {
            List currentPipe = this.myForks.get(keys.get(i));
            for (int j = currentPipe.size() - 1; j >= 0; --j) {
                Plugin current = (Plugin)currentPipe.get(j);
                if (!this.matchType(types, current)) continue;
                return current;
            }
        }
        return null;
    }

    private Plugin findLastPluginFromCurrentPipe(Class[] types) {
        if (this.myCurrentPipe != null && this.myCurrentPipe.size() != 0) {
            for (int i = this.myCurrentPipe.size() - 1; i >= 0; --i) {
                Plugin current = this.myCurrentPipe.get(i);
                if (!this.matchType(types, current)) continue;
                return current;
            }
        }
        return null;
    }

    private boolean matchType(Class[] types, Object test) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isInstance(test)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dataSetReturned(PluginEvent event) {
        DataSet tds = (DataSet)event.getSource();
        if (tds != null && tds.getSize() != 0 && this.myMainFrame != null) {
            this.myMainFrame.getDataTreePanel().addDataSet(tds, "Data");
        }
    }

    @Override
    public void progress(PluginEvent event) {
        DataSet ds;
        if (this.myMainFrame == null && (ds = (DataSet)event.getSource()) != null) {
            Datum datum;
            Integer percent;
            List<Datum> percentage = ds.getDataOfType(Integer.class);
            Plugin plugin = ds.getCreator();
            Integer lastValue = this.myProgressValues.get(plugin);
            if (lastValue == null) {
                lastValue = new Integer(0);
            }
            if (percentage.size() > 0 && (percent = (Integer)(datum = percentage.get(0)).getData()) >= lastValue) {
                myLogger.info((Object)(ds.getCreator().getClass().getName() + ": progress: " + percent + "%"));
                lastValue = lastValue + 10;
                this.myProgressValues.put(plugin, lastValue);
            }
        }
    }
}

