/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.plugindef;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;

public class DataSet
implements Serializable {
    private static final long serialVersionUID = -5197800047652332969L;
    private final List<Datum> myList;
    private final Plugin myCreator;

    public DataSet(List<Datum> list, Plugin creator) {
        this.myList = list == null ? new ArrayList<Datum>() : new ArrayList<Datum>(list);
        this.myCreator = creator;
    }

    public DataSet(Datum theDatum, Plugin creator) {
        if (theDatum == null) {
            this.myList = new ArrayList<Datum>();
        } else {
            this.myList = new ArrayList<Datum>();
            this.myList.add(theDatum);
        }
        this.myCreator = creator;
    }

    public DataSet(Datum[] list, Plugin creator) {
        this.myList = list == null ? new ArrayList<Datum>() : new ArrayList<Datum>(Arrays.asList(list));
        this.myCreator = creator;
    }

    public static DataSet getDataSet(List<DataSet> list, Plugin creator) {
        ArrayList<Datum> temp = new ArrayList<Datum>();
        if (list != null) {
            for (DataSet current : list) {
                if (current == null) continue;
                temp.addAll(current.getDataSet());
            }
        }
        return new DataSet(temp, creator);
    }

    public List getDataSet() {
        return new ArrayList<Datum>(this.myList);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DataSet...\n");
        if (this.getCreator() != null) {
            buffer.append("Creator: ");
            buffer.append(this.getCreator().getClass().getName());
            buffer.append("\n");
        }
        for (Datum current : this.myList) {
            buffer.append("name: ");
            buffer.append(current.getName());
            buffer.append("  type: ");
            buffer.append(current.getDataType());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public Datum getData(int i) {
        if (i < this.myList.size()) {
            return this.myList.get(i);
        }
        return null;
    }

    public int getSize() {
        return this.myList.size();
    }

    public Plugin getCreator() {
        return this.myCreator;
    }

    public List<Datum> getDataOfType(Class theClass) {
        if (theClass == null) {
            return null;
        }
        ArrayList<Datum> list = new ArrayList<Datum>();
        for (Datum current : this.myList) {
            if (!theClass.isInstance(current.getData())) continue;
            list.add(current);
        }
        return list;
    }

    public List<Datum> getDataOfType(Class[] classes) {
        if (classes == null || classes.length == 0) {
            return new ArrayList<Datum>(this.myList);
        }
        List<Datum> result = null;
        int n = classes.length;
        for (int i = 0; i < n; ++i) {
            List<Datum> current = this.getDataOfType(classes[i]);
            if (result == null) {
                result = current;
                continue;
            }
            result.addAll(current);
        }
        return result;
    }

    public List<Datum> getDataWithName(String name) {
        if (name == null) {
            return null;
        }
        ArrayList<Datum> list = new ArrayList<Datum>();
        for (Datum current : this.myList) {
            if (!name.equals(current.getName())) continue;
            list.add(current);
        }
        return list;
    }

    public List<Datum> getDataWithName(String[] names) {
        if (names == null || names.length == 0) {
            return new ArrayList<Datum>(this.myList);
        }
        List<Datum> result = null;
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            List<Datum> current = this.getDataWithName(names[i]);
            if (result == null) {
                result = current;
                continue;
            }
            result.addAll(current);
        }
        return result;
    }

    public List<Datum> getDataOfTypeWithName(Class[] classes, String[] names) {
        return new DataSet(this.getDataOfType(classes), null).getDataWithName(names);
    }
}

