/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.PCA;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import net.maizegenetics.stats.PCA.PrincipalComponents;

public class PCA {
    private DoubleMatrix2D data;
    private boolean isPop;
    private boolean isCorrelation = true;
    PrincipalComponents prcomp;

    public PCA(DoubleMatrix2D data) {
        this.data = data;
        this.isPop = false;
        this.build();
    }

    public PCA(DoubleMatrix2D data, boolean isPop) {
        this.data = data;
        this.isPop = isPop;
        this.build();
    }

    public PCA(DoubleMatrix2D data, boolean isPop, boolean isCorrelation) {
        this.isPop = isPop;
        this.isCorrelation = isCorrelation;
        this.data = data;
        double sum = data.zSum();
        this.build();
    }

    public DoubleMatrix2D getEigenVectors() {
        System.out.println("Now is extracting EigenVectors...");
        return this.prcomp.getEigenVectors();
    }

    public DoubleMatrix1D getEigenValues() {
        System.out.println("Now is extracting Eigenvalues...");
        return this.prcomp.getEigenValues();
    }

    public DoubleMatrix2D getPC() {
        System.out.println("Now is calculating PC...");
        return this.prcomp.getPrincipalComponents();
    }

    private void build() {
        System.out.println("Doing singularValueDecomposition..., please wait.");
        this.prcomp = this.isCorrelation ? new PrincipalComponents(this.data, 2) : new PrincipalComponents(this.data, 1);
        System.out.println("PCA was built successfuly");
    }
}

