/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.PCA;

import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.matrixalgebra.decomposition.SingularValueDecomposition;

public class PrinComp {
    SingularValueDecomposition svd;
    DoubleMatrix datamatrix;

    public PrinComp(DoubleMatrix data, PC_TYPE type) {
        this.datamatrix = this.centerCols(data);
        if (type == PC_TYPE.corr) {
            this.scaleCenteredMatrix(this.datamatrix);
        }
        this.svd = this.datamatrix.getSingularValueDecomposition();
    }

    public double[] getEigenValues() {
        double[] singularvals = this.svd.getSingularValues();
        int n = singularvals.length;
        double[] eigenvals = new double[n];
        for (int i = 0; i < n; ++i) {
            eigenvals[i] = singularvals[i] * singularvals[i];
        }
        return eigenvals;
    }

    public DoubleMatrix getEigenValuesAsColumnVector() {
        double[] eigenvals = this.getEigenValues();
        int n = eigenvals.length;
        return DoubleMatrixFactory.DEFAULT.make(n, 1, eigenvals);
    }

    public DoubleMatrix getEigenvalueMatrix() {
        return DoubleMatrixFactory.DEFAULT.diagonal(this.getEigenValues());
    }

    public DoubleMatrix getEigenVectors() {
        return this.svd.getV(false);
    }

    public DoubleMatrix getPrincipalComponents() {
        return this.datamatrix.mult(this.svd.getV(false));
    }

    private DoubleMatrix centerCols(DoubleMatrix data) {
        int nrows = data.numberOfRows();
        int ncols = data.numberOfColumns();
        DoubleMatrix dm = data.copy();
        for (int c = 0; c < ncols; ++c) {
            double colmean = dm.columnSum(c) / (double)nrows;
            for (int r = 0; r < nrows; ++r) {
                dm.set(r, c, dm.get(r, c) - colmean);
            }
        }
        return dm;
    }

    private void scaleCenteredMatrix(DoubleMatrix data) {
        int nrows = data.numberOfRows();
        int ncols = data.numberOfColumns();
        for (int c = 0; c < ncols; ++c) {
            double sumsq = 0.0;
            for (int r = 0; r < nrows; ++r) {
                double val = data.get(r, c);
                sumsq += val * val;
            }
            double stdDev = Math.sqrt(sumsq / (double)(nrows - 1));
            for (int r = 0; r < nrows; ++r) {
                double val = data.get(r, c);
                data.set(r, c, val / stdDev);
            }
        }
    }

    public static enum PC_TYPE {
        corr,
        cov;

    }
}

