/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.PCA;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import cern.jet.math.Functions;

public class PrincipalComponents {
    private DoubleMatrix2D genotypes;
    private SingularValueDecomposition svd;
    private boolean transposed = false;
    public static final int TYPE_CENTER = 1;
    public static final int TYPE_CENTER_AND_SCALE = 2;
    public static final int TYPE_NONE = 3;

    public PrincipalComponents(DoubleMatrix2D genotypes, int type) {
        this.genotypes = genotypes;
        System.out.println("PrincipalComponents: 1");
        if (type == 1) {
            this.centerGenotypesByMarker();
        } else if (type == 2) {
            this.centerAndScaleGenotypes();
        }
        System.out.println("PrincipalComponents: 2");
        int nrows = genotypes.rows();
        int ncols = genotypes.columns();
        System.out.println("PrincipalComponents: 3");
        if (nrows < ncols) {
            this.transposed = true;
            this.svd = new SingularValueDecomposition(genotypes.viewDice());
        } else {
            this.svd = new SingularValueDecomposition(genotypes);
        }
        System.out.println("finished");
    }

    public void centerGenotypesByMarker() {
        int nrows = this.genotypes.rows();
        int ncols = this.genotypes.columns();
        for (int c = 0; c < ncols; ++c) {
            DoubleMatrix1D marker = this.genotypes.viewColumn(c);
            double mean = marker.zSum() / (double)nrows;
            marker.assign(Functions.minus((double)mean));
        }
    }

    public void centerAndScaleGenotypes() {
        int nrows = this.genotypes.rows();
        int ncols = this.genotypes.columns();
        for (int c = 0; c < ncols; ++c) {
            DoubleMatrix1D marker = this.genotypes.viewColumn(c);
            double mean = marker.aggregate(Functions.plus, Functions.identity) / (double)nrows;
            marker.assign(Functions.minus((double)mean));
            double sd = marker.aggregate(Functions.plus, Functions.square);
            sd /= (double)(marker.size() - 1);
            sd = Math.sqrt(sd);
            marker.assign(Functions.div((double)sd));
        }
    }

    public DoubleMatrix2D getUS(int n) {
        if (this.transposed) {
            int ncol = this.svd.getV().columns();
            return this.svd.getV().viewPart(0, 0, ncol, n).zMult(this.svd.getS().viewPart(0, 0, n, n), null);
        }
        int ncol = this.svd.getU().columns();
        return this.svd.getU().viewPart(0, 0, ncol, n).zMult(this.svd.getS().viewPart(0, 0, n, n), null);
    }

    public DoubleMatrix2D getSV(int n) {
        if (this.transposed) {
            int ncol = this.svd.getU().columns();
            return this.svd.getU().viewPart(0, 0, ncol, n).zMult(this.svd.getS().viewPart(0, 0, n, n), null).viewDice().copy();
        }
        int ncol = this.svd.getV().columns();
        return this.svd.getV().viewPart(0, 0, ncol, n).zMult(this.svd.getS().viewPart(0, 0, n, n), null).viewDice().copy();
    }

    public DoubleMatrix2D getU() {
        if (this.transposed) {
            return this.svd.getV();
        }
        return this.svd.getU();
    }

    public DoubleMatrix2D getV() {
        if (this.transposed) {
            return this.svd.getU();
        }
        return this.svd.getV();
    }

    public DoubleMatrix1D getSingularValues() {
        return DoubleFactory1D.dense.make(this.svd.getSingularValues());
    }

    public DoubleMatrix2D getEigenVectors() {
        if (this.transposed) {
            return this.svd.getU();
        }
        return this.svd.getV();
    }

    public DoubleMatrix2D getPrincipalComponents() {
        if (this.transposed) {
            return this.svd.getV().zMult(this.svd.getS(), null).viewDice().copy();
        }
        return this.svd.getU().zMult(this.svd.getS(), null).viewDice().copy();
    }

    public DoubleMatrix1D getEigenValues() {
        double[] s = this.svd.getSingularValues();
        int n = s.length;
        int size = this.genotypes.rows();
        double[] eigenvalues = new double[n];
        for (int i = 0; i < n; ++i) {
            eigenvalues[i] = s[i] * s[i] / (double)(size - 1);
        }
        return DoubleFactory1D.dense.make(eigenvalues);
    }
}

