/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.stats.linearmodels;

import java.util.Arrays;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.stats.linearmodels.ModelEffect;

public class FactorModelEffect
implements ModelEffect {
    private Object id;
    private final int[] levels;
    private final int[] levelCounts;
    private final int size;
    private final int numberOfLevels;
    private boolean restricted = false;

    public FactorModelEffect(int[] levels, boolean restricted) {
        this.levels = levels;
        this.size = levels.length;
        this.restricted = restricted;
        int maxLevel = 0;
        for (int level : levels) {
            maxLevel = Math.max(maxLevel, level);
        }
        this.numberOfLevels = maxLevel + 1;
        int[] counts = new int[this.numberOfLevels];
        int[] arr$ = levels;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int level;
            int n = level = arr$[i$];
            counts[n] = counts[n] + 1;
        }
        this.levelCounts = counts;
    }

    public FactorModelEffect(int[] levels, boolean restricted, Object id) {
        this(levels, restricted);
        this.id = id;
    }

    private FactorModelEffect(Object id, int[] levels, int[] levelCounts, int size, int numberOfLevels, boolean restricted) {
        this.id = id;
        this.levels = Arrays.copyOf(levels, levels.length);
        this.levelCounts = Arrays.copyOf(levelCounts, levelCounts.length);
        this.size = size;
        this.numberOfLevels = numberOfLevels;
        this.restricted = restricted;
    }

    @Override
    public Object getID() {
        return this.id;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public DoubleMatrix getX() {
        if (this.restricted) {
            return this.getX_restricted();
        }
        return this.getX_unrestricted();
    }

    @Override
    public DoubleMatrix getXtX() {
        if (this.restricted) {
            return this.getXtX_restricted();
        }
        return this.getXtX_unrestricted();
    }

    @Override
    public DoubleMatrix getXty(double[] y) {
        if (this.restricted) {
            return this.getXty_restricted(y);
        }
        return this.getXty_unrestricted(y);
    }

    @Override
    public void setID(Object id) {
        this.id = id;
    }

    public DoubleMatrix getXtX2(FactorModelEffect fme) {
        int n1 = this.numberOfLevels;
        if (this.restricted) {
            --n1;
        }
        int n2 = fme.numberOfLevels;
        if (fme.restricted) {
            --n2;
        }
        DoubleMatrix xtx2 = DoubleMatrixFactory.DEFAULT.make(n1, n2, 0.0);
        for (int i = 0; i < this.size; ++i) {
            int row = this.levels[i];
            int col = fme.levels[i];
            if (row >= n1 || col >= n2) continue;
            xtx2.set(row, col, xtx2.get(row, col) + 1.0);
        }
        return xtx2;
    }

    @Override
    public DoubleMatrix getyhat(DoubleMatrix beta) {
        if (this.restricted) {
            return this.getyhat_restricted(beta);
        }
        return this.getyhat_unrestricted(beta);
    }

    @Override
    public DoubleMatrix getyhat(double[] beta) {
        if (this.restricted) {
            return this.getyhat_restricted(beta);
        }
        return this.getyhat_unrestricted(beta);
    }

    public int[] getLevels() {
        return this.levels;
    }

    public boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    @Override
    public int getNumberOfLevels() {
        return this.numberOfLevels;
    }

    @Override
    public int[] getLevelCounts() {
        return this.levelCounts;
    }

    private DoubleMatrix getX_unrestricted() {
        DoubleMatrix X = DoubleMatrixFactory.DEFAULT.make(this.size, this.numberOfLevels, 0.0);
        for (int i = 0; i < this.size; ++i) {
            X.set(i, this.levels[i], 1.0);
        }
        return X;
    }

    private DoubleMatrix getX_restricted() {
        DoubleMatrix X = DoubleMatrixFactory.DEFAULT.make(this.size, this.numberOfLevels - 1, 0.0);
        for (int i = 0; i < this.size; ++i) {
            if (this.levels[i] >= this.numberOfLevels - 1) continue;
            X.set(i, this.levels[i], 1.0);
        }
        return X;
    }

    private DoubleMatrix getXtX_unrestricted() {
        double[] counts = new double[this.numberOfLevels];
        for (int i = 0; i < this.numberOfLevels; ++i) {
            counts[i] = this.levelCounts[i];
        }
        DoubleMatrix xtx = DoubleMatrixFactory.DEFAULT.diagonal(counts);
        return xtx;
    }

    private DoubleMatrix getXtX_restricted() {
        double[] counts = new double[this.numberOfLevels - 1];
        for (int i = 0; i < this.numberOfLevels - 1; ++i) {
            counts[i] = this.levelCounts[i];
        }
        DoubleMatrix xtx = DoubleMatrixFactory.DEFAULT.diagonal(counts);
        return xtx;
    }

    private DoubleMatrix getXty_unrestricted(double[] y) {
        double[] sums = new double[this.numberOfLevels];
        for (int i = 0; i < this.size; ++i) {
            int n = this.levels[i];
            sums[n] = sums[n] + y[i];
        }
        return DoubleMatrixFactory.DEFAULT.make(this.numberOfLevels, 1, sums);
    }

    private DoubleMatrix getXty_restricted(double[] y) {
        double[] sums = new double[this.numberOfLevels - 1];
        for (int i = 0; i < this.size; ++i) {
            if (this.levels[i] >= this.numberOfLevels - 1) continue;
            int n = this.levels[i];
            sums[n] = sums[n] + y[i];
        }
        return DoubleMatrixFactory.DEFAULT.make(this.numberOfLevels - 1, 1, sums);
    }

    private DoubleMatrix getyhat_unrestricted(DoubleMatrix beta) {
        if (beta.numberOfRows() != this.numberOfLevels) {
            throw new IllegalArgumentException("Number of factor levels is not the same as the size of beta.");
        }
        double[] yhat = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            yhat[i] = beta.get(this.levels[i], 0);
        }
        return DoubleMatrixFactory.DEFAULT.make(this.size, 1, yhat);
    }

    private DoubleMatrix getyhat_restricted(DoubleMatrix beta) {
        if (beta.numberOfRows() != this.numberOfLevels - 1) {
            throw new IllegalArgumentException("Number of factor levels is not the same as the size of beta.");
        }
        double[] yhat = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            if (this.levels[i] >= this.numberOfLevels - 1) continue;
            yhat[i] = beta.get(this.levels[i], 0);
        }
        return DoubleMatrixFactory.DEFAULT.make(this.size, 1, yhat);
    }

    private DoubleMatrix getyhat_unrestricted(double[] beta) {
        if (beta.length != this.numberOfLevels) {
            throw new IllegalArgumentException("Number of factor levels is not the same as the size of beta.");
        }
        double[] yhat = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            yhat[i] = beta[this.levels[i]];
        }
        return DoubleMatrixFactory.DEFAULT.make(this.size, 1, yhat);
    }

    private DoubleMatrix getyhat_restricted(double[] beta) {
        if (beta.length != this.numberOfLevels - 1) {
            throw new IllegalArgumentException("Number of factor levels is not the same as the size of beta.");
        }
        double[] yhat = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            if (this.levels[i] >= this.numberOfLevels - 1) continue;
            yhat[i] = beta[this.levels[i]];
        }
        return DoubleMatrixFactory.DEFAULT.make(this.size, 1, yhat);
    }

    @Override
    public ModelEffect getCopy() {
        return new FactorModelEffect(this.id, Arrays.copyOf(this.levels, this.levels.length), Arrays.copyOf(this.levelCounts, this.levelCounts.length), this.size, this.numberOfLevels, this.restricted);
    }

    @Override
    public int getEffectSize() {
        if (this.restricted) {
            return this.numberOfLevels - 1;
        }
        return this.numberOfLevels;
    }
}

